/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.windows.wgl.WGLExt;
import jogamp.opengl.windows.wgl.WindowsPbufferWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;

public class WindowsPbufferWGLContext
extends WindowsWGLContext {
    private boolean rtt;
    private boolean hasRTT;
    private boolean rect;
    private int textureTarget;
    private int texture;

    protected WindowsPbufferWGLContext(WindowsPbufferWGLDrawable windowsPbufferWGLDrawable, GLContext gLContext) {
        super(windowsPbufferWGLDrawable, gLContext);
    }

    @Override
    public void bindPbufferToTexture() {
        if (!this.rtt) {
            throw new GLException("Shouldn't try to bind a pbuffer to a texture if render-to-texture hasn't been specified in its GLCapabilities");
        }
        GL gL = this.getGL();
        WGLExt wGLExt = this.getWGLExt();
        gL.glBindTexture(this.textureTarget, this.texture);
        if (this.rtt && this.hasRTT && !wGLExt.wglBindTexImageARB(((WindowsPbufferWGLDrawable)this.drawable).getPbufferHandle(), 8323)) {
            throw new GLException("Binding of pbuffer to texture failed: " + WindowsPbufferWGLContext.wglGetLastError());
        }
    }

    @Override
    public void releasePbufferFromTexture() {
        WGLExt wGLExt;
        if (!this.rtt) {
            throw new GLException("Shouldn't try to bind a pbuffer to a texture if render-to-texture hasn't been specified in its GLCapabilities");
        }
        if (this.rtt && this.hasRTT && !(wGLExt = this.getWGLExt()).wglReleaseTexImageARB(((WindowsPbufferWGLDrawable)this.drawable).getPbufferHandle(), 8323)) {
            throw new GLException("Releasing of pbuffer from texture failed: " + WindowsPbufferWGLContext.wglGetLastError());
        }
    }

    @Override
    protected boolean createImpl(GLContextImpl gLContextImpl) {
        boolean bl = super.createImpl(gLContextImpl);
        if (bl) {
            GLCapabilitiesImmutable gLCapabilitiesImmutable = this.drawable.getChosenGLCapabilities();
            GL gL = this.getGL();
            this.rtt = gLCapabilitiesImmutable.getPbufferRenderToTexture();
            boolean bl2 = this.rect = gL.isGL2GL3() && gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle();
            if (this.rtt) {
                if (DEBUG) {
                    System.err.println("Initializing render-to-texture support");
                }
                if (!gL.isExtensionAvailable("WGL_ARB_render_texture")) {
                    System.err.println("WindowsPbufferWGLContext: WARNING: WGL_ARB_render_texture extension not supported; implementing render_to_texture support using slow texture readback");
                } else {
                    this.hasRTT = true;
                    if (this.rect && !gL.isExtensionAvailable("GL_NV_texture_rectangle")) {
                        System.err.println("WindowsPbufferWGLContext: WARNING: GL_NV_texture_rectangle extension not supported; skipping requested render_to_texture_rectangle support for pbuffer");
                        this.rect = false;
                    }
                    if (this.rect) {
                        if (DEBUG) {
                            System.err.println("  Using render-to-texture-rectangle");
                        }
                        this.textureTarget = 34037;
                    } else {
                        if (DEBUG) {
                            System.err.println("  Using vanilla render-to-texture");
                        }
                        this.textureTarget = 3553;
                    }
                    int[] nArray = new int[1];
                    gL.glGenTextures(1, nArray, 0);
                    this.texture = nArray[0];
                    gL.glBindTexture(this.textureTarget, this.texture);
                    gL.glTexParameteri(this.textureTarget, 10241, 9728);
                    gL.glTexParameteri(this.textureTarget, 10240, 9728);
                    gL.glTexParameteri(this.textureTarget, 10242, 33071);
                    gL.glTexParameteri(this.textureTarget, 10243, 33071);
                    gL.glCopyTexImage2D(this.textureTarget, 0, 6407, 0, 0, this.drawable.getWidth(), this.drawable.getHeight(), 0);
                }
            }
        }
        return bl;
    }

    @Override
    public int getFloatingPointMode() {
        return ((WindowsPbufferWGLDrawable)this.drawable).getFloatingPointMode();
    }

    private static String wglGetLastError() {
        return WindowsWGLDrawableFactory.wglGetLastError();
    }
}

