/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.CanvasViewEventCatcher;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.Context;
import javax.media.j3d.Drawable;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.EventCatcher;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GraphicsConfigInfo;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.IllegalRenderingStateException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.J3DGraphics2DImpl;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dQueryProps;
import javax.media.j3d.LightBin;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.MasterControl;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Renderer;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.media.j3d.ShaderBin;
import javax.media.j3d.ShaderProgramRetained;
import javax.media.j3d.TexCoordGenerationRetained;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector4d;

public class Canvas3D
extends Canvas {
    public static final int FIELD_LEFT = 0;
    public static final int FIELD_RIGHT = 1;
    public static final int FIELD_ALL = 2;
    static final int POLYGONATTRS_DIRTY = 1;
    static final int LINEATTRS_DIRTY = 2;
    static final int POINTATTRS_DIRTY = 4;
    static final int MATERIAL_DIRTY = 8;
    static final int TRANSPARENCYATTRS_DIRTY = 16;
    static final int COLORINGATTRS_DIRTY = 32;
    static final int LIGHTBIN_DIRTY = 64;
    static final int LIGHTENABLES_DIRTY = 128;
    static final int AMBIENTLIGHT_DIRTY = 256;
    static final int ATTRIBUTEBIN_DIRTY = 512;
    static final int TEXTUREBIN_DIRTY = 1024;
    static final int TEXTUREATTRIBUTES_DIRTY = 2048;
    static final int RENDERMOLECULE_DIRTY = 4096;
    static final int FOG_DIRTY = 8192;
    static final int MODELCLIP_DIRTY = 16384;
    static final int VIEW_MATRIX_DIRTY = 32768;
    boolean offScreen = false;
    boolean manualRendering = false;
    Point offScreenCanvasLoc;
    Dimension offScreenCanvasSize;
    volatile boolean offScreenRendering = false;
    volatile boolean offScreenBufferPending = false;
    ImageComponent2D offScreenBuffer = null;
    boolean useSharedCtx = true;
    boolean stereoAvailable;
    boolean stereoEnable = true;
    boolean useStereo;
    boolean rightStereoPass = false;
    int monoscopicViewPolicy = 2;
    int requestedStencilSize;
    int actualStencilSize;
    boolean userStencilAvailable;
    boolean systemStencilAvailable;
    boolean doubleBufferAvailable;
    boolean doubleBufferEnable = true;
    boolean useDoubleBuffer;
    boolean sceneAntialiasingAvailable;
    boolean sceneAntialiasingMultiSamplesAvailable;
    private boolean antialiasingSet = false;
    int textureColorTableSize;
    int numActiveTexUnit = 0;
    int lastActiveTexUnit = -1;
    boolean shadingLanguageGLSL = false;
    J3dQueryProps queryProps;
    private boolean fatalError = false;
    Point3d leftManualEyeInImagePlate = new Point3d(0.142, 0.135, 0.4572);
    Point3d rightManualEyeInImagePlate = new Point3d(0.208, 0.135, 0.4572);
    View view = null;
    View pendingView;
    CanvasViewCache canvasViewCache = null;
    CanvasViewCache canvasViewCacheFrustum = null;
    boolean raIsVisible = false;
    RenderAtom ra = null;
    static final int STEREO_DIRTY = 1;
    static final int MONOSCOPIC_VIEW_POLICY_DIRTY = 2;
    static final int EYE_IN_IMAGE_PLATE_DIRTY = 4;
    static final int MOVED_OR_RESIZED_DIRTY = 8;
    static final int BACKGROUND_DIRTY = 16;
    static final int BACKGROUND_IMAGE_DIRTY = 32;
    static final int VIEW_INFO_DIRTY = 63;
    static final int RENDERER_DIRTY_IDX = 0;
    static final int RENDER_BIN_DIRTY_IDX = 1;
    int[] cvDirtyMask = new int[2];
    boolean resizeGraphics2D = true;
    volatile boolean isRunning = true;
    volatile boolean isRunningStatus = true;
    boolean active = false;
    boolean visible = false;
    boolean ctxReset = true;
    Screen3D screen = null;
    boolean imageReady = false;
    int fogOn = 0;
    GraphicsContext3D graphicsContext3D = null;
    boolean waiting = false;
    boolean swapDone = false;
    GraphicsConfiguration graphicsConfiguration;
    J3DGraphics2DImpl graphics2D = null;
    Object gfxCreationLock = new Object();
    Transform3D vworldToEc = new Transform3D();
    Transform3D vpcToEc;
    Drawable drawable = null;
    static Hashtable<GraphicsConfiguration, GraphicsConfigInfo> graphicsConfigTable = new Hashtable();
    String nativeGraphicsVersion = "<UNKNOWN>";
    String nativeGraphicsVendor = "<UNKNOWN>";
    String nativeGraphicsRenderer = "<UNKNOWN>";
    boolean firstPaintCalled = false;
    boolean added = false;
    private boolean addNotifyCalled = false;
    Context ctx = null;
    volatile long ctxTimeStamp = 0L;
    boolean ctxEyeLightingEnable = false;
    AppearanceRetained currentAppear = new AppearanceRetained();
    MaterialRetained currentMaterial = new MaterialRetained();
    CachedFrustum viewFrustum = new CachedFrustum();
    LightBin lightBin = null;
    EnvironmentSet environmentSet = null;
    AttributeBin attributeBin = null;
    ShaderBin shaderBin = null;
    RenderMolecule renderMolecule = null;
    PolygonAttributesRetained polygonAttributes = null;
    LineAttributesRetained lineAttributes = null;
    PointAttributesRetained pointAttributes = null;
    MaterialRetained material = null;
    boolean enableLighting = false;
    TransparencyAttributesRetained transparency = null;
    ColoringAttributesRetained coloringAttributes = null;
    Transform3D modelMatrix = null;
    Transform3D projTrans = null;
    TextureBin textureBin = null;
    LightRetained[] lights = null;
    int[] frameCount = null;
    long enableMask = -1L;
    FogRetained fog = null;
    ModelClipRetained modelClip = null;
    Color3f sceneAmbient = new Color3f();
    TextureUnitStateRetained[] texUnitState = null;
    TextureRetained texture = null;
    TextureAttributesRetained texAttrs = null;
    TexCoordGenerationRetained texCoordGeneration = null;
    RenderingAttributesRetained renderingAttrs = null;
    AppearanceRetained appearance = null;
    ShaderProgramRetained shaderProgram = null;
    Object appHandle = null;
    int canvasDirty = 65535;
    boolean dirtyDisplayList = false;
    ArrayList<RenderMolecule> dirtyRenderMoleculeList = new ArrayList();
    ArrayList<RenderAtomListInfo> dirtyRenderAtomList = new ArrayList();
    ArrayList<Object[]> dirtyDlistPerRinfoList = new ArrayList();
    ArrayList<Integer> displayListResourceFreeList = new ArrayList();
    ArrayList<Integer> textureIdResourceFreeList = new ArrayList();
    int canvasBit = 0;
    int canvasId = 0;
    private boolean canvasIdAlloc = false;
    Object cvLock = new Object();
    Object evaluateLock = new Object();
    Object dirtyMaskLock = new Object();
    boolean needToRebuildDisplayList = false;
    static final int TEXTURE_3D = 1;
    static final int TEXTURE_COLOR_TABLE = 2;
    static final int TEXTURE_MULTI_TEXTURE = 4;
    static final int TEXTURE_COMBINE = 8;
    static final int TEXTURE_COMBINE_DOT3 = 16;
    static final int TEXTURE_COMBINE_SUBTRACT = 32;
    static final int TEXTURE_REGISTER_COMBINERS = 64;
    static final int TEXTURE_CUBE_MAP = 128;
    static final int TEXTURE_SHARPEN = 256;
    static final int TEXTURE_DETAIL = 512;
    static final int TEXTURE_FILTER4 = 1024;
    static final int TEXTURE_ANISOTROPIC_FILTER = 2048;
    static final int TEXTURE_LOD_RANGE = 4096;
    static final int TEXTURE_LOD_OFFSET = 8192;
    static final int TEXTURE_LERP = 16384;
    static final int TEXTURE_NON_POWER_OF_TWO = 32768;
    static final int TEXTURE_AUTO_MIPMAP_GENERATION = 65536;
    int textureExtendedFeatures = 0;
    static final int SUN_GLOBAL_ALPHA = 1;
    static final int EXT_ABGR = 2;
    static final int EXT_BGR = 4;
    static final int MULTISAMPLE = 8;
    int extensionsSupported = 0;
    float anisotropicDegreeMax = 1.0f;
    int textureBoundaryWidthMax = 0;
    boolean multiTexAccelerated = false;
    int maxTexCoordSets = 1;
    int maxTextureUnits = 1;
    int maxTextureImageUnits = 0;
    int maxVertexTextureImageUnits = 0;
    int maxCombinedTextureImageUnits = 0;
    int maxVertexAttrs = 0;
    int maxAvailableTextureUnits;
    int textureWidthMax = 0;
    int textureHeightMax = 0;
    int texture3DWidthMax = -1;
    int texture3DHeightMax = -1;
    int texture3DDepthMax = -1;
    Point newPosition = new Point();
    Dimension newSize = new Dimension();
    ArrayList<TextureRetained> textureIDResourceTable = new ArrayList(5);
    static final int LIGHTBIN_BIT = 0;
    static final int ENVIRONMENTSET_BIT = 1;
    static final int ATTRIBUTEBIN_BIT = 2;
    static final int TEXTUREBIN_BIT = 3;
    static final int RENDERMOLECULE_BIT = 4;
    static final int TRANSPARENCY_BIT = 5;
    static final int SHADERBIN_BIT = 6;
    int stateUpdateMask = 0;
    Object[] curStateToUpdate = new Object[7];
    LightRetained[] currentLights = null;
    boolean depthBufferWriteEnableOverride = false;
    boolean depthBufferEnableOverride = false;
    boolean depthBufferWriteEnable = true;
    boolean vfPlanesValid = false;
    EventCatcher eventCatcher;
    private CanvasViewEventCatcher canvasViewEventCatcher;
    private Window windowParent;
    private LinkedList<Container> containerParentList = new LinkedList();
    boolean lightChanged = false;
    DrawingSurfaceObject drawingSurfaceObject;
    boolean validCtx = false;
    boolean validCanvas = false;
    boolean ctxChanged = false;
    private static GraphicsConfiguration defaultGcfg = null;
    static int ENV_STATE_MASK;

    private static synchronized GraphicsConfiguration defaultGraphicsConfiguration() {
        if (defaultGcfg == null) {
            GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
            defaultGcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(graphicsConfigTemplate3D);
        }
        return defaultGcfg;
    }

    private static boolean isValidConfig(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfigTable.containsKey(graphicsConfiguration);
    }

    private static synchronized GraphicsConfiguration checkForValidGraphicsConfig(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        if (!bl && VirtualUniverse.mc.allowNullGraphicsConfig && graphicsConfiguration == null) {
            System.err.println(J3dI18N.getString("Canvas3D7"));
            System.err.println("    " + J3dI18N.getString("Canvas3D18"));
            graphicsConfiguration = Canvas3D.defaultGraphicsConfiguration();
        }
        if (graphicsConfiguration == null) {
            throw new NullPointerException(J3dI18N.getString("Canvas3D19"));
        }
        if (!Canvas3D.isValidConfig(graphicsConfiguration)) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D17"));
        }
        return graphicsConfiguration;
    }

    private static GraphicsConfiguration getGraphicsConfig(GraphicsConfiguration graphicsConfiguration) {
        return Pipeline.getPipeline().getGraphicsConfig(graphicsConfiguration);
    }

    public Canvas3D(GraphicsConfiguration graphicsConfiguration) {
        this(null, Canvas3D.checkForValidGraphicsConfig(graphicsConfiguration, false), false);
    }

    public Canvas3D(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        this(null, Canvas3D.checkForValidGraphicsConfig(graphicsConfiguration, bl), bl);
    }

    private Canvas3D(Object object, GraphicsConfiguration graphicsConfiguration, boolean bl) {
        this(object, graphicsConfiguration, Canvas3D.getGraphicsConfig(graphicsConfiguration), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Canvas3D(Object object, GraphicsConfiguration graphicsConfiguration, GraphicsConfiguration graphicsConfiguration2, boolean bl) {
        super(graphicsConfiguration2);
        Object object2;
        this.offScreen = bl;
        this.graphicsConfiguration = graphicsConfiguration;
        boolean bl2 = false;
        if (this instanceof AutoOffScreenCanvas3D) {
            bl2 = true;
        }
        if (bl2 && !bl) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D25"));
        }
        this.cvDirtyMask[0] = 63;
        this.cvDirtyMask[1] = 63;
        GraphicsConfigInfo graphicsConfigInfo = graphicsConfigTable.get(graphicsConfiguration);
        this.requestedStencilSize = graphicsConfigInfo.getGraphicsConfigTemplate3D().getStencilSize();
        if (bl) {
            this.manualRendering = !bl2;
            this.screen = new Screen3D(graphicsConfiguration, bl);
            object2 = this.dirtyMaskLock;
            synchronized (object2) {
                this.cvDirtyMask[0] = this.cvDirtyMask[0] | 8;
                this.cvDirtyMask[1] = this.cvDirtyMask[1] | 8;
            }
            this.firstPaintCalled = true;
            if (this.manualRendering) {
                this.added = true;
            }
            this.evaluateActive();
            this.offScreenCanvasLoc = new Point(0, 0);
            this.offScreenCanvasSize = new Dimension(0, 0);
            this.setLocation(this.offScreenCanvasLoc);
            this.setSize(this.offScreenCanvasSize);
            this.newSize = this.offScreenCanvasSize;
            this.newPosition = this.offScreenCanvasLoc;
            if (!this.manualRendering) {
                this.eventCatcher = new EventCatcher(this);
                this.canvasViewEventCatcher = new CanvasViewEventCatcher(this);
            }
        } else {
            object2 = graphicsConfiguration.getDevice();
            this.eventCatcher = new EventCatcher(this);
            this.canvasViewEventCatcher = new CanvasViewEventCatcher(this);
            Hashtable<GraphicsDevice, Screen3D> hashtable = VirtualUniverse.mc.deviceScreenMap;
            synchronized (hashtable) {
                this.screen = VirtualUniverse.mc.deviceScreenMap.get(object2);
                if (this.screen == null) {
                    this.screen = new Screen3D(graphicsConfiguration, bl);
                    VirtualUniverse.mc.deviceScreenMap.put((GraphicsDevice)object2, this.screen);
                }
            }
        }
        this.lights = new LightRetained[VirtualUniverse.mc.maxLights];
        this.frameCount = new int[VirtualUniverse.mc.maxLights];
        for (int i = 0; i < this.frameCount.length; ++i) {
            this.frameCount[i] = -1;
        }
        this.drawingSurfaceObject = Pipeline.getPipeline().createDrawingSurfaceObject(this);
        GraphicsConfigTemplate3D.getGraphicsConfigFeatures(this);
        this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        this.useSharedCtx = VirtualUniverse.mc.isSharedCtx;
        assert (!(!bl && this.manualRendering));
        assert (!(bl && this.useDoubleBuffer));
        assert (!(bl && this.useStereo));
    }

    void sendEventToBehaviorScheduler(AWTEvent aWTEvent) {
        VirtualUniverse virtualUniverse;
        ViewPlatform viewPlatform;
        if (this.view != null && (viewPlatform = this.view.getViewPlatform()) != null && (virtualUniverse = ((ViewPlatformRetained)viewPlatform.retained).universe) != null) {
            virtualUniverse.behaviorStructure.handleAWTEvent(aWTEvent);
        }
    }

    private boolean isRecursivelyVisible() {
        Container container = this.getParent();
        return this.isVisible() && container != null && container.isShowing();
    }

    private boolean isIconified() {
        if (this.windowParent instanceof Frame) {
            return (((Frame)this.windowParent).getExtendedState() & 1) != 0;
        }
        return false;
    }

    void evaluateVisiblilty() {
        boolean bl;
        boolean bl2 = bl = this.isRecursivelyVisible() && !this.isIconified();
        if (this.visible != bl) {
            this.visible = bl;
            this.evaluateActive();
            if (bl && this.view != null) {
                this.view.repaint();
            }
        }
    }

    void redraw() {
        if (this.view != null && this.active && this.isRunning) {
            this.view.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (!this.firstPaintCalled && this.added && this.validCanvas && this.validGraphicsMode()) {
            try {
                this.newSize = this.getSize();
                this.newPosition = this.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                return;
            }
            DrawingSurfaceObject drawingSurfaceObject = this.drawingSurfaceObject;
            synchronized (drawingSurfaceObject) {
                this.drawingSurfaceObject.getDrawingSurfaceObjectInfo();
            }
            this.firstPaintCalled = true;
            this.visible = true;
            this.evaluateActive();
        }
        this.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        if (this.addNotifyCalled) {
            return;
        }
        this.addNotifyCalled = true;
        if (this.manualRendering) {
            return;
        }
        Renderer renderer = null;
        if (this.isRunning && this.screen != null && (renderer = this.screen.renderer) != null) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, renderer);
            while (!renderer.userStop) {
                MasterControl.threadYield();
            }
        }
        if (!this.offScreen) {
            super.addNotify();
        }
        this.screen.addUser(this);
        assert (this.containerParentList.isEmpty());
        this.windowParent = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof Window) {
                this.windowParent = (Window)container;
            }
            container.addComponentListener(this.eventCatcher);
            container.addComponentListener(this.canvasViewEventCatcher);
            this.containerParentList.add(container);
        }
        this.addComponentListener(this.eventCatcher);
        this.addComponentListener(this.canvasViewEventCatcher);
        if (this.windowParent != null) {
            this.windowParent.addWindowListener(this.eventCatcher);
        }
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 8;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 8;
        }
        this.allocateCanvasId();
        this.validCanvas = true;
        this.added = true;
        if (this.offScreen) {
            this.firstPaintCalled = true;
            this.visible = true;
            this.evaluateActive();
        }
        if (this.isRunning && !this.fatalError) {
            this.isRunningStatus = true;
        }
        this.ctxTimeStamp = 0L;
        if (this.view != null && this.view.universe != null) {
            this.view.universe.checkForEnableEvents();
        }
        if (renderer != null) {
            VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, renderer);
            while (renderer.userStop) {
                MasterControl.threadYield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        if (!this.addNotifyCalled) {
            return;
        }
        this.addNotifyCalled = false;
        if (this.manualRendering) {
            return;
        }
        Renderer renderer = null;
        if (this.isRunning && this.screen != null && (renderer = this.screen.renderer) != null) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, renderer);
            while (!renderer.userStop) {
                MasterControl.threadYield();
            }
        }
        DrawingSurfaceObject drawingSurfaceObject = this.drawingSurfaceObject;
        synchronized (drawingSurfaceObject) {
            this.validCtx = false;
            this.validCanvas = false;
        }
        this.removeCtx();
        Pipeline.getPipeline().freeDrawingSurface(this, this.drawingSurfaceObject);
        this.firstPaintCalled = false;
        this.visible = false;
        this.screen.removeUser(this);
        this.evaluateActive();
        this.freeCanvasId();
        this.ra = null;
        this.graphicsContext3D = null;
        this.ctx = null;
        this.graphics2D = null;
        super.removeNotify();
        for (Container container : this.containerParentList) {
            container.removeComponentListener(this.eventCatcher);
            container.removeComponentListener(this.canvasViewEventCatcher);
        }
        this.containerParentList.clear();
        this.removeComponentListener(this.eventCatcher);
        this.removeComponentListener(this.canvasViewEventCatcher);
        if (this.eventCatcher != null) {
            this.removeFocusListener(this.eventCatcher);
            this.removeKeyListener(this.eventCatcher);
            this.removeMouseListener(this.eventCatcher);
            this.removeMouseMotionListener(this.eventCatcher);
            this.removeMouseWheelListener(this.eventCatcher);
            this.eventCatcher.reset();
        }
        if (this.windowParent != null) {
            this.windowParent.removeWindowListener(this.eventCatcher);
            this.windowParent.requestFocus();
        }
        this.added = false;
        if (renderer != null) {
            VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, renderer);
            while (renderer.userStop) {
                MasterControl.threadYield();
            }
        }
        this.windowParent = null;
    }

    void allocateCanvasId() {
        if (!this.canvasIdAlloc) {
            this.canvasId = VirtualUniverse.mc.getCanvasId();
            this.canvasBit = 1 << this.canvasId;
            this.canvasIdAlloc = true;
        }
    }

    void freeCanvasId() {
        if (this.canvasIdAlloc) {
            VirtualUniverse.mc.freeCanvasId(this.canvasId);
            this.canvasBit = 0;
            this.canvasId = 0;
            this.canvasIdAlloc = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateActive() {
        Object object = this.evaluateLock;
        synchronized (object) {
            if ((this.visible || this.manualRendering) && this.firstPaintCalled) {
                if (!this.active) {
                    this.active = true;
                    if (this.pendingView != null) {
                        this.pendingView.evaluateActive();
                    }
                } else if (this.pendingView != null && !this.pendingView.activeStatus) {
                    this.pendingView.evaluateActive();
                }
            } else if (this.active) {
                this.active = false;
                if (this.view != null) {
                    this.view.evaluateActive();
                }
            }
        }
        if (this.view != null && !this.active && (object = this.view.universe) != null && !((VirtualUniverse)object).isSceneGraphLock) {
            ((VirtualUniverse)object).waitForMC();
        }
    }

    void setFrustumPlanes(Vector4d[] vector4dArray) {
        if (VirtualUniverse.mc.viewFrustumCulling) {
            this.viewFrustum.set(vector4dArray);
        }
    }

    public Screen3D getScreen3D() {
        return this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsContext3D getGraphicsContext3D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphicsContext3D == null) {
                this.graphicsContext3D = new GraphicsContext3D(this);
            }
        }
        return this.graphicsContext3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J3DGraphics2D getGraphics2D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphics2D == null) {
                this.graphics2D = new J3DGraphics2DImpl(this);
            }
        }
        return this.graphics2D;
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void postSwap() {
    }

    public void renderField(int n) {
    }

    public final void stopRenderer() {
        if (this.manualRendering) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
            this.isRunning = false;
        }
    }

    public final void startRenderer() {
        if (this.fatalError) {
            return;
        }
        if (!this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, this);
            this.isRunning = true;
            this.redraw();
        }
    }

    public final boolean isRendererRunning() {
        return this.isRunning;
    }

    boolean isFatalError() {
        return this.fatalError;
    }

    void setFatalError() {
        this.fatalError = true;
        if (this.isRunning) {
            this.isRunning = false;
            if (!this.manualRendering) {
                VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
            }
        }
    }

    public boolean isOffScreen() {
        return this.offScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffScreenBuffer(ImageComponent2D imageComponent2D) {
        int n;
        int n2;
        Object object;
        boolean bl = false;
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        J3dDebug.doAssert(!this.offScreenBufferPending, "!offScreenBufferPending");
        if (this.offScreenBuffer != null && this.offScreenBuffer != imageComponent2D) {
            object = (ImageComponent2DRetained)this.offScreenBuffer.retained;
            ((ImageComponentRetained)object).setUsedByOffScreen(false);
        }
        if (imageComponent2D != null) {
            object = (ImageComponent2DRetained)imageComponent2D.retained;
            if (((ImageComponent2DRetained)object).byReference && !(((ImageComponentRetained)object).getRefImage(0) instanceof BufferedImage)) {
                throw new IllegalArgumentException(J3dI18N.getString("Canvas3D15"));
            }
            if (((ImageComponentRetained)object).getNumberOfComponents() < 3) {
                throw new IllegalArgumentException(J3dI18N.getString("Canvas3D16"));
            }
            if (imageComponent2D.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Canvas3D26"));
            }
            if (((NodeComponentRetained)object).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Canvas3D27"));
            }
            if (imageComponent2D != this.offScreenBuffer && ((ImageComponentRetained)object).getUsedByOffScreen()) {
                throw new IllegalSharingException(J3dI18N.getString("Canvas3D28"));
            }
            ((ImageComponentRetained)object).setUsedByOffScreen(true);
            n2 = ((ImageComponent2DRetained)object).width;
            n = ((ImageComponent2DRetained)object).height;
            if (this.manualRendering) {
                this.sendAllocateCanvasId();
            }
        } else {
            n = 0;
            n2 = 0;
            if (this.manualRendering) {
                bl = true;
            }
        }
        if (this.offScreenCanvasSize.width != n2 || this.offScreenCanvasSize.height != n) {
            if (this.drawable != null) {
                this.sendDestroyCtxAndOffScreenBuffer();
                this.drawable = null;
            }
            this.ctx = null;
            this.offScreenCanvasSize.setSize(n2, n);
            this.setSize(this.offScreenCanvasSize);
            if (n2 > 0 && n > 0) {
                this.sendCreateOffScreenBuffer();
            }
        } else if (this.ctx != null) {
            this.removeCtx();
        }
        if (bl) {
            this.sendFreeCanvasId();
        }
        this.offScreenBuffer = imageComponent2D;
        object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 8;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 8;
        }
    }

    public ImageComponent2D getOffScreenBuffer() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return this.offScreenBuffer;
    }

    public void renderOffScreenBuffer() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (!this.manualRendering) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D24"));
        }
        if (this.fatalError) {
            throw new IllegalRenderingStateException(J3dI18N.getString("Canvas3D30"));
        }
        if (this.offScreenBuffer == null) {
            throw new NullPointerException(J3dI18N.getString("Canvas3D10"));
        }
        Dimension dimension = this.screen.getSize();
        if (dimension.width <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D8"));
        }
        if (dimension.height <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D9"));
        }
        if (this.screen.getPhysicalScreenWidth() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D12"));
        }
        if (this.screen.getPhysicalScreenHeight() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D13"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        if (!this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D11"));
        }
        if (!this.active || this.pendingView == null) {
            return;
        }
        this.offScreenRendering = true;
        boolean bl = false;
        try {
            bl = this.view.inCanvasCallback;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (bl) {
            if (this.screen.renderer == null) {
                this.screen.renderer = Screen3D.deviceRendererMap.get(this.screen.graphicsDevice);
            }
            if (Thread.currentThread() == this.screen.renderer) {
                J3dMessage j3dMessage = new J3dMessage();
                j3dMessage.threads = 16;
                j3dMessage.type = 42;
                j3dMessage.universe = this.view.universe;
                j3dMessage.view = this.view;
                j3dMessage.args[0] = this;
                this.screen.renderer.rendererStructure.addMessage(j3dMessage);
                this.screen.renderer.args = new Object[4];
                this.screen.renderer.args[0] = new Integer(2);
                this.screen.renderer.args[1] = this;
                this.screen.renderer.args[2] = this.view;
                this.screen.renderer.args[3] = null;
                this.screen.renderer.doWork(0L);
            } else {
                J3dMessage j3dMessage = new J3dMessage();
                j3dMessage.threads = 16;
                j3dMessage.type = 42;
                j3dMessage.universe = this.view.universe;
                j3dMessage.view = this.view;
                j3dMessage.args[0] = this;
                this.screen.renderer.rendererStructure.addMessage(j3dMessage);
                VirtualUniverse.mc.setWorkForRequestRenderer();
            }
        } else if (Thread.currentThread() instanceof BehaviorScheduler) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 16;
            j3dMessage.type = 42;
            j3dMessage.universe = this.view.universe;
            j3dMessage.view = this.view;
            j3dMessage.args[0] = this;
            this.screen.renderer.rendererStructure.addMessage(j3dMessage);
            VirtualUniverse.mc.setWorkForRequestRenderer();
        } else {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 42;
            j3dMessage.universe = this.pendingView.universe;
            j3dMessage.view = this.pendingView;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = this.offScreenBuffer;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    public void waitForOffScreenRendering() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (Thread.currentThread() instanceof Renderer) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D31"));
        }
        while (this.offScreenRendering) {
            MasterControl.threadYield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffScreenLocation(int n, int n2) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffScreenLocation(Point point) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(point);
        }
    }

    public Point getOffScreenLocation() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return new Point(this.offScreenCanvasLoc);
    }

    public Point getOffScreenLocation(Point point) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (point == null) {
            return new Point(this.offScreenCanvasLoc);
        }
        point.setLocation(this.offScreenCanvasLoc);
        return point;
    }

    void endOffScreenRendering() {
        ImageComponent2DRetained imageComponent2DRetained = (ImageComponent2DRetained)this.offScreenBuffer.retained;
        boolean bl = imageComponent2DRetained.isByReference();
        ImageComponentRetained.ImageData imageData = imageComponent2DRetained.getImageData(false);
        if (!bl) {
            if (imageData == null) {
                assert (!bl);
                imageComponent2DRetained.createBlankImageData();
                imageData = imageComponent2DRetained.getImageData(false);
            } else {
                imageComponent2DRetained.evaluateExtensions(this);
            }
            this.readOffScreenBuffer(this.ctx, imageComponent2DRetained.getImageFormatTypeIntValue(false), imageComponent2DRetained.getImageDataTypeIntValue(), imageData.get(), this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
        } else {
            imageComponent2DRetained.geomLock.getLock();
            imageComponent2DRetained.evaluateExtensions(this);
            this.readOffScreenBuffer(this.ctx, imageComponent2DRetained.getImageFormatTypeIntValue(false), imageComponent2DRetained.getImageDataTypeIntValue(), imageData.get(), this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
            if (!imageData.isDataByRef()) {
                if (imageComponent2DRetained.isImageTypeSupported()) {
                    imageComponent2DRetained.copyToRefImage(0);
                } else {
                    imageComponent2DRetained.copyToRefImageWithFormatConversion(0);
                }
            }
            imageComponent2DRetained.geomLock.unLock();
        }
    }

    public void swap() {
        if (this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D0"));
        }
        if (!this.firstPaintCalled) {
            return;
        }
        if (this.view != null && this.graphicsContext3D != null) {
            if (this.view.universe != null && Thread.currentThread() == this.view.universe.behaviorScheduler) {
                this.graphicsContext3D.sendRenderMessage(false, 2, null, null);
            } else {
                this.graphicsContext3D.sendRenderMessage(true, 2, null, null);
            }
            this.graphicsContext3D.runMonitor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSwap() {
        block8: {
            if (this.firstPaintCalled && this.useDoubleBuffer) {
                try {
                    if (!this.validCtx || this.ctx == null || this.view == null) break block8;
                    DrawingSurfaceObject drawingSurfaceObject = this.drawingSurfaceObject;
                    synchronized (drawingSurfaceObject) {
                        if (this.validCtx) {
                            if (!this.drawingSurfaceObject.renderLock()) {
                                this.graphicsContext3D.runMonitor(2);
                                return;
                            }
                            this.syncRender(this.ctx, true);
                            this.swapBuffers(this.ctx, this.drawable);
                            this.drawingSurfaceObject.unLock();
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    this.drawingSurfaceObject.unLock();
                }
            }
        }
        this.view.universe.behaviorStructure.incElapsedFrames();
        this.graphicsContext3D.runMonitor(2);
    }

    Context createNewContext(Context context, boolean bl) {
        Context context2 = this.createNewContext(this.drawable, context, bl, this.offScreen);
        this.maxAvailableTextureUnits = Math.max(this.maxTextureUnits, this.maxTextureImageUnits);
        this.antialiasingSet = false;
        return context2;
    }

    final void makeCtxCurrent() {
        this.makeCtxCurrent(this.ctx, this.drawable);
    }

    final void makeCtxCurrent(Context context) {
        this.makeCtxCurrent(context, this.drawable);
    }

    final void makeCtxCurrent(Context context, Drawable drawable) {
        if (context != this.screen.renderer.currentCtx || drawable != this.screen.renderer.currentDrawable) {
            if (!this.drawingSurfaceObject.isLocked()) {
                this.drawingSurfaceObject.renderLock();
                Canvas3D.useCtx(context, drawable);
                this.drawingSurfaceObject.unLock();
            } else {
                Canvas3D.useCtx(context, drawable);
            }
            this.screen.renderer.currentCtx = context;
            this.screen.renderer.currentDrawable = drawable;
        }
    }

    void releaseCtx() {
        if (this.screen.renderer.currentCtx != null) {
            boolean bl;
            boolean bl2 = bl = !this.drawingSurfaceObject.isLocked();
            if (bl) {
                this.drawingSurfaceObject.renderLock();
            }
            if (this.releaseCtx(this.screen.renderer.currentCtx)) {
                this.screen.renderer.currentCtx = null;
                this.screen.renderer.currentDrawable = null;
            }
            if (bl) {
                this.drawingSurfaceObject.unLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftManualEyeInImagePlate(Point3d point3d) {
        this.leftManualEyeInImagePlate.set((Tuple3d)point3d);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 4;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 4;
        }
        this.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightManualEyeInImagePlate(Point3d point3d) {
        this.rightManualEyeInImagePlate.set((Tuple3d)point3d);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 4;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 4;
        }
        this.redraw();
    }

    public void getLeftManualEyeInImagePlate(Point3d point3d) {
        point3d.set((Tuple3d)this.leftManualEyeInImagePlate);
    }

    public void getRightManualEyeInImagePlate(Point3d point3d) {
        point3d.set((Tuple3d)this.rightManualEyeInImagePlate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLeftEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set((Tuple3d)this.canvasViewCache.getLeftEyeInImagePlate());
            }
        } else {
            point3d.set((Tuple3d)this.leftManualEyeInImagePlate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRightEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set((Tuple3d)this.canvasViewCache.getRightEyeInImagePlate());
            }
        } else {
            point3d.set((Tuple3d)this.rightManualEyeInImagePlate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCenterEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set((Tuple3d)this.canvasViewCache.getCenterEyeInImagePlate());
            }
        } else {
            Point3d point3d2 = new Point3d();
            point3d2.add((Tuple3d)this.leftManualEyeInImagePlate, (Tuple3d)this.rightManualEyeInImagePlate);
            point3d2.scale(0.5);
            point3d.set((Tuple3d)point3d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImagePlateToVworld(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getImagePlateToVworld());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixelLocationInImagePlate(int n, int n2, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.x = this.canvasViewCache.getWindowXInImagePlate(n);
                point3d.y = this.canvasViewCache.getWindowYInImagePlate(n2);
                point3d.z = 0.0;
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getPixelLocationInImagePlate(double d, double d2, double d3, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                this.canvasViewCache.getPixelLocationInImagePlate(d, d2, d3, point3d);
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixelLocationInImagePlate(Point2d point2d, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.x = this.canvasViewCache.getWindowXInImagePlate(point2d.x);
                point3d.y = this.canvasViewCache.getWindowYInImagePlate(point2d.y);
                point3d.z = 0.0;
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixelLocationFromImagePlate(Point3d point3d, Point2d point2d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                this.canvasViewCache.getPixelLocationFromImagePlate(point3d, point2d);
            }
        } else {
            point2d.set(0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVworldProjection(Transform3D transform3D, Transform3D transform3D2) {
        if (this.canvasViewCache != null) {
            ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)this.view.getViewPlatform().retained;
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.mul(this.canvasViewCache.getLeftProjection(), this.canvasViewCache.getLeftVpcToEc());
                transform3D.mul(viewPlatformRetained.getVworldToVpc());
                if (this.useStereo) {
                    transform3D2.mul(this.canvasViewCache.getRightProjection(), this.canvasViewCache.getRightVpcToEc());
                    transform3D2.mul(viewPlatformRetained.getVworldToVpc());
                } else {
                    transform3D2.set(transform3D);
                }
            }
        } else {
            transform3D.setIdentity();
            transform3D2.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInverseVworldProjection(Transform3D transform3D, Transform3D transform3D2) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getLeftCcToVworld());
                if (this.useStereo) {
                    transform3D2.set(this.canvasViewCache.getRightCcToVworld());
                } else {
                    transform3D2.set(transform3D);
                }
            }
        } else {
            transform3D.setIdentity();
            transform3D2.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPhysicalWidth() {
        double d = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                d = this.canvasViewCache.getPhysicalWindowWidth();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPhysicalHeight() {
        double d = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                d = this.canvasViewCache.getPhysicalWindowHeight();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVworldToImagePlate(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getVworldToImagePlate());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getLastVworldToImagePlate(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getLastVworldToImagePlate());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    void setView(View view) {
        this.pendingView = view;
        VirtualUniverse.mc.postRequest(MasterControl.SET_VIEW, this);
        this.evaluateActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeViewCache() {
        Object object = this.cvLock;
        synchronized (object) {
            if (this.view == null) {
                this.canvasViewCache = null;
                this.canvasViewCacheFrustum = null;
            } else {
                this.canvasViewCache = new CanvasViewCache(this, this.screen.screenViewCache, this.view.viewCache);
                this.canvasViewCacheFrustum = new CanvasViewCache(this, this.screen.screenViewCache, this.view.viewCache);
                Object object2 = this.dirtyMaskLock;
                synchronized (object2) {
                    this.cvDirtyMask[0] = 63;
                    this.cvDirtyMask[1] = 63;
                }
            }
        }
    }

    public View getView() {
        return this.pendingView;
    }

    public boolean getStereoAvailable() {
        return (Boolean)this.queryProperties().get("stereoAvailable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStereoEnable(boolean bl) {
        this.stereoEnable = bl;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 1;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 1;
        }
        this.redraw();
    }

    public boolean getStereoEnable() {
        return this.stereoEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonoscopicViewPolicy(int n) {
        if (this.view != null && this.view.viewPolicy == 1 && this.monoscopicViewPolicy == 2 && !this.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        this.monoscopicViewPolicy = n;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 2;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 2;
        }
        this.redraw();
    }

    public int getMonoscopicViewPolicy() {
        return this.monoscopicViewPolicy;
    }

    public boolean getDoubleBufferAvailable() {
        return (Boolean)this.queryProperties().get("doubleBufferAvailable");
    }

    public void setDoubleBufferEnable(boolean bl) {
        this.doubleBufferEnable = bl;
        boolean bl2 = this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        if (Thread.currentThread() == this.screen.renderer) {
            this.setRenderMode(this.ctx, 2, this.useDoubleBuffer);
        }
        this.redraw();
    }

    public boolean getDoubleBufferEnable() {
        return this.doubleBufferEnable;
    }

    public boolean getSceneAntialiasingAvailable() {
        return (Boolean)this.queryProperties().get("sceneAntialiasingAvailable");
    }

    public boolean isShadingLanguageSupported(int n) {
        this.queryProperties();
        if (n == 1) {
            return this.shadingLanguageGLSL;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map queryProperties() {
        if (this.queryProps == null) {
            boolean bl = false;
            Object object = VirtualUniverse.mc.contextCreationLock;
            synchronized (object) {
                if (this.ctx == null) {
                    bl = true;
                }
            }
            if (bl) {
                GraphicsConfigTemplate3D.setQueryProps(this);
            }
            this.createQueryProps();
        }
        if (this.fatalError) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D29"));
        }
        return this.queryProps;
    }

    void createQueryContext() {
        this.createQueryContext(this.drawable, this.offScreen, 1, 1);
        this.maxAvailableTextureUnits = Math.max(this.maxTextureUnits, this.maxTextureImageUnits);
    }

    private void createQueryProps() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = 0;
        arrayList.add("doubleBufferAvailable");
        arrayList2.add(new Boolean(this.doubleBufferAvailable));
        arrayList.add("stereoAvailable");
        arrayList2.add(new Boolean(this.stereoAvailable));
        arrayList.add("sceneAntialiasingAvailable");
        arrayList2.add(new Boolean(this.sceneAntialiasingAvailable));
        arrayList.add("sceneAntialiasingNumPasses");
        if (this.sceneAntialiasingAvailable) {
            n = this.sceneAntialiasingMultiSamplesAvailable ? 1 : 8;
        }
        arrayList2.add(new Integer(n));
        arrayList.add("stencilSize");
        if (this.userStencilAvailable) {
            arrayList2.add(new Integer(this.actualStencilSize));
        } else {
            arrayList2.add(new Integer(0));
        }
        arrayList.add("compressedGeometry.majorVersionNumber");
        arrayList2.add(new Integer(1));
        arrayList.add("compressedGeometry.minorVersionNumber");
        arrayList2.add(new Integer(0));
        arrayList.add("compressedGeometry.minorMinorVersionNumber");
        arrayList2.add(new Integer(2));
        arrayList.add("texture3DAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 1) != 0));
        arrayList.add("textureColorTableSize");
        arrayList2.add(new Integer(this.textureColorTableSize));
        arrayList.add("textureEnvCombineAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 8) != 0));
        arrayList.add("textureCombineDot3Available");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x10) != 0));
        arrayList.add("textureCombineSubtractAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x20) != 0));
        arrayList.add("textureCubeMapAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x80) != 0));
        arrayList.add("textureSharpenAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x100) != 0));
        arrayList.add("textureDetailAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x200) != 0));
        arrayList.add("textureFilter4Available");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x400) != 0));
        arrayList.add("textureAnisotropicFilterDegreeMax");
        arrayList2.add(new Float(this.anisotropicDegreeMax));
        arrayList.add("textureWidthMax");
        arrayList2.add(new Integer(this.textureWidthMax));
        arrayList.add("textureHeightMax");
        arrayList2.add(new Integer(this.textureHeightMax));
        arrayList.add("texture3DWidthMax");
        arrayList2.add(new Integer(this.texture3DWidthMax));
        arrayList.add("texture3DHeightMax");
        arrayList2.add(new Integer(this.texture3DHeightMax));
        arrayList.add("texture3DDepthMax");
        arrayList2.add(new Integer(this.texture3DDepthMax));
        arrayList.add("textureBoundaryWidthMax");
        arrayList2.add(new Integer(this.textureBoundaryWidthMax));
        arrayList.add("textureLodRangeAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x1000) != 0));
        arrayList.add("textureLodOffsetAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x2000) != 0));
        arrayList.add("textureNonPowerOfTwoAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x8000) != 0));
        arrayList.add("textureAutoMipMapGenerationAvailable");
        arrayList2.add(new Boolean((this.textureExtendedFeatures & 0x10000) != 0));
        arrayList.add("textureCoordSetsMax");
        arrayList2.add(new Integer(this.maxTexCoordSets));
        arrayList.add("textureUnitStateMax");
        arrayList2.add(new Integer(this.maxTextureUnits));
        arrayList.add("textureImageUnitsMax");
        arrayList2.add(new Integer(this.maxTextureImageUnits));
        arrayList.add("textureImageUnitsVertexMax");
        arrayList2.add(new Integer(this.maxVertexTextureImageUnits));
        arrayList.add("textureImageUnitsCombinedMax");
        arrayList2.add(new Integer(this.maxCombinedTextureImageUnits));
        arrayList.add("vertexAttrsMax");
        arrayList2.add(new Integer(this.maxVertexAttrs));
        arrayList.add("shadingLanguageGLSL");
        arrayList2.add(new Boolean(this.shadingLanguageGLSL));
        arrayList.add("native.version");
        arrayList2.add(this.nativeGraphicsVersion);
        arrayList.add("native.vendor");
        arrayList2.add(this.nativeGraphicsVendor);
        arrayList.add("native.renderer");
        arrayList2.add(this.nativeGraphicsRenderer);
        this.queryProps = new J3dQueryProps(arrayList, arrayList2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateViewCache(boolean bl, CanvasViewCache canvasViewCache, BoundingBox boundingBox, boolean bl2) {
        assert (canvasViewCache == null);
        Object object = this.cvLock;
        synchronized (object) {
            if (this.firstPaintCalled && this.canvasViewCache != null) {
                assert (this.canvasViewCacheFrustum != null);
                if (boundingBox != null) {
                    this.canvasViewCacheFrustum.snapshot(true);
                    this.canvasViewCacheFrustum.computeDerivedData(bl, null, boundingBox, bl2);
                } else {
                    this.canvasViewCache.snapshot(false);
                    this.canvasViewCache.computeDerivedData(bl, null, null, bl2);
                }
            }
        }
    }

    void setDepthBufferWriteEnableOverride(boolean bl) {
        this.depthBufferWriteEnableOverride = bl;
    }

    void setDepthBufferEnableOverride(boolean bl) {
        this.depthBufferEnableOverride = bl;
    }

    void resetTexture(Context context, int n) {
        this.resetTextureNative(context, n);
        if (n < 0) {
            n = 0;
        }
        this.texUnitState[n].mirror = null;
        this.texUnitState[n].texture = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetRendering() {
        this.reset();
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 0x3F;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 0x3F;
        }
    }

    void reset() {
        int n;
        this.currentAppear = new AppearanceRetained();
        this.currentMaterial = new MaterialRetained();
        this.viewFrustum = new CachedFrustum();
        this.canvasDirty = 65535;
        this.lightBin = null;
        this.environmentSet = null;
        this.attributeBin = null;
        this.shaderBin = null;
        this.textureBin = null;
        this.renderMolecule = null;
        this.polygonAttributes = null;
        this.lineAttributes = null;
        this.pointAttributes = null;
        this.material = null;
        this.enableLighting = false;
        this.transparency = null;
        this.coloringAttributes = null;
        this.shaderProgram = null;
        this.texture = null;
        this.texAttrs = null;
        if (this.texUnitState != null) {
            for (n = 0; n < this.texUnitState.length; ++n) {
                TextureUnitStateRetained textureUnitStateRetained = this.texUnitState[n];
                if (textureUnitStateRetained == null) continue;
                textureUnitStateRetained.texAttrs = null;
                textureUnitStateRetained.texGen = null;
            }
        }
        this.texCoordGeneration = null;
        this.renderingAttrs = null;
        this.appearance = null;
        this.appHandle = null;
        this.dirtyRenderMoleculeList.clear();
        this.displayListResourceFreeList.clear();
        this.dirtyDlistPerRinfoList.clear();
        this.textureIdResourceFreeList.clear();
        this.lightChanged = true;
        this.modelMatrix = null;
        this.modelClip = null;
        this.fog = null;
        this.sceneAmbient = new Color3f();
        for (n = 0; n < this.frameCount.length; ++n) {
            this.frameCount[n] = -1;
        }
        for (n = 0; n < this.lights.length; ++n) {
            this.lights[n] = null;
        }
        if (this.currentLights != null) {
            for (n = 0; n < this.currentLights.length; ++n) {
                this.currentLights[n] = null;
            }
        }
        this.enableMask = -1L;
        this.stateUpdateMask = 0;
        this.depthBufferWriteEnableOverride = false;
        this.depthBufferEnableOverride = false;
        this.depthBufferWriteEnable = true;
        this.vfPlanesValid = false;
        this.lightChanged = false;
        for (n = 0; n < this.curStateToUpdate.length; ++n) {
            this.curStateToUpdate[n] = null;
        }
        this.needToRebuildDisplayList = true;
        this.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetImmediateRendering() {
        this.canvasDirty = 65535;
        this.ra = null;
        this.setSceneAmbient(this.ctx, 0.0f, 0.0f, 0.0f);
        this.disableFog(this.ctx);
        this.resetRenderingAttributes(this.ctx, false, false);
        this.resetTexture(this.ctx, -1);
        this.resetTexCoordGeneration(this.ctx);
        this.resetTextureAttributes(this.ctx);
        this.texUnitState[0].texAttrs = null;
        this.texUnitState[0].texGen = null;
        this.resetPolygonAttributes(this.ctx);
        this.resetLineAttributes(this.ctx);
        this.resetPointAttributes(this.ctx);
        this.resetTransparency(this.ctx, 4, 2, false, false);
        this.resetColoringAttributes(this.ctx, 1.0f, 1.0f, 1.0f, 1.0f, false);
        this.updateMaterial(this.ctx, 1.0f, 1.0f, 1.0f, 1.0f);
        this.resetRendering();
        this.makeCtxCurrent();
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 0x3F;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 0x3F;
        }
        this.needToRebuildDisplayList = true;
        this.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
    }

    public Point getLocationOnScreen() {
        try {
            return super.getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return new Point();
        }
    }

    void setProjectionMatrix(Context context, Transform3D transform3D) {
        this.projTrans = transform3D;
        this.setProjectionMatrix(context, transform3D.mat);
    }

    void setModelViewMatrix(Context context, double[] dArray, Transform3D transform3D) {
        this.setModelViewMatrix(context, dArray, transform3D.mat);
        if (!this.useStereo) {
            this.modelMatrix = transform3D;
        } else if (this.rightStereoPass) {
            this.modelMatrix = transform3D;
        }
    }

    void setDepthBufferWriteEnable(boolean bl) {
        this.depthBufferWriteEnable = bl;
        this.setDepthBufferWriteEnable(this.ctx, bl);
    }

    void setNumActiveTexUnit(int n) {
        this.numActiveTexUnit = n;
    }

    int getNumActiveTexUnit() {
        return this.numActiveTexUnit;
    }

    void setLastActiveTexUnit(int n) {
        this.lastActiveTexUnit = n;
    }

    int getLastActiveTexUnit() {
        return this.lastActiveTexUnit;
    }

    void createTexUnitState() {
        this.texUnitState = new TextureUnitStateRetained[this.maxAvailableTextureUnits];
        for (int i = 0; i < this.maxAvailableTextureUnits; ++i) {
            this.texUnitState[i] = new TextureUnitStateRetained();
            this.texUnitState[i].texture = null;
            this.texUnitState[i].mirror = null;
        }
    }

    boolean supportGlobalAlpha() {
        return (this.extensionsSupported & 1) != 0;
    }

    void enableSeparateSpecularColor() {
        boolean bl = !VirtualUniverse.mc.disableSeparateSpecularColor;
        this.updateSeparateSpecularColorEnable(this.ctx, bl);
    }

    private void sendCreateOffScreenBuffer() {
        if (!(Thread.currentThread() instanceof BehaviorScheduler) && !(Thread.currentThread() instanceof Renderer)) {
            this.offScreenBufferPending = true;
        }
        VirtualUniverse.mc.sendCreateOffScreenBuffer(this);
        while (this.offScreenBufferPending) {
            VirtualUniverse.mc.createMasterControlThread();
            MasterControl.threadYield();
        }
    }

    private void sendDestroyCtxAndOffScreenBuffer() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof BehaviorScheduler) && !(thread instanceof Renderer)) {
            this.offScreenBufferPending = true;
        }
        VirtualUniverse.mc.sendDestroyCtxAndOffScreenBuffer(this);
        while (this.offScreenBufferPending) {
            VirtualUniverse.mc.createMasterControlThread();
            MasterControl.threadYield();
        }
    }

    private void sendAllocateCanvasId() {
        VirtualUniverse.mc.sendAllocateCanvasId(this);
    }

    private void sendFreeCanvasId() {
        VirtualUniverse.mc.sendFreeCanvasId(this);
    }

    private void removeCtx() {
        if (this.screen != null && this.screen.renderer != null && this.ctx != null) {
            VirtualUniverse.mc.postRequest(MasterControl.FREE_CONTEXT, new Object[]{this, 0L, this.drawable, this.ctx});
            Thread thread = Thread.currentThread();
            if (!(thread instanceof BehaviorScheduler) && !(thread instanceof Renderer)) {
                while (this.ctxTimeStamp != 0L) {
                    MasterControl.threadYield();
                }
            }
            this.ctx = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new UnsupportedOperationException(J3dI18N.getString("Canvas3D20"));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(J3dI18N.getString("Canvas3D20"));
    }

    void setStateIsUpdated(int n) {
        this.stateUpdateMask &= ~(1 << n);
    }

    void setStateToUpdate(int n, Object object) {
        this.stateUpdateMask |= 1 << n;
        this.curStateToUpdate[n] = object;
    }

    void updateEnvState() {
        if ((this.stateUpdateMask & ENV_STATE_MASK) == 0) {
            return;
        }
        if ((this.stateUpdateMask & 1) != 0) {
            ((LightBin)this.curStateToUpdate[0]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 2) != 0) {
            ((EnvironmentSet)this.curStateToUpdate[1]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 4) != 0) {
            ((AttributeBin)this.curStateToUpdate[2]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 0x40) != 0) {
            ((ShaderBin)this.curStateToUpdate[6]).updateAttributes(this);
        }
        this.stateUpdateMask &= ~ENV_STATE_MASK;
    }

    void updateState(int n) {
        if (this.stateUpdateMask == 0) {
            return;
        }
        this.updateEnvState();
        if ((this.stateUpdateMask & 8) != 0) {
            ((TextureBin)this.curStateToUpdate[3]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 0x10) != 0) {
            ((RenderMolecule)this.curStateToUpdate[4]).updateAttributes(this, n);
        }
        if ((this.stateUpdateMask & 0x20) != 0) {
            ((RenderMolecule)this.curStateToUpdate[4]).updateTransparencyAttributes(this);
            this.stateUpdateMask &= 0xFFFFFFDF;
        }
        this.stateUpdateMask = 0;
    }

    void updateTextureForRaster(Texture2DRetained texture2DRetained) {
        Pipeline.getPipeline().updateTextureUnitState(this.ctx, 0, true);
        this.setLastActiveTexUnit(0);
        this.setNumActiveTexUnit(1);
        texture2DRetained.updateNative(this);
        this.resetTexCoordGeneration(this.ctx);
        this.resetTextureAttributes(this.ctx);
        for (int i = 1; i < this.maxTextureUnits; ++i) {
            this.resetTexture(this.ctx, i);
        }
        this.activeTextureUnit(this.ctx, 0);
        this.canvasDirty |= 0xC00;
    }

    void restoreTextureBin() {
        if (this.textureBin != null && this.textureBin.shaderBin != null) {
            this.textureBin.updateAttributes(this);
        }
    }

    void textureFill(RasterRetained rasterRetained, Point2d point2d, float f, float f2) {
        int n = this.canvasViewCache.getCanvasWidth();
        int n2 = this.canvasViewCache.getCanvasHeight();
        int n3 = rasterRetained.image.width;
        int n4 = rasterRetained.image.height;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        Point point = new Point();
        rasterRetained.getSrcOffset(point);
        Dimension dimension = new Dimension();
        rasterRetained.getSize(dimension);
        int n5 = point.x;
        int n6 = point.x + dimension.width;
        int n7 = point.y;
        int n8 = point.y + dimension.height;
        if (n5 >= n3 || n7 >= n4 || n6 <= 0 || n8 <= 0) {
            return;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n6 > n3) {
            n6 = n3;
        }
        if (n8 > n4) {
            n8 = n4;
        }
        f3 = (float)n5 / (float)n3;
        f5 = (float)n6 / (float)n3;
        f7 = (float)point2d.x / (float)n;
        f9 = (float)(point2d.x + (double)(n6 - n5)) / (float)n;
        if (rasterRetained.image.isYUp()) {
            f4 = (float)n7 / (float)n4;
            f6 = (float)n8 / (float)n4;
        } else {
            f4 = 1.0f - (float)n8 / (float)n4;
            f6 = 1.0f - (float)n7 / (float)n4;
        }
        f8 = 1.0f - (float)(point2d.y + (double)(n8 - n7)) / (float)n2;
        f10 = 1.0f - (float)point2d.y / (float)n2;
        this.textureFillRaster(this.ctx, f3, f5, f4, f6, f7, f9, f8, f10, f, f2, rasterRetained.image.useBilinearFilter());
    }

    void textureFill(BackgroundRetained backgroundRetained, int n, int n2) {
        int n3 = backgroundRetained.image.width;
        int n4 = backgroundRetained.image.height;
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        switch (backgroundRetained.imageScaleMode) {
            case 0: {
                f4 = 0.0f;
                f5 = 0.0f;
                f6 = 1.0f;
                f7 = 1.0f;
                f13 = (float)n / 2.0f;
                f14 = (float)n2 / 2.0f;
                f9 = (0.0f - f13) / f13;
                f10 = (0.0f - f14) / f14;
                f11 = ((float)n3 - f13) / f13;
                f12 = ((float)n4 - f14) / f14;
                f8 = ((float)n2 - (float)n4) / f14;
                f10 += f8;
                f12 += f8;
                break;
            }
            case 1: {
                f3 = Math.min(f, f2);
                f4 = 0.0f;
                f5 = 0.0f;
                f6 = 1.0f;
                f7 = 1.0f;
                f9 = -1.0f;
                f12 = 1.0f;
                if (f < f2) {
                    f11 = 1.0f;
                    f10 = -1.0f + 2.0f * (1.0f - f3 * (float)n4 / (float)n2);
                    break;
                }
                f11 = -1.0f + f3 * (float)n3 / (float)n * 2.0f;
                f10 = -1.0f;
                break;
            }
            case 2: {
                f3 = Math.max(f, f2);
                f9 = -1.0f;
                f10 = -1.0f;
                f11 = 1.0f;
                f12 = 1.0f;
                if (f < f2) {
                    f4 = 0.0f;
                    f5 = 0.0f;
                    f6 = (float)n / (float)n3 / f3;
                    f7 = 1.0f;
                    break;
                }
                f4 = 0.0f;
                f5 = 1.0f - (float)n2 / (float)n4 / f3;
                f6 = 1.0f;
                f7 = 1.0f;
                break;
            }
            case 3: {
                f4 = 0.0f;
                f5 = 0.0f;
                f6 = 1.0f;
                f7 = 1.0f;
                f9 = -1.0f;
                f10 = -1.0f;
                f11 = 1.0f;
                f12 = 1.0f;
                break;
            }
            case 4: {
                f4 = 0.0f;
                f5 = -f2;
                f6 = f;
                f7 = 0.0f;
                f9 = -1.0f;
                f10 = -1.0f;
                f11 = 1.0f;
                f12 = 1.0f;
                break;
            }
            case 5: {
                if (f >= 1.0f) {
                    f4 = 0.0f;
                    f6 = 1.0f;
                    f9 = -((float)n3) / (float)n;
                    f11 = (float)n3 / (float)n;
                } else {
                    f4 = 0.5f - (float)n / (float)n3 / 2.0f;
                    f6 = 0.5f + (float)n / (float)n3 / 2.0f;
                    f9 = -1.0f;
                    f11 = 1.0f;
                }
                if (f2 >= 1.0f) {
                    f5 = 0.0f;
                    f7 = 1.0f;
                    f10 = -((float)n4) / (float)n2;
                    f12 = (float)n4 / (float)n2;
                    break;
                }
                f5 = 0.5f - (float)n2 / (float)n4 / 2.0f;
                f7 = 0.5f + (float)n2 / (float)n4 / 2.0f;
                f10 = -1.0f;
                f12 = 1.0f;
            }
        }
        this.textureFillBackground(this.ctx, f4, f6, f5, f7, f9, f11, f10, f12, backgroundRetained.image.useBilinearFilter());
    }

    void clear(BackgroundRetained backgroundRetained, int n, int n2) {
        boolean bl = VirtualUniverse.mc.stencilClear && this.userStencilAvailable;
        this.clear(this.ctx, backgroundRetained.color.x, backgroundRetained.color.y, backgroundRetained.color.z, bl);
        if (backgroundRetained.image != null && backgroundRetained.image.imageData != null) {
            this.updateTextureForRaster(backgroundRetained.texture);
            this.textureFill(backgroundRetained, n, n2);
            this.restoreTextureBin();
        }
    }

    void addTextureResource(int n, TextureRetained textureRetained) {
        if (n <= 0) {
            return;
        }
        if (this.useSharedCtx) {
            this.screen.renderer.addTextureResource(n, textureRetained);
        } else if (this.textureIDResourceTable.size() <= n) {
            for (int i = this.textureIDResourceTable.size(); i < n; ++i) {
                this.textureIDResourceTable.add(null);
            }
            this.textureIDResourceTable.add(textureRetained);
        } else {
            this.textureIDResourceTable.set(n, textureRetained);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeResourcesInFreeList(Context context) {
        if (this.displayListResourceFreeList.size() > 0) {
            for (int n : this.displayListResourceFreeList) {
                if (n <= 0) continue;
                Canvas3D.freeDisplayList(context, n);
            }
            this.displayListResourceFreeList.clear();
        }
        if (this.textureIdResourceFreeList.size() > 0) {
            for (int n : this.textureIdResourceFreeList) {
                if (n <= 0) continue;
                if (n >= this.textureIDResourceTable.size()) {
                    System.err.println("Error in freeResourcesInFreeList : ResourceIDTableSize = " + this.textureIDResourceTable.size() + " val = " + n);
                } else {
                    TextureRetained textureRetained = this.textureIDResourceTable.get(n);
                    if (textureRetained != null) {
                        Object object = textureRetained.resourceLock;
                        synchronized (object) {
                            textureRetained.resourceCreationMask &= ~this.canvasBit;
                            if (textureRetained.resourceCreationMask == 0) {
                                textureRetained.freeTextureId(n);
                            }
                        }
                    }
                    this.textureIDResourceTable.set(n, null);
                }
                Canvas3D.freeTexture(context, n);
            }
            this.textureIdResourceFreeList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeContextResources(Renderer renderer, boolean bl, Context context) {
        if (renderer == null || context == null) {
            return;
        }
        if (bl && this.graphics2D != null) {
            this.graphics2D.dispose();
        }
        for (int i = this.textureIDResourceTable.size() - 1; i >= 0; --i) {
            TextureRetained textureRetained = this.textureIDResourceTable.get(i);
            if (textureRetained == null) continue;
            Canvas3D.freeTexture(context, i);
            Object object = textureRetained.resourceLock;
            synchronized (object) {
                textureRetained.resourceCreationMask &= ~this.canvasBit;
                if (textureRetained.resourceCreationMask == 0) {
                    textureRetained.freeTextureId(i);
                }
                continue;
            }
        }
        this.textureIDResourceTable.clear();
        this.freeAllDisplayListResources(context);
    }

    void freeAllDisplayListResources(Context context) {
        if (this.view != null && this.view.renderBin != null) {
            this.view.renderBin.freeAllDisplayListResources(this, context);
            if (this.useSharedCtx && this.screen != null && this.screen.renderer != null) {
                this.screen.renderer.needToRebuildDisplayList = true;
            }
        }
    }

    private Context createNewContext(Drawable drawable, Context context, boolean bl, boolean bl2) {
        return Pipeline.getPipeline().createNewContext(this, drawable, context, bl, bl2);
    }

    private void createQueryContext(Drawable drawable, boolean bl, int n, int n2) {
        Pipeline.getPipeline().createQueryContext(this, drawable, bl, n, n2);
    }

    Drawable createOffScreenBuffer(Context context, int n, int n2) {
        return Pipeline.getPipeline().createOffScreenBuffer(this, context, n, n2);
    }

    void destroyOffScreenBuffer(Context context, Drawable drawable) {
        assert (drawable != null);
        Pipeline.getPipeline().destroyOffScreenBuffer(this, context, drawable);
    }

    private void readOffScreenBuffer(Context context, int n, int n2, Object object, int n3, int n4) {
        Pipeline.getPipeline().readOffScreenBuffer(this, context, n, n2, object, n3, n4);
    }

    void swapBuffers(Context context, Drawable drawable) {
        Pipeline.getPipeline().swapBuffers(this, context, drawable);
    }

    void updateMaterial(Context context, float f, float f2, float f3, float f4) {
        Pipeline.getPipeline().updateMaterialColor(context, f, f2, f3, f4);
    }

    static void destroyContext(Drawable drawable, Context context) {
        Pipeline.getPipeline().destroyContext(drawable, context);
    }

    void accum(Context context, float f) {
        Pipeline.getPipeline().accum(context, f);
    }

    void accumReturn(Context context) {
        Pipeline.getPipeline().accumReturn(context);
    }

    void clearAccum(Context context) {
        Pipeline.getPipeline().clearAccum(context);
    }

    int getNumCtxLights(Context context) {
        return Pipeline.getPipeline().getNumCtxLights(context);
    }

    boolean decal1stChildSetup(Context context) {
        return Pipeline.getPipeline().decal1stChildSetup(context);
    }

    void decalNthChildSetup(Context context) {
        Pipeline.getPipeline().decalNthChildSetup(context);
    }

    void decalReset(Context context, boolean bl) {
        Pipeline.getPipeline().decalReset(context, bl);
    }

    void ctxUpdateEyeLightingEnable(Context context, boolean bl) {
        Pipeline.getPipeline().ctxUpdateEyeLightingEnable(context, bl);
    }

    void setBlendColor(Context context, float f, float f2, float f3, float f4) {
        Pipeline.getPipeline().setBlendColor(context, f, f2, f3, f4);
    }

    void setBlendFunc(Context context, int n, int n2) {
        Pipeline.getPipeline().setBlendFunc(context, n, n2);
    }

    void setFogEnableFlag(Context context, boolean bl) {
        Pipeline.getPipeline().setFogEnableFlag(context, bl);
    }

    boolean isAntialiasingSet() {
        return this.antialiasingSet;
    }

    void setFullSceneAntialiasing(Context context, boolean bl) {
        Pipeline.getPipeline().setFullSceneAntialiasing(context, bl);
        this.antialiasingSet = bl;
    }

    void setGlobalAlpha(Context context, float f) {
        Pipeline.getPipeline().setGlobalAlpha(context, f);
    }

    void updateSeparateSpecularColorEnable(Context context, boolean bl) {
        Pipeline.getPipeline().updateSeparateSpecularColorEnable(context, bl);
    }

    private boolean validGraphicsMode() {
        return Pipeline.getPipeline().validGraphicsMode();
    }

    void setLightEnables(Context context, long l, int n) {
        Pipeline.getPipeline().setLightEnables(context, l, n);
    }

    void setSceneAmbient(Context context, float f, float f2, float f3) {
        Pipeline.getPipeline().setSceneAmbient(context, f, f2, f3);
    }

    void disableFog(Context context) {
        Pipeline.getPipeline().disableFog(context);
    }

    void disableModelClip(Context context) {
        Pipeline.getPipeline().disableModelClip(context);
    }

    void resetRenderingAttributes(Context context, boolean bl, boolean bl2) {
        Pipeline.getPipeline().resetRenderingAttributes(context, bl, bl2);
    }

    void resetTextureNative(Context context, int n) {
        Pipeline.getPipeline().resetTextureNative(context, n);
    }

    void activeTextureUnit(Context context, int n) {
        Pipeline.getPipeline().activeTextureUnit(context, n);
    }

    void resetTexCoordGeneration(Context context) {
        Pipeline.getPipeline().resetTexCoordGeneration(context);
    }

    void resetTextureAttributes(Context context) {
        Pipeline.getPipeline().resetTextureAttributes(context);
    }

    void resetPolygonAttributes(Context context) {
        Pipeline.getPipeline().resetPolygonAttributes(context);
    }

    void resetLineAttributes(Context context) {
        Pipeline.getPipeline().resetLineAttributes(context);
    }

    void resetPointAttributes(Context context) {
        Pipeline.getPipeline().resetPointAttributes(context);
    }

    void resetTransparency(Context context, int n, int n2, boolean bl, boolean bl2) {
        Pipeline.getPipeline().resetTransparency(context, n, n2, bl, bl2);
    }

    void resetColoringAttributes(Context context, float f, float f2, float f3, float f4, boolean bl) {
        Pipeline.getPipeline().resetColoringAttributes(context, f, f2, f3, f4, bl);
    }

    void syncRender(Context context, boolean bl) {
        Pipeline.getPipeline().syncRender(context, bl);
    }

    static boolean useCtx(Context context, Drawable drawable) {
        return Pipeline.getPipeline().useCtx(context, drawable);
    }

    private boolean releaseCtx(Context context) {
        return Pipeline.getPipeline().releaseCtx(context);
    }

    void clear(Context context, float f, float f2, float f3, boolean bl) {
        Pipeline.getPipeline().clear(context, f, f2, f3, bl);
    }

    void textureFillBackground(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl) {
        Pipeline.getPipeline().textureFillBackground(context, f, f2, f3, f4, f5, f6, f7, f8, bl);
    }

    void textureFillRaster(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl) {
        Pipeline.getPipeline().textureFillRaster(context, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, bl);
    }

    void executeRasterDepth(Context context, float f, float f2, float f3, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        Pipeline.getPipeline().executeRasterDepth(context, f, f2, f3, n, n2, n3, n4, n5, n6, n7, object);
    }

    void setModelViewMatrix(Context context, double[] dArray, double[] dArray2) {
        Pipeline.getPipeline().setModelViewMatrix(context, dArray, dArray2);
    }

    void setProjectionMatrix(Context context, double[] dArray) {
        Pipeline.getPipeline().setProjectionMatrix(context, dArray);
    }

    void setViewport(Context context, int n, int n2, int n3, int n4) {
        Pipeline.getPipeline().setViewport(context, n, n2, n3, n4);
    }

    void newDisplayList(Context context, int n) {
        Pipeline.getPipeline().newDisplayList(context, n);
    }

    void endDisplayList(Context context) {
        Pipeline.getPipeline().endDisplayList(context);
    }

    void callDisplayList(Context context, int n, boolean bl) {
        Pipeline.getPipeline().callDisplayList(context, n, bl);
    }

    static void freeDisplayList(Context context, int n) {
        Pipeline.getPipeline().freeDisplayList(context, n);
    }

    static void freeTexture(Context context, int n) {
        Pipeline.getPipeline().freeTexture(context, n);
    }

    static int generateTexID(Context context) {
        return Pipeline.getPipeline().generateTexID(context);
    }

    void texturemapping(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, byte[] byArray, int n12, int n13) {
        Pipeline.getPipeline().texturemapping(context, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, byArray, n12, n13);
    }

    boolean initTexturemapping(Context context, int n, int n2, int n3) {
        return Pipeline.getPipeline().initTexturemapping(context, n, n2, n3);
    }

    void setRenderMode(Context context, int n, boolean bl) {
        Pipeline.getPipeline().setRenderMode(context, n, bl);
    }

    void setDepthBufferWriteEnable(Context context, boolean bl) {
        Pipeline.getPipeline().setDepthBufferWriteEnable(context, bl);
    }

    boolean hasDoubleBuffer() {
        return Pipeline.getPipeline().hasDoubleBuffer(this);
    }

    boolean hasStereo() {
        return Pipeline.getPipeline().hasStereo(this);
    }

    int getStencilSize() {
        return Pipeline.getPipeline().getStencilSize(this);
    }

    boolean hasSceneAntialiasingMultisample() {
        return Pipeline.getPipeline().hasSceneAntialiasingMultisample(this);
    }

    boolean hasSceneAntialiasingAccum() {
        return Pipeline.getPipeline().hasSceneAntialiasingAccum(this);
    }

    static {
        VirtualUniverse.loadLibraries();
        ENV_STATE_MASK = 71;
    }
}

