/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.common.os.MachineDescription;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;

public class Field {
    private String name;
    private Type type;
    private SizeThunk offset;

    public Field(String string, Type type, SizeThunk sizeThunk) {
        this.name = string;
        this.type = type;
        this.offset = sizeThunk;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Field)) {
            return false;
        }
        Field field = (Field)object;
        return (this.name != null && this.name.equals(field.name) || this.name == null && field.name == null) && this.type.equals(field.type);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public SizeThunk getOffset() {
        return this.offset;
    }

    public long getOffset(MachineDescription machineDescription) {
        return this.offset.computeSize(machineDescription);
    }

    public void setOffset(SizeThunk sizeThunk) {
        this.offset = sizeThunk;
    }

    public String toString() {
        if (!this.getType().isFunctionPointer()) {
            if (this.getName() == null && this.getType().asCompound() != null && this.getType().asCompound().isUnion()) {
                return "" + this.getType() + ";";
            }
            return "" + this.getType() + " " + this.getName() + ";";
        }
        FunctionType functionType = this.getType().asPointer().getTargetType().asFunction();
        return functionType.toString(this.getName(), null, false, true) + ";";
    }
}

