/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.common.os.MachineDescription;

public abstract class SizeThunk
implements Cloneable {
    private boolean fixedNativeSize;
    public static final SizeThunk INT8 = new SizeThunk(true){

        @Override
        public long computeSize(MachineDescription machineDescription) {
            return machineDescription.int8SizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDescription machineDescription) {
            return machineDescription.int8AlignmentInBytes();
        }
    };
    public static final SizeThunk INT16 = new SizeThunk(true){

        @Override
        public long computeSize(MachineDescription machineDescription) {
            return machineDescription.int16SizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDescription machineDescription) {
            return machineDescription.int16AlignmentInBytes();
        }
    };
    public static final SizeThunk INT32 = new SizeThunk(true){

        @Override
        public long computeSize(MachineDescription machineDescription) {
            return machineDescription.int32SizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDescription machineDescription) {
            return machineDescription.int32AlignmentInBytes();
        }
    };
    public static final SizeThunk INTxx = new SizeThunk(false){

        @Override
        public long computeSize(MachineDescription machineDescription) {
            return machineDescription.intSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDescription machineDescription) {
            return machineDescription.intAlignmentInBytes();
        }
    };
    public static final SizeThunk LONG = new SizeThunk(false){

        @Override
        public long computeSize(MachineDescription machineDescription) {
            return machineDescription.longSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDescription machineDescription) {
            return machineDescription.longAlignmentInBytes();
        }
    };
    public static final SizeThunk INT64 = new SizeThunk(true){

        @Override
        public long computeSize(MachineDescription machineDescription) {
            return machineDescription.int64SizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDescription machineDescription) {
            return machineDescription.int64AlignmentInBytes();
        }
    };
    public static final SizeThunk FLOAT = new SizeThunk(true){

        @Override
        public long computeSize(MachineDescription machineDescription) {
            return machineDescription.floatSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDescription machineDescription) {
            return machineDescription.floatAlignmentInBytes();
        }
    };
    public static final SizeThunk DOUBLE = new SizeThunk(true){

        @Override
        public long computeSize(MachineDescription machineDescription) {
            return machineDescription.doubleSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDescription machineDescription) {
            return machineDescription.doubleAlignmentInBytes();
        }
    };
    public static final SizeThunk POINTER = new SizeThunk(false){

        @Override
        public long computeSize(MachineDescription machineDescription) {
            return machineDescription.pointerSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDescription machineDescription) {
            return machineDescription.pointerAlignmentInBytes();
        }
    };

    private SizeThunk(boolean bl) {
        this.fixedNativeSize = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final boolean hasFixedNativeSize() {
        return this.fixedNativeSize;
    }

    public abstract long computeSize(MachineDescription var1);

    public abstract long computeAlignment(MachineDescription var1);

    public static SizeThunk add(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDescription machineDescription) {
                return sizeThunk.computeSize(machineDescription) + sizeThunk2.computeSize(machineDescription);
            }

            @Override
            public long computeAlignment(MachineDescription machineDescription) {
                long l;
                long l2 = sizeThunk.computeAlignment(machineDescription);
                return l2 > (l = sizeThunk2.computeAlignment(machineDescription)) ? l2 : l;
            }
        };
    }

    public static SizeThunk mul(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDescription machineDescription) {
                return sizeThunk.computeSize(machineDescription) * sizeThunk2.computeSize(machineDescription);
            }

            @Override
            public long computeAlignment(MachineDescription machineDescription) {
                long l;
                long l2 = sizeThunk.computeAlignment(machineDescription);
                return l2 > (l = sizeThunk2.computeAlignment(machineDescription)) ? l2 : l;
            }
        };
    }

    public static SizeThunk align(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDescription machineDescription) {
                long l;
                long l2 = sizeThunk.computeSize(machineDescription);
                long l3 = l2 & (l = sizeThunk2.computeAlignment(machineDescription)) - 1L;
                long l4 = l3 > 0L ? l - l3 : 0L;
                return l2 + l4;
            }

            @Override
            public long computeAlignment(MachineDescription machineDescription) {
                long l;
                long l2 = sizeThunk.computeAlignment(machineDescription);
                return l2 > (l = sizeThunk2.computeAlignment(machineDescription)) ? l2 : l;
            }
        };
    }

    public static SizeThunk max(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDescription machineDescription) {
                return Math.max(sizeThunk.computeSize(machineDescription), sizeThunk2.computeSize(machineDescription));
            }

            @Override
            public long computeAlignment(MachineDescription machineDescription) {
                long l;
                long l2 = sizeThunk.computeAlignment(machineDescription);
                return l2 > (l = sizeThunk2.computeAlignment(machineDescription)) ? l2 : l;
            }
        };
    }

    public static SizeThunk constant(final int n) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDescription machineDescription) {
                return n;
            }

            @Override
            public long computeAlignment(MachineDescription machineDescription) {
                return 1L;
            }
        };
    }
}

