

(function($){
  
  
  window.addWikiFormattingToolbar = function(textarea) {
    if ((document.selection == undefined)
     && (textarea.setSelectionRange == undefined)) {
      return;
    }
  
    var toolbar = document.createElement("div");
    toolbar.className = "wikitoolbar";
  
    function addButton(id, title, fn) {
      var a = document.createElement("a");
      a.href = "#";
      a.id = id;
      a.title = title;
      a.onclick = function() { try { fn() } catch (e) { } return false };
      a.tabIndex = 400;
      toolbar.appendChild(a);
    }
  
    function encloseSelection(prefix, suffix) {
      textarea.focus();
      var start, end, sel, scrollPos, subst;
      if (document.selection != undefined) {
        sel = document.selection.createRange().text;
      } else if (textarea.setSelectionRange != undefined) {
        start = textarea.selectionStart;
        end = textarea.selectionEnd;
        scrollPos = textarea.scrollTop;
        sel = textarea.value.substring(start, end);
      }
      if (sel.match(/ $/)) { // exclude ending space char, if any
        sel = sel.substring(0, sel.length - 1);
        suffix = suffix + " ";
      }
      subst = prefix + sel + suffix;
      if (document.selection != undefined) {
        var range = document.selection.createRange().text = subst;
        textarea.caretPos -= suffix.length;
      } else if (textarea.setSelectionRange != undefined) {
        textarea.value = textarea.value.substring(0, start) + subst +
                         textarea.value.substring(end);
        if (sel) {
          textarea.setSelectionRange(start + subst.length, start + subst.length);
        } else {
          textarea.setSelectionRange(start + prefix.length, start + prefix.length);
        }
        textarea.scrollTop = scrollPos;
      }
    }
  
    addButton("strong", "太字: '''例'''", function() {
      encloseSelection("'''", "'''");
    });
    addButton("em", "斜体: ''例''", function() {
      encloseSelection("''", "''");
    });
    addButton("heading", "見出し: == 例 ==", function() {
      encloseSelection("\n== ", " ==\n", "Heading");
    });
    addButton("link", "リンク: [http://www.example.com/ 例]", function() {
      encloseSelection("[", "]");
    });
    addButton("code", "整形済みブロック: {{{ 例 }}}", function() {
      encloseSelection("\n{{{\n", "\n}}}\n");
    });
    addButton("hr", "水平ライン: ----", function() {
      encloseSelection("\n----\n", "");
    });
    addButton("np", "新しい段落", function() {
      encloseSelection("\n\n", "");
    });
    addButton("br", "改行: [[BR]]", function() {
      encloseSelection("[[BR]]\n", "");
    });
    addButton("img", "画像: [[Image()]]", function() {
      encloseSelection("[[Image(", ")]]");
    });
  
    $(textarea).before(toolbar);
  }

})(jQuery);

// Add the toolbar to all <textarea> elements on the page with the class
// 'wikitext'.
jQuery(document).ready(function($) {
  $("textarea.wikitext").each(function() { addWikiFormattingToolbar(this) });
});
