/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;

public class LiquidOptionPaneUI
extends OptionPaneUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    private static String newline;
    private int[] mnemonics;
    protected JOptionPane optionPane;
    protected Dimension minimumSize;
    protected JComponent inputComponent;
    protected Component initialFocusComponent;
    protected boolean hasCustomComponents;
    protected PropertyChangeListener propertyChangeListener;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                newline = System.getProperty("line.separator");
                if (newline == null) {
                    newline = "\n";
                }
                return null;
            }
        });
    }

    public static ComponentUI createUI(JComponent x) {
        return new LiquidOptionPaneUI();
    }

    public void installUI(JComponent c) {
        this.optionPane = (JOptionPane)c;
        this.installDefaults();
        this.optionPane.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallComponents();
        this.optionPane.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.optionPane, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(this.optionPane, "OptionPane.border");
        this.minimumSize = UIManager.getDimension("OptionPane.minimumSize");
        if (LiquidLookAndFeel.areStipplesUsed()) {
            this.optionPane.setOpaque(false);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.optionPane);
    }

    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container separator = this.createSeparator();
        if (separator != null) {
            this.optionPane.add(separator);
        }
        this.optionPane.add(this.createButtonArea());
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
    }

    protected void uninstallComponents() {
        this.hasCustomComponents = false;
        this.inputComponent = null;
        this.initialFocusComponent = null;
        this.optionPane.removeAll();
    }

    protected LayoutManager createLayoutManager() {
        return new BoxLayout(this.optionPane, 1);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap map = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, map);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.optionPane, actionMap);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, null);
        SwingUtilities.replaceUIActionMap(this.optionPane, null);
    }

    InputMap getInputMap(int condition) {
        Object[] bindings;
        if (condition == 2 && (bindings = (Object[])UIManager.get("OptionPane.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.optionPane, bindings);
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("OptionPane.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("OptionPane.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("close", new CloseAction());
        return map;
    }

    public Dimension getMinimumOptionPaneSize() {
        if (this.minimumSize == null) {
            return new Dimension(262, 90);
        }
        return new Dimension(this.minimumSize.width, this.minimumSize.height);
    }

    public Dimension getPreferredSize(JComponent c) {
        if ((JOptionPane)c == this.optionPane) {
            Dimension ourMin = this.getMinimumOptionPaneSize();
            LayoutManager lm = c.getLayout();
            if (lm != null) {
                Dimension lmSize = lm.preferredLayoutSize(c);
                if (ourMin != null) {
                    return new Dimension(Math.max(lmSize.width, ourMin.width), Math.max(lmSize.height, ourMin.height));
                }
                return lmSize;
            }
            return ourMin;
        }
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected Container createMessageArea() {
        JPanel top = new JPanel();
        top.setBorder(UIManager.getBorder("OptionPane.messageAreaBorder"));
        top.setLayout(new BorderLayout());
        if (LiquidLookAndFeel.areStipplesUsed()) {
            top.setOpaque(false);
        }
        JPanel body = new JPanel(){
            private static final long serialVersionUID = 1L;
        };
        JPanel realBody = new JPanel(){
            private static final long serialVersionUID = 1L;
        };
        realBody.setLayout(new BorderLayout());
        if (LiquidLookAndFeel.areStipplesUsed()) {
            ((JPanel)realBody).setOpaque(false);
            ((JPanel)body).setOpaque(false);
        }
        if (this.getIcon() != null) {
            JPanel sep = new JPanel(){
                private static final long serialVersionUID = 1L;

                public Dimension getPreferredSize() {
                    return new Dimension(15, 1);
                }
            };
            if (LiquidLookAndFeel.areStipplesUsed()) {
                ((JPanel)sep).setOpaque(false);
            }
            realBody.add((Component)sep, "Before");
        }
        realBody.add((Component)body, "Center");
        body.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = 21;
        cons.insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(body, cons, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        top.add((Component)realBody, "Center");
        this.addIcon(top);
        return top;
    }

    protected void addMessageComponents(Container container, GridBagConstraints cons, Object msg, int maxll, boolean internallyCreated) {
        if (msg == null) {
            return;
        }
        if (msg instanceof Component) {
            if (msg instanceof JScrollPane || msg instanceof JPanel) {
                cons.fill = 1;
                cons.weighty = 1.0;
            } else {
                cons.fill = 2;
            }
            cons.weightx = 1.0;
            container.add((Component)msg, cons);
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.fill = 0;
            ++cons.gridy;
            if (!internallyCreated) {
                this.hasCustomComponents = true;
            }
        } else if (msg instanceof Object[]) {
            Object[] msgs = (Object[])msg;
            int i = 0;
            while (i < msgs.length) {
                this.addMessageComponents(container, cons, msgs[i], maxll, false);
                ++i;
            }
        } else if (msg instanceof Icon) {
            JLabel label = new JLabel((Icon)msg, 0);
            this.configureMessageLabel(label);
            this.addMessageComponents(container, cons, label, maxll, true);
        } else {
            String s = msg.toString();
            int len = s.length();
            if (len <= 0) {
                return;
            }
            int nl = -1;
            int nll = 0;
            nl = s.indexOf(newline);
            if (nl >= 0) {
                nll = newline.length();
            } else {
                nl = s.indexOf("\r\n");
                if (nl >= 0) {
                    nll = 2;
                } else {
                    nl = s.indexOf(10);
                    if (nl >= 0) {
                        nll = 1;
                    }
                }
            }
            if (nl >= 0) {
                if (nl == 0) {
                    this.addMessageComponents(container, cons, new Component(){
                        private static final long serialVersionUID = 1L;

                        public Dimension getPreferredSize() {
                            Font f = this.getFont();
                            if (f != null) {
                                return new Dimension(1, f.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    }, maxll, true);
                } else {
                    this.addMessageComponents(container, cons, s.substring(0, nl), maxll, false);
                }
                this.addMessageComponents(container, cons, s.substring(nl + nll), maxll, false);
            } else if (len > maxll) {
                Box c = Box.createVerticalBox();
                this.burstStringInto(c, s, maxll);
                this.addMessageComponents(container, cons, c, maxll, true);
            } else {
                JLabel label = new JLabel(s, 10);
                this.configureMessageLabel(label);
                this.addMessageComponents(container, cons, label, maxll, true);
            }
        }
    }

    protected Object getMessage() {
        this.inputComponent = null;
        if (this.optionPane != null) {
            if (this.optionPane.getWantsInput()) {
                JComponent toAdd;
                Object message = this.optionPane.getMessage();
                Object[] sValues = this.optionPane.getSelectionValues();
                Object inputValue = this.optionPane.getInitialSelectionValue();
                if (sValues != null) {
                    if (sValues.length < 20) {
                        JComboBox<Object> cBox = new JComboBox<Object>();
                        int counter = 0;
                        int maxCounter = sValues.length;
                        while (counter < maxCounter) {
                            cBox.addItem(sValues[counter]);
                            ++counter;
                        }
                        if (inputValue != null) {
                            cBox.setSelectedItem(inputValue);
                        }
                        this.inputComponent = cBox;
                        toAdd = cBox;
                    } else {
                        JList<Object> list = new JList<Object>(sValues);
                        JScrollPane sp = new JScrollPane(list);
                        list.setVisibleRowCount(10);
                        list.setSelectionMode(0);
                        if (inputValue != null) {
                            list.setSelectedValue(inputValue, true);
                        }
                        list.addMouseListener(new ListSelectionListener());
                        toAdd = sp;
                        this.inputComponent = list;
                    }
                } else {
                    MultiplexingTextField tf = new MultiplexingTextField(20);
                    tf.setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke("ENTER")});
                    if (inputValue != null) {
                        String inputString = inputValue.toString();
                        tf.setText(inputString);
                        tf.setSelectionStart(0);
                        tf.setSelectionEnd(inputString.length());
                    }
                    tf.addActionListener(new TextFieldActionListener());
                    this.inputComponent = tf;
                    toAdd = this.inputComponent;
                }
                Object[] newMessage = message == null ? new Object[]{toAdd} : new Object[]{message, toAdd};
                return newMessage;
            }
            return this.optionPane.getMessage();
        }
        return null;
    }

    protected void addIcon(Container top) {
        Icon sideIcon = this.getIcon();
        if (sideIcon != null) {
            JLabel iconLabel = new JLabel(sideIcon);
            iconLabel.setVerticalAlignment(1);
            top.add((Component)iconLabel, "Before");
        }
    }

    protected Icon getIcon() {
        Icon mIcon;
        Icon icon = mIcon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (mIcon == null && this.optionPane != null) {
            mIcon = this.getIconForType(this.optionPane.getMessageType());
        }
        return mIcon;
    }

    protected Icon getIconForType(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        switch (messageType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    protected void burstStringInto(Container c, String d, int maxll) {
        int len = d.length();
        if (len <= 0) {
            return;
        }
        if (len > maxll) {
            int p = d.lastIndexOf(32, maxll);
            if (p <= 0) {
                p = d.indexOf(32, maxll);
            }
            if (p > 0 && p < len) {
                this.burstStringInto(c, d.substring(0, p), maxll);
                this.burstStringInto(c, d.substring(p + 1), maxll);
                return;
            }
        }
        JLabel label = new JLabel(d, 2);
        this.configureMessageLabel(label);
        c.add(label);
    }

    protected Container createSeparator() {
        return null;
    }

    protected Container createButtonArea() {
        JPanel bottom = new JPanel();
        if (LiquidLookAndFeel.areStipplesUsed()) {
            bottom.setOpaque(false);
        }
        bottom.setBorder(UIManager.getBorder("OptionPane.buttonAreaBorder"));
        bottom.setLayout(new ButtonAreaLayout(true, 6));
        this.addButtonComponents(bottom, this.getButtons(), this.getInitialValueIndex());
        this.mnemonics = null;
        return bottom;
    }

    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        if (buttons != null && buttons.length > 0) {
            boolean sizeButtonsToSame = this.getSizeButtonsToSameWidth();
            boolean createdAll = true;
            int numButtons = buttons.length;
            JButton[] createdButtons = null;
            int maxWidth = 0;
            int[] mnemonics = this.mnemonics;
            if (mnemonics != null && mnemonics.length != buttons.length) {
                mnemonics = null;
            }
            if (sizeButtonsToSame) {
                createdButtons = new JButton[numButtons];
            }
            int counter = 0;
            while (counter < numButtons) {
                Component newComponent;
                Object button = buttons[counter];
                if (button instanceof Component) {
                    createdAll = false;
                    newComponent = (Component)button;
                    container.add(newComponent);
                    this.hasCustomComponents = true;
                } else {
                    JButton aButton = button instanceof Icon ? new JButton((Icon)button) : new JButton(button.toString());
                    aButton.setMultiClickThreshhold(UIManager.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton(aButton);
                    container.add(aButton);
                    ActionListener buttonListener = this.createButtonActionListener(counter);
                    if (buttonListener != null) {
                        aButton.addActionListener(buttonListener);
                    }
                    newComponent = aButton;
                    if (mnemonics != null) {
                        aButton.setMnemonic(mnemonics[counter]);
                    }
                }
                if (sizeButtonsToSame && createdAll && newComponent instanceof JButton) {
                    createdButtons[counter] = (JButton)newComponent;
                    maxWidth = Math.max(maxWidth, newComponent.getMinimumSize().width);
                }
                if (counter == initialIndex) {
                    this.initialFocusComponent = newComponent;
                    if (this.initialFocusComponent instanceof JButton) {
                        JButton defaultB = (JButton)this.initialFocusComponent;
                        defaultB.addAncestorListener(new AncestorListener(){

                            public void ancestorAdded(AncestorEvent e) {
                                JButton defaultButton = (JButton)e.getComponent();
                                JRootPane root = SwingUtilities.getRootPane(defaultButton);
                                if (root != null) {
                                    root.setDefaultButton(defaultButton);
                                }
                            }

                            public void ancestorRemoved(AncestorEvent event) {
                            }

                            public void ancestorMoved(AncestorEvent event) {
                            }
                        });
                    }
                }
                ++counter;
            }
            ((ButtonAreaLayout)container.getLayout()).setSyncAllWidths(sizeButtonsToSame && createdAll);
            if (sizeButtonsToSame && createdAll) {
                int padSize = numButtons <= 2 ? 8 : 4;
                int counter2 = 0;
                while (counter2 < numButtons) {
                    JButton aButton = createdButtons[counter2];
                    aButton.setMargin(new Insets(2, padSize, 2, padSize));
                    ++counter2;
                }
            }
        }
    }

    protected ActionListener createButtonActionListener(int buttonIndex) {
        return new ButtonActionListener(buttonIndex);
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            if (suppliedOptions == null) {
                Object[] defaultOptions;
                int type = this.optionPane.getOptionType();
                Locale l = this.optionPane.getLocale();
                if (type == 0) {
                    defaultOptions = new String[]{UIManager.get("OptionPane.yesButtonText", l), UIManager.get("OptionPane.noButtonText", l)};
                    this.mnemonics = new int[2];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.yesButtonMnemonic", l);
                    this.mnemonics[1] = this.getMnemonic("OptionPane.noButtonMnemonic", l);
                } else if (type == 1) {
                    defaultOptions = new String[]{UIManager.get("OptionPane.yesButtonText", l), UIManager.get("OptionPane.noButtonText", l), UIManager.get("OptionPane.cancelButtonText", l)};
                    this.mnemonics = new int[3];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.yesButtonMnemonic", l);
                    this.mnemonics[1] = this.getMnemonic("OptionPane.noButtonMnemonic", l);
                    this.mnemonics[2] = this.getMnemonic("OptionPane.cancelButtonMnemonic", l);
                } else if (type == 2) {
                    defaultOptions = new String[]{UIManager.get("OptionPane.okButtonText", l), UIManager.get("OptionPane.cancelButtonText", l)};
                    this.mnemonics = new int[2];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.okButtonMnemonic", l);
                    this.mnemonics[1] = this.getMnemonic("OptionPane.cancelButtonMnemonic", l);
                } else {
                    defaultOptions = new String[]{UIManager.get("OptionPane.okButtonText", l)};
                    this.mnemonics = new int[1];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.okButtonMnemonic", l);
                }
                return defaultOptions;
            }
            return suppliedOptions;
        }
        return null;
    }

    private int getMnemonic(String key, Locale l) {
        String value = (String)UIManager.get(key, l);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected int getInitialValueIndex() {
        if (this.optionPane != null) {
            Object iv = this.optionPane.getInitialValue();
            Object[] options = this.optionPane.getOptions();
            if (options == null) {
                return 0;
            }
            if (iv != null) {
                int counter = options.length - 1;
                while (counter >= 0) {
                    if (options[counter].equals(iv)) {
                        return counter;
                    }
                    --counter;
                }
            }
        }
        return -1;
    }

    protected void resetInputValue() {
        if (this.inputComponent != null && this.inputComponent instanceof JTextField) {
            this.optionPane.setInputValue(((JTextField)this.inputComponent).getText());
        } else if (this.inputComponent != null && this.inputComponent instanceof JComboBox) {
            this.optionPane.setInputValue(((JComboBox)this.inputComponent).getSelectedItem());
        } else if (this.inputComponent != null) {
            this.optionPane.setInputValue(((JList)this.inputComponent).getSelectedValue());
        }
    }

    public void selectInitialValue(JOptionPane op) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
        } else {
            JRootPane root;
            if (this.initialFocusComponent != null) {
                this.initialFocusComponent.requestFocus();
            }
            if (this.initialFocusComponent instanceof JButton && (root = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
                root.setDefaultButton((JButton)this.initialFocusComponent);
            }
        }
    }

    public boolean containsCustomComponents(JOptionPane op) {
        return this.hasCustomComponents;
    }

    private void fireAudioAction(String actionName) {
        ActionMap map = this.optionPane.getActionMap();
        if (map != null) {
            Action action = map.get(actionName);
        }
    }

    private void configureMessageLabel(JLabel label) {
        label.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        Font messageFont = UIManager.getFont("OptionPane.messageFont");
        if (messageFont != null) {
            label.setFont(messageFont);
        }
    }

    private void configureButton(JButton button) {
        Font buttonFont = UIManager.getFont("OptionPane.buttonFont");
        if (buttonFont != null) {
            button.setFont(buttonFont);
        }
    }

    public class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int buttonIndex) {
            this.buttonIndex = buttonIndex;
        }

        public void actionPerformed(ActionEvent e) {
            if (LiquidOptionPaneUI.this.optionPane != null) {
                int optionType = LiquidOptionPaneUI.this.optionPane.getOptionType();
                Object[] options = LiquidOptionPaneUI.this.optionPane.getOptions();
                if (LiquidOptionPaneUI.this.inputComponent != null && (options != null || optionType == -1 || (optionType == 0 || optionType == 1 || optionType == 2) && this.buttonIndex == 0)) {
                    LiquidOptionPaneUI.this.resetInputValue();
                }
                if (options == null) {
                    if (optionType == 2 && this.buttonIndex == 1) {
                        LiquidOptionPaneUI.this.optionPane.setValue(new Integer(2));
                    } else {
                        LiquidOptionPaneUI.this.optionPane.setValue(new Integer(this.buttonIndex));
                    }
                } else {
                    LiquidOptionPaneUI.this.optionPane.setValue(options[this.buttonIndex]);
                }
            }
        }
    }

    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean syncAllWidths;
        protected int padding;
        protected boolean centersChildren;

        public ButtonAreaLayout(boolean syncAllWidths, int padding) {
            this.syncAllWidths = syncAllWidths;
            this.padding = padding;
            this.centersChildren = true;
        }

        public void setSyncAllWidths(boolean newValue) {
            this.syncAllWidths = newValue;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void setPadding(int newPadding) {
            this.padding = newPadding;
        }

        public int getPadding() {
            return this.padding;
        }

        public void setCentersChildren(boolean newValue) {
            this.centersChildren = newValue;
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public void addLayoutComponent(String string, Component comp) {
        }

        public void layoutContainer(Container container) {
            block18: {
                Component[] children = container.getComponents();
                if (children == null || children.length <= 0) break block18;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top;
                boolean ltr = container.getComponentOrientation().isLeftToRight();
                if (this.syncAllWidths) {
                    int xOffset;
                    int xLocation;
                    int maxWidth = 0;
                    int counter = 0;
                    while (counter < numChildren) {
                        sizes[counter] = children[counter].getPreferredSize();
                        maxWidth = Math.max(maxWidth, sizes[counter].width);
                        ++counter;
                    }
                    if (this.getCentersChildren()) {
                        xLocation = (container.getSize().width - insets.left - insets.right - (maxWidth * numChildren + (numChildren - 1) * this.padding)) / 2;
                        xOffset = this.padding + maxWidth;
                    } else if (numChildren > 1) {
                        xLocation = insets.left;
                        xOffset = (container.getSize().width - insets.left - insets.right - maxWidth * numChildren) / (numChildren - 1) + maxWidth;
                    } else {
                        xLocation = insets.left + (container.getSize().width - insets.left - insets.right - maxWidth) / 2;
                        xOffset = 0;
                    }
                    if (!ltr) {
                        xLocation = container.getSize().width - insets.right - (xLocation - insets.left) - maxWidth;
                        xOffset = -xOffset;
                    }
                    counter = 0;
                    while (counter < numChildren) {
                        children[counter].setBounds(xLocation, yLocation, maxWidth, sizes[counter].height);
                        xLocation += xOffset;
                        ++counter;
                    }
                } else {
                    int xOffset;
                    int xLocation;
                    int totalWidth = 0;
                    int counter = 0;
                    while (counter < numChildren) {
                        sizes[counter] = children[counter].getPreferredSize();
                        totalWidth += sizes[counter].width;
                        ++counter;
                    }
                    totalWidth += (numChildren - 1) * this.padding;
                    boolean cc = this.getCentersChildren();
                    if (cc) {
                        xLocation = insets.left + (container.getSize().width - insets.left - insets.right - totalWidth) / 2;
                        xOffset = this.padding;
                    } else if (numChildren > 1) {
                        xOffset = (container.getSize().width - insets.left - insets.right - totalWidth) / (numChildren - 1);
                        xLocation = insets.left;
                    } else {
                        xLocation = insets.left + (container.getSize().width - insets.left - insets.right - totalWidth) / 2;
                        xOffset = 0;
                    }
                    if (ltr) {
                        counter = 0;
                        while (counter < numChildren) {
                            children[counter].setBounds(xLocation, yLocation, sizes[counter].width, sizes[counter].height);
                            xLocation += xOffset + sizes[counter].width;
                            ++counter;
                        }
                    } else {
                        xLocation = container.getSize().width - insets.right - (xLocation - insets.left);
                        counter = 0;
                        while (counter < numChildren) {
                            children[counter].setBounds(xLocation -= xOffset + sizes[counter].width, yLocation, sizes[counter].width, sizes[counter].height);
                            ++counter;
                        }
                    }
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                if (this.syncAllWidths) {
                    int maxWidth = 0;
                    int counter = 0;
                    while (counter < numChildren) {
                        Dimension aSize = children[counter].getPreferredSize();
                        height = Math.max(height, aSize.height);
                        maxWidth = Math.max(maxWidth, aSize.width);
                        ++counter;
                    }
                    return new Dimension(extraWidth + maxWidth * numChildren + (numChildren - 1) * this.padding, extraHeight + height);
                }
                int totalWidth = 0;
                int counter = 0;
                while (counter < numChildren) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    totalWidth += aSize.width;
                    ++counter;
                }
                return new Dimension(extraWidth + (totalWidth += (numChildren - 1) * this.padding), extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public void removeLayoutComponent(Component c) {
        }
    }

    private static class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane optionPane = (JOptionPane)e.getSource();
            optionPane.setValue(new Integer(-1));
        }
    }

    private class ListSelectionListener
    extends MouseAdapter {
        private ListSelectionListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                LiquidOptionPaneUI.this.optionPane.setInputValue(list.getModel().getElementAt(index));
            }
        }
    }

    private static class MultiplexingTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private KeyStroke[] strokes;

        MultiplexingTextField(int cols) {
            super(cols);
        }

        void setKeyStrokes(KeyStroke[] strokes) {
            this.strokes = strokes;
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            boolean processed = super.processKeyBinding(ks, e, condition, pressed);
            if (processed && condition != 2) {
                int counter = this.strokes.length - 1;
                while (counter >= 0) {
                    if (this.strokes[counter].equals(ks)) {
                        return false;
                    }
                    --counter;
                }
            }
            return processed;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == LiquidOptionPaneUI.this.optionPane) {
                String changeName;
                if ("ancestor" == e.getPropertyName()) {
                    JOptionPane op = (JOptionPane)e.getSource();
                    boolean isComingUp = e.getOldValue() == null;
                    switch (op.getMessageType()) {
                        case -1: {
                            if (!isComingUp) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.informationSound");
                            break;
                        }
                        case 3: {
                            if (!isComingUp) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.questionSound");
                            break;
                        }
                        case 1: {
                            if (!isComingUp) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.informationSound");
                            break;
                        }
                        case 2: {
                            if (!isComingUp) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.warningSound");
                            break;
                        }
                        case 0: {
                            if (!isComingUp) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.errorSound");
                            break;
                        }
                        default: {
                            System.err.println("Undefined JOptionPane type: " + op.getMessageType());
                        }
                    }
                }
                if ((changeName = e.getPropertyName()).equals("options") || changeName.equals("initialValue") || changeName.equals("icon") || changeName.equals("messageType") || changeName.equals("optionType") || changeName.equals("message") || changeName.equals("selectionValues") || changeName.equals("initialSelectionValue") || changeName.equals("wantsInput")) {
                    LiquidOptionPaneUI.this.uninstallComponents();
                    LiquidOptionPaneUI.this.installComponents();
                    LiquidOptionPaneUI.this.optionPane.validate();
                } else if (changeName.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JOptionPane op = (JOptionPane)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        op.applyComponentOrientation(o);
                    }
                }
            }
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private TextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LiquidOptionPaneUI.this.optionPane.setInputValue(((JTextField)e.getSource()).getText());
        }
    }
}

