/*
 * Decompiled with CFR 0.152.
 */
package parser;

import enumerators.SyntacticLevel;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import parser.LoadFile;
import parser.SaveFile;
import syntaxTree.CaseFeatureSet;
import syntaxTree.GenericFeatureSet;
import syntaxTree.RepositionTree;
import syntaxTree.Sentence;
import syntaxTree.SyntacticAssociation;
import syntaxTree.SyntacticFeature;
import syntaxTree.SyntacticFeatureSet;
import syntaxTree.SyntacticStructure;
import syntaxTree.SyntaxFacade;
import syntaxTree.ThetaRoleFeatureSet;
import userInterface.UserFrame;
import userInterface.UserInternalFrame;

public class XMLParser
implements SaveFile,
LoadFile {
    private HashMap mAssociationMap;
    private HashMap mStructureMap;
    private UserInternalFrame mInternalFrame;
    private SyntaxFacade mSyntaxFacade;
    private UserFrame mUserFrame;
    private DocumentBuilderFactory mFactory;
    private DocumentBuilder mBuilder;
    private DOMImplementation mImpl;
    private Document mDoc;
    private Element mRoot;

    public void saveFileToDisk(SyntaxFacade pSyntaxFacade) {
        this.mDoc = this.saveFile(pSyntaxFacade);
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        Transformer idTransform = null;
        try {
            idTransform = xformFactory.newTransformer();
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        DOMSource input = new DOMSource(this.mDoc);
        StreamResult output = new StreamResult(pSyntaxFacade.getFile());
        try {
            idTransform.transform(input, output);
        }
        catch (TransformerException e2) {
            e2.printStackTrace();
        }
    }

    public Document saveFile(SyntaxFacade pSyntaxFacade) {
        this.mFactory = DocumentBuilderFactory.newInstance();
        this.mFactory.setNamespaceAware(true);
        try {
            this.mBuilder = this.mFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.mImpl = this.mBuilder.getDOMImplementation();
        this.mDoc = this.mImpl.createDocument(null, "sentence", null);
        this.mRoot = this.mDoc.getDocumentElement();
        Attr lName = this.mDoc.createAttribute("name");
        lName.setValue(pSyntaxFacade.getName());
        this.mRoot.setAttributeNode(lName);
        lName = this.mDoc.createAttribute("file");
        lName.setValue(pSyntaxFacade.getFile().getPath());
        this.mRoot.setAttributeNode(lName);
        lName = this.mDoc.createAttribute("type");
        lName.setValue("TreeForm");
        this.mRoot.setAttributeNode(lName);
        lName = this.mDoc.createAttribute("linelength");
        lName.setValue(String.valueOf(pSyntaxFacade.getUIF().getProperties().getMinLineLength()));
        this.mRoot.setAttributeNode(lName);
        lName = this.mDoc.createAttribute("mintextwidth");
        lName.setValue(String.valueOf(pSyntaxFacade.getUIF().getProperties().getMinLineWidth()));
        this.mRoot.setAttributeNode(lName);
        lName = this.mDoc.createAttribute("lefttranslate");
        lName.setValue(String.valueOf(pSyntaxFacade.getUIF().getProperties().getLeftTranslate()));
        this.mRoot.setAttributeNode(lName);
        lName = this.mDoc.createAttribute("toptranslate");
        lName.setValue(String.valueOf(pSyntaxFacade.getUIF().getProperties().getTopTranslate()));
        this.mRoot.setAttributeNode(lName);
        lName = this.mDoc.createAttribute("defaultfontsize");
        lName.setValue(String.valueOf(pSyntaxFacade.getUIF().getProperties().getDefaultFontSize()));
        this.mRoot.setAttributeNode(lName);
        int i = 0;
        while (i < pSyntaxFacade.getSentence().getChildren().size()) {
            this.saveHead((SyntacticStructure)pSyntaxFacade.getSentence().getChildren().get(0), this.mRoot);
            ++i;
        }
        return this.mDoc;
    }

    private void saveHead(SyntacticStructure pSS, Element pRoot) {
        Element lRoot = this.mDoc.createElement("syntacticstructure");
        Attr lAttr = this.mDoc.createAttribute("syntacticlevel");
        lAttr.setValue(pSS.getSyntacticLevel().toString());
        lRoot.setAttributeNode(lAttr);
        lAttr = this.mDoc.createAttribute("string");
        lAttr.setValue(Integer.toString(pSS.hashCode()));
        lRoot.setAttributeNode(lAttr);
        lAttr = this.mDoc.createAttribute("linered");
        lAttr.setValue(Integer.toString(pSS.getLineColor().getRed()));
        lRoot.setAttributeNode(lAttr);
        lAttr = this.mDoc.createAttribute("linegreen");
        lAttr.setValue(Integer.toString(pSS.getLineColor().getGreen()));
        lRoot.setAttributeNode(lAttr);
        lAttr = this.mDoc.createAttribute("lineblue");
        lAttr.setValue(Integer.toString(pSS.getLineColor().getBlue()));
        lRoot.setAttributeNode(lAttr);
        lRoot.appendChild(this.saveATDetails(pSS.getHead()));
        lRoot.appendChild(this.saveFeatureSet(pSS.getSyntacticFeatureSet(), pRoot));
        lRoot.appendChild(this.saveAssociations(pSS.getSyntacticAssociation(), pRoot));
        lRoot.appendChild(this.saveStartTrace(pSS.getStartTrace(), pSS, pRoot));
        lRoot.appendChild(this.saveEndTrace(pSS.getEndTrace(), pRoot));
        pRoot.appendChild(lRoot);
        int i = 0;
        while (i < pSS.getChildren().size()) {
            this.saveHead((SyntacticStructure)pSS.getChildren().get(i), lRoot);
            ++i;
        }
    }

    private Node saveAssociations(LinkedList list, Element pRoot) {
        Element lRootSAS = this.mDoc.createElement("syntacticassociations");
        int i = 0;
        while (i < list.size()) {
            Element lRootSA = this.mDoc.createElement("syntacticassociation");
            Attr lAttr = this.mDoc.createAttribute("string");
            lAttr.setValue(Integer.toString(list.get(i).hashCode()));
            lRootSA.setAttributeNode(lAttr);
            lRootSAS.appendChild(lRootSA);
            ++i;
        }
        return lRootSAS;
    }

    private Node saveStartTrace(LinkedList list, SyntacticStructure start, Element pRoot) {
        Element lRootSAS = this.mDoc.createElement("starttraces");
        int i = 0;
        while (i < list.size()) {
            Element lRootSA = this.mDoc.createElement("starttrace");
            Attr lAttr = this.mDoc.createAttribute("string");
            lAttr.setValue(Integer.toString(list.get(i).hashCode()));
            lRootSA.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("customtrace");
            lAttr.setValue(Boolean.toString(start.getCustomTrace()));
            lRootSA.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("controlstartx");
            lAttr.setValue(Integer.toString(start.getControlStartX()));
            lRootSA.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("controlendx");
            lAttr.setValue(Integer.toString(start.getControlEndX()));
            lRootSA.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("controlstarty");
            lAttr.setValue(Integer.toString(start.getControlStartY()));
            lRootSA.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("controlendy");
            lAttr.setValue(Integer.toString(start.getControlEndY()));
            lRootSA.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("startx");
            lAttr.setValue(Integer.toString(start.getStartX()));
            lRootSA.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("endx");
            lAttr.setValue(Integer.toString(start.getEndX()));
            lRootSA.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("starty");
            lAttr.setValue(Integer.toString(start.getStartY()));
            lRootSA.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("endy");
            lAttr.setValue(Integer.toString(start.getEndY()));
            lRootSA.setAttributeNode(lAttr);
            lRootSAS.appendChild(lRootSA);
            ++i;
        }
        return lRootSAS;
    }

    private Node saveEndTrace(LinkedList list, Element pRoot) {
        Element lRootSAS = this.mDoc.createElement("endtraces");
        int i = 0;
        while (i < list.size()) {
            Element lRootSA = this.mDoc.createElement("endtrace");
            Attr lAttr = this.mDoc.createAttribute("string");
            lAttr.setValue(Integer.toString(list.get(i).hashCode()));
            lRootSA.setAttributeNode(lAttr);
            lRootSAS.appendChild(lRootSA);
            ++i;
        }
        return lRootSAS;
    }

    private Element saveFeatureSet(LinkedList list, Element pRoot) {
        Element lRootSFSS = this.mDoc.createElement("syntacticfeaturesets");
        int i = 0;
        while (i < list.size()) {
            SyntacticFeatureSet lSFS = (SyntacticFeatureSet)list.get(i);
            Element lRootSFS = this.mDoc.createElement("syntacticfeatureset");
            Attr lAttr = this.mDoc.createAttribute("featuretype");
            if (list.get(i) instanceof ThetaRoleFeatureSet) {
                lAttr.setValue("theta");
            } else if (list.get(i) instanceof CaseFeatureSet) {
                lAttr.setValue("case");
            } else if (list.get(i) instanceof GenericFeatureSet) {
                lAttr.setValue("feature");
            }
            lRootSFS.setAttributeNode(lAttr);
            int j = 0;
            while (j < lSFS.getSyntacticFeature().size()) {
                SyntacticFeature lSF = (SyntacticFeature)lSFS.getSyntacticFeature().get(j);
                Element lRootSF = this.mDoc.createElement("syntacticfeature");
                lRootSF.appendChild(this.saveATDetails(lSF.getHead()));
                Element lRootSAS = this.mDoc.createElement("syntacticassociations");
                lRootSF.appendChild(lRootSAS);
                int k = 0;
                while (k < lSF.getSyntacticAssociation().size()) {
                    SyntacticAssociation lSA = (SyntacticAssociation)lSF.getSyntacticAssociation().get(k);
                    Element lRootSA = this.mDoc.createElement("syntacticassociation");
                    lAttr = this.mDoc.createAttribute("string");
                    lAttr.setValue(Integer.toString(lSA.hashCode()));
                    lRootSA.setAttributeNode(lAttr);
                    lRootSAS.appendChild(lRootSA);
                    ++k;
                }
                lRootSFS.appendChild(lRootSF);
                ++j;
            }
            lRootSFSS.appendChild(lRootSFS);
            ++i;
        }
        return lRootSFSS;
    }

    private Element saveATDetails(AttributedString pAT) {
        Element lText = this.mDoc.createElement("text");
        String lString = "";
        AttributedCharacterIterator lIterator = pAT.getIterator();
        char c = lIterator.first();
        while (c != '\uffff') {
            lString = String.valueOf(lString) + c;
            c = lIterator.next();
        }
        Attr lAttr = this.mDoc.createAttribute("text");
        lAttr.setValue(lString);
        lText.setAttributeNode(lAttr);
        int i = 0;
        char c2 = lIterator.first();
        while (c2 != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> lMap = lIterator.getAttributes();
            Set<AttributedCharacterIterator.Attribute> lSet = lMap.keySet();
            Iterator<AttributedCharacterIterator.Attribute> lSetIterator = lSet.iterator();
            Element lIElement = this.mDoc.createElement("N" + Integer.toString(i));
            while (lSetIterator.hasNext()) {
                AttributedCharacterIterator.Attribute lKey = lSetIterator.next();
                Object lValue = lMap.get(lKey);
                this.saveAttributes(lIElement, lKey, lValue);
            }
            lText.appendChild(lIElement);
            ++i;
            c2 = lIterator.next();
        }
        return lText;
    }

    private void saveAttributes(Element lIElement, Object lKey, Object lValue) {
        if (lKey.equals(TextAttribute.FONT)) {
            Font lFont = (Font)lValue;
            Attr lAttr = this.mDoc.createAttribute("font");
            lAttr.setValue(lFont.getFamily());
            lIElement.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("style");
            lAttr.setValue(Integer.toString(lFont.getStyle()));
            lIElement.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("size");
            lAttr.setValue(Integer.toString(lFont.getSize()));
            lIElement.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("subscript");
            if ((TransformAttribute)lFont.getAttributes().get(TextAttribute.TRANSFORM) != null && ((TransformAttribute)lFont.getAttributes().get(TextAttribute.TRANSFORM)).getTransform().getTranslateY() == 1.0) {
                lAttr.setValue("sub");
            } else if ((TransformAttribute)lFont.getAttributes().get(TextAttribute.TRANSFORM) != null && ((TransformAttribute)lFont.getAttributes().get(TextAttribute.TRANSFORM)).getTransform().getTranslateY() == -3.0) {
                lAttr.setValue("super");
            } else {
                lAttr.setValue("normal");
            }
            lIElement.setAttributeNode(lAttr);
        } else if (lKey.equals(TextAttribute.UNDERLINE)) {
            Attr lAttr = this.mDoc.createAttribute("underline");
            if (lValue.equals(TextAttribute.UNDERLINE_ON)) {
                lAttr.setValue("true");
            } else {
                lAttr.setValue("false");
            }
            lIElement.setAttributeNode(lAttr);
        } else if (lKey.equals(TextAttribute.STRIKETHROUGH)) {
            Attr lAttr = this.mDoc.createAttribute("strikethrough");
            if (lValue.equals(TextAttribute.STRIKETHROUGH_ON)) {
                lAttr.setValue("true");
            } else {
                lAttr.setValue("false");
            }
            lIElement.setAttributeNode(lAttr);
        } else if (lKey.equals(TextAttribute.BACKGROUND)) {
            Attr lAttr = this.mDoc.createAttribute("backgroundred");
            lAttr.setValue(Integer.toString(((Color)lValue).getRed()));
            lIElement.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("backgroundgreen");
            lAttr.setValue(Integer.toString(((Color)lValue).getGreen()));
            lIElement.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("backgroundblue");
            lAttr.setValue(Integer.toString(((Color)lValue).getBlue()));
            lIElement.setAttributeNode(lAttr);
        } else if (lKey.equals(TextAttribute.FOREGROUND)) {
            Attr lAttr = this.mDoc.createAttribute("foregroundred");
            lAttr.setValue(Integer.toString(((Color)lValue).getRed()));
            lIElement.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("foregroundgreen");
            lAttr.setValue(Integer.toString(((Color)lValue).getGreen()));
            lIElement.setAttributeNode(lAttr);
            lAttr = this.mDoc.createAttribute("foregroundblue");
            lAttr.setValue(Integer.toString(((Color)lValue).getBlue()));
            lIElement.setAttributeNode(lAttr);
        } else if (lKey.equals(TextAttribute.SUPERSCRIPT)) {
            Attr lAttr = this.mDoc.createAttribute("subscript");
            if (lValue.equals(TextAttribute.SUPERSCRIPT_SUB)) {
                lAttr.setValue("sub");
            } else {
                lAttr.setValue("sub");
            }
            lIElement.setAttributeNode(lAttr);
        } else {
            System.out.println("ERROR!");
        }
    }

    public void loadFileFromDisk(UserFrame pUserFrame, File pFile) {
        this.mUserFrame = pUserFrame;
        this.mFactory = DocumentBuilderFactory.newInstance();
        try {
            this.mBuilder = this.mFactory.newDocumentBuilder();
            this.mDoc = this.mBuilder.parse(pFile);
            this.mRoot = this.mDoc.getDocumentElement();
            String lString = this.mRoot.getAttribute("type");
            if (lString.equals("TreeForm")) {
                this.mUserFrame.getDesktopPane().addInternalFrame();
                this.mInternalFrame = this.mUserFrame.getDesktopPane().getInternalFrame();
                this.loadFile(this.mDoc, this.mInternalFrame);
            } else {
                JOptionPane.showMessageDialog(null, "Not a treeform file", "This is NOT a treeform file!", 0);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadFile(Document doc, UserInternalFrame userInternalFrame) {
        this.mInternalFrame = userInternalFrame;
        this.mUserFrame = this.mInternalFrame.getUserFrame();
        this.mFactory = DocumentBuilderFactory.newInstance();
        try {
            this.mBuilder = this.mFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.mDoc = doc;
        this.mRoot = this.mDoc.getDocumentElement();
        this.mSyntaxFacade = this.mInternalFrame.getSyntaxFacade();
        this.mAssociationMap = new HashMap();
        this.mStructureMap = new HashMap();
        this.loadATDetails(this.mRoot.getChildNodes().item(0), this.mSyntaxFacade.getSentence());
        this.mSyntaxFacade.setName(this.mRoot.getAttribute("name"));
        this.mSyntaxFacade.setFile(this.mRoot.getAttribute("file"));
        this.mInternalFrame.setTitle(this.mRoot.getAttribute("name"));
        if (this.mRoot.getAttribute("linelength") != "") {
            this.mInternalFrame.getProperties().setDefaultFontSize(new Integer(this.mRoot.getAttribute("defaultfontsize")));
            this.mInternalFrame.getProperties().setLineLength(new Integer(this.mRoot.getAttribute("linelength")));
            this.mInternalFrame.getProperties().setMinLineWidth(new Integer(this.mRoot.getAttribute("mintextwidth")));
            this.mInternalFrame.getProperties().setLeftTranslate(new Integer(this.mRoot.getAttribute("lefttranslate")));
            this.mInternalFrame.getProperties().setTopTranslate(new Integer(this.mRoot.getAttribute("toptranslate")));
        }
        Set lKey = this.mAssociationMap.keySet();
        Iterator lIterator = lKey.iterator();
        while (lIterator.hasNext()) {
            SyntacticAssociation lAS = (SyntacticAssociation)this.mAssociationMap.get(lIterator.next());
            lAS.setHead(lAS.getSyntacticFeature().getHead());
            this.mInternalFrame.getContentPane().add(lAS);
            lAS.getSyntacticStructure().testXY();
        }
        this.mSyntaxFacade.displayTree();
    }

    private void loadATDetails(Node pRoot, RepositionTree pSS) {
        Element lElement = (Element)pRoot;
        if (lElement != null) {
            if (lElement.getNodeName().equals("syntacticstructure")) {
                NodeList lNodeList = pRoot.getChildNodes();
                SyntacticStructure lSS = null;
                if (lElement.getAttribute("string") != "") {
                    if (this.mStructureMap.get(lElement.getAttribute("string")) == null) {
                        lSS = new SyntacticStructure(this.mInternalFrame, pSS);
                        this.mStructureMap.put(lElement.getAttribute("string"), lSS);
                    } else {
                        lSS = (SyntacticStructure)this.mStructureMap.get(lElement.getAttribute("string"));
                        lSS.setSyntacticParent(pSS);
                    }
                } else {
                    lSS = new SyntacticStructure(this.mInternalFrame, pSS);
                }
                if (lElement.getAttribute("linered") != "") {
                    lSS.setLineColor(new Color(Integer.valueOf(lElement.getAttribute("linered")), Integer.valueOf(lElement.getAttribute("linegreen")), Integer.valueOf(lElement.getAttribute("lineblue"))));
                }
                lSS.setSyntacticLevel(this.getSyntacticLevel(lElement.getAttribute("syntacticlevel")));
                lSS.setHead(this.loadHead(lElement));
                if (pSS instanceof Sentence) {
                    lSS.setSyntacticParent(null);
                }
                if (pSS != null) {
                    pSS.getChildren().add(lSS);
                }
                this.mInternalFrame.getContentPane().add(lSS);
                this.mInternalFrame.getContentPane().add(lSS.getSyntacticStructureLines());
                int i = 0;
                while (i < lNodeList.getLength()) {
                    this.loadATDetails(lNodeList.item(i), lSS);
                    ++i;
                }
            } else if (lElement.getNodeName().equals("syntacticfeaturesets")) {
                this.loadFeatureSets(lElement, pSS);
            } else if (lElement.getNodeName().equals("syntacticassociations")) {
                this.loadAssociations(lElement, pSS);
            } else if (lElement.getNodeName().equals("starttraces")) {
                this.loadStartTraces(lElement, pSS);
            } else if (lElement.getNodeName().equals("endtraces")) {
                this.loadEndTraces(lElement, pSS);
            }
        }
    }

    private void loadAssociations(Element lElement, RepositionTree pSS) {
        SyntacticStructure lSS = (SyntacticStructure)pSS;
        NodeList lAssociations = lElement.getChildNodes();
        int l = 0;
        while (l < lAssociations.getLength()) {
            Element lRootSA = (Element)lAssociations.item(l);
            SyntacticAssociation lSA = null;
            if (this.mAssociationMap.get(lRootSA.getAttribute("string")) != null) {
                lSA = (SyntacticAssociation)this.mAssociationMap.get(lRootSA.getAttribute("string"));
                lSS.getSyntacticAssociation().add(lSA);
                lSA.setSyntacticStructure(lSS);
            } else {
                lSA = new SyntacticAssociation(this.mInternalFrame);
                lSS.getSyntacticAssociation().add(lSA);
                lSA.setSyntacticStructure(lSS);
                this.mAssociationMap.put(lRootSA.getAttribute("string"), lSA);
            }
            ++l;
        }
    }

    private void loadStartTraces(Element lElement, RepositionTree pSS) {
        SyntacticStructure lSS = (SyntacticStructure)pSS;
        NodeList lStartTraces = lElement.getChildNodes();
        int l = 0;
        while (l < lStartTraces.getLength()) {
            Element lStartTrace = (Element)lStartTraces.item(l);
            SyntacticStructure lSSTrace = null;
            if (this.mStructureMap.get(lStartTrace.getAttribute("string")) != null) {
                lSSTrace = (SyntacticStructure)this.mStructureMap.get(lStartTrace.getAttribute("string"));
                lSS.getStartTrace().add(lSSTrace);
            } else {
                lSSTrace = new SyntacticStructure(this.mInternalFrame, null);
                lSS.getStartTrace().add(lSSTrace);
                this.mStructureMap.put(lStartTrace.getAttribute("string"), lSSTrace);
            }
            if (lStartTrace.getAttribute("customtrace") != "") {
                if (lStartTrace.getAttribute("customtrace").equals("true")) {
                    lSS.setCustomTrace(true);
                }
                lSS.setControlStartX(new Integer(lStartTrace.getAttribute("controlstartx")));
                lSS.setControlStartY(new Integer(lStartTrace.getAttribute("controlstarty")));
                lSS.setControlEndX(new Integer(lStartTrace.getAttribute("controlendx")));
                lSS.setControlEndY(new Integer(lStartTrace.getAttribute("controlendy")));
                lSS.setStartX(new Integer(lStartTrace.getAttribute("startx")));
                lSS.setStartY(new Integer(lStartTrace.getAttribute("starty")));
                lSS.setEndX(new Integer(lStartTrace.getAttribute("endx")));
                lSS.setEndY(new Integer(lStartTrace.getAttribute("endy")));
            }
            ++l;
        }
    }

    private void loadEndTraces(Element lElement, RepositionTree pSS) {
        SyntacticStructure lSS = (SyntacticStructure)pSS;
        NodeList lEndTraces = lElement.getChildNodes();
        int l = 0;
        while (l < lEndTraces.getLength()) {
            Element lEndTrace = (Element)lEndTraces.item(l);
            SyntacticStructure lSSTrace = null;
            if (this.mStructureMap.get(lEndTrace.getAttribute("string")) != null) {
                lSSTrace = (SyntacticStructure)this.mStructureMap.get(lEndTrace.getAttribute("string"));
                lSS.getEndTrace().add(lSSTrace);
            } else {
                lSSTrace = new SyntacticStructure(this.mInternalFrame, null);
                lSS.getEndTrace().add(lSSTrace);
                this.mStructureMap.put(lEndTrace.getAttribute("string"), lSSTrace);
            }
            ++l;
        }
    }

    private void loadFeatureSets(Element lElement, RepositionTree pSS) {
        SyntacticStructure lSS = (SyntacticStructure)pSS;
        NodeList lFeatureSets = lElement.getChildNodes();
        int i = 0;
        while (i < lFeatureSets.getLength()) {
            Element lEFS = (Element)lFeatureSets.item(i);
            SyntacticFeatureSet lSFS = null;
            if (lEFS.getAttribute("featuretype").equals("theta")) {
                lSFS = new ThetaRoleFeatureSet();
            } else if (lEFS.getAttribute("featuretype").equals("case")) {
                lSFS = new CaseFeatureSet();
            } else if (lEFS.getAttribute("featuretype").equals("feature")) {
                lSFS = new GenericFeatureSet();
            } else {
                System.out.println("ERROR!  Danger Will Robinson!!");
            }
            lSFS.setSyntacticStructure(lSS);
            lSS.getSyntacticFeatureSet().add(lSFS);
            NodeList lFeatures = lEFS.getChildNodes();
            int j = 0;
            while (j < lFeatures.getLength()) {
                Element lEF = (Element)lFeatures.item(j);
                SyntacticFeature lSF = new SyntacticFeature(this.mInternalFrame);
                lSFS.getSyntacticFeature().add(lSF);
                this.mInternalFrame.getContentPane().add(lSF);
                lSF.setSyntacticFeatureSet(lSFS);
                lSF.setHead(this.loadHead(lEF));
                NodeList lFeature = lEF.getChildNodes();
                int k = 0;
                while (k < lFeature.getLength()) {
                    if (((Element)lFeature.item(k)).getNodeName().equals("syntacticassociations")) {
                        NodeList lAssociations = ((Element)lFeature.item(k)).getChildNodes();
                        int l = 0;
                        while (l < lAssociations.getLength()) {
                            Element lRootSA = (Element)lAssociations.item(l);
                            SyntacticAssociation lSA = null;
                            if (this.mAssociationMap.get(lRootSA.getAttribute("string")) != null) {
                                lSA = (SyntacticAssociation)this.mAssociationMap.get(lRootSA.getAttribute("string"));
                                lSF.getSyntacticAssociation().add(lSA);
                                lSA.setSyntacticFeature(lSF);
                            } else {
                                lSA = new SyntacticAssociation(this.mInternalFrame);
                                lSF.getSyntacticAssociation().add(lSA);
                                lSA.setSyntacticFeature(lSF);
                                this.mAssociationMap.put(lRootSA.getAttribute("string"), lSA);
                            }
                            ++l;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        lSS.testXY();
    }

    private AttributedString loadHead(Element pElement) {
        Node lNode = pElement.getChildNodes().item(0);
        Element lElement = (Element)lNode;
        String lString = lElement.getAttribute("text");
        AttributedString lAT = new AttributedString(lString);
        NodeList lNodeList = lElement.getChildNodes();
        int i = 0;
        while (i < lNodeList.getLength()) {
            lAT.addAttributes(this.loadAttributes(lNodeList.item(i)), i, i + 1);
            ++i;
        }
        return lAT;
    }

    private Map loadAttributes(Node pNode) {
        HashMap<TextAttribute, Serializable> lMap = new HashMap<TextAttribute, Serializable>();
        Element lElement = (Element)pNode;
        String lFontName = lElement.getAttribute("font");
        String lStyle = lElement.getAttribute("style");
        String lSize = lElement.getAttribute("size");
        String lUnderline = lElement.getAttribute("underline");
        String lStrikethrough = lElement.getAttribute("strikethrough");
        String lScript = lElement.getAttribute("subscript");
        if (!lFontName.equals("")) {
            Font lFont = new Font(lFontName, (int)new Integer(lStyle), new Integer(lSize));
            AffineTransform lAT = new AffineTransform();
            if (lScript.equals("sub")) {
                lAT.translate(0.0, 1.0);
                lAT.scale(0.6666666666666666, 0.6666666666666666);
                lFont = lFont.deriveFont(lAT);
            } else if (lScript.equals("super")) {
                lAT.translate(0.0, -3.0);
                lAT.scale(0.6666666666666666, 0.6666666666666666);
                lFont = lFont.deriveFont(lAT);
            }
            lMap.put(TextAttribute.FONT, lFont);
        }
        if (lUnderline.equals("true")) {
            lMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (lStrikethrough.equals("true")) {
            lMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (lElement.getAttribute("backgroundred") != "") {
            lMap.put(TextAttribute.BACKGROUND, new Color(Integer.valueOf(lElement.getAttribute("backgroundred")), Integer.valueOf(lElement.getAttribute("backgroundgreen")), Integer.valueOf(lElement.getAttribute("backgroundblue"))));
            lMap.put(TextAttribute.FOREGROUND, new Color(Integer.valueOf(lElement.getAttribute("foregroundred")), Integer.valueOf(lElement.getAttribute("foregroundgreen")), Integer.valueOf(lElement.getAttribute("foregroundblue"))));
        }
        return lMap;
    }

    private SyntacticLevel getSyntacticLevel(String string) {
        if (string.equals("DOUBLE_BAR")) {
            return SyntacticLevel.DOUBLE_BAR;
        }
        if (string.equals("BAR")) {
            return SyntacticLevel.BAR;
        }
        if (string.equals("HEAD")) {
            return SyntacticLevel.HEAD;
        }
        if (string.equals("MORPH")) {
            return SyntacticLevel.MORPH;
        }
        if (string.equals("NULL")) {
            return SyntacticLevel.NULL;
        }
        if (string.equals("TRIANGLE")) {
            return SyntacticLevel.TRIANGLE;
        }
        return null;
    }
}

