/*
 * Decompiled with CFR 0.152.
 */
package syntaxTree;

import enumerators.SyntacticFeatureType;
import enumerators.SyntacticLevel;
import enumerators.SyntacticStructureType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.im.InputMethodRequests;
import java.io.IOException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import staticFunctions.Sizer;
import syntaxTree.SyntacticAssociation;
import syntaxTree.SyntacticFeature;
import syntaxTree.SyntacticStructure;
import syntaxTree.SyntaxFacade;
import userInterface.UserInternalFrame;

public class EditableComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private int mTextHeight;
    private int mTextWidth;
    private boolean mCaratTimer;
    private UserInternalFrame mUserInternalFrame;
    private TextLayout mTextLayoutHead;
    private AttributedString mHead;
    private int mHeadLength;
    private boolean mOver;
    private boolean mCarat;
    private int mRealTextWidth;
    private int mInsertionIndex;
    private int mHighlightBegin;
    private int mHighlightEnd;
    private Color mFontColor;
    private Color mBackgroundColor;
    private int mDelete;
    private SyntaxFacade mSyntaxFacade;
    private static final Color STRONG_CARET_COLOR = Color.black;
    private static final Color WEAK_CARET_COLOR = Color.black;
    private static final Color HIGHLIGHT_COLOR = new Color(36, 139, 192, 90);
    private static final Color TEXT_HIGHLIGHT_COLOR = new Color(0, 0, 255, 80);
    private static final Color NULL_COLOR = new Color(223, 61, 51, 90);
    private static final Color FEATURE_COLOR = new Color(50, 171, 90, 90);
    private static final Color ASSOCIATION_COLOR = new Color(166, 127, 190, 90);

    public EditableComponent(UserInternalFrame pUserInternalFrame) {
        this.setUserInternalFrame(pUserInternalFrame);
        this.setSyntaxFacade(pUserInternalFrame.getSyntaxFacade());
        this.mHead = new AttributedString(" ");
        Font lFont = new Font("Doulos SIL", 1, this.getUserInternalFrame().getProperties().getDefaultFontSize());
        this.mHead.addAttribute(TextAttribute.FONT, lFont);
        UserDropTarget dtl = new UserDropTarget();
        this.setDropTarget(dtl);
        HitTestMouseListener hitTest = new HitTestMouseListener();
        this.addMouseListener(hitTest);
        this.addMouseMotionListener(hitTest);
        UserKeyListener key = new UserKeyListener();
        this.addKeyListener(key);
        this.addInputMethodListener(new UserInputMethodListener());
        int delay = 500;
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditableComponent.this.mCaratTimer = !EditableComponent.this.mCaratTimer;
                if (EditableComponent.this.getCarat()) {
                    EditableComponent.this.repaint();
                }
            }
        };
        new Timer(delay, taskPerformer).start();
    }

    public void paint(Graphics pG) {
        Graphics lGraphics = pG;
        Graphics2D lGraphics2D = (Graphics2D)lGraphics;
        Point2D.Float lPoint2D = new Point2D.Float(this.getTextWidth(), this.getTextHeight());
        Point2D.Float lPoint2DScaled = new Point2D.Float((int)(lPoint2D.getX() * (double)Sizer.scaleWidth() * (double)this.getUserInternalFrame().getScale()), (int)(lPoint2D.getY() * (double)Sizer.scaleHeight() * (double)this.getUserInternalFrame().getScale()));
        lGraphics2D.scale(Sizer.scaleWidth() * this.getUserInternalFrame().getScale(), Sizer.scaleHeight() * this.getUserInternalFrame().getScale());
        lGraphics2D.setColor(Color.BLACK);
        lGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        lGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        FontRenderContext lFrc = lGraphics2D.getFontRenderContext();
        this.mTextLayoutHead = new TextLayout(this.getHead().getIterator(), lFrc);
        this.mTextLayoutHead.draw(lGraphics2D, (float)(this.getZero((double)this.getTextWidth() - this.mTextLayoutHead.getBounds().getWidth()) / 2.0), this.mTextLayoutHead.getAscent());
        this.setSize((int)lPoint2DScaled.getX(), (int)lPoint2DScaled.getY());
        if (this.getOver()) {
            SyntacticStructure hold;
            lGraphics2D.setColor(HIGHLIGHT_COLOR);
            if (this instanceof SyntacticStructure && (hold = (SyntacticStructure)this).getSyntacticLevel() == SyntacticLevel.NULL) {
                lGraphics2D.setColor(NULL_COLOR);
            }
            if (this instanceof SyntacticFeature) {
                lGraphics2D.setColor(FEATURE_COLOR);
            }
            if (this instanceof SyntacticAssociation) {
                lGraphics2D.setColor(ASSOCIATION_COLOR);
            }
            lGraphics2D.fillRect(0, 0, (int)lPoint2D.getX(), (int)lPoint2D.getY());
        }
        if (this.getHighlightBegin() != this.getHighlightEnd()) {
            Shape lHilite = this.mTextLayoutHead.getLogicalHighlightShape(this.getHighlightBegin(), this.getHighlightEnd());
            lGraphics2D.setColor(TEXT_HIGHLIGHT_COLOR);
            float rx = (float)(this.getZero((double)this.getTextWidth() - this.mTextLayoutHead.getBounds().getWidth()) / 2.0);
            float ry = this.mTextLayoutHead.getAscent();
            AffineTransform at = AffineTransform.getTranslateInstance(rx, ry);
            lHilite = at.createTransformedShape(lHilite);
            lGraphics2D.fill(lHilite);
        }
        if (this.getCarat() && this.mCaratTimer && this.isEnabled()) {
            lGraphics2D.translate(this.getZero((double)this.getTextWidth() - this.mTextLayoutHead.getBounds().getWidth()) / 2.0, this.mTextLayoutHead.getAscent());
            Shape[] carets = this.mTextLayoutHead.getCaretShapes(this.getInsertionIndex());
            lGraphics2D.setColor(STRONG_CARET_COLOR);
            lGraphics2D.draw(carets[0]);
            if (carets[1] != null) {
                lGraphics2D.setColor(WEAK_CARET_COLOR);
                lGraphics2D.draw(carets[1]);
            }
        }
    }

    private double getZero(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }

    public void setTextWidth(int pWidth) {
        this.mTextWidth = pWidth;
    }

    public int getTextWidth() {
        return this.mTextWidth;
    }

    public void setTextHeight(int pTextHeight) {
        this.mTextHeight = pTextHeight;
    }

    public int getTextHeight() {
        return this.mTextHeight;
    }

    public void setUserInternalFrame(UserInternalFrame pUserInternalFrame) {
        this.mUserInternalFrame = pUserInternalFrame;
    }

    public UserInternalFrame getUserInternalFrame() {
        return this.mUserInternalFrame;
    }

    public AttributedString getHead() {
        return this.mHead;
    }

    public void setHead(AttributedString pHead) {
        this.mHead = pHead;
        AttributedCharacterIterator lIterator = this.getHead().getIterator();
        int lI = 0;
        char c = lIterator.first();
        while (c != '\uffff') {
            ++lI;
            c = lIterator.next();
        }
        this.testXY();
        this.setHeadLength(lI);
    }

    public void setHeadLength(int pHeadLength) {
        this.mHeadLength = pHeadLength;
    }

    public int getHeadLength() {
        return this.mHeadLength;
    }

    public boolean getOver() {
        return this.mOver;
    }

    public void setOver(boolean pB) {
        this.mOver = pB;
    }

    private boolean getCarat() {
        return this.mCarat;
    }

    public void setCarat(boolean pCarat) {
        this.mCarat = pCarat;
    }

    public void setRealTextWidth(int pWidth) {
        this.mRealTextWidth = pWidth;
    }

    public int getRealTextWidth() {
        return this.mRealTextWidth;
    }

    public void setInsertionIndex(int pInsertionIndex) {
        if (pInsertionIndex < 0) {
            pInsertionIndex = 0;
        }
        if (pInsertionIndex > this.getHeadLength()) {
            pInsertionIndex = this.getHeadLength();
        }
        this.mInsertionIndex = pInsertionIndex;
    }

    public int getInsertionIndex() {
        return this.mInsertionIndex;
    }

    public void setHighlightBegin(int pHighlightBegin) {
        if (pHighlightBegin < 0) {
            pHighlightBegin = 0;
        }
        if (pHighlightBegin > this.getHeadLength()) {
            pHighlightBegin = this.getHeadLength();
        }
        this.mHighlightBegin = pHighlightBegin;
    }

    public int getHighlightBegin() {
        if (this.mHighlightBegin < this.mHighlightEnd) {
            return this.mHighlightBegin;
        }
        return this.mHighlightEnd;
    }

    public void setHighlightEnd(int pHighlightEnd) {
        if (pHighlightEnd < 0) {
            pHighlightEnd = 0;
        }
        if (pHighlightEnd > this.getHeadLength()) {
            pHighlightEnd = this.getHeadLength();
        }
        this.mHighlightEnd = pHighlightEnd;
    }

    public int getHighlightEnd() {
        if (this.mHighlightBegin < this.mHighlightEnd) {
            return this.mHighlightEnd;
        }
        return this.mHighlightBegin;
    }

    public AttributedString getClip() {
        return new AttributedString(this.mHead.getIterator(null, this.mHighlightBegin, this.mHighlightEnd));
    }

    public void insertHead(AttributedString pInsert, int pIndex) {
        String lString = "";
        String lInsertString = "";
        AttributedCharacterIterator lIterator = this.getHead().getIterator();
        char c = lIterator.first();
        while (c != '\uffff') {
            lString = String.valueOf(lString) + c;
            c = lIterator.next();
        }
        AttributedCharacterIterator lInsertIterator = pInsert.getIterator();
        c = lInsertIterator.first();
        while (c != '\uffff') {
            lInsertString = String.valueOf(lInsertString) + c;
            c = lInsertIterator.next();
        }
        String lFinalString = String.valueOf(lString.substring(0, pIndex)) + lInsertString + lString.substring(pIndex, lString.length());
        AttributedString lAT = new AttributedString(lFinalString);
        lIterator.first();
        char lHold = '\u0000';
        int i = 0;
        while (i < pIndex) {
            lAT.addAttributes(lIterator.getAttributes(), i, i + 1);
            lHold = lIterator.next();
            ++i;
        }
        int j = 0;
        char c2 = lInsertIterator.first();
        while (c2 != '\uffff') {
            lAT.addAttributes(lInsertIterator.getAttributes(), pIndex + j, pIndex + j + 1);
            ++j;
            c2 = lInsertIterator.next();
        }
        while (lHold != '\uffff') {
            lAT.addAttributes(lIterator.getAttributes(), pIndex + j, pIndex + j + 1);
            ++j;
            lHold = lIterator.next();
        }
        this.setHead(lAT);
    }

    public void deleteHead() {
        if (this.getHighlightBegin() != this.getHighlightEnd()) {
            String lString = "";
            AttributedCharacterIterator lIterator = this.getHead().getIterator();
            int lI = 0;
            char c = lIterator.first();
            while (c != '\uffff') {
                if (lI < this.getHighlightBegin() || lI >= this.getHighlightEnd()) {
                    lString = String.valueOf(lString) + c;
                }
                ++lI;
                c = lIterator.next();
            }
            AttributedString lAttributedString = new AttributedString(lString);
            lI = 0;
            int lJ = 0;
            char c2 = lIterator.first();
            while (c2 != '\uffff') {
                if (lI < this.getHighlightBegin() || lI >= this.getHighlightEnd()) {
                    lAttributedString.addAttributes(lIterator.getAttributes(), lJ, lJ + 1);
                    ++lJ;
                }
                ++lI;
                c2 = lIterator.next();
            }
            int lHighlight = this.getHighlightBegin();
            this.setHighlightEnd(lHighlight);
            this.setHighlightBegin(lHighlight);
            this.setInsertionIndex(lHighlight);
            this.setHead(lAttributedString);
        }
    }

    public void addAttribute(AttributedCharacterIterator.Attribute string, Object object) {
        if (this.getHighlightBegin() != this.getHighlightEnd()) {
            this.getHead().addAttribute(string, object, this.getHighlightBegin(), this.getHighlightEnd());
            this.testXY();
            this.mUserInternalFrame.getSyntaxFacade().displayTree();
        }
    }

    public boolean testAttribute() {
        return this.getHighlightBegin() != this.getHighlightEnd();
    }

    public void removeAttribute() {
        if (this.getHighlightBegin() != this.getHighlightEnd()) {
            this.getHead().addAttribute(TextAttribute.TRANSFORM, new AffineTransform(), this.getHighlightBegin(), this.getHighlightEnd());
            this.testXY();
        }
    }

    public void testXY() {
        TextLayout tl;
        int lWidth = 0;
        AttributedCharacterIterator iter = this.getHead().getIterator();
        FontRenderContext frc = ((Graphics2D)this.getUserInternalFrame().getGraphics()).getFontRenderContext();
        try {
            tl = new TextLayout(iter, frc);
        }
        catch (IllegalArgumentException e) {
            AttributedString lAT = new AttributedString(" ");
            Font lFont = new Font("Doulos SIL", 0, this.getUserInternalFrame().getProperties().getDefaultFontSize());
            lAT.addAttribute(TextAttribute.FONT, lFont);
            this.setHead(lAT);
            tl = new TextLayout(this.getHead().getIterator(), frc);
        }
        lWidth = (int)tl.getAdvance() + 4;
        this.setRealTextWidth(lWidth);
        lWidth = lWidth < this.getUserInternalFrame().getProperties().getMinLineWidth() ? this.getUserInternalFrame().getProperties().getMinLineWidth() : lWidth;
        this.setTextWidth(lWidth);
        this.setTextHeight((int)(tl.getAscent() + tl.getDescent()) + 1);
    }

    public void setHeadObservers() {
        AttributedCharacterIterator lIterator = this.mHead.getIterator();
        lIterator.setIndex(this.getInsertionIndex());
        Map<AttributedCharacterIterator.Attribute, Object> lAttributes = lIterator.getAttributes();
        Font lFont = (Font)lAttributes.get(TextAttribute.FONT);
        if (lFont != null) {
            this.mUserInternalFrame.getObservableFont().setValue(lFont.getName());
            this.mUserInternalFrame.getObservableFontSize().setValue(lFont.getSize());
            this.mUserInternalFrame.getObservableFontBold().setValue(lFont.isBold());
            this.mUserInternalFrame.getObservableFontItalic().setValue(lFont.isItalic());
            if (lAttributes.get(TextAttribute.FOREGROUND) != null) {
                this.mUserInternalFrame.getUserFrame().getObservableFontColor().setValue((Color)lAttributes.get(TextAttribute.FOREGROUND));
            } else {
                this.mUserInternalFrame.getUserFrame().getObservableFontColor().setValue(new Color(0, 0, 0));
            }
            if (lAttributes.get(TextAttribute.BACKGROUND) != null) {
                this.mUserInternalFrame.getUserFrame().getObservableBackgroundColor().setValue((Color)lAttributes.get(TextAttribute.BACKGROUND));
            } else {
                this.mUserInternalFrame.getUserFrame().getObservableBackgroundColor().setValue(new Color(255, 255, 255));
            }
            if ((TransformAttribute)lFont.getAttributes().get(TextAttribute.TRANSFORM) != null && ((TransformAttribute)lFont.getAttributes().get(TextAttribute.TRANSFORM)).getTransform().getTranslateY() == 1.0) {
                this.mUserInternalFrame.getObservableFontSubscript().setValue(true);
                this.mUserInternalFrame.getObservableFontSuperscript().setValue(false);
            } else if ((TransformAttribute)lFont.getAttributes().get(TextAttribute.TRANSFORM) != null && ((TransformAttribute)lFont.getAttributes().get(TextAttribute.TRANSFORM)).getTransform().getTranslateY() == -3.0) {
                this.mUserInternalFrame.getObservableFontSubscript().setValue(false);
                this.mUserInternalFrame.getObservableFontSuperscript().setValue(true);
            } else {
                this.mUserInternalFrame.getObservableFontSubscript().setValue(false);
                this.mUserInternalFrame.getObservableFontSuperscript().setValue(false);
            }
            Object lObject = lAttributes.get(TextAttribute.UNDERLINE);
            if (lObject == TextAttribute.UNDERLINE_ON) {
                this.mUserInternalFrame.getObservableFontUnderline().setValue(true);
            } else {
                this.mUserInternalFrame.getObservableFontUnderline().setValue(false);
            }
            lObject = lAttributes.get(TextAttribute.STRIKETHROUGH);
            if (lObject == TextAttribute.STRIKETHROUGH_ON) {
                this.mUserInternalFrame.getObservableFontStrikethrough().setValue(true);
            } else {
                this.mUserInternalFrame.getObservableFontStrikethrough().setValue(false);
            }
        } else {
            this.mUserInternalFrame.getObservableFontSubscript().setValue(false);
            this.mUserInternalFrame.getObservableFontSuperscript().setValue(false);
        }
    }

    public void setFontColor(Color color) {
        this.mFontColor = color;
    }

    public void setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
    }

    public Color getFontColor() {
        return this.mFontColor;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public SyntaxFacade getSyntaxFacade() {
        return this.mSyntaxFacade;
    }

    public void setSyntaxFacade(SyntaxFacade syntaxFacade) {
        this.mSyntaxFacade = syntaxFacade;
    }

    public void selectAll() {
        this.setOver(false);
        this.setCarat(false);
        Rectangle2D lRectangle = this.mTextLayoutHead.getBounds();
        this.setHighlightBegin((int)lRectangle.getX());
        this.setHighlightEnd((int)lRectangle.getWidth());
        this.repaint();
    }

    public InputMethodRequests getInputMethodRequests() {
        return (InputMethodRequests)((Object)this.getInputContext());
    }

    public void setDropTarget(DropTarget dropTarget) {
        super.setDropTarget(dropTarget);
    }

    public DropTarget getDropTarget() {
        return super.getDropTarget();
    }

    public void setClicked(int pME, int clickCount, Object source) {
        this.mSyntaxFacade.deselectTree();
        this.setInsertionIndex(pME);
        if (clickCount > 1) {
            this.selectAll();
        } else {
            this.setHighlightBegin(pME);
            this.setHighlightEnd(pME);
        }
        this.mUserInternalFrame.getObservableClipboard().setValue(source);
        this.mUserInternalFrame.getObservableClipboard().setIndex(this.getInsertionIndex());
        this.setCarat(true);
        this.requestFocus(true);
    }

    private int pointTest(MouseEvent pME) {
        float clickX = pME.getX();
        float clickY = pME.getY();
        return this.pointTestXY(clickX, clickY);
    }

    private int pointTestXY(float clickX, float clickY) {
        Point2D origin = this.computeLayoutOrigin();
        clickX = (float)((double)clickX - origin.getX());
        clickY = (float)((double)clickY - origin.getY());
        Rectangle2D lRectangle = this.mTextLayoutHead.getBounds();
        clickX = (double)clickX < lRectangle.getWidth() / 2.0 ? (float)(lRectangle.getWidth() / 2.0 - (lRectangle.getWidth() / 2.0 - (double)clickX) / (double)(Sizer.scaleWidth() * this.getUserInternalFrame().getScale())) : (float)(lRectangle.getWidth() / 2.0 + ((double)clickX - lRectangle.getWidth() / 2.0) / (double)(Sizer.scaleWidth() * this.getUserInternalFrame().getScale()));
        clickY = (double)clickY < lRectangle.getHeight() / 2.0 ? (float)(lRectangle.getHeight() / 2.0 - (lRectangle.getHeight() / 2.0 - (double)clickY) / (double)(Sizer.scaleHeight() * this.getUserInternalFrame().getScale())) : (float)(lRectangle.getHeight() / 2.0 + ((double)clickY - lRectangle.getHeight() / 2.0) / (double)(Sizer.scaleHeight() * this.getUserInternalFrame().getScale()));
        TextHitInfo currentHit = this.mTextLayoutHead.hitTestChar(clickX, clickY);
        return currentHit.getInsertionIndex();
    }

    private Point2D computeLayoutOrigin() {
        Dimension size = this.getSize();
        Point2D.Float origin = new Point2D.Float();
        origin.x = ((float)size.width - this.mTextLayoutHead.getAdvance()) / 2.0f;
        origin.y = ((float)size.height - this.mTextLayoutHead.getDescent() + this.mTextLayoutHead.getAscent()) / 2.0f;
        return origin;
    }

    private class HitTestMouseListener
    implements MouseInputListener {
        private boolean mMove;
        private boolean mTrace;

        private HitTestMouseListener() {
        }

        public void mouseClicked(MouseEvent pME) {
            EditableComponent.this.setClicked(EditableComponent.this.pointTest(pME), pME.getClickCount(), pME.getSource());
        }

        public void mouseEntered(MouseEvent arg0) {
            if (EditableComponent.this.mUserInternalFrame.getCursor().getType() != 12) {
                Cursor lMoveCursor = new Cursor(2);
                EditableComponent.this.mUserInternalFrame.setCursor(lMoveCursor);
            }
            EditableComponent.this.setOver(true);
            if (arg0.getSource() instanceof SyntacticFeature) {
                SyntacticFeature hold = (SyntacticFeature)arg0.getSource();
                int i = 0;
                while (i < hold.getSyntacticAssociation().size()) {
                    SyntacticAssociation w = (SyntacticAssociation)hold.getSyntacticAssociation().get(i);
                    w.setOver(true);
                    w.repaint();
                    ++i;
                }
            }
            if (arg0.getSource() instanceof SyntacticAssociation) {
                SyntacticAssociation hold1 = (SyntacticAssociation)arg0.getSource();
                SyntacticFeature hold = hold1.getSyntacticFeature();
                hold.setOver(true);
                hold.repaint();
                int i = 0;
                while (i < hold.getSyntacticAssociation().size()) {
                    SyntacticAssociation w = (SyntacticAssociation)hold.getSyntacticAssociation().get(i);
                    w.setOver(true);
                    w.repaint();
                    ++i;
                }
            }
            EditableComponent.this.repaint();
        }

        public void mouseExited(MouseEvent arg0) {
            if (EditableComponent.this.mUserInternalFrame.getCursor().getType() != 12) {
                Cursor lMoveCursor = new Cursor(0);
                EditableComponent.this.mUserInternalFrame.setCursor(lMoveCursor);
            }
            if (arg0.getSource() instanceof SyntacticFeature) {
                SyntacticFeature hold = (SyntacticFeature)arg0.getSource();
                int i = 0;
                while (i < hold.getSyntacticAssociation().size()) {
                    SyntacticAssociation w = (SyntacticAssociation)hold.getSyntacticAssociation().get(i);
                    w.setOver(false);
                    w.repaint();
                    ++i;
                }
            }
            if (arg0.getSource() instanceof SyntacticAssociation) {
                SyntacticAssociation hold1 = (SyntacticAssociation)arg0.getSource();
                SyntacticFeature hold = hold1.getSyntacticFeature();
                hold.setOver(false);
                hold.repaint();
                int i = 0;
                while (i < hold.getSyntacticAssociation().size()) {
                    SyntacticAssociation w = (SyntacticAssociation)hold.getSyntacticAssociation().get(i);
                    w.setOver(false);
                    w.repaint();
                    ++i;
                }
            }
            EditableComponent.this.setOver(false);
            EditableComponent.this.repaint();
        }

        public void mousePressed(MouseEvent e) {
            if ((e.getModifiersEx() & 0x40) != 0) {
                this.mMove = true;
                Cursor lMoveCursor = new Cursor(12);
                EditableComponent.this.mUserInternalFrame.setCursor(lMoveCursor);
            } else if ((e.getModifiersEx() & 0x200) != 0) {
                this.mTrace = true;
                Cursor lMoveCursor = new Cursor(12);
                EditableComponent.this.setCursor(lMoveCursor);
                EditableComponent.this.mUserInternalFrame.setCursor(lMoveCursor);
            } else {
                if ((e.getModifiersEx() & 0x1000) != 0 || (e.getModifiersEx() & 0x80) != 0) {
                    EditableComponent.this.getUserInternalFrame().getSyntaxFacade().getPopupMenu(e.getSource()).show(e.getComponent(), e.getX(), e.getY());
                }
                EditableComponent.this.setOver(false);
                int lI = EditableComponent.this.pointTest(e);
                EditableComponent.this.setInsertionIndex(lI);
                EditableComponent.this.setHighlightBegin(lI);
                EditableComponent.this.setHighlightEnd(lI);
                EditableComponent.this.mUserInternalFrame.getObservableClipboard().setValue(e.getSource());
                EditableComponent.this.mUserInternalFrame.getObservableClipboard().setIndex(EditableComponent.this.getInsertionIndex());
                EditableComponent.this.setHeadObservers();
                EditableComponent.this.setCarat(true);
                EditableComponent.this.requestFocus(true);
                EditableComponent.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent pME) {
            Point containerPoint = SwingUtilities.convertPoint((Component)pME.getSource(), pME.getPoint(), EditableComponent.this.mUserInternalFrame.getContentPane());
            if (this.mMove) {
                Component hold = EditableComponent.this.mUserInternalFrame.getSyntaxFacade().getUnder(containerPoint, pME.getSource(), false);
                if (hold != null) {
                    ((EditableComponent)hold).setOver(false);
                    hold.repaint();
                    ((EditableComponent)pME.getSource()).setOver(false);
                    ((Component)pME.getSource()).repaint();
                }
                if (EditableComponent.this.mUserInternalFrame.getSyntaxFacade().getUnder(containerPoint, pME.getSource(), false) instanceof SyntacticStructure) {
                    SyntacticStructure lSSParent = (SyntacticStructure)EditableComponent.this.mUserInternalFrame.getSyntaxFacade().getUnder(containerPoint, pME.getSource(), !(pME.getSource() instanceof SyntacticStructure));
                    if (lSSParent != null && pME.getSource() instanceof SyntacticStructure) {
                        EditableComponent.this.mUserInternalFrame.getSyntaxFacade().moveSyntacticStructure(lSSParent, (SyntacticStructure)pME.getSource());
                    } else if (lSSParent != null && pME.getSource() instanceof SyntacticFeature) {
                        EditableComponent.this.mUserInternalFrame.getSyntaxFacade().associateSyntacticFeature(lSSParent, (SyntacticFeature)pME.getSource());
                    } else {
                        EditableComponent.this.mUserInternalFrame.getSyntaxFacade().displayTree();
                    }
                } else {
                    EditableComponent.this.mUserInternalFrame.getSyntaxFacade().displayTree();
                }
                Cursor lDefaultCursor = new Cursor(0);
                EditableComponent.this.mUserInternalFrame.setCursor(lDefaultCursor);
            } else if (this.mTrace) {
                SyntacticStructure lSSEnd;
                containerPoint = SwingUtilities.convertPoint((Component)pME.getSource(), pME.getPoint(), EditableComponent.this.mUserInternalFrame.getContentPane());
                Component hold = EditableComponent.this.mUserInternalFrame.getSyntaxFacade().getUnder(containerPoint, pME.getSource(), true);
                if (hold != null) {
                    ((EditableComponent)hold).setOver(false);
                    hold.repaint();
                    ((EditableComponent)pME.getSource()).setOver(false);
                    ((Component)pME.getSource()).repaint();
                }
                if (hold instanceof SyntacticAssociation) {
                    hold = ((SyntacticAssociation)hold).getSyntacticStructure();
                }
                if (hold instanceof SyntacticFeature) {
                    hold = ((SyntacticFeature)hold).getSyntacticFeatureSet().getSyntacticStructure();
                }
                if (hold instanceof SyntacticStructure && (lSSEnd = (SyntacticStructure)hold) != null && pME.getSource() instanceof SyntacticStructure) {
                    EditableComponent.this.mUserInternalFrame.getSyntaxFacade().addTrace(lSSEnd, (SyntacticStructure)pME.getSource());
                }
                EditableComponent.this.mUserInternalFrame.getSyntaxFacade().displayTree();
                Cursor lDefaultCursor = new Cursor(0);
                EditableComponent.this.mUserInternalFrame.setCursor(lDefaultCursor);
            } else {
                EditableComponent.this.setHighlightEnd(EditableComponent.this.pointTest(pME));
                EditableComponent.this.repaint();
            }
            this.mMove = false;
            this.mTrace = false;
        }

        public void mouseDragged(MouseEvent pME) {
            if ((pME.getModifiersEx() & 0x40) != 0) {
                Point containerPoint = SwingUtilities.convertPoint((Component)pME.getSource(), pME.getPoint(), EditableComponent.this.mUserInternalFrame.getContentPane());
                Component hold = EditableComponent.this.mUserInternalFrame.getSyntaxFacade().getUnder(containerPoint, pME.getSource(), !(pME.getSource() instanceof SyntacticStructure));
                if (hold != null) {
                    EditableComponent.this.mUserInternalFrame.getSyntaxFacade().setHighlight(hold);
                }
                if (pME.getSource() instanceof SyntacticStructure) {
                    EditableComponent.this.mUserInternalFrame.getSyntaxFacade().translateSyntacticSubtree((SyntacticStructure)pME.getSource(), pME);
                }
                if (pME.getSource() instanceof SyntacticFeature) {
                    EditableComponent.this.mUserInternalFrame.getSyntaxFacade().translateSyntacticFeature((SyntacticFeature)pME.getSource(), pME);
                }
            } else if ((pME.getModifiersEx() & 0x200) != 0 && pME.getSource() instanceof SyntacticStructure) {
                Point containerPoint = SwingUtilities.convertPoint((Component)pME.getSource(), pME.getPoint(), EditableComponent.this.mUserInternalFrame.getContentPane());
                Component hold = EditableComponent.this.mUserInternalFrame.getSyntaxFacade().getUnder(containerPoint, pME.getSource(), true);
                if (hold != null) {
                    EditableComponent.this.mUserInternalFrame.getSyntaxFacade().setHighlight(hold);
                }
                EditableComponent.this.mUserInternalFrame.getSyntaxFacade().translateSyntacticStructure((SyntacticStructure)pME.getSource(), pME);
            } else {
                EditableComponent.this.setOver(false);
                EditableComponent.this.setCarat(false);
                EditableComponent.this.setHighlightEnd(EditableComponent.this.pointTest(pME));
                EditableComponent.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent arg0) {
        }
    }

    private class UserDropTarget
    extends DropTarget
    implements DropTargetListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private UserDropTarget() {
        }

        public void dragOver(DropTargetDragEvent dtde) {
            EditableComponent.this.setClicked(EditableComponent.this.pointTestXY(dtde.getLocation().x, dtde.getLocation().y), 1, dtde.getSource());
            EditableComponent.this.repaint();
        }

        public void drop(DropTargetDropEvent dtde) {
            EditableComponent.this.setClicked(EditableComponent.this.pointTestXY(dtde.getLocation().x, dtde.getLocation().y), 1, dtde.getSource());
            try {
                dtde.acceptDrop(1);
                Object lObject = dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if (lObject instanceof String) {
                    EditableComponent.this.deleteHead();
                    AttributedString lAT = new AttributedString((String)lObject);
                    lAT.addAttributes(EditableComponent.this.mUserInternalFrame.getAttributes(), 0, ((String)lObject).length());
                    EditableComponent.this.insertHead(lAT, EditableComponent.this.getInsertionIndex());
                    EditableComponent.this.setInsertionIndex(EditableComponent.this.getInsertionIndex() + ((String)lObject).length());
                    EditableComponent.this.setHighlightBegin(EditableComponent.this.getInsertionIndex());
                    EditableComponent.this.setHighlightEnd(EditableComponent.this.getInsertionIndex());
                    EditableComponent.this.mUserInternalFrame.getSyntaxFacade().displayTree();
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class UserInputMethodListener
    implements InputMethodListener {
        private UserInputMethodListener() {
        }

        public void caretPositionChanged(InputMethodEvent arg0) {
        }

        public void inputMethodTextChanged(InputMethodEvent event) {
            int start = event.getText().getBeginIndex();
            int end = event.getText().getEndIndex();
            int commit = event.getCommittedCharacterCount();
            EditableComponent.this.deleteHead();
            if (EditableComponent.this.mDelete > 0) {
                EditableComponent.this.setHighlightBegin(EditableComponent.this.getInsertionIndex());
                EditableComponent.this.setHighlightEnd(EditableComponent.this.getInsertionIndex() - EditableComponent.this.mDelete);
                EditableComponent.this.deleteHead();
            }
            EditableComponent.this.mDelete = end - commit;
            if (start != end) {
                AttributedString lAT = new AttributedString(event.getText());
                lAT.addAttributes(EditableComponent.this.mUserInternalFrame.getAttributes(), start, end);
                EditableComponent.this.insertHead(lAT, EditableComponent.this.getInsertionIndex());
                EditableComponent.this.setInsertionIndex(EditableComponent.this.getInsertionIndex() + (end - start));
                EditableComponent.this.setHighlightBegin(EditableComponent.this.getInsertionIndex());
                EditableComponent.this.setHighlightEnd(EditableComponent.this.getInsertionIndex());
                EditableComponent.this.mUserInternalFrame.getSyntaxFacade().displayTree();
            }
        }
    }

    private class UserKeyListener
    implements KeyListener {
        private UserKeyListener() {
        }

        public void keyPressed(KeyEvent pKE) {
            int location = pKE.getKeyCode();
            if (location == 37) {
                EditableComponent.this.setInsertionIndex(EditableComponent.this.getInsertionIndex() - 1);
                EditableComponent.this.setHighlightEnd(EditableComponent.this.getInsertionIndex());
                if ((pKE.getModifiersEx() & 0x40) == 0) {
                    EditableComponent.this.setCarat(true);
                    EditableComponent.this.setHighlightBegin(EditableComponent.this.getInsertionIndex());
                } else {
                    EditableComponent.this.setCarat(false);
                }
                EditableComponent.this.setHeadObservers();
                EditableComponent.this.repaint();
            } else if (location == 39) {
                EditableComponent.this.setInsertionIndex(EditableComponent.this.getInsertionIndex() + 1);
                EditableComponent.this.setHighlightEnd(EditableComponent.this.getInsertionIndex());
                if ((pKE.getModifiersEx() & 0x40) == 0) {
                    EditableComponent.this.setHighlightBegin(EditableComponent.this.getInsertionIndex());
                    EditableComponent.this.setCarat(true);
                } else {
                    EditableComponent.this.setCarat(false);
                }
                EditableComponent.this.setHeadObservers();
                EditableComponent.this.repaint();
            } else if (location == 127) {
                if (EditableComponent.this.getHighlightBegin() == EditableComponent.this.getHighlightEnd()) {
                    EditableComponent.this.setHighlightEnd(EditableComponent.this.getHighlightBegin() + 1);
                }
                EditableComponent.this.deleteHead();
                EditableComponent.this.mUserInternalFrame.getSyntaxFacade().displayTree();
            } else if (location == 8) {
                if (EditableComponent.this.getHighlightBegin() == EditableComponent.this.getHighlightEnd()) {
                    EditableComponent.this.setHighlightBegin(EditableComponent.this.getInsertionIndex() - 1);
                }
                EditableComponent.this.deleteHead();
                EditableComponent.this.mUserInternalFrame.getSyntaxFacade().displayTree();
            } else if (pKE.getSource() instanceof SyntacticStructure) {
                SyntacticStructure ss = (SyntacticStructure)pKE.getSource();
                UserInternalFrame uif = ss.getUserInternalFrame();
                SyntaxFacade sf = uif.getSyntaxFacade();
                if (location == 112) {
                    try {
                        sf.addSyntacticStructure(SyntacticStructureType.HEAD, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 113) {
                    try {
                        sf.addSyntacticStructure(SyntacticStructureType.PHRASE, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 114) {
                    try {
                        sf.addSyntacticStructure(SyntacticStructureType.MORPH, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 115) {
                    try {
                        sf.addSyntacticStructure(SyntacticStructureType.TRIANGLE, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 116) {
                    try {
                        sf.addSyntacticFeatureToStructure(SyntacticFeatureType.CASE, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 117) {
                    try {
                        sf.addSyntacticFeatureToStructure(SyntacticFeatureType.THETA, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 118) {
                    try {
                        sf.addSyntacticFeatureToStructure(SyntacticFeatureType.FEATURE, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 119) {
                    try {
                        sf.addSyntacticStructure(SyntacticStructureType.UNARY, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 120) {
                    try {
                        sf.addSyntacticStructure(SyntacticStructureType.BINARY, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 121) {
                    try {
                        sf.addSyntacticStructure(SyntacticStructureType.TRINARY, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 122) {
                    try {
                        sf.addSyntacticStructure(SyntacticStructureType.ADJUNCT, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (location == 123) {
                    try {
                        sf.addSyntacticStructure(SyntacticStructureType.X_BAR, uif, ss);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void keyReleased(KeyEvent pKE) {
        }

        public void keyTyped(KeyEvent pKE) {
            char location = pKE.getKeyChar();
            EditableComponent.this.setCarat(true);
            if (location != '\b' && location != '\u007f' && location != '\n' && (pKE.getModifiersEx() & 0x80) == 0 && (pKE.getModifiersEx() & 0x100) == 0) {
                EditableComponent.this.deleteHead();
                AttributedString lAT = new AttributedString(String.valueOf(pKE.getKeyChar()));
                lAT.addAttributes(EditableComponent.this.mUserInternalFrame.getAttributes(), 0, 1);
                EditableComponent.this.insertHead(lAT, EditableComponent.this.getInsertionIndex());
                EditableComponent.this.setInsertionIndex(EditableComponent.this.getInsertionIndex() + 1);
                EditableComponent.this.setHighlightBegin(EditableComponent.this.getInsertionIndex());
                EditableComponent.this.setHighlightEnd(EditableComponent.this.getInsertionIndex());
                EditableComponent.this.mUserInternalFrame.getSyntaxFacade().displayTree();
            }
        }
    }
}

