/*
 * Decompiled with CFR 0.152.
 */
package syntaxTree;

import enumerators.SyntacticLevel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.text.AttributedString;
import java.util.LinkedList;
import javax.swing.JComponent;
import staticFunctions.Sizer;
import syntaxTree.EditableComponent;
import syntaxTree.RepositionTree;
import syntaxTree.SyntacticAssociation;
import syntaxTree.SyntacticFeatureSet;
import userInterface.UserInternalFrame;

public class SyntacticStructure
extends EditableComponent
implements RepositionTree {
    private static final long serialVersionUID = 1L;
    private SyntacticStructureLines mSyntacticStructureLines;
    private int mMinWidth;
    private LinkedList mChildren;
    private int mButtonHeight;
    private int mButtonWidth;
    private RepositionTree mParent;
    private double mPrelim;
    private double mY;
    private LinkedList mSyntacticAssociation;
    private LinkedList mSyntacticFeatureSet;
    private SyntacticLevel mSyntacticLevel;
    private boolean mVisibility;
    private double mMod;
    private SyntacticStructure mThread;
    private SyntacticStructure mAncestor;
    private double mChange;
    private double mShift;
    private double mX;
    private int mNumber;
    private int mLevel;
    private int mPreorder;
    private LinkedList mStartTrace;
    private LinkedList mEndTrace;
    private int mPadBottom;
    private int mAbsoluteOrder;
    private int mTraceCount;
    private boolean mCustomTrace = false;
    private int mControlStartX;
    private int mControlEndX;
    private int mControlStartY;
    private int mControlEndY;
    private int mStartX;
    private int mEndX;
    private int mEndY;
    private int mStartY;
    private Color mLineColor = new Color(0, 0, 0);

    public SyntacticStructure(UserInternalFrame pUserInternalFrame, RepositionTree pParent) {
        super(pUserInternalFrame);
        this.mChildren = new LinkedList();
        this.mSyntacticAssociation = new LinkedList();
        this.mSyntacticFeatureSet = new LinkedList();
        this.mStartTrace = new LinkedList();
        this.mEndTrace = new LinkedList();
        this.mParent = pParent;
        this.setSyntacticStructureLines(new SyntacticStructureLines());
    }

    public int getButtonHeight() {
        this.testXY();
        return this.mButtonHeight;
    }

    public int getButtonWidth() {
        int lButtonWidth = this.getChildWidth() > this.getTextWidth() ? this.getChildWidth() : this.getTextWidth();
        lButtonWidth = lButtonWidth > this.getMinWidth() ? lButtonWidth : this.getMinWidth();
        lButtonWidth = lButtonWidth > this.mButtonWidth ? lButtonWidth : this.mButtonWidth;
        return lButtonWidth;
    }

    public double getPrelim() {
        return this.mPrelim;
    }

    public double getButtonY() {
        return this.mY;
    }

    public LinkedList getChildren() {
        return this.mChildren;
    }

    public int getChildWidth() {
        int lWidth = 0;
        if (this.getChildren().size() == 0) {
            lWidth = this.getTextWidth();
        } else {
            int i = 0;
            while (i < this.getChildren().size()) {
                lWidth += ((SyntacticStructure)this.getChildren().get(i)).getMinWidth();
                ++i;
            }
        }
        return lWidth;
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    public void setMinWidth(int pMinWidth) {
        this.mMinWidth = pMinWidth;
    }

    public LinkedList getSyntacticAssociation() {
        return this.mSyntacticAssociation;
    }

    public SyntacticLevel getSyntacticLevel() {
        return this.mSyntacticLevel;
    }

    public RepositionTree getSyntacticParent() {
        return this.mParent;
    }

    public boolean getVisibility() {
        return this.mVisibility;
    }

    public void setHead(AttributedString pHead) {
        super.setHead(pHead);
        this.testXY();
    }

    public void insertHead(AttributedString pHead, int pInt) {
        super.insertHead(pHead, pInt);
        this.testXY();
    }

    public void setButtonHeight(int pHeight) {
        this.mButtonHeight = pHeight;
    }

    public void setButtonWidth(int mButtonWidth) {
        this.mButtonWidth = mButtonWidth;
    }

    public void setPrelim(double prelim) {
        this.mPrelim = prelim;
    }

    public void setButtonY(double level) {
        this.mY = level;
    }

    public void setChildren(LinkedList children) {
        this.mChildren = children;
    }

    public void setMod(double pMod) {
        this.mMod = pMod;
    }

    public void setThread(SyntacticStructure pThread) {
        this.mThread = pThread;
    }

    public void setAncestor(SyntacticStructure pAncestor) {
        this.mAncestor = pAncestor;
    }

    public double getMod() {
        return this.mMod;
    }

    public SyntacticStructure getThread() {
        return this.mThread;
    }

    public SyntacticStructure getAncestor() {
        return this.mAncestor;
    }

    public void setSyntacticAssociation(LinkedList syntacticAssociation) {
        this.mSyntacticAssociation = syntacticAssociation;
    }

    public void setSyntacticLevel(SyntacticLevel syntacticLevel) {
        this.mSyntacticLevel = syntacticLevel;
        if (syntacticLevel == SyntacticLevel.NULL) {
            this.setEnabled(false);
        }
    }

    public void setSyntacticParent(RepositionTree pParent) {
        this.mParent = pParent;
    }

    public void setVisibility(boolean visibility) {
        this.mVisibility = visibility;
    }

    public void testXY() {
        super.testXY();
        int lHeight = this.getUserInternalFrame().getProperties().getMinLineLength();
        lHeight = lHeight + this.getTextHeight() + 2;
        int lWidth = this.getTextWidth();
        int i = 0;
        while (i < this.getSyntacticAssociation().size()) {
            lHeight += ((SyntacticAssociation)this.getSyntacticAssociation().get(i)).getTextHeight();
            lWidth = lWidth > ((SyntacticAssociation)this.getSyntacticAssociation().get(i)).getTextWidth() ? lWidth : ((SyntacticAssociation)this.getSyntacticAssociation().get(i)).getTextWidth();
            ++i;
        }
        i = 0;
        while (i < this.getSyntacticFeatureSet().size()) {
            lHeight += ((SyntacticFeatureSet)this.getSyntacticFeatureSet().get(i)).getHeight();
            lWidth = lWidth > ((SyntacticFeatureSet)this.getSyntacticFeatureSet().get(i)).getWidth() ? lWidth : ((SyntacticFeatureSet)this.getSyntacticFeatureSet().get(i)).getWidth();
            ++i;
        }
        this.setTextWidth(lWidth);
        this.setButtonHeight(lHeight);
    }

    public void setSyntacticStructureLines(SyntacticStructureLines mSyntacticStructureLines) {
        this.mSyntacticStructureLines = mSyntacticStructureLines;
    }

    public SyntacticStructureLines getSyntacticStructureLines() {
        return this.mSyntacticStructureLines;
    }

    public void repaint() {
        super.repaint();
        if (this.getSyntacticStructureLines() != null) {
            this.getSyntacticStructureLines().repaint();
        }
    }

    public void setSyntacticFeatureSet(LinkedList pSyntacticFeatureSet) {
        this.mSyntacticFeatureSet = pSyntacticFeatureSet;
    }

    public LinkedList getSyntacticFeatureSet() {
        return this.mSyntacticFeatureSet;
    }

    public void deleteHead() {
        super.deleteHead();
        this.testXY();
    }

    public double getChange() {
        return this.mChange;
    }

    public void setChange(double change) {
        this.mChange = change;
    }

    public double getShift() {
        return this.mShift;
    }

    public void setShift(double shift) {
        this.mShift = shift;
    }

    public void setButtonX(double x) {
        this.mX = x;
    }

    public double getButtonX() {
        return this.mX;
    }

    public void setNumber(int number) {
        this.mNumber = number;
    }

    public int getNumber() {
        return this.mNumber;
    }

    public void setLevel(int level) {
        this.mLevel = level;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public void setPreorder(int preorder) {
        this.mPreorder = preorder;
    }

    public int getPreorder() {
        return this.mPreorder;
    }

    public LinkedList getEndTrace() {
        return this.mEndTrace;
    }

    public LinkedList getStartTrace() {
        return this.mStartTrace;
    }

    public int getPadBottom() {
        return this.mPadBottom;
    }

    public void setPadBottom(int padBottom) {
        this.mPadBottom = padBottom;
    }

    public void setAbsoluteOrder(int i) {
        this.mAbsoluteOrder = i;
    }

    public int getAbsoluteOrder() {
        return this.mAbsoluteOrder;
    }

    public int getTraceCount() {
        return this.mTraceCount;
    }

    public void setTraceCount(int traceCount) {
        this.mTraceCount = traceCount;
    }

    public int getTraceNumber() {
        return this.getStartTrace().size() + this.getEndTrace().size();
    }

    public void setCustomTrace(boolean customTrace) {
        this.mCustomTrace = customTrace;
    }

    public boolean getCustomTrace() {
        return this.mCustomTrace;
    }

    public int getControlStartX() {
        return this.mControlStartX;
    }

    public int getControlEndX() {
        return this.mControlEndX;
    }

    public int getControlStartY() {
        return this.mControlStartY;
    }

    public int getControlEndY() {
        return this.mControlEndY;
    }

    public void setControlStartX(int midStartX) {
        this.mControlStartX = midStartX;
    }

    public void setControlEndX(int midEndX) {
        this.mControlEndX = midEndX;
    }

    public void setControlStartY(int midStartY) {
        this.mControlStartY = midStartY;
    }

    public void setControlEndY(int midEndY) {
        this.mControlEndY = midEndY;
    }

    public void setStartX(int startX) {
        this.mStartX = startX;
    }

    public int getStartX() {
        return this.mStartX;
    }

    public void setEndX(int endX) {
        this.mEndX = endX;
    }

    public int getEndX() {
        return this.mEndX;
    }

    public void setStartY(int startY) {
        this.mStartY = startY;
    }

    public int getStartY() {
        return this.mStartY;
    }

    public void setEndY(int endY) {
        this.mEndY = endY;
    }

    public int getEndY() {
        return this.mEndY;
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public void setLineColor(Color color) {
        this.mLineColor = color;
        this.repaint();
    }

    public class SyntacticStructureLines
    extends JComponent {
        private static final long serialVersionUID = 1L;

        public void paint(Graphics pG) {
            Graphics lGraphics = pG;
            Graphics2D lGraphics2D = (Graphics2D)lGraphics;
            lGraphics2D.scale(Sizer.scaleWidth() * SyntacticStructure.this.getUserInternalFrame().getScale(), Sizer.scaleHeight() * SyntacticStructure.this.getUserInternalFrame().getScale());
            lGraphics2D.setColor(Color.BLACK);
            lGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            lGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            lGraphics2D.setColor(SyntacticStructure.this.getLineColor());
            if (SyntacticStructure.this.getChildren().size() > 0) {
                SyntacticStructure left = (SyntacticStructure)SyntacticStructure.this.getChildren().getFirst();
                SyntacticStructure w = (SyntacticStructure)SyntacticStructure.this.getChildren().getFirst();
                int halfway = (int)(SyntacticStructure.this.getButtonX() - left.getButtonX() + (double)(SyntacticStructure.this.getButtonWidth() / 2));
                int relativeWidth = 0;
                int i = 0;
                while (i < SyntacticStructure.this.getChildren().size()) {
                    w = (SyntacticStructure)SyntacticStructure.this.getChildren().get(i);
                    relativeWidth = (int)(w.getButtonX() - left.getButtonX());
                    if (w.getSyntacticLevel() == SyntacticLevel.TRIANGLE) {
                        GeneralPath polly = new GeneralPath();
                        int triangleDifference = (w.getButtonWidth() - w.getRealTextWidth()) / 2 + 1;
                        polly.moveTo(halfway, 1.0f);
                        polly.lineTo(relativeWidth + triangleDifference, (float)(w.getButtonY() - SyntacticStructure.this.getButtonY() - (double)SyntacticStructure.this.getButtonHeight() + (double)SyntacticStructure.this.getUserInternalFrame().getProperties().getMinLineLength()));
                        polly.lineTo(relativeWidth + w.getButtonWidth() - triangleDifference, (float)(w.getButtonY() - SyntacticStructure.this.getButtonY() - (double)SyntacticStructure.this.getButtonHeight() + (double)SyntacticStructure.this.getUserInternalFrame().getProperties().getMinLineLength()));
                        polly.closePath();
                        lGraphics2D.draw(polly);
                    } else {
                        lGraphics2D.drawLine(halfway, 1, relativeWidth + w.getButtonWidth() / 2, (int)(w.getButtonY() - SyntacticStructure.this.getButtonY() - (double)SyntacticStructure.this.getButtonHeight() + (double)SyntacticStructure.this.getUserInternalFrame().getProperties().getMinLineLength()));
                    }
                    ++i;
                }
            }
        }
    }
}

