/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Arc2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import staticFunctions.Sizer;
import userInterface.ObservableBackgroundColor;
import userInterface.ObservableNew;
import userInterface.UserFrame;

public class UserButtonBackgroundColor
extends JButton
implements Observer {
    private static final long serialVersionUID = 1L;
    private ObservableNew mObservableNew;
    private Color mColor;
    private boolean mIconSize;
    private UserFrame mUserFrame;

    public UserButtonBackgroundColor(UserFrame userFrame, boolean iconSize, ObservableBackgroundColor observableFontColor, ObservableNew observableNew) {
        this.mUserFrame = userFrame;
        this.mColor = Color.yellow;
        this.mIconSize = iconSize;
        this.mObservableNew = observableNew;
        if (iconSize) {
            this.setPreferredSize(new Dimension(32, 32));
        } else {
            this.setPreferredSize(new Dimension(24, 24));
        }
    }

    public void update(Observable arg0, Object arg1) {
        if (arg0 == this.mObservableNew) {
            if (this.mObservableNew.getValue() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    public void setColor(Color background) {
        this.mColor = background;
        this.mUserFrame.getSyntaxFacade().changeAttributes(TextAttribute.BACKGROUND, this.mColor);
        this.repaint();
    }

    public Color getColor() {
        return this.mColor;
    }

    public void paintComponent(Graphics pG) {
        super.paintComponent(pG);
        Graphics2D mGraphics2D = (Graphics2D)pG;
        mGraphics2D.setColor(Color.BLACK);
        mGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        mGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.mIconSize) {
            mGraphics2D.scale(1.3333333730697632, 1.3333333730697632);
        }
        Font mFont = new Font("Doulos SIL", 1, 7);
        FontRenderContext mFrc = mGraphics2D.getFontRenderContext();
        AttributedString ats = new AttributedString("ABC");
        ats.addAttribute(TextAttribute.FONT, mFont);
        ats.addAttribute(TextAttribute.FOREGROUND, Color.BLACK);
        ats.addAttribute(TextAttribute.BACKGROUND, Sizer.BLUE2);
        AttributedCharacterIterator iter = ats.getIterator();
        TextLayout tl = new TextLayout(iter, mFrc);
        tl.draw(mGraphics2D, 5.0f, 17.0f);
        mGraphics2D.setStroke(new BasicStroke(0.5f));
        Arc2D.Double arc2D = new Arc2D.Double(3.0, 3.0, 7.0, 7.0, 0.0, 360.0, 2);
        mGraphics2D.setColor(Color.BLUE);
        mGraphics2D.fill(arc2D);
        mGraphics2D.setColor(Sizer.BROWN1);
        mGraphics2D.draw(arc2D);
        arc2D = new Arc2D.Double(3.0, 3.0, 7.0, 7.0, 0.0, 240.0, 2);
        mGraphics2D.setColor(Color.GREEN);
        mGraphics2D.fill(arc2D);
        mGraphics2D.setColor(Sizer.BROWN1);
        mGraphics2D.draw(arc2D);
        arc2D = new Arc2D.Double(3.0, 3.0, 7.0, 7.0, 0.0, 120.0, 2);
        mGraphics2D.setColor(Color.RED);
        mGraphics2D.fill(arc2D);
        mGraphics2D.setColor(Sizer.BROWN1);
        mGraphics2D.draw(arc2D);
        mGraphics2D.setColor(this.mColor);
        mGraphics2D.fillRect(5, 17, 15, 4);
    }
}

