/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import userInterface.ListenerHighlightPane;
import userInterface.ListenerInternalFrame;
import userInterface.MDIDesktopManager;
import userInterface.UserFrame;
import userInterface.UserInternalFrame;

public class UserDesktopPane
extends JDesktopPane {
    private static final long serialVersionUID = 1L;
    private UserFrame mUserFrame;
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager mManager;

    public UserDesktopPane(UserFrame pUserFrame) {
        this.mUserFrame = pUserFrame;
        this.mManager = new MDIDesktopManager(this);
        this.setDesktopManager(this.mManager);
        this.setDragMode(1);
    }

    public void addInternalFrame() {
        UserInternalFrame internalFrame = new UserInternalFrame(this.mUserFrame, this.mUserFrame.getDesktopPane().getAllFrames().length + 1);
        internalFrame.setVisible(true);
        internalFrame.addInternalFrameListener(new ListenerInternalFrame(this.mUserFrame));
        internalFrame.getContentPane().setLayout(null);
        ListenerHighlightPane hold = new ListenerHighlightPane(this.mUserFrame);
        internalFrame.addMouseListener(hold);
        internalFrame.addMouseMotionListener(hold);
        this.add(internalFrame);
        try {
            internalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void closeInternalFrame() {
        if (this.getSelectedFrame() != null) {
            this.remove(this.getSelectedFrame());
            this.selecteNewFrame();
        }
        this.repaint();
    }

    public void selecteNewFrame() {
        JInternalFrame[] jif = this.getAllFrames();
        if (jif.length > 0) {
            this.setSelectedFrame(jif[0]);
            try {
                jif[0].setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            jif[0].repaint();
        }
    }

    public UserInternalFrame getInternalFrame() {
        return (UserInternalFrame)this.getSelectedFrame();
    }

    public void closeAllInternalFrames() {
        JInternalFrame[] jif = this.getAllFrames();
        int i = 0;
        while (i < jif.length) {
            this.remove(jif[i]);
            ++i;
        }
        this.repaint();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.checkDesktopSize();
    }

    public void remove(Component c) {
        super.remove(c);
        this.checkDesktopSize();
    }

    public void cascadeFrames() {
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        this.mManager.setNormalSize();
        int frameHeight = this.getBounds().height - 5 - allFrames.length * FRAME_OFFSET;
        int frameWidth = this.getBounds().width - 5 - allFrames.length * FRAME_OFFSET;
        int i = allFrames.length - 1;
        while (i >= 0) {
            allFrames[i].setSize(frameWidth, frameHeight);
            allFrames[i].setLocation(x, y);
            x += FRAME_OFFSET;
            y += FRAME_OFFSET;
            --i;
        }
    }

    public void tileFrames() {
        JInternalFrame[] allFrames = this.getAllFrames();
        this.mManager.setNormalSize();
        int frameHeight = this.getBounds().height / allFrames.length;
        int y = 0;
        int i = 0;
        while (i < allFrames.length) {
            allFrames[i].setSize(this.getBounds().width, frameHeight);
            allFrames[i].setLocation(0, y);
            y += frameHeight;
            ++i;
        }
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.mManager.resizeDesktop();
        }
    }
}

