/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.swing.JComponent;
import staticFunctions.Sizer;
import syntaxTree.SyntacticStructure;
import userInterface.UserFrame;

public class UserGlassPane
extends JComponent {
    private static final long serialVersionUID = 1L;
    private SyntacticStructure mSSChild;
    private int mMaxPosition;
    private HashMap mPositions;
    private int mPosition;
    private Point2D.Float mPoint;
    private SyntacticStructure mSS;
    private UserFrame mUserFrame;

    public UserGlassPane(UserFrame pUserFrame, SyntacticStructure pSS, SyntacticStructure pSSChild) {
        this.mUserFrame = pUserFrame;
        this.mSS = pSS;
        this.mSSChild = pSSChild;
    }

    public void paintComponent(Graphics g) {
        Graphics2D lGraphics2D = (Graphics2D)g;
        lGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        lGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        lGraphics2D.scale(Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale(), Sizer.scaleHeight() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        this.mPositions = new HashMap();
        Rectangle lRectangle = this.mSS.getSyntacticStructureLines().getBounds();
        this.mPoint = new Point2D.Float((float)lRectangle.x / (Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale()), (float)(lRectangle.y + lRectangle.height - 4) / (Sizer.scaleHeight() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale()));
        SyntacticStructure left = (SyntacticStructure)this.mSS.getChildren().getFirst();
        SyntacticStructure right = (SyntacticStructure)this.mSS.getChildren().getLast();
        int lI = 0;
        int lJ = 0;
        int i = 0;
        while (i < this.mSS.getChildren().size()) {
            SyntacticStructure w = (SyntacticStructure)this.mSS.getChildren().get(i);
            SyntacticStructure w1 = null;
            if (i == 0) {
                lI = 0;
            } else {
                w1 = (SyntacticStructure)this.mSS.getChildren().get(i - 1);
                lI = (int)((w.getButtonX() + (double)w.getButtonWidth() - w1.getButtonX()) / 2.0 + w1.getButtonX() - left.getButtonX());
            }
            lJ = lI + w.getButtonWidth() / 2;
            this.drawArc(lGraphics2D, lI, i);
            this.mPositions.put(new Integer(i), new Float(((float)lJ + this.mPoint.x) * Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale()));
            ++i;
        }
        lI = (int)(right.getButtonX() + (double)right.getButtonWidth() - left.getButtonX());
        this.drawArc(lGraphics2D, lI, this.mSS.getChildren().size());
        this.mPositions.put(new Integer(this.mSS.getChildren().size()), new Float(((float)lI + this.mPoint.x) * Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale()));
        this.mMaxPosition = this.mSS.getChildren().size();
    }

    public void setSyntacticStructure(SyntacticStructure pSS) {
        this.mSS = pSS;
    }

    private void drawArc(Graphics2D lGraphics2D, int pRelativePosition, int pPosition) {
        Arc2D.Float lArc;
        int startX = (int)((float)(this.mSS.getButtonWidth() / 2) + (float)this.mSS.getX() / (Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale()));
        int startY = (int)((float)this.mSS.getTextHeight() + (float)this.mSS.getY() / (Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale()));
        int endX = (int)this.mPoint.x + pRelativePosition;
        int endY = (int)this.mPoint.y;
        if (pPosition == this.getPosition()) {
            Color lColor = new Color(0, 190, 0);
            lGraphics2D.setColor(lColor);
            lArc = new Arc2D.Float(this.mPoint.x + (float)pRelativePosition - 4.0f, this.mPoint.y - 4.0f, 8.0f, 8.0f, 0.0f, 360.0f, 0);
            lGraphics2D.fill(lArc);
            lGraphics2D.setColor(Color.BLACK);
            float[] dash = new float[]{2.0f, 2.0f};
            lGraphics2D.setStroke(new BasicStroke(0.8f, 0, 0, 10.0f, dash, 0.0f));
            lGraphics2D.drawLine(startX, startY, endX, endY);
            lGraphics2D.setStroke(new BasicStroke());
        } else {
            Color lColor = new Color(255, 0, 0);
            lGraphics2D.setColor(lColor);
            lArc = new Arc2D.Float(this.mPoint.x + (float)pRelativePosition - 2.0f, this.mPoint.y - 2.0f, 4.0f, 4.0f, 0.0f, 360.0f, 0);
            lGraphics2D.fill(lArc);
        }
        lGraphics2D.setColor(Sizer.BROWN1);
        lGraphics2D.draw(lArc);
    }

    public void setPosition(MouseEvent pME) {
        this.mPosition = this.mMaxPosition;
        int i = this.mMaxPosition;
        while (i >= 0) {
            if (pME.getX() < ((Float)this.mPositions.get(new Integer(i))).intValue()) {
                this.mPosition = i;
            }
            --i;
        }
        this.mSS.setOver(true);
        this.mSS.repaint();
        this.repaint();
    }

    public int getPosition() {
        return this.mPosition;
    }

    public void setChild() {
        this.mSS.getChildren().add(this.mPosition, this.mSSChild);
        this.mSSChild.setSyntacticParent(this.mSS);
        this.mUserFrame.getInternalFrame().getTrace().setDrawTrace(true);
        this.mUserFrame.getSyntaxFacade().displayTree();
        this.mSS.setOver(false);
        this.mSS.repaint();
        this.mUserFrame.getDesktopPane().getInternalFrame().deactivateGlassPane();
    }
}

