/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import staticFunctions.Sizer;
import syntaxTree.SyntacticStructure;
import userInterface.UserFrame;

public class UserMovementPane
extends JComponent {
    private UserFrame mUserFrame;
    private SyntacticStructure mSS;
    private double mX;
    private double mY;
    private static final long serialVersionUID = 1L;

    public UserMovementPane(UserFrame userFrame, SyntacticStructure structure) {
        this.mUserFrame = userFrame;
        this.mSS = structure;
        this.mX = this.mSS.getButtonX() + (double)(this.mSS.getButtonWidth() / 2) - 5.0;
        this.mY = this.mSS.getButtonY() + (double)this.mSS.getButtonHeight() - (double)this.mUserFrame.getInternalFrame().getProperties().getMinLineLength();
    }

    public void setPosition(MouseEvent pme) {
        this.mX = (float)pme.getX() / (Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        this.mY = (float)pme.getY() / (Sizer.scaleHeight() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        this.repaint();
    }

    public void setEnd(SyntacticStructure structure) {
        this.mUserFrame.getSyntaxFacade().addTrace(structure, this.mSS);
    }

    public void paintComponent(Graphics g) {
        Graphics2D lGraphics2D = (Graphics2D)g;
        lGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        lGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        lGraphics2D.scale(Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale(), Sizer.scaleHeight() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        lGraphics2D.setColor(new Color(0, 0, 200));
        Ellipse2D.Double ellipse = new Ellipse2D.Double(this.mX, this.mY, 10.0, 10.0);
        lGraphics2D.fill(ellipse);
        double x = this.mSS.getButtonX() + (double)(this.mSS.getButtonWidth() / 2) - 5.0;
        double y = this.mSS.getButtonY() + (double)this.mSS.getButtonHeight() - (double)this.mUserFrame.getInternalFrame().getProperties().getMinLineLength();
        ellipse = new Ellipse2D.Double(x, y, 10.0, 10.0);
        lGraphics2D.fill(ellipse);
        lGraphics2D.setColor(Color.BLACK);
        float[] dash = new float[]{2.0f, 2.0f};
        lGraphics2D.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, dash, 0.0f));
        CubicCurve2D.Double bezier = new CubicCurve2D.Double(x + 5.0, y + 5.0, x + 5.0, (this.mY < y ? y : this.mY) + 25.0, this.mX + 5.0, (this.mY < y ? y : this.mY) + 25.0, this.mX + 5.0, this.mY + 5.0);
        lGraphics2D.draw(bezier);
    }
}

