// Wild Magic Source Code
// David Eberly
// http://www.geometrictools.com
// Copyright (c) 1998-2009
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or (at
// your option) any later version.  The license is available for reading at
// either of the locations:
//     http://www.gnu.org/copyleft/lgpl.html
//     http://www.geometrictools.com/License/WildMagicLicense.pdf
//
// Version: 4.0.1 (2006/09/21)

//----------------------------------------------------------------------------
inline bool ExtractSurfaceCubes::VETable::IsValidVertex (int i) const
{
    assert(0 <= i && i < 18);
    return m_akVertex[i].Valid;
}
//----------------------------------------------------------------------------
inline float ExtractSurfaceCubes::VETable::GetX (int i) const
{
    assert(0 <= i && i < 18);
    return m_akVertex[i].P.X();
}
//----------------------------------------------------------------------------
inline float ExtractSurfaceCubes::VETable::GetY (int i) const
{
    assert(0 <= i && i < 18);
    return m_akVertex[i].P.Y();
}
//----------------------------------------------------------------------------
inline float ExtractSurfaceCubes::VETable::GetZ (int i) const
{
    assert(0 <= i && i < 18);
    return m_akVertex[i].P.Z();
}
//----------------------------------------------------------------------------
inline ExtractSurfaceCubes::VETable::Vertex::Vertex ()
{
    AdjQuantity = 0;
    Valid = false;
}
//----------------------------------------------------------------------------
