// Wild Magic Source Code
// David Eberly
// http://www.geometrictools.com
// Copyright (c) 1998-2009
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or (at
// your option) any later version.  The license is available for reading at
// either of the locations:
//     http://www.gnu.org/copyleft/lgpl.html
//     http://www.geometrictools.com/License/WildMagicLicense.pdf
//
// Version: 4.0.0 (2006/06/28)

#ifndef BSPLINECURVEEXAMPLES_H
#define BSPLINECURVEEXAMPLES_H

#include "Wm4WindowApplication2.h"
#include "Wm4BSplineCurve2.h"
using namespace Wm4;

class BSplineCurveExamples : public WindowApplication2
{
    WM4_DECLARE_INITIALIZE;

public:
    BSplineCurveExamples ();

    virtual bool OnInitialize ();
    virtual void OnTerminate ();
    virtual void OnDisplay ();
    virtual bool OnKeyDown (unsigned char ucKey, int iX, int iY);

protected:
    BSplineCurve2f* m_pkSpline;
    int m_iNumCtrlPoints, m_iDegree;
    Vector2f* m_akCtrlPoint;
    float* m_afKnot;
    float m_afLocCtrlMin[6], m_afLocCtrlMax[6];
    int m_iCurveType;
    bool m_bModified;
};

WM4_REGISTER_INITIALIZE(BSplineCurveExamples);

#endif
