<?php
/**
 * Copyright Zikula Foundation 2009 - Profile module for Zikula
 *
 * This work is contributed to the Zikula Foundation under one or more
 * Contributor Agreements and licensed to You under the following license:
 *
 * @license GNU/GPLv3 (or at your option, any later version).
 * @package Profile
 *
 * Please see the NOTICE file distributed with this source code for further
 * information regarding copyright and licensing.
 */

/**
 * "Members Online" block.
 */
class Profile_Block_Membersonline extends Zikula_Controller_AbstractBlock
{
    /**
     * Initialise block.
     *
     * @return void
     */
    public function init()
    {
        SecurityUtil::registerPermissionSchema('Profile:MembersOnlineblock:', 'Block title::');
    }

    /**
     * Get information on the block.
     *
     * @return array The block information.
     */
    public function info()
    {
        return array(
            'module'          => 'Profile',
            'text_type'       => $this->__('Users on-line'),
            'text_type_long'  => $this->__('Show which registered users are currently on-line'),
            'allow_multiple'  => true,
            'form_content'    => false,
            'form_refresh'    => false,
            'show_preview'    => true,
            'admin_tableless' => true,
        );
    }

    /**
     * Display the block.
     *
     * @param array $blockinfo A blockinfo structure.
     * 
     * @return string The rendered block.
     */
    public function display($blockinfo)
    {
        // Check if the Profile module is available.
        if (!ModUtil::available('Profile')) {
            return false;
        }

        // Security check
        if (!SecurityUtil::checkPermission('Profile:MembersOnlineblock:', "$blockinfo[title]::", ACCESS_READ)) {
            return false;
        }

        // Get variables from content block
        $vars = BlockUtil::varsFromContent($blockinfo['content']);

        // Defaults
        if (empty($vars['lengthmax'])) {
            $vars['lengthmax'] = 30;
        }

        $uid         = (int)UserUtil::getVar('uid');
        $users       = ModUtil::apiFunc('Profile', 'memberslist', 'getallonline');
        $usersonline = array();

        if ($users) {
            foreach ($users['unames'] as $user) {
                $usersonline[] = $user;
            }
        }

        $this->view->setCaching(false)
                       ->setCacheId($uid);

        // check which messaging module is available and add the necessary info
        $msgmodule = ModUtil::apiFunc('Profile', 'memberslist', 'getmessagingmodule');
        if (!empty($msgmodule) && UserUtil::isLoggedIn()) {
            $this->view->assign('messages', ModUtil::apiFunc($msgmodule, 'user', 'getmessagecount'));
        }

        $this->view->assign('msgmodule',   $msgmodule);
        $this->view->assign('maxLength',   $vars['lengthmax']);
        $this->view->assign('usersonline', $usersonline);
        $this->view->assign('membonline',  $users['numusers']);
        $this->view->assign('anononline',  $users['numguests']);
        $this->view->assign('uid',         $uid);

        $blockinfo['content'] = $this->view->fetch('profile_block_membersonline.tpl');

        return BlockUtil::themeBlock($blockinfo);
    }

    /**
     * Modify block settings.
     *
     * @param array $blockinfo A blockinfo structure.
     * 
     * @return string The rendered block form.
     */
    public function modify($blockinfo)
    {
        // Get current content
        $vars = BlockUtil::varsFromContent($blockinfo['content']);

        // Defaults
        if (empty($vars['lengthmax'])) {
            $vars['lengthmax'] = 30;
        }

        // Create output object
        $this->view->setCaching(false);

        // assign the approriate values
        $this->view->assign('lengthmax', $vars['lengthmax']);

        // Return the output that has been generated by this function
        return $this->view->fetch('profile_block_membersonline_modify.tpl');
    }

    /**
     * Update block settings.
     *
     * @param array $blockinfo A blockinfo structure.
     * 
     * @return array The modified blockinfo structure.
     */
    public function update($blockinfo)
    {
        // Get current content
        $vars = BlockUtil::varsFromContent($blockinfo['content']);

        // alter the corresponding variable
        $vars['lengthmax'] = (int)$this->request->getPost()->get('lengthmax', null);

        // write back the new contents
        $blockinfo['content'] = BlockUtil::varsToContent($vars);

        // clear the block cache
        $this->view->clear_cache('profile_block_membersonline.tpl');

        return $blockinfo;
    }
}
