# Part of the A-A-P recipe executive: Testing of scopes

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os, stat, shutil, string

def runaap(args):
    res = os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))
    if res:
        print "Aap exited with error value %d" % res
    return res

os.chdir("rectest")

# Create a recipe to test whether the recipe scope is passed to build commands
# and reading a local variable before it is written results in a warning.

rec1 = "rectest1.aap"
rec2 = "rectest2.aap"
rec3 = "rectest3.aap"
rec4 = "rectest4.aap"
rec5 = "rectest5.aap"
rec6 = "rectest6.aap"
rec7 = "rectest7.aap"
aapout = "rectest.aap.out"

def cleanup():
    for n in [ rec1, rec2, rec3, rec4, rec5, rec6, rec7, aapout ]:
        try:
            os.remove(n)
        except:
            pass

cleanup()

f = open(rec1, "w")
f.write("""
var1 = toplevel
var2 = toplevel2
:include %s
:child %s
:print from grandchild: $var6
:child {nopass} %s
:print toplevel TOP: $TOP

CFLAGS = nonsense
:execute %s
:execute {pass} %s

all:
        var2 = all
        :print no scope: $var1 $var2 $var3 $var4 $var5
        :print _no scope: $_no.var1 $_no.var2
        :print _recipe scope: $_recipe.var1 $_recipe.var2
        :print _up scope: $_up.var1 $_up.var2
        var1 = get no error here
        var2 = nothing
        :print after the error: $var1 $var2
        TOP += all            # check appending
        :print TOP local: $TOP recipe: $_recipe.TOP
        TOP ?= nothing             # won't do anything
        BUILD ?= buildd            # set $BUILD
        _recipe.TOP += build
        :print build TOP local: $TOP recipe: $_recipe.TOP BUILD: `BUILD`
""" % (rec2, rec3, rec4, rec6, rec7))
f.close()

# Included recipe, will be at the toplevel.
f = open(rec2, "w")
f.write("""
var3 = toplevel3
var4 = toplevel4
TOP = toplevel
""")
f.close()

# Normal child recipe, will see the parent recipe variables.
f = open(rec3, "w")
f.write("""
var2 = child2
_top.var3 = child3  # set var3 in parent/toplevel recipe
:print child: $var1 $var2 $var3 $var4
_parent.var4 = child4
# Check default variable $OBJSUF
@if _no.OBJSUF == _parent.OBJSUF:
   :print OBJSUF OK
TOP += child     # append to local var
:print TOP child: $TOP _up: $_up.TOP
:child %s           # nested child
:print from grandchild: $var6
""" % rec5)
f.close()

# {nopass} child recipe, will not see the parent recipe variables.
f = open(rec4, "w")
f.write("""
var2 = child22
_top.var3 = child33   # Check toplevel is this recipe, _parent.var3 unchanged
@try:
   :print this should generate an error: $var1
@except:
   :print child: error generated correctly for var1
:print child: $var2 $var3 $_parent.var4
# Check we can set a variable in the parent recipe.
_parent.var5 = child5
# Check default variable $OBJSUF
@if _no.OBJSUF == _parent.OBJSUF:
   :print OBJSUF OK
# Check ":progsearch" with a scope name.
:progsearch _recipe.SHELL sh csh command cmd
@if not SHELL:
   :print Could not find a shell!?
""")
f.close()

# Nested child recipe.
f = open(rec5, "w")
f.write("""
var6 = grandchild-local
_parent.var6 = grandchild-parent
_top.var6 = grandchild-top
:print grandchild: $var1 $var2 $var4 $var6
""")
f.close()

# Executed recipe.  Will have a new toplevel.
f = open(rec6, "w")
f.write("""
var3 = executed
@if CFLAGS == "nonsense":
   :print CFLAGS wasn't set to default value!
all:
    var4 = all
    @try:
       :print this should generate an error: $var1
    @except:
       :print executed: error generated correctly for var1
    :print executed: $_parent.var2 $_recipe.var3 $var4
""")
f.close()

# Executed recipe with passed toplevel.
f = open(rec7, "w")
f.write("""
var3 = executed
@if _no.CFLAGS != "nonsense":
    :print CFLAGS was set to default value!
all:
    :print executed: $_parent.var2 $_recipe.var3 $var4
""")
f.close()

def check_contents(fname, expected):
    f = open(fname)
    actual = f.read()
    f.close()
    if actual != expected:
	print ('File contents wrong for "%s":\n%s\n--- instead of ---\n%s\n---'
						   % (fname, actual, expected))
        return 1
    return 0

# The first time running should result in two files being copied.
res = runaap("-f %s > %s" % (rec1, aapout))

failed = res + check_contents(aapout,
"""child: toplevel child2 child3 toplevel4
OBJSUF OK
TOP child: toplevel child _up: toplevel
grandchild: toplevel child2 child4 grandchild-local
from grandchild: grandchild-parent
from grandchild: grandchild-top
child: error generated correctly for var1
child: child22 child33 child4
OBJSUF OK
toplevel TOP: toplevel
executed: error generated correctly for var1
executed: toplevel2 executed all
executed: toplevel2 executed child4
no scope: toplevel all child3 child4 child5
_no scope: toplevel all
_recipe scope: toplevel toplevel2
_up scope: toplevel toplevel2
after the error: get no error here nothing
TOP local: toplevel all recipe: toplevel
build TOP local: toplevel all recipe: toplevel build BUILD: buildd
""")

cleanup()

sys.exit(failed)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
