# Part of the A-A-P recipe executive: Setup using ICC

# Copyright (c) 2002-2003 stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# This module sets up variables and actions for using the IBM C compiler tools.
#

from RecPython import *
import Global
from Action import action_add
from Dictlist import str2dictlist
from RecPos import RecPos


def exists():
    """
    Return TRUE when the ICC toolchain can be found.
    """
    return program_path("icc")


def define_actions():
    """
    Define the actions that ICC can accomplish.
    """
    # TODO: change $DEFINE and $INCLUDE to icc specific lists
    rd = Global.globals
    rpstack = [ RecPos("compile_icc action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "compile_icc object c"),
            ":sys $ICC $CPPFLAGS $?DEFINE $?INCLUDE `cflags_normal()` "
                "$CFLAGS /c $source /Fo$target")
    if not rd.get("ICC"):
        rd["ICC"] = "icc"


def use_actions(scope):
    """
    Setup variables so that the default actions use the ICC actions.
    """
    scope["C_COMPILE_ACTION"] = "compile_icc"
    scope["CXX_COMPILE_ACTION"] = "compile_icc"

    # Avoid using gcc for dependency checks.  It may exist but won't work with
    # the icc compiler flags.
    scope["HASGCC"] = "no"
    scope["HASGCCXX"] = "no"

# vim: set sw=4 et sts=4 tw=79 fo+=l:
