/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import antlr.Token;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.AnalysisTimeoutException;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NonLLStarDecisionException;
import org.antlr.analysis.PredicateLabel;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.misc.BitSet;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;
import org.antlr.tool.ErrorManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFAToDFAConverter {
    protected List work = new LinkedList();
    protected NFAContext[] contextTrees;
    protected DFA dfa;
    public static boolean debug = false;
    public static boolean SINGLE_THREADED_NFA_CONVERSION = true;
    protected boolean computingStartState = false;

    public NFAToDFAConverter(DFA dFA) {
        this.dfa = dFA;
        int n = dFA.getNumberOfAlts();
        this.initContextTrees(n);
    }

    public void convert() {
        this.dfa.conversionStartTime = System.currentTimeMillis();
        this.dfa.startState = this.computeStartState();
        while (this.work.size() > 0 && !this.dfa.nfa.grammar.NFAToDFAConversionExternallyAborted()) {
            int n;
            DFAState dFAState = (DFAState)this.work.get(0);
            if (this.dfa.nfa.grammar.composite.watchNFAConversion) {
                System.out.println(new StringBuffer().append("convert DFA state ").append(dFAState.stateNumber).append(" (").append(dFAState.nfaConfigurations.size()).append(" nfa states)").toString());
            }
            if ((n = this.dfa.getUserMaxLookahead()) > 0 && n == dFAState.getLookaheadDepth()) {
                this.resolveNonDeterminisms(dFAState);
                if (dFAState.isResolvedWithPredicates()) {
                    this.addPredicateTransitions(dFAState);
                } else {
                    dFAState.setAcceptState(true);
                }
            } else {
                this.findNewDFAStatesAndAddDFATransitions(dFAState);
            }
            this.work.remove(0);
        }
        this.dfa.findAllGatedSynPredsUsedInDFAAcceptStates();
    }

    protected DFAState computeStartState() {
        NFAState nFAState = this.dfa.decisionNFAStartState;
        DFAState dFAState = this.dfa.newState();
        this.computingStartState = true;
        int n = 0;
        int n2 = 1;
        while (nFAState != null) {
            NFAContext nFAContext = this.contextTrees[n];
            if (n == 0 && this.dfa.getNFADecisionStartState().decisionStateType == 1) {
                int n3;
                n2 = n3 = this.dfa.nfa.grammar.getNumberOfAltsForDecisionNFA(this.dfa.decisionNFAStartState);
                this.closure((NFAState)nFAState.transition[0].target, n2, nFAContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, dFAState, true);
                n2 = 1;
            } else {
                this.closure((NFAState)nFAState.transition[0].target, n2, nFAContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, dFAState, true);
                ++n2;
            }
            ++n;
            if (nFAState.transition[1] == null) break;
            nFAState = (NFAState)nFAState.transition[1].target;
        }
        this.dfa.addState(dFAState);
        this.work.add(dFAState);
        this.computingStartState = false;
        return dFAState;
    }

    protected void findNewDFAStatesAndAddDFATransitions(DFAState dFAState) {
        int n;
        boolean bl;
        OrderedHashSet orderedHashSet = dFAState.getReachableLabels();
        Label label = new Label(-2);
        boolean bl2 = bl = orderedHashSet != null && orderedHashSet.contains(label);
        if (!this.dfa.isGreedy() && bl) {
            this.convertToEOTAcceptState(dFAState);
            return;
        }
        int n2 = 0;
        HashMap hashMap = new HashMap();
        int n3 = 0;
        if (orderedHashSet != null) {
            n3 = orderedHashSet.size();
        }
        for (n = 0; n < n3; ++n) {
            Label label2 = (Label)orderedHashSet.get(n);
            DFAState dFAState2 = this.reach(dFAState, label2);
            if (debug) {
                System.out.println(new StringBuffer().append("DFA state after reach ").append(label2).append(" ").append(dFAState).append("-").append(label2.toString(this.dfa.nfa.grammar)).append("->").append(dFAState2).toString());
            }
            if (dFAState2 == null) continue;
            if (dFAState2.getUniqueAlt() == -1) {
                this.closure(dFAState2);
            }
            DFAState dFAState3 = this.addDFAStateToWorkList(dFAState2);
            n2 += NFAToDFAConverter.addTransition(dFAState, label2, dFAState3, hashMap);
            dFAState3.setLookaheadDepth(dFAState.getLookaheadDepth() + 1);
        }
        if (!dFAState.isResolvedWithPredicates() && n2 == 0) {
            this.dfa.probe.reportDanglingState(dFAState);
            n = this.resolveByPickingMinAlt(dFAState, null);
            dFAState.setAcceptState(true);
            this.dfa.setAcceptState(n, dFAState);
        }
        if (dFAState.isResolvedWithPredicates()) {
            this.addPredicateTransitions(dFAState);
        }
    }

    protected static int addTransition(DFAState dFAState, Label label, DFAState dFAState2, Map map) {
        int n = 0;
        if (DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES) {
            Integer n2 = Utils.integer(dFAState2.stateNumber);
            Transition transition = (Transition)map.get(n2);
            if (transition != null) {
                if (label.getAtom() == -2) {
                    transition.label = new Label(-2);
                } else if (transition.label.getAtom() != -2) {
                    transition.label.add(label);
                }
            } else {
                n = 1;
                label = (Label)label.clone();
                int n3 = dFAState.addTransition(dFAState2, label);
                Transition transition2 = dFAState.getTransition(n3);
                map.put(n2, transition2);
            }
        } else {
            n = 1;
            dFAState.addTransition(dFAState2, label);
        }
        return n;
    }

    public void closure(DFAState dFAState) {
        if (debug) {
            System.out.println(new StringBuffer().append("closure(").append(dFAState).append(")").toString());
        }
        ArrayList<NFAConfiguration> arrayList = new ArrayList<NFAConfiguration>();
        arrayList.addAll(dFAState.nfaConfigurations);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)arrayList.get(i);
            if (nFAConfiguration.singleAtomTransitionEmanating) continue;
            this.closure(this.dfa.nfa.getState(nFAConfiguration.state), nFAConfiguration.alt, nFAConfiguration.context, nFAConfiguration.semanticContext, dFAState, false);
        }
        dFAState.closureBusy = null;
    }

    public void closure(NFAState nFAState, int n, NFAContext nFAContext, SemanticContext semanticContext, DFAState dFAState, boolean bl) {
        if (debug) {
            System.out.println(new StringBuffer().append("closure at ").append(nFAState.enclosingRule.name).append(" state ").append(nFAState.stateNumber).append("|").append(n).append(" filling DFA state ").append(dFAState.stateNumber).append(" with context ").append(nFAContext).toString());
        }
        if (DFA.MAX_TIME_PER_DFA_CREATION > 0 && System.currentTimeMillis() - dFAState.dfa.conversionStartTime >= (long)DFA.MAX_TIME_PER_DFA_CREATION) {
            throw new AnalysisTimeoutException(dFAState.dfa);
        }
        NFAConfiguration nFAConfiguration = new NFAConfiguration(nFAState.stateNumber, n, nFAContext, semanticContext);
        if (NFAToDFAConverter.closureIsBusy(dFAState, nFAConfiguration)) {
            if (debug) {
                System.out.println(new StringBuffer().append("avoid visiting exact closure computation NFA config: ").append(nFAConfiguration).append(" in ").append(nFAState.enclosingRule.name).toString());
                System.out.println(new StringBuffer().append("state is ").append(dFAState.dfa.decisionNumber).append(".").append(dFAState.stateNumber).toString());
            }
            return;
        }
        dFAState.closureBusy.add(nFAConfiguration);
        dFAState.addNFAConfiguration(nFAState, nFAConfiguration);
        Transition transition = nFAState.transition[0];
        if (transition instanceof RuleClosureTransition) {
            int n2 = nFAContext.recursionDepthEmanatingFromState(nFAState.stateNumber);
            if (n2 == 1 && dFAState.dfa.getUserMaxLookahead() == 0) {
                dFAState.dfa.recursiveAltSet.add(n);
                if (dFAState.dfa.recursiveAltSet.size() > 1) {
                    dFAState.abortedDueToMultipleRecursiveAlts = true;
                    throw new NonLLStarDecisionException(dFAState.dfa);
                }
            }
            if (n2 >= NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK) {
                dFAState.abortedDueToRecursionOverflow = true;
                dFAState.dfa.probe.reportRecursionOverflow(dFAState, nFAConfiguration);
                if (debug) {
                    System.out.println(new StringBuffer().append("analysis overflow in closure(").append(dFAState.stateNumber).append(")").toString());
                }
                return;
            }
            RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)transition;
            NFAContext nFAContext2 = new NFAContext(nFAContext, nFAState);
            NFAState nFAState2 = (NFAState)ruleClosureTransition.target;
            this.closure(nFAState2, n, nFAContext2, semanticContext, dFAState, bl);
        } else if (nFAState.isAcceptState() && nFAContext.parent != null) {
            NFAState nFAState3 = nFAContext.invokingState;
            RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)nFAState3.transition[0];
            NFAState nFAState4 = ruleClosureTransition.followState;
            NFAContext nFAContext3 = nFAContext.parent;
            this.closure(nFAState4, n, nFAContext3, semanticContext, dFAState, bl);
        } else {
            if (transition != null && transition.isEpsilon()) {
                boolean bl2 = bl;
                if (transition.isAction() && bl) {
                    bl2 = false;
                }
                this.closure((NFAState)transition.target, n, nFAContext, semanticContext, dFAState, bl2);
            } else if (transition != null && transition.isSemanticPredicate()) {
                if (this.computingStartState) {
                    if (bl) {
                        this.dfa.predicateVisible = true;
                    } else {
                        this.dfa.hasPredicateBlockedByAction = true;
                    }
                }
                SemanticContext semanticContext2 = semanticContext;
                if (bl) {
                    SemanticContext semanticContext3 = transition.label.getSemanticContext();
                    int n3 = this.dfa.decisionNFAStartState.translateDisplayAltToWalkAlt(n);
                    NFAState nFAState5 = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(this.dfa.decisionNFAStartState, n3);
                    if (!semanticContext3.isSyntacticPredicate() || nFAState == nFAState5.transition[0].target) {
                        semanticContext2 = SemanticContext.and(semanticContext, semanticContext3);
                    }
                }
                this.closure((NFAState)transition.target, n, nFAContext, semanticContext2, dFAState, bl);
            }
            Transition transition2 = nFAState.transition[1];
            if (transition2 != null && transition2.isEpsilon()) {
                this.closure((NFAState)transition2.target, n, nFAContext, semanticContext, dFAState, bl);
            }
        }
    }

    public static boolean closureIsBusy(DFAState dFAState, NFAConfiguration nFAConfiguration) {
        return dFAState.closureBusy.contains(nFAConfiguration);
    }

    public DFAState reach(DFAState dFAState, Label label) {
        DFAState dFAState2 = this.dfa.newState();
        List<NFAConfiguration> list = dFAState.configurationsWithLabeledEdges;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            NFAConfiguration nFAConfiguration = list.get(i);
            if (nFAConfiguration.resolved || nFAConfiguration.resolveWithPredicate) continue;
            NFAState nFAState = this.dfa.nfa.getState(nFAConfiguration.state);
            Transition transition = nFAState.transition[0];
            if (transition == null || !nFAConfiguration.singleAtomTransitionEmanating) continue;
            Label label2 = transition.label;
            if (nFAConfiguration.context.parent != null && label2.label == -2 || !Label.intersect(label, label2)) continue;
            NFAConfiguration nFAConfiguration2 = dFAState2.addNFAConfiguration((NFAState)transition.target, nFAConfiguration.alt, nFAConfiguration.context, nFAConfiguration.semanticContext);
        }
        if (dFAState2.nfaConfigurations.size() == 0) {
            this.dfa.setState(dFAState2.stateNumber, null);
            dFAState2 = null;
        }
        return dFAState2;
    }

    protected void convertToEOTAcceptState(DFAState dFAState) {
        Label label = new Label(-2);
        int n = dFAState.nfaConfigurations.size();
        for (int i = 0; i < n; ++i) {
            NFAConfiguration nFAConfiguration = dFAState.nfaConfigurations.get(i);
            if (nFAConfiguration.resolved || nFAConfiguration.resolveWithPredicate) continue;
            NFAState nFAState = this.dfa.nfa.getState(nFAConfiguration.state);
            Transition transition = nFAState.transition[0];
            Label label2 = transition.label;
            if (!label2.equals(label)) continue;
            dFAState.setAcceptState(true);
            dFAState.nfaConfigurations.clear();
            dFAState.addNFAConfiguration(nFAState, nFAConfiguration.alt, nFAConfiguration.context, nFAConfiguration.semanticContext);
            return;
        }
    }

    protected DFAState addDFAStateToWorkList(DFAState dFAState) {
        DFAState dFAState2 = this.dfa.addState(dFAState);
        if (dFAState != dFAState2) {
            this.dfa.setState(dFAState.stateNumber, dFAState2);
            return dFAState2;
        }
        this.resolveNonDeterminisms(dFAState);
        int n = dFAState.getUniquelyPredictedAlt();
        if (n != -1) {
            dFAState = this.convertToAcceptState(dFAState, n);
        } else {
            this.work.add(dFAState);
        }
        return dFAState;
    }

    protected DFAState convertToAcceptState(DFAState dFAState, int n) {
        DFAState dFAState2;
        if (DFAOptimizer.MERGE_STOP_STATES && dFAState.getNonDeterministicAlts() == null && !dFAState.abortedDueToRecursionOverflow && !dFAState.abortedDueToMultipleRecursiveAlts && (dFAState2 = this.dfa.getAcceptState(n)) != null) {
            SemanticContext semanticContext = dFAState.getGatedPredicatesInNFAConfigurations();
            SemanticContext semanticContext2 = dFAState2.getGatedPredicatesInNFAConfigurations();
            if (semanticContext == null && semanticContext2 == null || semanticContext != null && semanticContext2 != null && semanticContext.equals(semanticContext2)) {
                this.dfa.setState(dFAState.stateNumber, dFAState2);
                this.dfa.removeState(dFAState);
                dFAState = dFAState2;
                return dFAState;
            }
        }
        dFAState.setAcceptState(true);
        this.dfa.setAcceptState(n, dFAState);
        return dFAState;
    }

    public void resolveNonDeterminisms(DFAState dFAState) {
        boolean bl;
        Set set;
        if (debug) {
            System.out.println(new StringBuffer().append("resolveNonDeterminisms ").append(dFAState.toString()).toString());
        }
        boolean bl2 = false;
        Set set2 = dFAState.getNonDeterministicAlts();
        if (debug && set2 != null) {
            System.out.println(new StringBuffer().append("nondet alts=").append(set2).toString());
        }
        NFAConfiguration nFAConfiguration = dFAState.nfaConfigurations.get(0);
        NFAState nFAState = this.dfa.nfa.getState(nFAConfiguration.state);
        if (nFAState.isEOTTargetState() && (set = dFAState.getAltSet()) != null && set.size() > 1) {
            set2 = set;
            if (dFAState.dfa.isTokensRuleDecision()) {
                this.dfa.probe.reportLexerRuleNondeterminism(dFAState, set);
                bl2 = true;
            }
        }
        if (!dFAState.abortedDueToRecursionOverflow && set2 == null) {
            return;
        }
        if (!dFAState.abortedDueToRecursionOverflow && !bl2) {
            this.dfa.probe.reportNondeterminism(dFAState, set2);
        }
        if (bl = this.tryToResolveWithSemanticPredicates(dFAState, set2)) {
            if (debug) {
                System.out.println(new StringBuffer().append("resolved DFA state ").append(dFAState.stateNumber).append(" with pred").toString());
            }
            dFAState.resolvedWithPredicates = true;
            this.dfa.probe.reportNondeterminismResolvedWithSemanticPredicate(dFAState);
            return;
        }
        this.resolveByChoosingFirstAlt(dFAState, set2);
    }

    protected int resolveByChoosingFirstAlt(DFAState dFAState, Set set) {
        int n;
        int n2 = 0;
        n2 = this.dfa.isGreedy() ? this.resolveByPickingMinAlt(dFAState, set) : (set.contains(Utils.integer(n = this.dfa.getNumberOfAlts())) ? this.resolveByPickingExitAlt(dFAState, set) : this.resolveByPickingMinAlt(dFAState, set));
        return n2;
    }

    protected int resolveByPickingMinAlt(DFAState dFAState, Set set) {
        int n = Integer.MAX_VALUE;
        n = set != null ? NFAToDFAConverter.getMinAlt(set) : dFAState.minAltInConfigurations;
        NFAToDFAConverter.turnOffOtherAlts(dFAState, n, set);
        return n;
    }

    protected int resolveByPickingExitAlt(DFAState dFAState, Set set) {
        int n = this.dfa.getNumberOfAlts();
        NFAToDFAConverter.turnOffOtherAlts(dFAState, n, set);
        return n;
    }

    protected static void turnOffOtherAlts(DFAState dFAState, int n, Set<Integer> set) {
        int n2 = dFAState.nfaConfigurations.size();
        for (int i = 0; i < n2; ++i) {
            NFAConfiguration nFAConfiguration = dFAState.nfaConfigurations.get(i);
            if (nFAConfiguration.alt == n || set != null && !set.contains(Utils.integer(nFAConfiguration.alt))) continue;
            nFAConfiguration.resolved = true;
        }
    }

    protected static int getMinAlt(Set<Integer> set) {
        int n = Integer.MAX_VALUE;
        for (Integer n2 : set) {
            int n3 = n2;
            if (n3 >= n) continue;
            n = n3;
        }
        return n;
    }

    protected boolean tryToResolveWithSemanticPredicates(DFAState dFAState, Set set) {
        SemanticContext semanticContext;
        Map<Integer, SemanticContext> map = this.getPredicatesPerNonDeterministicAlt(dFAState, set);
        if (map.size() == 0) {
            return false;
        }
        this.dfa.probe.reportAltPredicateContext(dFAState, map);
        if (set.size() - map.size() > 1) {
            return false;
        }
        if (map.size() == set.size() - 1) {
            SemanticContext semanticContext2;
            BitSet bitSet = BitSet.of(set);
            BitSet bitSet2 = BitSet.of(map);
            int n = bitSet.subtract(bitSet2).getSingleElement();
            semanticContext = null;
            semanticContext = n == NFAToDFAConverter.max(set) ? new SemanticContext.TruePredicate() : ((semanticContext2 = NFAToDFAConverter.getUnionOfPredicates(map)).isSyntacticPredicate() ? new SemanticContext.TruePredicate() : SemanticContext.not(semanticContext2));
            map.put(Utils.integer(n), semanticContext);
            int n2 = dFAState.nfaConfigurations.size();
            for (int i = 0; i < n2; ++i) {
                NFAConfiguration nFAConfiguration = dFAState.nfaConfigurations.get(i);
                if (nFAConfiguration.alt != n) continue;
                nFAConfiguration.semanticContext = semanticContext;
            }
        }
        if (map.size() == set.size()) {
            if (dFAState.abortedDueToRecursionOverflow) {
                dFAState.dfa.probe.removeRecursiveOverflowState(dFAState);
            }
            int n = dFAState.nfaConfigurations.size();
            for (int i = 0; i < n; ++i) {
                NFAConfiguration nFAConfiguration = dFAState.nfaConfigurations.get(i);
                semanticContext = map.get(Utils.integer(nFAConfiguration.alt));
                if (semanticContext != null) {
                    nFAConfiguration.resolveWithPredicate = true;
                    nFAConfiguration.semanticContext = semanticContext;
                    map.remove(Utils.integer(nFAConfiguration.alt));
                    if (!semanticContext.isSyntacticPredicate()) continue;
                    this.dfa.nfa.grammar.synPredUsedInDFA(this.dfa, semanticContext);
                    continue;
                }
                if (!set.contains(Utils.integer(nFAConfiguration.alt))) continue;
                nFAConfiguration.resolved = true;
            }
            return true;
        }
        return false;
    }

    protected Map<Integer, SemanticContext> getPredicatesPerNonDeterministicAlt(DFAState dFAState, Set set) {
        Set<Object> set2;
        Object object;
        Object object2;
        Object object32;
        Serializable serializable2;
        HashMap<Integer, SemanticContext> hashMap = new HashMap<Integer, SemanticContext>();
        HashMap hashMap2 = new HashMap();
        for (Serializable serializable2 : set) {
            hashMap2.put((Integer)serializable2, new HashSet());
        }
        HashMap hashMap3 = new HashMap();
        serializable2 = new HashSet();
        int n = dFAState.nfaConfigurations.size();
        for (int i = 0; i < n; ++i) {
            NFAConfiguration nFAConfiguration = dFAState.nfaConfigurations.get(i);
            object32 = Utils.integer(nFAConfiguration.alt);
            if (!set.contains(object32)) continue;
            if (nFAConfiguration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
                object2 = (Set)hashMap2.get(object32);
                object2.add(nFAConfiguration.semanticContext);
                continue;
            }
            serializable2.add(object32);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object32 : set) {
            object2 = (Set)hashMap2.get(object32);
            if (serializable2.contains(object32)) {
                if (object2.size() <= 0) continue;
                arrayList.add(object32);
                continue;
            }
            object = null;
            set2 = object2.iterator();
            while (set2.hasNext()) {
                SemanticContext semanticContext = (SemanticContext)set2.next();
                object = SemanticContext.or(object, semanticContext);
            }
            hashMap.put((Integer)object32, (SemanticContext)object);
        }
        if (arrayList.size() > 0) {
            for (int i = 0; i < n; ++i) {
                object32 = dFAState.nfaConfigurations.get(i);
                object2 = Utils.integer(((NFAConfiguration)object32).alt);
                if (!arrayList.contains(object2) || ((NFAConfiguration)object32).semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) continue;
                object = this.dfa.nfa.getState(((NFAConfiguration)object32).state);
                if (((NFAState)object).incidentEdgeLabel == null || ((NFAState)object).incidentEdgeLabel.label == -1) continue;
                if (((NFAState)object).associatedASTNode == null || ((NFAState)object).associatedASTNode.token == null) {
                    ErrorManager.internalError("no AST/token for nonepsilon target w/o predicate");
                    continue;
                }
                set2 = (Set)hashMap3.get(object2);
                if (set2 == null) {
                    set2 = new HashSet<Token>();
                    hashMap3.put(object2, set2);
                }
                set2.add(((NFAState)object).associatedASTNode.token);
            }
            this.dfa.probe.reportIncompletelyCoveredAlts(dFAState, hashMap3);
        }
        return hashMap;
    }

    protected static SemanticContext getUnionOfPredicates(Map map) {
        SemanticContext semanticContext = null;
        for (SemanticContext semanticContext2 : map.values()) {
            if (semanticContext == null) {
                semanticContext = semanticContext2;
                continue;
            }
            semanticContext = SemanticContext.or(semanticContext, semanticContext2);
        }
        return semanticContext;
    }

    protected void addPredicateTransitions(DFAState dFAState) {
        ArrayList<NFAConfiguration> arrayList = new ArrayList<NFAConfiguration>();
        int n = dFAState.nfaConfigurations.size();
        for (int i = 0; i < n; ++i) {
            NFAConfiguration nFAConfiguration = dFAState.nfaConfigurations.get(i);
            if (!nFAConfiguration.resolveWithPredicate) continue;
            arrayList.add(nFAConfiguration);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                NFAConfiguration nFAConfiguration = (NFAConfiguration)object;
                NFAConfiguration nFAConfiguration2 = (NFAConfiguration)object2;
                if (nFAConfiguration.alt < nFAConfiguration2.alt) {
                    return -1;
                }
                if (nFAConfiguration.alt > nFAConfiguration2.alt) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<NFAConfiguration> arrayList2 = arrayList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)arrayList2.get(i);
            DFAState dFAState2 = dFAState.dfa.getAcceptState(nFAConfiguration.alt);
            if (dFAState2 == null) {
                dFAState2 = this.dfa.newState();
                dFAState2.addNFAConfiguration(this.dfa.nfa.getState(nFAConfiguration.state), nFAConfiguration.alt, nFAConfiguration.context, nFAConfiguration.semanticContext);
                dFAState2.setAcceptState(true);
                this.dfa.setAcceptState(nFAConfiguration.alt, dFAState2);
                DFAState dFAState3 = this.dfa.addState(dFAState2);
                if (dFAState2 != dFAState3) {
                    this.dfa.setState(dFAState2.stateNumber, dFAState3);
                    dFAState2 = dFAState3;
                }
            }
            dFAState.addTransition(dFAState2, new PredicateLabel(nFAConfiguration.semanticContext));
        }
    }

    protected void initContextTrees(int n) {
        this.contextTrees = new NFAContext[n];
        for (int i = 0; i < this.contextTrees.length; ++i) {
            int n2 = i + 1;
            this.contextTrees[i] = new NFAContext(null, null);
        }
    }

    public static int max(Set set) {
        if (set == null) {
            return Integer.MIN_VALUE;
        }
        int n = 0;
        int n2 = 0;
        for (Integer n3 : set) {
            if (++n == 1) {
                n2 = n3;
                continue;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }
}

