/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.antlr.xjlib.appkit.swing.XJRollOverButton;

public class ComponentMemoryStatus
extends JPanel {
    private final JButton gcButton = XJRollOverButton.createTextButton("");
    private Timer timer;

    public ComponentMemoryStatus() {
        super(new BorderLayout());
        this.setOpaque(false);
        Box b = Box.createHorizontalBox();
        b.setBorder(BorderFactory.createEmptyBorder(2, 0, 1, 0));
        b.add(Box.createHorizontalGlue());
        b.add(this.gcButton);
        this.add((Component)b, "Center");
        this.gcButton.setFocusable(false);
        this.gcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Runtime.getRuntime().gc();
            }
        });
        this.timer = new Timer(4000, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ComponentMemoryStatus.this.refresh();
            }
        });
        this.timer.start();
        this.refresh();
    }

    public void close() {
        this.timer.stop();
        this.timer = null;
    }

    public void refresh() {
        String usedMemory = this.displayableMemory(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        String maxMemory = this.displayableMemory(Runtime.getRuntime().maxMemory());
        this.gcButton.setText(String.format("%s of %s", usedMemory, maxMemory));
    }

    private String displayableMemory(long bytes) {
        if ((double)bytes > 1000000.0) {
            return String.format("%dM", (int)((double)bytes / 1000000.0));
        }
        if ((double)bytes > 1000.0) {
            return String.format("%dKB", (int)((double)bytes / 1000.0));
        }
        return String.format("%db", bytes);
    }
}

