/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.Toolbar;
import org.antlr.xjlib.appkit.swing.XJRollOverButton;
import org.antlr.xjlib.appkit.swing.XJRollOverButtonToggle;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class ComponentToolbar
implements XJNotificationObserver {
    public Toolbar toolbar;
    public JButton debug;
    public JButton debugAgain;
    public JButton backward;
    public JButton forward;
    public JToggleButton sort;
    public JToggleButton sd;
    public JToggleButton coloring;
    public JToggleButton ideas;
    public JButton find;
    public ComponentContainer container;

    public ComponentToolbar(ComponentContainer container) {
        this.container = container;
        this.createInterface();
        this.addActions();
        this.debugAgain.setEnabled(false);
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STARTED");
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STOPPED");
    }

    public void close() {
        this.container = null;
        AWPrefs.getPreferences().unbindFromPreferences(this.sort, "PREF_TOOLBAR_SORT");
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public JComponent getToolbar() {
        return this.toolbar;
    }

    public void notificationFire(Object source, String name) {
        if (name.equals("NOTIF_DEBUG_STARTED")) {
            this.find.setEnabled(false);
            this.debug.setEnabled(false);
            this.debugAgain.setEnabled(false);
        } else if (name.equals("NOTIF_DEBUG_STOPPED")) {
            this.find.setEnabled(true);
            this.debug.setEnabled(true);
            this.debugAgain.setEnabled(this.container.getDebugger().canDebugAgain());
        }
    }

    public void createInterface() {
        this.toolbar = Toolbar.createHorizontalToolbar();
        this.sd = this.createToggleButton(IconManager.shared().getIconSyntaxDiagram(), "Toggle Syntax diagram");
        this.toolbar.addElement(this.sd);
        this.coloring = this.createToggleButton(IconManager.shared().getIconColoring(), "Toggle Syntax coloring");
        this.toolbar.addElement(this.coloring);
        this.ideas = this.createToggleButton(IconManager.shared().getIconIdea(), "Toggle Syntax ideas");
        this.toolbar.addElement(this.ideas);
        this.toolbar.addGroupSeparator();
        this.sort = this.createToggleButton(IconManager.shared().getIconSort(), "Toggle Sort rules");
        this.toolbar.addElement(this.sort);
        this.find = this.createButton(IconManager.shared().getIconFind(), "Find text");
        this.toolbar.addElement(this.find);
        this.toolbar.addGroupSeparator();
        this.backward = this.createButton(IconManager.shared().getIconBackward(), "Back");
        this.toolbar.addElement(this.backward);
        this.forward = this.createButton(IconManager.shared().getIconForward(), "Forward");
        this.toolbar.addElement(this.forward);
        this.toolbar.addGroupSeparator();
        this.debug = this.createButton(IconManager.shared().getIconDebug(), "Debug");
        this.toolbar.addElement(this.debug);
        this.debugAgain = this.createButton(IconManager.shared().getIconDebugAgain(), "Debug Again");
        this.toolbar.addElement(this.debugAgain);
        AWPrefs.getPreferences().bindToPreferences(this.sort, "PREF_TOOLBAR_SORT", false);
    }

    public void updateStates() {
        this.sort.setSelected(this.getSelectedEditor().isRulesSorted());
        this.sd.setSelected(this.getSelectedEditor().isSyntaxDiagramDisplayed());
        this.coloring.setSelected(this.getSelectedEditor().isSyntaxColored());
        this.ideas.setSelected(this.getSelectedEditor().isIdeasEnabled());
    }

    public void awake() {
        this.sd.setSelected(true);
        this.coloring.setSelected(true);
        this.ideas.setSelected(true);
    }

    public ComponentEditorGrammar getSelectedEditor() {
        return (ComponentEditorGrammar)this.container.getSelectedEditor();
    }

    public void addActions() {
        this.backward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentToolbar.this.getSelectedEditor().goToBackward();
            }
        });
        this.forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentToolbar.this.getSelectedEditor().goToForward();
            }
        });
        this.sort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentToolbar.this.getSelectedEditor().toggleRulesSorting();
            }
        });
        this.sd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentToolbar.this.getSelectedEditor().toggleSyntaxDiagram();
            }
        });
        this.coloring.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentToolbar.this.getSelectedEditor().toggleSyntaxColoring();
            }
        });
        this.ideas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentToolbar.this.getSelectedEditor().toggleIdeas();
            }
        });
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentToolbar.this.getSelectedEditor().find();
            }
        });
        this.debug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentToolbar.this.container.getActionDebugger().debug();
            }
        });
        this.debugAgain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentToolbar.this.container.getActionDebugger().debugAgain();
            }
        });
    }

    public JButton createButton(ImageIcon icon, String tooltip) {
        XJRollOverButton b = XJRollOverButton.createMediumButton(icon);
        b.setToolTipText(tooltip);
        return b;
    }

    public JToggleButton createToggleButton(ImageIcon icon, String tooltip) {
        XJRollOverButtonToggle b = XJRollOverButtonToggle.createMediumButton(icon);
        b.setToolTipText(tooltip);
        return b;
    }
}

