/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JPanel;
import org.antlr.works.components.ComponentWindow;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.container.ComponentContainerGrammar;
import org.antlr.works.components.container.ComponentContainerInternal;
import org.antlr.works.components.document.ComponentDocumentGrammar;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;

public class ComponentWindowImpl
extends XJWindow
implements ComponentWindow {
    private final ComponentContainer componentContainer = new ComponentContainerGrammar(this);

    public void awake() {
        super.awake();
        this.componentContainer.awake();
        this.componentContainer.assemble(false);
    }

    public ComponentContainer getComponentContainer() {
        return this.componentContainer;
    }

    public void setContentPanel(JPanel panel) {
        this.getContentPane().add(panel);
        this.pack();
    }

    public String autosaveName() {
        if (AWPrefs.getRestoreWindows()) {
            return this.getDocument().getDocumentName();
        }
        return null;
    }

    public void setDefaultSize() {
        if (XJApplication.shared().useDesktopMode()) {
            super.setDefaultSize();
            return;
        }
        Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        r.width = (int)((double)r.width * 0.8);
        r.height = (int)((double)r.height * 0.8);
        this.setPreferredSize(r.getSize());
    }

    public void dirtyChanged() {
        this.componentContainer.dirtyChanged();
    }

    public void windowActivated() {
        this.componentContainer.windowActivated();
        super.windowActivated();
    }

    public void windowDocumentPathDidChange(XJDocument doc) {
        ComponentDocumentGrammar g = (ComponentDocumentGrammar)doc;
        g.getEditor().componentDocumentContentChanged();
    }

    public void selectDocument(XJDocument doc) {
        ComponentDocumentGrammar g = (ComponentDocumentGrammar)doc;
        ComponentContainer container = g.getContainer();
        if (container instanceof ComponentContainerInternal) {
            ComponentContainerInternal cci = (ComponentContainerInternal)container;
            ComponentContainerGrammar ccg = (ComponentContainerGrammar)cci.getMainContainer();
            ccg.selectGrammar(doc);
        }
    }

    public void becomingVisibleForTheFirstTime() {
        this.componentContainer.becomingVisibleForTheFirstTime();
    }

    public void customizeFileMenu(XJMenu menu) {
        this.componentContainer.customizeFileMenu(menu);
    }

    public void customizeMenuBar(XJMainMenuBar menubar) {
        this.componentContainer.customizeMenuBar(menubar);
    }

    public void menuItemState(XJMenuItem item) {
        this.componentContainer.menuItemState(item);
    }

    public void handleMenuSelected(XJMenu menu) {
        this.componentContainer.handleMenuSelected(menu);
    }

    public boolean close(boolean force) {
        return super.close(force) && this.componentContainer.close();
    }
}

