/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components.container;

import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.antlr.works.IDE;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.menu.ActionDebugger;
import org.antlr.works.menu.ActionDebuggerImpl;
import org.antlr.works.menu.ActionExport;
import org.antlr.works.menu.ActionFind;
import org.antlr.works.menu.ActionGenerate;
import org.antlr.works.menu.ActionGoTo;
import org.antlr.works.menu.ActionGrammar;
import org.antlr.works.menu.ActionRefactor;
import org.antlr.works.menu.ActionRefactorImpl;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;

public class ComponentContainerGrammarMenu
implements XJMenuItemDelegate {
    public static final int MI_PRINT = 5;
    public static final int MI_TOGGLE_SYNTAX_COLORING = 6;
    public static final int MI_TOGGLE_SYNTAX_DIAGRAM = 7;
    public static final int MI_TOGGLE_NFA_OPTIMIZATION = 9;
    public static final int MI_TOGGLE_AUTOINDENT = 10;
    public static final int MI_EXPAND_COLLAPSE_RULE = 20;
    public static final int MI_EXPAND_COLLAPSE_ACTION = 21;
    public static final int MI_FIND = 30;
    public static final int MI_FIND_NEXT = 31;
    public static final int MI_FIND_PREV = 32;
    public static final int MI_FIND_TOKEN = 33;
    public static final int MI_FIND_USAGE = 34;
    public static final int MI_GOTO_RULE = 40;
    public static final int MI_GOTO_DECLARATION = 41;
    public static final int MI_GOTO_LINE = 42;
    public static final int MI_GOTO_CHARACTER = 43;
    public static final int MI_GOTO_BACK = 44;
    public static final int MI_GOTO_FORWARD = 45;
    public static final int MI_PREV_BREAKPOINT = 46;
    public static final int MI_NEXT_BREAKPOINT = 47;
    public static final int MI_HIGHLIGHT_DECISION_DFA = 50;
    public static final int MI_SHOW_DECISION_DFA = 51;
    public static final int MI_SHOW_DEPENDENCY = 52;
    public static final int MI_SHOW_TOKENS_SD = 53;
    public static final int MI_SHOW_TOKENS_DFA = 54;
    public static final int MI_GROUP_RULE = 56;
    public static final int MI_UNGROUP_RULE = 57;
    public static final int MI_IGNORE_RULE = 58;
    public static final int MI_CHECK_GRAMMAR = 59;
    public static final int MI_RENAME = 61;
    public static final int MI_REPLACE_LITERAL_WITH_TOKEN_LABEL = 62;
    public static final int MI_LITERAL_TO_SINGLEQUOTE = 63;
    public static final int MI_LITERAL_TO_DOUBLEQUOTE = 64;
    public static final int MI_LITERAL_TO_CSTYLEQUOTE = 65;
    public static final int MI_REMOVE_LEFT_RECURSION = 66;
    public static final int MI_REMOVE_ALL_LEFT_RECURSION = 67;
    public static final int MI_EXTRACT_RULE = 68;
    public static final int MI_INLINE_RULE = 69;
    public static final int MI_GENERATE_CODE = 70;
    public static final int MI_SHOW_GENERATED_PARSER_CODE = 71;
    public static final int MI_SHOW_GENERATED_LEXER_CODE = 72;
    public static final int MI_SHOW_RULE_GENCODE = 73;
    public static final int MI_RUN_INTERPRETER = 80;
    public static final int MI_RUN = 81;
    public static final int MI_DEBUG = 82;
    public static final int MI_DEBUG_AGAIN = 83;
    public static final int MI_DEBUG_REMOTE = 84;
    public static final int MI_DEBUG_SHOW_INPUT_TOKENS = 86;
    public static final int MI_EDIT_TEST_RIG = 87;
    public static final int MI_SUBMIT_STATS = 100;
    public static final int MI_SEND_FEEDBACK = 101;
    public static final int MI_CHECK_UPDATES = 102;
    public static final int MI_EXPORT_AS_IMAGE = 110;
    public static final int MI_EXPORT_AS_EPS = 111;
    public static final int MI_EXPORT_ALL_AS_IMAGE = 112;
    public static final int MI_EXPORT_ALL_AS_EPS = 113;
    public static final int MI_EXPORT_AS_DOT = 114;
    public static final int MI_EXPORT_EVENT = 115;
    public static final int MI_PRIVATE_UNREGISTER = 200;
    public static final int MI_SERIALIZE_SD = 201;
    private ActionFind actionFind;
    private ActionGrammar actionGrammar;
    private ActionGoTo actionGoTo;
    private ActionGenerate actionGenerate;
    private ActionDebugger actionDebugger;
    private ActionExport actionExport;
    private ActionRefactor actionRefactor;
    private ComponentContainer container;
    private XJMenuItem ignoreRuleMenuItem;
    private static ResourceBundle resourceBundle = IDE.getMenusResourceBundle();

    public ComponentContainerGrammarMenu(ComponentContainer container) {
        this.container = container;
        this.actionFind = new ActionFind(container);
        this.actionGrammar = new ActionGrammar(container);
        this.actionGoTo = new ActionGoTo(container);
        this.actionGenerate = new ActionGenerate(container);
        this.actionDebugger = new ActionDebuggerImpl(container);
        this.actionExport = new ActionExport(container);
        this.actionRefactor = new ActionRefactorImpl(container);
    }

    public void close() {
        this.actionFind.close();
        this.actionGrammar.close();
        this.actionGoTo.close();
        this.actionGenerate.close();
        this.actionDebugger.close();
        this.actionExport.close();
        this.actionRefactor.close();
        this.container = null;
    }

    public void awake() {
        this.actionGenerate.awake();
    }

    public ComponentEditorGrammar getEditor() {
        return (ComponentEditorGrammar)this.container.getSelectedEditor();
    }

    public boolean isDebuggerRunning() {
        return this.actionDebugger.isRunning();
    }

    public void customizeFileMenu(XJMenu menu) {
        menu.insertItemAfter(new XJMenuItem(resourceBundle.getString("menu.item.print"), 80, 5, this), 10003);
        menu.insertSeparatorAfter(10003);
        XJMenu exportMenu = new XJMenu();
        exportMenu.setTitle(resourceBundle.getString("menu.title.exportEvents"));
        exportMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.asText"), 115, this));
        menu.insertItemAfter(exportMenu, 10003);
        exportMenu = new XJMenu();
        exportMenu.setTitle(resourceBundle.getString("menu.title.exportAllRules"));
        exportMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsEPS"), 113, this));
        exportMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsBitmap"), 112, this));
        menu.insertItemAfter(exportMenu, 10003);
        exportMenu = new XJMenu();
        exportMenu.setTitle(resourceBundle.getString("menu.title.export"));
        exportMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsEPS"), 111, this));
        exportMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsBitmap"), 110, this));
        exportMenu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.exportAsDot"), 114, this));
        menu.insertItemAfter(exportMenu, 10003);
        menu.insertSeparatorAfter(10003);
    }

    public void customizeMenuBar(XJMainMenuBar menubar) {
        this.createFindMenu(menubar);
        this.createGoToMenu(menubar);
        this.createGrammarMenu(menubar);
        this.createRefactorMenu(menubar);
        this.createGenerateMenu(menubar);
        this.createRunMenu(menubar);
        this.createPrivateMenu(menubar);
    }

    private void createPrivateMenu(XJMainMenuBar menubar) {
        if (AWPrefs.getPrivateMenu()) {
            XJMenu menu = new XJMenu();
            menu.setTitle("*");
            menu.addItem(new XJMenuItem("Unregister user", 200, this));
            menu.addItem(new XJMenuItem("Serialize Syntax Diagrams...", 201, this));
            menubar.addCustomMenu(menu);
        }
    }

    private void createRunMenu(XJMainMenuBar menubar) {
        XJMenu menu = new XJMenu();
        menu.setTitle(resourceBundle.getString("menu.title.run"));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.run"), 82, XJMenuItem.getKeyModifier() | 1, 81, (XJMenuItemDelegate)this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.debug"), 68, 82, this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.debugAgain"), 68, XJMenuItem.getKeyModifier() | 1, 83, (XJMenuItemDelegate)this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.debugRemote"), 84, this));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showInputTokens"), 86, this));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(this.getEditTestRigTitle(), 87, this));
        menubar.addCustomMenu(menu);
    }

    private String getEditTestRigTitle() {
        String grammarName = "";
        String language = null;
        if (this.container.getDebugger() != null) {
            if (this.container.getDebugger().getDelegate().getDocument() != null) {
                grammarName = this.container.getDebugger().getDelegate().getDocument().getDocumentName();
            }
            if (this.container.getDebugger().getDelegate().getGrammarEngine() != null) {
                language = this.container.getDebugger().getDelegate().getGrammarEngine().getGrammarLanguage();
            }
        }
        String menuItemName = grammarName != null && !"".equals(grammarName) ? "Edit " + grammarName + " Test Rig" : "Edit Test Rig";
        if (language != null) {
            menuItemName = menuItemName.concat(" for " + language);
        }
        return menuItemName;
    }

    private void createGenerateMenu(XJMainMenuBar menubar) {
        XJMenu menu = new XJMenu();
        menu.setTitle(resourceBundle.getString("menu.title.generate"));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.generateCode"), 71, XJMenuItem.getKeyModifier() | 1, 70, (XJMenuItemDelegate)this));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showParserCode"), 71, this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showLexerCode"), 72, this));
        menu.addSeparator();
        menu.addItem(this.createMenuItem(73));
        menubar.addCustomMenu(menu);
    }

    private void createGoToMenu(XJMainMenuBar menubar) {
        XJMenu menu = new XJMenu();
        menu.setTitle(resourceBundle.getString("menu.title.goto"));
        menu.addItem(this.createMenuItem(40));
        menu.addItem(this.createMenuItem(41));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoLine"), 71, 42, this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoCharacter"), 43, this));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoBack"), 37, XJMenuItem.getKeyModifier() | 8, 44, (XJMenuItemDelegate)this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoForward"), 39, XJMenuItem.getKeyModifier() | 8, 45, (XJMenuItemDelegate)this));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoPreviousBreakpoint"), 46, this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.gotoNextBreakpoint"), 47, this));
        menubar.addCustomMenu(menu);
    }

    private void createRefactorMenu(XJMainMenuBar menubar) {
        XJMenu menu = new XJMenu();
        menu.setTitle(resourceBundle.getString("menu.title.refactor"));
        menu.addItem(this.createMenuItem(61));
        menu.addItem(this.createMenuItem(62));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.removeLeftRecursion"), 66, this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.removeAllLeftRecursion"), 67, this));
        menu.addSeparator();
        menu.addItem(this.createMenuItem(68));
        menu.addItem(this.createMenuItem(69));
        menu.addSeparator();
        XJMenu literals = new XJMenu();
        literals.setTitle(resourceBundle.getString("menu.title.convertLiterals"));
        literals.addItem(new XJMenuItem(resourceBundle.getString("menu.item.convertToSingleQuote"), 63, this));
        literals.addItem(new XJMenuItem(resourceBundle.getString("menu.item.convertToDoubleQuote"), 64, this));
        literals.addItem(new XJMenuItem(resourceBundle.getString("menu.item.convertToCStyleQuote"), 65, this));
        menu.addItem(literals);
        menubar.addCustomMenu(menu);
    }

    private void createGrammarMenu(XJMainMenuBar menubar) {
        XJMenu menu = new XJMenu();
        menu.setTitle(resourceBundle.getString("menu.title.grammar"));
        menu.addItem(new XJMenuItemCheck(resourceBundle.getString("menu.item.highlightDecisionDFA"), 50, this, false));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showRuleDependencyGraph"), 52, this));
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showTokensSyntaxDiagram"), 53, this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.showTokensDFA"), 54, this));
        menu.addSeparator();
        XJMenu rules = new XJMenu();
        rules.setTitle(resourceBundle.getString("menu.title.rules"));
        rules.addItem(this.createMenuItem(56));
        rules.addItem(this.createMenuItem(57));
        rules.addSeparator();
        this.ignoreRuleMenuItem = this.createMenuItem(58);
        rules.addItem(this.ignoreRuleMenuItem);
        menu.addItem(rules);
        menu.addSeparator();
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.checkGrammar"), 82, 59, this));
        menubar.addCustomMenu(menu);
    }

    private void createFindMenu(XJMainMenuBar menubar) {
        XJMenu menu = new XJMenu();
        menu.setTitle(resourceBundle.getString("menu.title.find"));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.find"), 70, 30, this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.findNext"), 114, 0, 31, (XJMenuItemDelegate)this));
        menu.addItem(new XJMenuItem(resourceBundle.getString("menu.item.findPrevious"), 114, 1, 32, (XJMenuItemDelegate)this));
        menu.addItem(this.createMenuItem(33));
        menu.addSeparator();
        menu.addItem(this.createMenuItem(34));
        menubar.addCustomMenu(menu);
    }

    public XJMenuItem createMenuItem(int tag) {
        return this.createMenuItem(tag, false);
    }

    public XJMenuItem createMenuItem(int tag, boolean contextual) {
        XJMenuItem item = null;
        switch (tag) {
            case 33: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.findTextAtCaret"), 114, 33, this);
                break;
            }
            case 34: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.findUsages"), 118, 8, 34, (XJMenuItemDelegate)this);
                break;
            }
            case 51: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.showDecisionDFA"), 51, this);
                break;
            }
            case 52: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.showRuleDependencyGraph"), 52, this);
                break;
            }
            case 40: {
                item = new XJMenuItem(contextual ? resourceBundle.getString("contextual.item.gotoRule") : resourceBundle.getString("menu.item.gotoRule"), 66, XJMenuItem.getKeyModifier() | 1, 40, (XJMenuItemDelegate)this);
                break;
            }
            case 41: {
                item = new XJMenuItem(contextual ? resourceBundle.getString("contextual.item.goToDeclaration") : resourceBundle.getString("menu.item.gotoDeclaration"), 66, 41, this);
                break;
            }
            case 61: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.rename"), 117, 1, 61, (XJMenuItemDelegate)this);
                break;
            }
            case 62: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.replaceLiteralsWithTokenLabel"), 62, this);
                break;
            }
            case 68: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.extractRule"), 68, this);
                break;
            }
            case 69: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.inlineRule"), 69, this);
                break;
            }
            case 73: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.showRuleCode"), 73, this);
                break;
            }
            case 56: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.group"), 56, this);
                break;
            }
            case 57: {
                item = new XJMenuItem(resourceBundle.getString("menu.item.ungroup"), 57, this);
                break;
            }
            case 58: {
                item = new XJMenuItemCheck(resourceBundle.getString("menu.item.ignoreInInterpreter"), 58, this, true);
                break;
            }
            case 110: {
                item = new XJMenuItem(contextual ? resourceBundle.getString("contextual.item.exportAsBitmapImage") : resourceBundle.getString("menu.item.exportAsBitmap"), 110, this);
                break;
            }
            case 111: {
                item = new XJMenuItem(contextual ? resourceBundle.getString("contextual.item.exportAsEPS") : resourceBundle.getString("menu.item.exportAsEPS"), 111, this);
                break;
            }
            case 114: {
                item = new XJMenuItem(contextual ? resourceBundle.getString("contextual.item.exportAsDot") : resourceBundle.getString("menu.item.exportAsDot"), 114, this);
            }
        }
        return item;
    }

    public JPopupMenu getContextualMenu(int textIndex) {
        boolean overReference = this.getEditor().getCurrentReference() != null;
        boolean overToken = this.getEditor().getCurrentToken() != null;
        boolean overRule = this.getEditor().getCurrentRule() != null;
        boolean overSelection = this.getEditor().getTextPane().getSelectionStart() != this.getEditor().getTextPane().getSelectionEnd();
        boolean overDecisionDFA = this.getEditor().decisionDFAEngine.isDecisionPointAroundLocation(this.getEditor().getTextEditor().getLineIndexAtTextPosition(textIndex), this.getEditor().getTextEditor().getColumnPositionAtIndex(textIndex));
        ContextualMenuFactory factory = new ContextualMenuFactory(this);
        factory.addItem(40);
        if (overReference) {
            factory.addItem(41);
        }
        factory.addSeparator();
        if (overToken) {
            factory.addItem(61);
        }
        if (this.actionRefactor.canReplaceLiteralWithTokenLabel()) {
            factory.addItem(62);
        }
        if (this.actionRefactor.canExtractRule()) {
            factory.addItem(68);
        }
        if (this.actionRefactor.canInlineRule()) {
            factory.addItem(69);
        }
        if (overToken) {
            factory.addSeparator();
            if (overSelection) {
                factory.addItem(33);
            }
            factory.addItem(34);
        }
        if (overRule) {
            factory.addSeparator();
            if (overDecisionDFA) {
                factory.addItem(51);
            }
            factory.addItem(52);
            factory.addItem(73);
        }
        return factory.menu;
    }

    public void menuItemState(final XJMenuItem item) {
        EditorTab tab = this.getEditor().getSelectedTab();
        switch (item.getTag()) {
            case 10023: 
            case 10024: {
                if (!this.isDebuggerRunning()) break;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        item.setEnabled(false);
                    }
                });
                break;
            }
            case 10025: 
            case 10027: {
                item.setEnabled(this.getEditor().isFileWritable());
                break;
            }
            case 20: 
            case 21: 
            case 30: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 80: {
                item.setEnabled(!this.isDebuggerRunning());
                break;
            }
            case 83: {
                item.setEnabled(!this.isDebuggerRunning() && this.actionDebugger.canDebugAgain());
                break;
            }
            case 87: {
                item.setTitle(this.getEditTestRigTitle());
                boolean enabled = XJApplication.shared().getActiveWindow() != null && XJApplication.shared().getActiveWindow().getDocument() != null && XJApplication.shared().getActiveWindow().getDocument().getDocumentName() != null;
                item.setEnabled(!this.isDebuggerRunning() && enabled);
                break;
            }
            case 81: 
            case 82: 
            case 84: {
                item.setEnabled(!this.isDebuggerRunning());
                break;
            }
            case 44: {
                item.setEnabled(this.getEditor().goToHistory.canGoBack());
                break;
            }
            case 45: {
                item.setEnabled(this.getEditor().goToHistory.canGoForward());
                break;
            }
            case 110: {
                item.setEnabled(tab != null && tab.canExportToBitmap());
                break;
            }
            case 111: {
                item.setEnabled(tab != null && tab.canExportToEPS());
                break;
            }
            case 114: {
                item.setEnabled(tab != null && tab.canExportToDOT());
                break;
            }
            case 86: {
                item.setTitle(this.actionDebugger.isInputTokenVisible() ? resourceBundle.getString("menu.item.hideInputTokens") : resourceBundle.getString("menu.item.showInputTokens"));
                break;
            }
            case 50: {
                if (this.getEditor().decisionDFAEngine.getDecisionDFACount() == 0) {
                    item.setSelected(false);
                    break;
                }
                item.setSelected(true);
            }
        }
    }

    public void handleMenuSelected(XJMenu menu) {
        boolean ignored = this.getEditor().rules.getFirstSelectedRuleIgnoredFlag();
        this.ignoreRuleMenuItem.setSelected(ignored);
    }

    public void handleMenuEvent(XJMenu menu, XJMenuItem item) {
        this.handleMenuFile(item.getTag());
        this.handleMenuFind(item.getTag());
        this.handleMenuGrammar(item);
        this.handleMenuRefactor(item.getTag());
        this.handleMenuGoTo(item.getTag());
        this.handleMenuGenerate(item.getTag());
        this.handleMenuRun(item.getTag());
        this.handleMenuPrivate(item.getTag());
        this.handleMenuExport(item.getTag());
    }

    public void handleMenuFile(int itemTag) {
        switch (itemTag) {
            case 5: {
                this.getEditor().print();
            }
        }
    }

    public void handleMenuFind(int itemTag) {
        switch (itemTag) {
            case 30: {
                this.actionFind.find();
                break;
            }
            case 31: {
                this.actionFind.findNext();
                break;
            }
            case 32: {
                this.actionFind.findPrev();
                break;
            }
            case 33: {
                this.actionFind.findSelection();
                break;
            }
            case 34: {
                this.actionFind.findUsage();
            }
        }
    }

    public void handleMenuGrammar(XJMenuItem item) {
        switch (item.getTag()) {
            case 53: {
                this.actionGrammar.showTokensSD();
                break;
            }
            case 54: {
                this.actionGrammar.showTokensDFA();
                break;
            }
            case 51: {
                this.actionGrammar.showDecisionDFA();
                break;
            }
            case 50: {
                this.actionGrammar.highlightDecisionDFA();
                break;
            }
            case 52: {
                this.actionGrammar.showDependency();
                break;
            }
            case 56: {
                this.actionGrammar.group();
                break;
            }
            case 57: {
                this.actionGrammar.ungroup();
                break;
            }
            case 58: {
                if (item.isSelected()) {
                    this.actionGrammar.ignore();
                    break;
                }
                this.actionGrammar.consider();
                break;
            }
            case 59: {
                this.actionGrammar.checkGrammar();
            }
        }
    }

    public void handleMenuRefactor(int itemTag) {
        switch (itemTag) {
            case 61: {
                this.actionRefactor.rename();
                break;
            }
            case 62: {
                this.actionRefactor.replaceLiteralWithTokenLabel();
                break;
            }
            case 63: {
                this.actionRefactor.convertLiteralsToSingleQuote();
                break;
            }
            case 64: {
                this.actionRefactor.convertLiteralsToDoubleQuote();
                break;
            }
            case 65: {
                this.actionRefactor.convertLiteralsToCStyleQuote();
                break;
            }
            case 66: {
                this.actionRefactor.removeLeftRecursion();
                break;
            }
            case 67: {
                this.actionRefactor.removeAllLeftRecursion();
                break;
            }
            case 68: {
                this.actionRefactor.extractRule();
                break;
            }
            case 69: {
                this.actionRefactor.inlineRule();
            }
        }
    }

    public void handleMenuGoTo(int itemTag) {
        switch (itemTag) {
            case 40: {
                this.actionGoTo.goToRule();
                break;
            }
            case 41: {
                this.actionGoTo.goToDeclaration();
                break;
            }
            case 42: {
                this.actionGoTo.goToLine();
                break;
            }
            case 43: {
                this.actionGoTo.goToCharacter();
                break;
            }
            case 44: {
                this.actionGoTo.goToBackward();
                break;
            }
            case 45: {
                this.actionGoTo.goToForward();
                break;
            }
            case 46: {
                this.actionGoTo.goToBreakpoint(-1);
                break;
            }
            case 47: {
                this.actionGoTo.goToBreakpoint(1);
            }
        }
    }

    public void handleMenuGenerate(int itemTag) {
        switch (itemTag) {
            case 70: {
                this.actionGenerate.generateCode();
                break;
            }
            case 72: {
                this.actionGenerate.showGeneratedCode(2);
                break;
            }
            case 71: {
                this.actionGenerate.showGeneratedCode(1);
                break;
            }
            case 73: {
                this.actionGenerate.showRuleGeneratedCode();
            }
        }
    }

    public void handleMenuRun(int itemTag) {
        switch (itemTag) {
            case 80: {
                this.actionDebugger.runInterpreter();
                break;
            }
            case 81: {
                this.actionDebugger.run();
                break;
            }
            case 82: {
                this.actionDebugger.debug();
                break;
            }
            case 83: {
                this.actionDebugger.debugAgain();
                break;
            }
            case 84: {
                this.actionDebugger.debugRemote();
                break;
            }
            case 86: {
                this.actionDebugger.toggleInputTokens();
                this.getEditor().refreshMainMenuBar();
                break;
            }
            case 87: {
                this.actionDebugger.showEditTestRig();
            }
        }
    }

    public void handleMenuPrivate(int itemTag) {
        switch (itemTag) {
            case 200: {
                AWPrefs.removeUserRegistration();
                break;
            }
            case 201: {
                this.getEditor().visual.serializeSyntaxDiagram();
            }
        }
    }

    public void handleMenuExport(int itemTag) {
        switch (itemTag) {
            case 110: {
                this.actionExport.exportAsImage();
                break;
            }
            case 111: {
                this.actionExport.exportAsEPS();
                break;
            }
            case 114: {
                this.actionExport.exportAsDOT();
                break;
            }
            case 112: {
                this.actionExport.exportAllRulesAsImage();
                break;
            }
            case 113: {
                this.actionExport.exportAllRulesAsEPS();
                break;
            }
            case 115: {
                this.actionExport.exportEventsAsTextFile();
            }
        }
    }

    public ActionRefactor getActionRefactor() {
        return this.actionRefactor;
    }

    public ActionDebugger getActionDebugger() {
        return this.actionDebugger;
    }

    public ActionGoTo getActionGoTo() {
        return this.actionGoTo;
    }
}

