/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components.document;

import org.antlr.works.components.ComponentWindow;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.editor.ComponentEditor;
import org.antlr.xjlib.appkit.document.XJDataPlainText;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.foundation.XJUtils;

public abstract class ComponentDocument
extends XJDocument {
    private ComponentContainer container;
    private ComponentEditor editor;

    public ComponentEditor getEditor() {
        return this.editor;
    }

    public void setEditor(ComponentEditor editor) {
        this.editor = editor;
    }

    public ComponentContainer getContainer() {
        if (this.container != null) {
            return this.container;
        }
        return ((ComponentWindow)this.getWindow()).getComponentContainer();
    }

    public void setContainer(ComponentContainer container) {
        this.container = container;
    }

    public void awake() {
        super.awake();
        this.editor.awake();
    }

    public void changeDone() {
        super.changeDone();
        this.getContainer().setDirty();
    }

    public void documentWillWriteData() {
        XJDataPlainText data = (XJDataPlainText)this.getDocumentData();
        data.setText(XJUtils.getLocalizedText(this.editor.getText()));
    }

    public void documentDidReadData() {
        XJDataPlainText data = (XJDataPlainText)this.getDocumentData();
        this.editor.loadText(XJUtils.getNormalizedText(data.getText()));
        this.getContainer().documentLoaded(this);
    }
}

