/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components.editor;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.ComponentStatusBar;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.document.ComponentDocument;
import org.antlr.works.editor.navigation.GoToRule;
import org.antlr.works.find.FindAndReplace;
import org.antlr.works.grammar.element.Jumpable;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentEditor
implements XJNotificationObserver {
    protected ComponentContainer container;
    protected ComponentDocument document;
    protected JPanel mainPanel = new JPanel(new BorderLayout());
    protected Box statusBar;
    protected ComponentListener cl = new MainPanelComponentListener();
    protected PropertyChangeListener pcl;

    public ComponentEditor() {
        this.mainPanel.addComponentListener(this.cl);
        this.statusBar = new ComponentStatusBar();
        this.statusBar.setPreferredSize(new Dimension(0, 30));
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_PREFS_APPLIED");
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STARTED");
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_DEBUG_STOPPED");
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (prop.equals("permanentFocusOwner")) {
                    // empty if block
                }
            }
        };
        focusManager.addPropertyChangeListener(this.pcl);
    }

    public void awake() {
        this.create();
        this.assemble();
    }

    public ComponentContainer getContainer() {
        return this.container;
    }

    public void setContainer(ComponentContainer container) {
        this.container = container;
    }

    public void refreshMainMenuBar() {
        if (this.getXJFrame().getMainMenuBar() != null) {
            this.getXJFrame().getMainMenuBar().refreshState();
        }
    }

    public JComponent getStatusComponent() {
        return this.statusBar;
    }

    public void setDocument(ComponentDocument document) {
        this.document = document;
    }

    public ComponentDocument getDocument() {
        return this.document;
    }

    public XJFrameInterface getXJFrame() {
        return this.container.getXJFrame();
    }

    public Container getJavaContainer() {
        return this.getXJFrame().getJavaContainer();
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public XJUndo getCurrentUndo() {
        return this.getXJFrame().getCurrentUndo();
    }

    @Override
    public void notificationFire(Object source, String name) {
        if (name.equals("NOTIF_PREFS_APPLIED")) {
            this.notificationPrefsChanged();
        } else if (name.equals("NOTIF_DEBUG_STARTED")) {
            this.notificationDebuggerStarted();
        } else if (name.equals("NOTIF_DEBUG_STOPPED")) {
            this.notificationDebuggerStopped();
        }
    }

    protected static JComponent createSeparator() {
        JSeparator s = new JSeparator(1);
        Dimension d = s.getMaximumSize();
        d.width = 2;
        s.setMaximumSize(d);
        return s;
    }

    public void becomingVisibleForTheFirstTime() {
        this.componentDidAwake();
    }

    public abstract void create();

    public abstract void assemble();

    public abstract void loadText(String var1);

    public abstract String getText();

    public abstract ATEPanel getTextEditor();

    public abstract void setCaretPosition(int var1);

    public abstract void goToHistoryRememberCurrentPosition();

    public abstract void goToBackward();

    public abstract void goToForward();

    public abstract List<ATELine> getLines();

    public abstract void find();

    public abstract FindAndReplace getFindAndReplace();

    public abstract GoToRule getGoToRule();

    public abstract ATEToken getCurrentToken();

    public abstract boolean goToRule(String var1);

    public abstract void goToDeclaration();

    public abstract void goToDeclaration(Jumpable var1);

    public abstract List<String> getRulesStartingWith(String var1);

    public abstract void beginGroupChange(String var1);

    public abstract void endGroupChange();

    public abstract void disableTextPaneUndo();

    public abstract void enableTextPaneUndo();

    public List<ATEToken> getTokens() {
        return this.getTextEditor().getTokens();
    }

    public ATETextPane getTextPane() {
        return this.getTextEditor().getTextPane();
    }

    public void setText(String s) {
        this.getTextEditor().setText(s);
    }

    public int getCaretPosition() {
        return this.getTextEditor().getCaretPosition();
    }

    public void close() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.pcl);
        this.pcl = null;
        this.mainPanel.removeComponentListener(this.cl);
        this.cl = null;
        this.container = null;
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public abstract void componentDocumentContentChanged();

    public boolean componentDocumentWillSave() {
        return true;
    }

    public void componentDidAwake() {
    }

    public void componentActivated() {
    }

    public void componentDidHide() {
    }

    public void componentIsSelected() {
    }

    public void notificationPrefsChanged() {
    }

    public void notificationDebuggerStarted() {
    }

    public void notificationDebuggerStopped() {
    }

    public void setEditable(boolean flag) {
    }

    protected class MainPanelComponentListener
    extends ComponentAdapter {
        protected MainPanelComponentListener() {
        }

        public void componentHidden(ComponentEvent e) {
            ComponentEditor.this.componentDidHide();
        }
    }
}

