/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.components.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.antlr.Tool;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATEPanelDelegate;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEThread;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.ComponentMemoryStatus;
import org.antlr.works.components.editor.ComponentEditor;
import org.antlr.works.editor.EditorATEEditorKit;
import org.antlr.works.editor.EditorAnalysisManager;
import org.antlr.works.editor.EditorConsole;
import org.antlr.works.editor.EditorFoldingManager;
import org.antlr.works.editor.EditorGutterColumnManager;
import org.antlr.works.editor.EditorIdeas;
import org.antlr.works.editor.EditorInspector;
import org.antlr.works.editor.EditorPersistence;
import org.antlr.works.editor.EditorRules;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.editor.EditorTips;
import org.antlr.works.editor.EditorUnderlyingManager;
import org.antlr.works.editor.InspectorDelegate;
import org.antlr.works.editor.completion.AutoCompletionMenu;
import org.antlr.works.editor.completion.AutoCompletionMenuDelegate;
import org.antlr.works.editor.navigation.GoToHistory;
import org.antlr.works.editor.navigation.GoToRule;
import org.antlr.works.find.FindAndReplace;
import org.antlr.works.grammar.GrammarAutoIndent;
import org.antlr.works.grammar.decisiondfa.DecisionDFAEngine;
import org.antlr.works.grammar.element.ElementAction;
import org.antlr.works.grammar.element.ElementImport;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.element.Jumpable;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.grammar.engine.GrammarEngineDelegate;
import org.antlr.works.grammar.engine.GrammarEngineImpl;
import org.antlr.works.interpreter.EditorInterpreter;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.Utils;
import org.antlr.works.visualization.Visual;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.swing.XJTree;
import org.antlr.xjlib.appkit.text.XJURLLabel;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentEditorGrammar
extends ComponentEditor
implements AutoCompletionMenuDelegate,
ATEPanelDelegate,
XJUndoDelegate,
InspectorDelegate,
GrammarEngineDelegate {
    public AutoCompletionMenu autoCompletionMenu;
    public FindAndReplace findAndReplace;
    public DecisionDFAEngine decisionDFAEngine;
    public GoToRule goToRule;
    public GoToHistory goToHistory;
    public EditorGutterColumnManager gutterColumnManager;
    public EditorFoldingManager foldingManager;
    public EditorUnderlyingManager underlyingManager;
    public EditorAnalysisManager analysisManager;
    public GrammarEngine engine;
    public EditorRules rules;
    public Visual visual;
    public EditorInterpreter interpreter;
    public EditorConsole console;
    public EditorIdeas editorIdeas;
    public EditorTips editorTips;
    public EditorInspector editorInspector;
    public EditorPersistence persistence;
    public EditorATEEditorKit editorKit;
    public ATEPanel textEditor;
    private JScrollPane rulesScrollPane;
    private XJTree rulesTree;
    private JLabel infoLabel;
    private JLabel cursorLabel;
    private JLabel writableLabel;
    private ConsoleStatus consoleStatus;
    private ComponentMemoryStatus memoryStatus;
    private int debuggerLocation = -1;
    private Jumpable highlightedReference;
    private boolean windowFirstDisplay = true;
    private String lastSelectedRule;
    private AfterParseOperations afterParserOp;
    private XJDialogProgress progress;

    @Override
    public void create() {
        this.initCore();
        this.createInterface();
        this.initEditor();
        this.initManagers();
        this.initComponents();
        this.initAutoCompletion();
        this.initTools();
        this.awakeInstances();
        this.register();
    }

    @Override
    public void assemble() {
        this.mainPanel.add((Component)this.textEditor, "Center");
    }

    public Component getComponentRules() {
        return this.rulesScrollPane;
    }

    public Component getComponentEditor() {
        return this.textEditor;
    }

    public EditorTab getComponentSD() {
        return this.visual;
    }

    public EditorTab getComponentInterpreter() {
        return this.interpreter;
    }

    public EditorTab getComponentConsole() {
        return this.console;
    }

    protected void initComponents() {
        this.rules = new EditorRules(this, this.rulesTree);
        this.visual = new Visual(this);
    }

    protected void initTools() {
        this.goToRule = new GoToRule(this, this.getXJFrame(), this.getTextPane());
        this.goToHistory = new GoToHistory();
        this.findAndReplace = new FindAndReplace(this);
    }

    protected void initAutoCompletion() {
        if (this.autoCompletionMenu != null) {
            this.autoCompletionMenu.close();
        }
        this.autoCompletionMenu = new AutoCompletionMenu(this, this.getTextPane(), this.getXJFrame());
    }

    protected void initCore() {
        this.afterParserOp = new AfterParseOperations();
        this.engine = new GrammarEngineImpl(this);
        this.decisionDFAEngine = new DecisionDFAEngine(this);
        this.interpreter = new EditorInterpreter(this);
    }

    protected void initEditor() {
        this.console = new EditorConsole(this);
        this.console.makeCurrent();
        this.editorIdeas = new EditorIdeas(this);
        this.editorTips = new EditorTips(this);
        this.editorInspector = new EditorInspector(this.engine, this.decisionDFAEngine, this);
        this.persistence = new EditorPersistence(this);
    }

    protected void initManagers() {
        this.gutterColumnManager = new EditorGutterColumnManager(this);
        this.textEditor.setGutterColumnManager(this.gutterColumnManager);
        this.foldingManager = new EditorFoldingManager(this);
        this.textEditor.setFoldingManager(this.foldingManager);
        this.underlyingManager = new EditorUnderlyingManager(this);
        this.textEditor.setUnderlyingManager(this.underlyingManager);
        this.analysisManager = new EditorAnalysisManager(this);
        this.textEditor.setAnalysisManager(this.analysisManager);
    }

    protected void awakeInstances() {
        this.editorIdeas.awake();
        this.editorTips.awake();
        this.interpreter.awake();
        this.rules.setKeyBindings(this.textEditor.getKeyBindings());
        this.textEditor.setParserEngine(this.engine.getSyntaxEngine());
    }

    protected void createTextEditor() {
        this.textEditor = new ATEPanel(this.getXJFrame());
        this.editorKit = new EditorATEEditorKit(this);
        this.textEditor.setEditorKit(this.editorKit);
        this.textEditor.setSyntaxColoring(true);
        this.textEditor.setDelegate(this);
        this.applyPrefs();
    }

    protected void createRulesPane() {
        this.rulesTree = new RuleTree();
        this.rulesTree.setBorder(null);
        this.rulesTree.setToolTipText("");
        this.rulesTree.setDragEnabled(true);
        this.rulesScrollPane = new JScrollPane(this.rulesTree);
        this.rulesScrollPane.setWheelScrollingEnabled(true);
    }

    public JComponent getRulesComponent() {
        return this.rulesScrollPane;
    }

    protected void createStatusBar() {
        this.infoLabel = new JLabel();
        this.cursorLabel = new JLabel();
        this.writableLabel = new JLabel();
        this.consoleStatus = new ConsoleStatus();
        this.memoryStatus = new ComponentMemoryStatus();
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.infoLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(ComponentEditorGrammar.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.cursorLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(ComponentEditorGrammar.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.writableLabel);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(ComponentEditorGrammar.createSeparator());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.consoleStatus.getPanel());
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(ComponentEditorGrammar.createSeparator());
        this.statusBar.add(Box.createHorizontalGlue());
        this.statusBar.add(this.memoryStatus);
    }

    protected void createInterface() {
        this.createTextEditor();
        this.createRulesPane();
        this.createStatusBar();
    }

    protected void register() {
        this.getXJFrame().registerUndo(this, this.getTextPane());
    }

    public void applyPrefs() {
        this.afterParserOp.setDefaultThreshold(AWPrefs.getParserDelay());
        this.textEditor.setFoldingEnabled(AWPrefs.getFoldingEnabled());
        this.textEditor.setLineNumberEnabled(AWPrefs.getLineNumberEnabled());
        this.textEditor.setHighlightCursorLine(AWPrefs.getHighlightCursorEnabled());
        this.textEditor.refresh();
        this.initAutoCompletion();
        this.applyFont();
    }

    public void applyFont() {
        this.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
    }

    @Override
    public void close() {
        this.goToRule.close();
        this.findAndReplace.close();
        this.autoCompletionMenu.close();
        this.decisionDFAEngine.close();
        this.interpreter.close();
        this.console.close();
        this.editorIdeas.close();
        this.editorTips.close();
        this.editorInspector.close();
        this.persistence.close();
        this.engine.close();
        this.rules.close();
        this.visual.close();
        this.afterParserOp.stop();
        this.afterParserOp = null;
        this.gutterColumnManager.close();
        this.foldingManager.close();
        this.underlyingManager.close();
        this.analysisManager.close();
        this.textEditor.close();
        this.getXJFrame().unregisterUndo(this);
        this.editorKit.close();
        this.consoleStatus = null;
        this.memoryStatus.close();
        this.memoryStatus = null;
        this.rulesTree.close();
        this.rulesTree = null;
        super.close();
    }

    public void addTab(EditorTab tab) {
        this.container.addTab(tab);
    }

    public void selectVisualizationTab() {
        this.container.selectSyntaxDiagramTab(this);
    }

    public void selectInterpreterTab() {
        this.container.selectInterpreterTab(this);
    }

    public void selectConsoleTab() {
        this.container.selectConsoleTab(this);
    }

    public EditorTab getSelectedTab() {
        return this.container.getSelectedTab();
    }

    public void selectTab(Component c) {
        this.container.selectTab(c);
    }

    public EditorConsole getConsole() {
        return this.console;
    }

    @Override
    public ATETextPane getTextPane() {
        return this.textEditor.getTextPane();
    }

    @Override
    public ATEPanel getTextEditor() {
        return this.textEditor;
    }

    @Override
    public void gotoToRule(String grammar, final String name) {
        if (!grammar.equals(this.engine.getGrammarName())) {
            final ComponentEditorGrammar editor = (ComponentEditorGrammar)this.getContainer().selectEditor(grammar);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    editor.gotoToRule(name);
                }
            });
        } else {
            this.gotoToRule(name);
        }
    }

    public void gotoToRule(String name) {
        int index = this.engine.getFirstDeclarationPosition(name);
        if (index != -1) {
            this.setCaretPosition(index);
        }
    }

    public void toggleAutoIndent() {
        this.textEditor.setAutoIndent(!this.textEditor.autoIndent());
    }

    public void toggleSyntaxColoring() {
        StatisticsAW.shared().recordEvent(120);
        this.textEditor.toggleSyntaxColoring();
    }

    public boolean isSyntaxColored() {
        return this.textEditor.isSyntaxColoring();
    }

    public void toggleRulesSorting() {
        StatisticsAW.shared().recordEvent(123);
        this.rules.toggleSorting();
        this.interpreter.setRules(this.getNaturalRules());
    }

    public boolean isRulesSorted() {
        return this.rules.isSorted();
    }

    public void toggleSyntaxDiagram() {
        StatisticsAW.shared().recordEvent(121);
        this.visual.setEnable(!this.visual.isEnabled());
        if (this.visual.isEnabled()) {
            this.visual.setText(this.getText(), this.getFileName());
        }
        this.updateVisualization(false);
    }

    public boolean isSyntaxDiagramDisplayed() {
        return this.visual.isEnabled();
    }

    public void toggleNFAOptimization() {
        this.visual.toggleNFAOptimization();
        this.updateVisualization(false);
    }

    public void toggleIdeas() {
        StatisticsAW.shared().recordEvent(122);
        this.editorIdeas.toggleEnabled();
    }

    public boolean isIdeasEnabled() {
        return this.editorIdeas.isEnabled();
    }

    public void toggleTips() {
        this.editorTips.toggleEnabled();
    }

    public void toggleUnderlying() {
        this.textEditor.setUnderlying(!this.textEditor.isUnderlying());
        this.textEditor.refresh();
    }

    public void toggleAnalysis() {
        this.textEditor.toggleAnalysis();
    }

    public void changeUpdate() {
        this.ateChangeUpdate(-1, -1, false);
    }

    @Override
    public void beginGroupChange(String name) {
        this.disableTextPane(false);
        this.beginTextPaneUndoGroup(name);
    }

    @Override
    public void endGroupChange() {
        this.endTextPaneUndoGroup();
        this.enableTextPane(false);
        this.textEditor.parse();
        this.changeDone();
    }

    public void enableTextPane(boolean undo) {
        this.textEditor.setEnableRecordChange(true);
        if (undo) {
            this.enableTextPaneUndo();
        }
    }

    public void disableTextPane(boolean undo) {
        this.textEditor.setEnableRecordChange(false);
        if (undo) {
            this.disableTextPaneUndo();
        }
    }

    public void beginTextPaneUndoGroup(String name) {
        XJUndo undo = this.getXJFrame().getUndo(this.getTextPane());
        if (undo != null) {
            undo.beginUndoGroup(name);
        }
    }

    public void endTextPaneUndoGroup() {
        XJUndo undo = this.getXJFrame().getUndo(this.getTextPane());
        if (undo != null) {
            undo.endUndoGroup();
        }
    }

    @Override
    public void enableTextPaneUndo() {
        XJUndo undo = this.getXJFrame().getUndo(this.getTextPane());
        if (undo != null) {
            undo.enableUndo();
        }
    }

    @Override
    public void disableTextPaneUndo() {
        XJUndo undo = this.getXJFrame().getUndo(this.getTextPane());
        if (undo != null) {
            undo.disableUndo();
        }
    }

    @Override
    public void undoManagerWillUndo(boolean redo) {
    }

    @Override
    public void undoManagerDidUndo(boolean redo) {
        this.changeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadText(String text) {
        this.disableTextPaneUndo();
        try {
            this.textEditor.loadText(text);
            this.grammarChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.enableTextPaneUndo();
        }
    }

    @Override
    public void setText(String text) {
        this.textEditor.setText(text);
        this.grammarChanged();
        this.textEditor.parse();
        this.changeDone();
    }

    @Override
    public synchronized String getText() {
        return this.getTextPane().getText();
    }

    @Override
    public String getGrammarFileName() {
        String fileName = this.getFileName();
        return fileName == null ? "<notsaved>" : fileName;
    }

    @Override
    public String getGrammarText() {
        return this.getText();
    }

    @Override
    public void reportError(String error) {
        this.getConsole().println(error, 2);
    }

    @Override
    public void reportError(Exception e) {
        this.getConsole().println(e);
    }

    @Override
    public Tool getANTLRTool() {
        String[] params = AWPrefs.getANTLR3Options();
        if (this.getOutputPath() != null) {
            File output = new File(this.getOutputPath());
            if (!output.exists()) {
                output.mkdirs();
            }
            params = Utils.concat(params, new String[]{"-o", output.getAbsolutePath(), "-lib", this.getFileFolder()});
        }
        if (params.length > 0) {
            return new Tool(params);
        }
        return new Tool();
    }

    @Override
    public void engineAnalyzeCompleted() {
        this.visual.clearCacheGraphs();
        this.rules.refreshRules();
        if (!this.visual.update()) {
            this.updateVisualization(true);
        }
        this.updateInformation();
    }

    @Override
    public void createFile(String name) {
        this.container.createFile(name);
    }

    @Override
    public void createRuleAtIndex(boolean lexer, String name, String content) {
        this.container.getActionRefactor().createRuleAtIndex(lexer, name, content);
    }

    @Override
    public void deleteRuleAtCurrentPosition() {
        this.container.getActionRefactor().deleteRuleAtIndex(this.getCaretPosition());
    }

    @Override
    public void removeLeftRecursion() {
        this.container.getActionRefactor().removeLeftRecursion();
    }

    @Override
    public void convertLiteralsToSingleQuote() {
        this.container.getActionRefactor().convertLiteralsToSingleQuote();
    }

    @Override
    public void replaceText(int leftIndex, int rightIndex, String text) {
        this.textEditor.replaceText(leftIndex, rightIndex, text);
    }

    public void selectTextRange(int start, int end) {
        this.textEditor.selectTextRange(start, end);
    }

    public void deselectTextRange() {
        this.textEditor.deselectTextRange();
    }

    public void setDebuggerLocation(int index) {
        this.debuggerLocation = index;
        if (index != -1) {
            this.textEditor.getTextPane().setCaretPosition(index);
        }
    }

    public int getDebuggerLocation() {
        return this.debuggerLocation;
    }

    public int getSelectionLeftIndexOnTokenBoundary() {
        ATEToken t = this.getTokenAtPosition(this.getTextPane().getSelectionStart(), true);
        if (t == null) {
            return -1;
        }
        return t.getStartIndex();
    }

    public int getSelectionRightIndexOnTokenBoundary() {
        ATEToken t = this.getTokenAtPosition(this.getTextPane().getSelectionEnd(), false);
        if (t == null) {
            return -1;
        }
        return t.getEndIndex();
    }

    public synchronized boolean isFileWritable() {
        String path = this.getFilePath();
        if (path == null) {
            return true;
        }
        File f = new File(path);
        return !f.exists() || f.canWrite();
    }

    public synchronized boolean isFileExists() {
        String path = this.getFilePath();
        if (path == null) {
            return false;
        }
        File f = new File(path);
        return f.exists();
    }

    public synchronized String getFileFolder() {
        return XJUtils.getPathByDeletingLastComponent(this.getFilePath());
    }

    @Override
    public String getTokenVocabFile(String tokenVocabName) {
        String filePath = this.getFileFolder();
        if (filePath == null) {
            return null;
        }
        String path = XJUtils.concatPath(filePath, tokenVocabName);
        if (new File(path).exists()) {
            return path;
        }
        path = XJUtils.concatPath(this.getOutputPath(), tokenVocabName);
        if (new File(path).exists()) {
            return path;
        }
        return null;
    }

    public synchronized String getFilePath() {
        return this.getDocument().getDocumentPath();
    }

    @Override
    public synchronized String getFileName() {
        return this.getDocument().getDocumentName();
    }

    public String getOutputPath() {
        File outputPath = new File(AWPrefs.getOutputPath());
        if (outputPath.isAbsolute()) {
            return outputPath.getAbsolutePath();
        }
        if (this.getFilePath() == null) {
            return null;
        }
        return XJUtils.concatPath(XJUtils.getPathByDeletingLastComponent(this.getFilePath()), outputPath.getPath());
    }

    public Container getWindowContainer() {
        return this.getXJFrame().getJavaContainer();
    }

    public GrammarEngine getGrammarEngine() {
        return this.engine;
    }

    public List<ElementRule> getNaturalRules() {
        return this.rules.isSorted() ? this.rules.getSortedRules() : this.rules.getRules();
    }

    public List<ElementRule> getRules() {
        return this.rules.getRules();
    }

    public List<ElementRule> getSortedRules() {
        return this.rules.getSortedRules();
    }

    @Override
    public List<ATEToken> getTokens() {
        return this.textEditor.getTokens();
    }

    @Override
    public List<ATELine> getLines() {
        return this.textEditor.getLines();
    }

    @Override
    public void goToHistoryRememberCurrentPosition() {
        this.goToHistory.addPosition(this.getCaretPosition());
        this.refreshMainMenuBar();
    }

    public ElementReference getCurrentReference() {
        return this.getReferenceAtPosition(this.getCaretPosition());
    }

    public ElementReference getReferenceAtPosition(int pos) {
        for (ElementReference ref : this.engine.getReferences()) {
            if (!ref.containsIndex(pos)) continue;
            return ref;
        }
        return null;
    }

    public ElementImport getImportAtPosition(int pos) {
        for (ElementImport element : this.engine.getImports()) {
            if (!element.containsIndex(pos)) continue;
            return element;
        }
        return null;
    }

    @Override
    public ATEToken getCurrentToken() {
        return this.getTokenAtPosition(this.getCaretPosition(), false);
    }

    public ATEToken getTokenAtPosition(int pos, boolean fromRight) {
        List<ATEToken> tokens = this.getTokens();
        if (tokens == null) {
            return null;
        }
        if (fromRight) {
            for (int i = tokens.size() - 1; i >= 0; --i) {
                ATEToken token = tokens.get(i);
                if (!token.containsIndex(pos)) continue;
                return token;
            }
        } else {
            for (ATEToken token : tokens) {
                if (!token.containsIndex(pos)) continue;
                return token;
            }
        }
        return null;
    }

    public ElementRule getCurrentRule() {
        return this.rules.getEnclosingRuleAtPosition(this.getCaretPosition());
    }

    public ElementAction getCurrentAction() {
        List<ElementAction> actions = this.engine.getActions();
        int position = this.getCaretPosition();
        for (ElementAction action : actions) {
            if (!action.containsIndex(position)) continue;
            return action;
        }
        return null;
    }

    @Override
    public void setCaretPosition(int position) {
        this.setCaretPosition(position, AWPrefs.getSmoothScrolling());
    }

    public void setCaretPosition(int position, boolean animate) {
        ElementRule rule = this.rules.getEnclosingRuleAtPosition(position);
        if (rule != null && !rule.isExpanded()) {
            this.foldingManager.toggleFolding(rule);
        }
        this.textEditor.setCaretPosition(position, true, animate);
    }

    @Override
    public int getCaretPosition() {
        return this.textEditor.getCaretPosition();
    }

    public void updateVisualization(boolean immediate) {
        if (this.visual.isEnabled()) {
            ElementRule r = this.rules.getEnclosingRuleAtPosition(this.getCaretPosition());
            if (r == null) {
                this.visual.setPlaceholder("Select a rule to display its syntax diagram");
            } else {
                if (r.hasErrors() && r.needsToBuildErrors()) {
                    this.engine.computeRuleErrors(r);
                    try {
                        this.visual.createGraphsForRule(r);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.visual.setRule(r, immediate);
            }
        } else {
            this.visual.setPlaceholder("Syntax Diagram Disabled");
        }
    }

    public void updateInformation() {
        String t;
        int size = this.engine.getNumberOfRules();
        switch (size) {
            case 0: {
                t = "No rules";
                break;
            }
            case 1: {
                t = "One rule";
                break;
            }
            default: {
                t = size + " rules";
            }
        }
        int warnings = this.engine.getNumberOfErrors();
        if (warnings > 0) {
            t = t + " (" + warnings + " warning" + (warnings > 0 ? "s" : "") + ")";
        }
        this.infoLabel.setText(t);
        if (this.isFileWritable()) {
            this.writableLabel.setText("Writable");
        } else {
            this.writableLabel.setText("Read-only");
        }
    }

    public void updateCursorInfo() {
        this.cursorLabel.setText(this.textEditor.getCurrentLinePosition() + ":" + this.textEditor.getCurrentColumnPosition());
    }

    @Override
    public FindAndReplace getFindAndReplace() {
        return this.findAndReplace;
    }

    @Override
    public GoToRule getGoToRule() {
        return this.goToRule;
    }

    @Override
    public boolean goToRule(String ruleName) {
        ElementRule rule = this.rules.selectRuleNameInTree(ruleName);
        if (rule != null) {
            this.goToHistoryRememberCurrentPosition();
            this.rules.goToRule(rule);
            return true;
        }
        return false;
    }

    @Override
    public void goToDeclaration() {
        Comparable ref = this.getCurrentReference();
        if (ref == null) {
            ref = this.getImportAtPosition(this.getCaretPosition());
        }
        this.container.getActionGoTo().goToDeclaration((Jumpable)((Object)ref));
    }

    @Override
    public void goToDeclaration(final Jumpable ref) {
        this.goToHistoryRememberCurrentPosition();
        if (ref instanceof ElementImport) {
            this.getContainer().selectEditor(ref.getName());
        } else if (ref != null) {
            GrammarEngine engine = this.getGrammarEngine();
            int index = engine.getFirstDeclarationPosition(ref.getName());
            if (index == -1) {
                List<String> grammars = (engine = engine.getRootEngine()).getGrammarsOverriddenByRule(ref.getName());
                if (!grammars.isEmpty()) {
                    this.getContainer().selectEditor(grammars.get(0));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GrammarEngine engine = ComponentEditorGrammar.this.getGrammarEngine();
                            int index = engine.getFirstDeclarationPosition(ref.getName());
                            if (index != -1) {
                                ComponentEditorGrammar.this.setCaretPosition(index);
                            }
                        }
                    });
                }
            } else {
                this.setCaretPosition(index);
            }
        }
    }

    @Override
    public List<String> getRulesStartingWith(String match) {
        return this.rules.getRulesStartingWith(match);
    }

    public void rulesCaretPositionDidChange() {
        this.updateVisualization(false);
    }

    public void rulesDidSelectRule() {
        this.updateVisualization(true);
    }

    public void rulesDidChange() {
        this.interpreter.updateIgnoreTokens(this.getRules());
    }

    public JPopupMenu rulesGetContextualMenu(List selectedObjects) {
        if (selectedObjects.isEmpty()) {
            return null;
        }
        ContextualMenuFactory factory = this.container.createContextualMenuFactory();
        factory.addItem(56);
        factory.addItem(57);
        factory.addSeparator();
        XJMenuItemCheck item = (XJMenuItemCheck)factory.addItem(58);
        item.setSelected(this.rules.getFirstSelectedRuleIgnoredFlag());
        return factory.menu;
    }

    @Override
    public void ateEngineWillParse() {
        this.persistence.store();
    }

    @Override
    public void ateEngineDidParse() {
        this.updateInformation();
        this.updateCursorInfo();
        if (this.windowFirstDisplay) {
            this.windowFirstDisplay = false;
            this.afterParseOperations();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComponentEditorGrammar.this.updateVisualization(true);
                    ComponentEditorGrammar.this.findTokensToIgnore(true);
                }
            });
        } else {
            this.afterParserOp.awakeThread();
        }
    }

    private void afterParseOperations() {
        this.container.editorParsed(this);
        this.persistence.restore();
        this.interpreter.setRules(this.getNaturalRules());
        this.rules.parserDidParse();
        this.decisionDFAEngine.reset();
        this.decisionDFAEngine.refreshMenu();
        this.editorIdeas.display(this.getCaretPosition());
        this.visual.setText(this.getText(), this.getFileName());
        this.updateVisualization(false);
        this.textEditor.damage();
        this.textEditor.repaint();
    }

    public void changeDone() {
        this.grammarChanged();
        this.getDocument().changeDone();
    }

    public boolean ensureDocumentSaved() {
        return this.getDocument().getDocumentPath() != null || this.getDocument().save(false);
    }

    private void grammarChanged() {
        this.engine.markDirty();
        this.container.editorContentChanged();
    }

    public void consolePrint(String s, int level) {
        this.consoleStatus.showLevel(level);
    }

    public void clearConsoleStatus() {
        this.consoleStatus.clearMessage();
    }

    public void setHighlightedReference(Jumpable highlightedReference) {
        if (highlightedReference != this.highlightedReference) {
            this.textEditor.repaint();
        }
        this.highlightedReference = highlightedReference;
    }

    public Jumpable getHighlightedReference() {
        return this.highlightedReference;
    }

    @Override
    public void notificationPrefsChanged() {
        this.applyPrefs();
    }

    @Override
    public void notificationDebuggerStarted() {
        this.refreshMainMenuBar();
        this.editorIdeas.hide();
    }

    @Override
    public void setEditable(boolean flag) {
        this.textEditor.setEditable(flag);
        if (flag) {
            this.getTextPane().requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComponentEditorGrammar.this.getTextPane().getCaret().setVisible(true);
                }
            });
        } else {
            this.getTextPane().getCaret().setVisible(flag);
        }
    }

    @Override
    public void componentDidAwake() {
        this.updateInformation();
        this.updateCursorInfo();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentEditorGrammar.this.getTextPane().requestFocusInWindow();
            }
        });
    }

    @Override
    public void componentActivated() {
        this.console.makeCurrent();
        this.engine.reset();
        this.engine.updateAll();
        this.textEditor.getTextPane().setWritable(this.isFileWritable());
        this.textEditor.refresh();
        this.updateInformation();
    }

    @Override
    public void componentDidHide() {
        this.editorIdeas.hide();
    }

    @Override
    public void componentIsSelected() {
        this.getTextPane().requestFocusInWindow();
    }

    @Override
    public void componentDocumentContentChanged() {
        if (!this.isFileExists()) {
            XJAlert.display(this.getWindowContainer(), "Warning", "The document cannot be found on the disk anymore.");
            return;
        }
        if (AWPrefs.isAlertFileChangesDetected()) {
            XJAlert alert = XJAlert.createInstance();
            alert.setDisplayDoNotShowAgainButton(true);
            int result = alert.showCustom(this.getWindowContainer(), "File Changes", "The file \"" + this.getFileName() + "\" changed on the disk. Do you want to reload it?", "Cancel", "Reload", 1, 0);
            AWPrefs.setAlertFileChangesDetected(!alert.isDoNotShowAgain());
            if (result == 0) {
                return;
            }
        }
        int oldCursorPosition = this.getCaretPosition();
        try {
            this.getDocument().reload();
        }
        catch (Exception e) {
            e.printStackTrace();
            XJAlert.display(this.getWindowContainer(), "Error Reloading Document", "An error occurred when reloading the document:\n" + e.toString());
        }
        this.grammarChanged();
        this.setCaretPosition(Math.min(oldCursorPosition, this.getText().length()));
    }

    @Override
    public List<String> autoCompletionMenuGetMatchingWordsForPartialWord(String partialWord) {
        if (this.engine.getNumberOfRules() == 0) {
            return null;
        }
        partialWord = partialWord.toLowerCase();
        ArrayList<String> matchingRules = new ArrayList<String>();
        if (this.rules.isRuleAtIndex(this.getCaretPosition())) {
            ArrayList<ElementRule> sortedRules = Collections.list(Collections.enumeration(this.engine.getRules()));
            Collections.sort(sortedRules, new Comparator<ElementRule>(){

                @Override
                public int compare(ElementRule o1, ElementRule o2) {
                    return o1.name.compareToIgnoreCase(o2.name);
                }
            });
            for (ElementRule rule : sortedRules) {
                if (!rule.name.toLowerCase().startsWith(partialWord) || matchingRules.contains(rule.name)) continue;
                matchingRules.add(rule.name);
            }
        } else {
            ArrayList<ElementReference> sortedUndefinedReferences = Collections.list(Collections.enumeration(this.engine.getUndefinedReferences()));
            Collections.sort(sortedUndefinedReferences, new Comparator<ElementReference>(){

                @Override
                public int compare(ElementReference o1, ElementReference o2) {
                    return o1.rule.name.compareToIgnoreCase(o2.rule.name);
                }
            });
            for (ElementReference ref : sortedUndefinedReferences) {
                String attr = ref.token.getAttribute();
                if (!attr.toLowerCase().startsWith(partialWord) || attr.equals(partialWord) || matchingRules.contains(attr)) continue;
                matchingRules.add(attr);
            }
        }
        return matchingRules;
    }

    @Override
    public void autoCompletionMenuWillDisplay() {
        this.editorIdeas.hide();
    }

    @Override
    public void ateChangeUpdate(int offset, int length, boolean insert) {
        this.changeDone();
        this.visual.cancelDrawingProcess();
    }

    @Override
    public void ateAutoIndent(int offset, int length) {
        try {
            GrammarAutoIndent.autoIndentOnSpecificKeys(this, this.getTextPane().getDocument(), offset, length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void ateMousePressed(Point point) {
        if (this.textEditor.getTextPane().isWritable()) {
            this.editorIdeas.display(point);
        }
        if (this.highlightedReference != null) {
            this.container.getActionGoTo().goToDeclaration(this.highlightedReference);
            this.highlightedReference = null;
        }
    }

    @Override
    public void ateMouseExited() {
        if (this.getTextPane().hasFocus()) {
            this.editorTips.hide();
        }
    }

    @Override
    public void ateMouseMoved(MouseEvent event) {
        Point pt = event.getPoint();
        if (this.getTextPane().hasFocus()) {
            Point absolutePoint = SwingUtilities.convertPoint(this.getTextPane(), pt, this.getJavaContainer());
            this.editorTips.display(pt, absolutePoint);
        }
        this.setHighlightedReference(null);
        if (event.isMetaDown() && XJSystem.isMacOS() || event.isControlDown()) {
            int index = this.textEditor.getTextIndexAtPosition(pt.x, pt.y);
            Comparable ref = this.getReferenceAtPosition(index);
            if (ref == null) {
                ref = this.getImportAtPosition(index);
            }
            this.setHighlightedReference((Jumpable)((Object)ref));
        }
    }

    @Override
    public void ateInvokePopUp(Component component, int x, int y) {
        JPopupMenu m = this.container.getContextualMenu(this.textEditor.getTextIndexAtPosition(x, y));
        if (m != null) {
            m.show(component, x, y);
        }
    }

    @Override
    public void ateCaretUpdate(int index) {
        this.updateCursorInfo();
        if (this.getTextPane().hasFocus()) {
            this.editorIdeas.hide();
            if (this.textEditor.getTextPane().isWritable()) {
                this.editorIdeas.display(this.getCaretPosition());
            }
        }
        this.autoCompletionMenu.updateAutoCompleteList();
        ElementRule rule = this.rules.selectRuleInTreeAtPosition(index);
        if (rule == null || rule.name == null) {
            this.updateVisualization(false);
            this.lastSelectedRule = null;
            return;
        }
        if (this.lastSelectedRule == null || !this.lastSelectedRule.equals(rule.name)) {
            this.lastSelectedRule = rule.name;
            this.updateVisualization(false);
        }
    }

    public void findTokensToIgnore(boolean reset) {
        this.rules.findTokensToIgnore(reset);
        this.interpreter.setRules(this.getNaturalRules());
    }

    @Override
    public boolean componentDocumentWillSave() {
        AWPrefs.setLastSavedDocument(this.getFilePath());
        if (!this.isFileWritable()) {
            XJAlert.display(this.getWindowContainer(), "Cannot Save", "This file cannot be saved. Check the file permission on the disk and try again.");
            return false;
        }
        return true;
    }

    public void print() {
        try {
            this.textEditor.print();
        }
        catch (PrinterException e) {
            XJAlert.display(this.getWindowContainer(), "Print Error", "An error occurred while printing:\n" + e.toString());
        }
    }

    public void showProgress(String title, XJDialogProgressDelegate delegate) {
        if (this.progress == null) {
            this.progress = new XJDialogProgress(this.getWindowContainer());
        }
        this.progress.setInfo(title);
        this.progress.setCancellable(true);
        this.progress.setDelegate(delegate);
        this.progress.setIndeterminate(true);
        this.progress.display();
    }

    public void hideProgress() {
        this.progress.close();
    }

    @Override
    public void goToBackward() {
        StatisticsAW.shared().recordEvent(24);
        if (this.goToHistory.canGoBack()) {
            this.setCaretPosition(this.goToHistory.getBackPosition(this.getCaretPosition()));
            this.refreshMainMenuBar();
        }
    }

    @Override
    public void goToForward() {
        StatisticsAW.shared().recordEvent(25);
        if (this.goToHistory.canGoForward()) {
            this.setCaretPosition(this.goToHistory.getForwardPosition());
            this.refreshMainMenuBar();
        }
    }

    @Override
    public void find() {
        StatisticsAW.shared().recordEvent(10);
        this.findAndReplace.find();
    }

    public ContextualMenuFactory createContextualMenuFactory() {
        return this.container.createContextualMenuFactory();
    }

    public Set<Integer> getBreakpoints() {
        return this.gutterColumnManager.getBreakpoints();
    }

    protected class ConsoleStatus {
        public Box box = Box.createHorizontalBox();
        public XJURLLabel label;
        public boolean visible;
        public int currentDisplayedLevel;

        public ConsoleStatus() {
            this.label = new XJURLLabel(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ComponentEditorGrammar.this.selectConsoleTab();
                    ConsoleStatus.this.clearMessage();
                }
            });
            this.clearMessage();
        }

        public void showMessage(String message, Color color) {
            this.label.setText(message);
            this.label.setUnvisitedURLColor(color);
            this.label.setVisitedURLColor(color);
            this.label.repaint();
        }

        public void showLevel(int level) {
            if (level == 0) {
                return;
            }
            if (!this.visible) {
                this.visible = true;
                this.box.removeAll();
                this.box.add(this.label);
                this.box.revalidate();
            }
            if (level > this.currentDisplayedLevel) {
                this.currentDisplayedLevel = level;
                if (level == 2) {
                    this.showMessage("Errors reported in console", Color.red);
                } else {
                    this.showMessage("Warnings reported in console", Color.blue);
                }
            }
        }

        public void clearMessage() {
            this.label.setText("");
            this.box.removeAll();
            this.box.add(Box.createHorizontalStrut(20));
            this.visible = false;
            this.currentDisplayedLevel = 0;
        }

        public JComponent getPanel() {
            return this.box;
        }
    }

    protected static class RuleTree
    extends XJTree {
        protected RuleTree() {
        }

        public String getToolTipText(MouseEvent e) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return "";
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            EditorRules.RuleTreeUserObject n = (EditorRules.RuleTreeUserObject)node.getUserObject();
            if (n == null) {
                return "";
            }
            ElementRule r = n.rule;
            if (r == null || !r.hasErrors()) {
                return "";
            }
            return r.getErrorMessageHTML();
        }
    }

    protected class AfterParseOperations
    extends ATEThread {
        public AfterParseOperations() {
            this.start();
        }

        protected void threadRun() throws Exception {
            ComponentEditorGrammar.this.afterParseOperations();
        }
    }
}

