/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JScrollPane;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.DetachablePanel;
import org.antlr.works.utils.StreamWatcherDelegate;
import org.antlr.works.utils.TextPane;
import org.antlr.works.utils.TextUtils;

public class DBOutputPanel
extends DetachablePanel
implements StreamWatcherDelegate {
    protected TextPane outputTextPane;
    protected Debugger debugger;

    public DBOutputPanel(Debugger debugger) {
        super("Output", debugger);
        this.debugger = debugger;
        this.outputTextPane = new TextPane();
        this.outputTextPane.setBackground(Color.white);
        this.outputTextPane.setBorder(null);
        this.outputTextPane.setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.outputTextPane.setText("");
        this.outputTextPane.setEditable(false);
        TextUtils.createTabs(this.outputTextPane);
        JScrollPane textScrollPane = new JScrollPane(this.outputTextPane);
        textScrollPane.setWheelScrollingEnabled(true);
        this.mainPanel.add((Component)textScrollPane, "Center");
    }

    public void close() {
        super.close();
        this.debugger = null;
    }

    public synchronized void streamWatcherDidStarted() {
        this.outputTextPane.setText("");
    }

    public synchronized void streamWatcherDidReceiveString(String string) {
        this.outputTextPane.setText(this.outputTextPane.getText() + string);
    }

    public synchronized void streamWatcherException(Exception e) {
        this.debugger.getConsole().println(e);
    }
}

