/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.dialog;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.antlr.works.IDE;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.HelpManager;
import org.antlr.works.utils.TextUtils;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.app.XJPreferences;
import org.antlr.xjlib.appkit.frame.XJPanel;
import org.antlr.xjlib.appkit.swing.XJLookAndFeel;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;

public class AWPrefsDialog
extends XJPanel {
    public static final String NOTIF_PREFS_APPLIED = "NOTIF_PREFS_APPLIED";
    protected ButtonGroup compilerRadioButtonGroup;
    protected ButtonGroup testRigRadioButtonGroup;
    protected int lafIndex = 0;
    private JPanel dialogPane;
    private JPanel contentPane;
    private JTabbedPane tabbedPane1;
    private JPanel tabGeneral;
    private JLabel label2;
    private JLabel label5;
    private JComboBox lafCombo;
    private JComboBox startupActionCombo;
    private JCheckBox restoreWindowsBoundButton;
    private JCheckBox desktopModeButton;
    private JLabel label25;
    private JTextField outputPathField;
    private JButton browseOutputPathButton;
    private JLabel label24;
    private JTextField dotToolPathField;
    private JButton browseDotToolPathButton;
    private JLabel label37;
    private JTextField antlr3OptionsField;
    private JPanel tabEditor;
    private JLabel label3;
    private JComboBox editorFontCombo;
    private JSpinner editorFontSizeSpinner;
    private JCheckBox autoSaveButton;
    private JTextField autoSaveDelayField;
    private JLabel label11;
    private JCheckBox backupFileButton;
    private JCheckBox highlightCursorLineButton;
    private JCheckBox smoothScrollingButton;
    private JCheckBox autoIndentColonInRuleButton;
    private JCheckBox showLineNumbers;
    private JCheckBox vstyleAutocompletionButton;
    private JLabel label1;
    private JTextField tabWidthField;
    private JLabel label22;
    private JTextField parserDelayField;
    private JLabel label23;
    private JPanel tabSyntax;
    private JLabel label26;
    private JPanel parserColorPanel;
    private JCheckBox parserBoldButton;
    private JCheckBox parserItalicButton;
    private JLabel label27;
    private JPanel lexerColorPanel;
    private JCheckBox lexerBoldButton;
    private JCheckBox lexerItalicButton;
    private JLabel label28;
    private JPanel labelColorPanel;
    private JCheckBox labelsBoldButton;
    private JCheckBox labelsItalicButton;
    private JLabel label29;
    private JPanel refsActionColorPanel;
    private JCheckBox refsActionBoldButton;
    private JCheckBox refsActionItalicButton;
    private JLabel label38;
    private JPanel blockLabelsColorPanel;
    private JCheckBox blockLabelsBoldButton;
    private JCheckBox blockLabelsItalicButton;
    private JLabel label30;
    private JPanel commentsColorPanel;
    private JCheckBox commentsBoldButton;
    private JCheckBox commentsItalicButton;
    private JLabel label31;
    private JPanel stringsColorPanel;
    private JCheckBox stringsBoldButton;
    private JCheckBox stringsItalicButton;
    private JLabel label32;
    private JPanel keywordsColorPanel;
    private JCheckBox keywordsBoldButton;
    private JCheckBox keywordsItalicButton;
    private JButton syntaxDefaultButton;
    private JPanel tabCompiler;
    private JRadioButton jikesRadio;
    private JRadioButton integratedRadio;
    private JRadioButton javacRadio;
    private JCheckBox javacCustomPathButton;
    private JTextField javacPathField;
    private JButton browseJavacPath;
    private JLabel label4;
    private JTextField jikesPathField;
    private JButton browseJikesPath;
    private JLabel label9;
    private JCheckBox classpathSystemButton;
    private JCheckBox classpathCustomButton;
    private JTextField customClasspathField;
    private JButton browseCustomClassPathButton;
    private JPanel tabDebugger;
    private JLabel label33;
    private JTextField debugDefaultLocalPortField;
    private JLabel label34;
    private JTextField debugLaunchTimeoutField;
    private JLabel label35;
    private JLabel label12;
    private JPanel debugNonConsumedColorPanel;
    private JLabel label13;
    private JPanel debugConsumedColorPanel;
    private JLabel label14;
    private JPanel debugHiddenColorPanel;
    private JLabel label15;
    private JPanel debugDeadColorPanel;
    private JLabel label16;
    private JPanel debugLTColorPanel;
    private JLabel label36;
    private JCheckBox detachablePanelChildrenButton;
    private JCheckBox askGenButton;
    private JPanel panel1;
    private JLabel label8;
    private JCheckBox checkGrammarSuccessButton;
    private JCheckBox generateCodeSuccessButton;
    private JCheckBox fileModifiedOnDiskButton;
    private JCheckBox interpreterLimitationButton;
    private JLabel label6;
    private JCheckBox clearConsoleBeforeCheckButton;
    private JPanel tabUpdates;
    private JLabel label7;
    private JComboBox updateTypeCombo;
    private JButton checkForUpdatesButton;
    private JLabel label10;
    private JTextField downloadPathField;
    private JButton browseUpdateDownloadPathButton;
    private JPanel tabTestRig;
    private JLabel label17;
    private JComboBox testRigLanguageComboBox;
    private JRadioButton testRigDefaultRadio;
    private JRadioButton testRigTextRadio;
    private JScrollPane scrollPane1;
    private JTextPane testTextArea;
    private JPanel buttonBar;
    private JButton applyButton;

    public AWPrefsDialog() {
        this.initComponents();
        this.prepareGeneralTab();
        this.prepareEditorTab();
        this.prepareSyntaxTab();
        this.prepareCompilerTab();
        this.prepareDebuggerTab();
        this.prepareAdvancedTab();
        this.prepareUpdateTab();
        this.prepareTestRigTab();
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AWPrefsDialog.this.apply();
            }
        });
    }

    public void prepareGeneralTab() {
        UIManager.LookAndFeelInfo[] info;
        this.browseOutputPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.outputPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setOutputPath(AWPrefsDialog.this.outputPathField.getText());
                }
            }
        });
        this.browseDotToolPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (XJFileChooser.shared().displayOpenDialog(AWPrefsDialog.this.getJavaContainer(), false)) {
                    AWPrefsDialog.this.dotToolPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setDOTToolPath(AWPrefsDialog.this.dotToolPathField.getText());
                }
            }
        });
        this.lafCombo.removeAllItems();
        for (UIManager.LookAndFeelInfo anInfo : info = UIManager.getInstalledLookAndFeels()) {
            this.lafCombo.addItem(anInfo.getName());
        }
        this.lafCombo.setEnabled(!IDE.isPlugin());
        AWPrefsDialog.getPreferences().bindToPreferences(this.startupActionCombo, "PREF_STARTUP_ACTION", 1);
        AWPrefsDialog.getPreferences().bindToPreferences(this.restoreWindowsBoundButton, "PREF_RESTORE_WINDOWS", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.lafCombo, "PREF_LOOK_AND_FEEL", XJLookAndFeel.getDefaultLookAndFeelName());
        AWPrefsDialog.getPreferences().bindToPreferences(this.desktopModeButton, "PREF_DESKTOP_MODE", AWPrefs.DEFAULT_DESKTOP_MODE);
        AWPrefsDialog.getPreferences().bindToPreferences(this.outputPathField, "PREF_OUTPUT_PATH", "output");
        AWPrefsDialog.getPreferences().bindToPreferences(this.dotToolPathField, "PREF_DOT_TOOL_PATH", AWPrefs.DEFAULT_DOT_TOOL_PATH);
        AWPrefsDialog.getPreferences().bindToPreferences(this.antlr3OptionsField, "PREF_ANTLR3_OPTIONS", "");
    }

    public void prepareEditorTab() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.editorFontCombo.removeAllItems();
        for (String fontName : fontNames) {
            this.editorFontCombo.addItem(fontName);
        }
        AWPrefsDialog.getPreferences().bindToPreferences(this.autoSaveButton, "PREF_AUTOSAVE_ENABLED", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.autoSaveDelayField, "PREF_AUTOSAVE_DELAY", 5);
        AWPrefsDialog.getPreferences().bindToPreferences(this.backupFileButton, "PREF_BACKUP_FILE_ENABLED", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.highlightCursorLineButton, "PREF_HIGHLIGHTCURSORLINE", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.tabWidthField, "PREF_TAB_WIDTH", 8);
        AWPrefsDialog.getPreferences().bindToPreferences(this.editorFontCombo, "PREF_EDITOR_FONT", AWPrefs.DEFAULT_EDITOR_FONT);
        AWPrefsDialog.getPreferences().bindToPreferences(this.editorFontSizeSpinner, "PREF_EDITOR_FONT_SIZE", 12);
        AWPrefsDialog.getPreferences().bindToPreferences(this.parserDelayField, "PREF_PARSER_DELAY", 250);
        AWPrefsDialog.getPreferences().bindToPreferences(this.autoIndentColonInRuleButton, "PREF_AUTO_IDENT_COLON_RULE", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.showLineNumbers, "PREF_LINE_NUMBER", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.vstyleAutocompletionButton, "PREF_VSTYLE_AUTOCOMPLETION", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.smoothScrollingButton, "PREF_SMOOTH_SCROLLING", true);
    }

    public void bindSyntax(String identifier, JPanel colorPanel, JCheckBox bold, JCheckBox italic) {
        AWPrefsDialog.getPreferences().bindToPreferences(colorPanel, AWPrefs.getSyntaxColorKey(identifier), AWPrefs.getSyntaxDefaultColor(identifier));
        AWPrefsDialog.getPreferences().bindToPreferences(bold, AWPrefs.getSyntaxBoldKey(identifier), AWPrefs.getSyntaxDefaultBold(identifier));
        AWPrefsDialog.getPreferences().bindToPreferences(italic, AWPrefs.getSyntaxItalicKey(identifier), AWPrefs.getSyntaxDefaultItalic(identifier));
    }

    public void defaultSyntax(String identifier, JPanel colorPanel, JCheckBox bold, JCheckBox italic) {
        AWPrefsDialog.getPreferences().defaultPreference(colorPanel, AWPrefs.getSyntaxColorKey(identifier), AWPrefs.getSyntaxDefaultColor(identifier));
        AWPrefsDialog.getPreferences().defaultPreference(bold, AWPrefs.getSyntaxBoldKey(identifier), AWPrefs.getSyntaxDefaultBold(identifier));
        AWPrefsDialog.getPreferences().defaultPreference(italic, AWPrefs.getSyntaxItalicKey(identifier), AWPrefs.getSyntaxDefaultItalic(identifier));
    }

    public void prepareSyntaxTab() {
        this.syntaxDefaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_PARSER", AWPrefsDialog.this.parserColorPanel, AWPrefsDialog.this.parserBoldButton, AWPrefsDialog.this.parserItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_LEXER", AWPrefsDialog.this.lexerColorPanel, AWPrefsDialog.this.lexerBoldButton, AWPrefsDialog.this.lexerItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_LABEL", AWPrefsDialog.this.labelColorPanel, AWPrefsDialog.this.labelsBoldButton, AWPrefsDialog.this.labelsItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_REFS", AWPrefsDialog.this.refsActionColorPanel, AWPrefsDialog.this.refsActionBoldButton, AWPrefsDialog.this.refsActionItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_BLOCK", AWPrefsDialog.this.blockLabelsColorPanel, AWPrefsDialog.this.blockLabelsBoldButton, AWPrefsDialog.this.blockLabelsItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_COMMENT", AWPrefsDialog.this.commentsColorPanel, AWPrefsDialog.this.commentsBoldButton, AWPrefsDialog.this.commentsItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_STRING", AWPrefsDialog.this.stringsColorPanel, AWPrefsDialog.this.stringsBoldButton, AWPrefsDialog.this.stringsItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_KEYWORD", AWPrefsDialog.this.keywordsColorPanel, AWPrefsDialog.this.keywordsBoldButton, AWPrefsDialog.this.keywordsItalicButton);
            }
        });
        this.bindSyntax("PREF_SYNTAX_PARSER", this.parserColorPanel, this.parserBoldButton, this.parserItalicButton);
        this.bindSyntax("PREF_SYNTAX_LEXER", this.lexerColorPanel, this.lexerBoldButton, this.lexerItalicButton);
        this.bindSyntax("PREF_SYNTAX_LABEL", this.labelColorPanel, this.labelsBoldButton, this.labelsItalicButton);
        this.bindSyntax("PREF_SYNTAX_REFS", this.refsActionColorPanel, this.refsActionBoldButton, this.refsActionItalicButton);
        this.bindSyntax("PREF_SYNTAX_BLOCK", this.blockLabelsColorPanel, this.blockLabelsBoldButton, this.blockLabelsItalicButton);
        this.bindSyntax("PREF_SYNTAX_COMMENT", this.commentsColorPanel, this.commentsBoldButton, this.commentsItalicButton);
        this.bindSyntax("PREF_SYNTAX_STRING", this.stringsColorPanel, this.stringsBoldButton, this.stringsItalicButton);
        this.bindSyntax("PREF_SYNTAX_KEYWORD", this.keywordsColorPanel, this.keywordsBoldButton, this.keywordsItalicButton);
    }

    public void prepareCompilerTab() {
        this.javacCustomPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWPrefsDialog.this.javacPathField.setEnabled(AWPrefsDialog.this.javacCustomPathButton.isSelected());
                AWPrefsDialog.this.browseJavacPath.setEnabled(AWPrefsDialog.this.javacCustomPathButton.isSelected());
            }
        });
        this.browseJavacPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.javacPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setJavaCPath(AWPrefsDialog.this.javacPathField.getText());
                }
            }
        });
        this.browseJikesPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.jikesPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setJikesPath(AWPrefsDialog.this.jikesPathField.getText());
                }
            }
        });
        this.classpathCustomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AWPrefsDialog.this.customClasspathField.setEnabled(AWPrefsDialog.this.classpathCustomButton.isSelected());
                AWPrefsDialog.this.browseCustomClassPathButton.setEnabled(AWPrefsDialog.this.classpathCustomButton.isSelected());
            }
        });
        this.browseCustomClassPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.customClasspathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setCustomClassPath(AWPrefsDialog.this.customClasspathField.getText());
                }
            }
        });
        this.compilerRadioButtonGroup = new ButtonGroup();
        this.compilerRadioButtonGroup.add(this.jikesRadio);
        this.compilerRadioButtonGroup.add(this.integratedRadio);
        this.compilerRadioButtonGroup.add(this.javacRadio);
        this.integratedRadio.setActionCommand("integrated");
        this.javacRadio.setActionCommand("javac");
        this.jikesRadio.setActionCommand("jikes");
        AWPrefsDialog.getPreferences().bindToPreferences(this.javacCustomPathButton, "PREF_JAVAC_CUSTOM_PATH", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.javacPathField, "PREF_JAVAC_PATH", "");
        AWPrefsDialog.getPreferences().bindToPreferences(this.jikesPathField, "PREF_JIKES_PATH", "");
        AWPrefsDialog.getPreferences().bindToPreferences(this.compilerRadioButtonGroup, "PREF_COMPILER", "javac");
        AWPrefsDialog.getPreferences().bindToPreferences(this.classpathSystemButton, "PREF_CLASSPATH_SYSTEM", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.classpathCustomButton, "PREF_CLASSPATH_CUSTOM", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.customClasspathField, "PREF_CUSTOM_CLASS_PATH", "");
    }

    public void prepareDebuggerTab() {
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugDefaultLocalPortField, "PREF_DEBUG_LOCALPORT", 49100);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugLaunchTimeoutField, "PREF_DEBUG_LAUNCHTIMEOUT", 5);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugNonConsumedColorPanel, "PREF_NONCONSUMED_TOKEN_COLOR2", AWPrefs.DEFAULT_NONCONSUMED_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugConsumedColorPanel, "PREF_CONSUMED_TOKEN_COLOR2", AWPrefs.DEFAULT_CONSUMED_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugHiddenColorPanel, "PREF_HIDDEN_TOKEN_COLOR2", AWPrefs.DEFAULT_HIDDEN_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugDeadColorPanel, "PREF_DEAD_TOKEN_COLOR2", AWPrefs.DEFAULT_DEAD_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugLTColorPanel, "PREF_LOOKAHEAD_TOKEN_COLOR2", AWPrefs.DEFAULT_LOOKAHEAD_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.detachablePanelChildrenButton, "PREF_DETACHABLE_CHILDREN", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.askGenButton, "PREF_DEBUGGER_ASK_GEN", false);
    }

    public void prepareAdvancedTab() {
        AWPrefsDialog.getPreferences().bindToPreferences(this.checkGrammarSuccessButton, "PREF_ALERT_CHECK_GRAMMAR_SUCCESS", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.generateCodeSuccessButton, "PREF_ALERT_GENERATE_CODE_SUCCESS", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.fileModifiedOnDiskButton, "PREF_ALERT_FILE_CHANGES_DETECTED", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.interpreterLimitationButton, "PREF_ALERT_INTERPRETER_LIMITATION", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.clearConsoleBeforeCheckButton, "PREF_CLEAR_CONSOLE_BEFORE_CHECK", false);
    }

    public void prepareUpdateTab() {
        this.browseUpdateDownloadPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.downloadPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setDownloadPath(AWPrefsDialog.this.downloadPathField.getText());
                }
            }
        });
        this.checkForUpdatesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HelpManager.checkUpdates(AWPrefsDialog.this.getJavaContainer(), false);
            }
        });
        AWPrefsDialog.getPreferences().bindToPreferences(this.updateTypeCombo, "PREF_UPDATE_TYPE", 3);
        AWPrefsDialog.getPreferences().bindToPreferences(this.downloadPathField, "PREF_DOWNLOAD_PATH", AWPrefs.DEFAULT_DOWNLOAD_PATH);
    }

    public void prepareTestRigTab() {
        this.testRigRadioButtonGroup = new ButtonGroup();
        this.testRigRadioButtonGroup.add(this.testRigDefaultRadio);
        this.testRigRadioButtonGroup.add(this.testRigTextRadio);
        TextUtils.createTabs(this.testTextArea);
        TextUtils.setDefaultTextPaneProperties(this.testTextArea);
        this.testTextArea.setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.testTextArea.setFocusable(true);
        this.testTextArea.requestFocusInWindow();
        this.testRigLanguageComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWPrefsDialog.this.prepareTestRigTabValues();
            }
        });
        this.testRigDefaultRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AWPrefsDialog.this.testRigDefaultRadio.isSelected()) {
                    AWPrefsDialog.this.testTextArea.setEnabled(false);
                } else {
                    AWPrefsDialog.this.testTextArea.setEnabled(true);
                }
            }
        });
        this.testRigTextRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AWPrefsDialog.this.testRigDefaultRadio.isSelected()) {
                    AWPrefsDialog.this.testTextArea.setEnabled(false);
                } else {
                    AWPrefsDialog.this.testTextArea.setEnabled(true);
                }
            }
        });
        this.prepareTestRigTabValues();
    }

    private void prepareTestRigTabValues() {
        String grammarLanguage = this.testRigLanguageComboBox.getSelectedItem().toString();
        this.testTextArea.setText(AWPrefs.getTestRigTemplateTextByLanguage(grammarLanguage));
        if ("".equals(this.testTextArea.getText())) {
            try {
                if ("JAVA".equalsIgnoreCase(grammarLanguage)) {
                    this.testTextArea.setText(Utils.stringFromFile(IDE.getApplicationPath() + File.separatorChar + "templates/" + "DBParserGlueCode" + ".st"));
                } else if ("PYTHON".equalsIgnoreCase(grammarLanguage)) {
                    this.testTextArea.setText(Utils.stringFromFile(IDE.getApplicationPath() + File.separatorChar + "templates/" + "DBParserGlueCode" + "_python.st"));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ("default".equals(AWPrefs.getTestRigTemplateModeByLanguage(grammarLanguage))) {
            this.testRigDefaultRadio.setSelected(true);
            this.testTextArea.setEnabled(false);
        } else {
            this.testRigTextRadio.setSelected(true);
            this.testTextArea.setEnabled(true);
        }
    }

    private void applyTestRigPrefs() {
        String grammarLanguage = this.testRigLanguageComboBox.getSelectedItem().toString();
        AWPrefs.setTestRigTemplateModeByLanguage(grammarLanguage, this.testRigDefaultRadio.isSelected() ? "default" : "text");
        AWPrefs.setTestRigTemplateTextByLanguage(grammarLanguage, this.testTextArea.getText());
    }

    public void displayTestRigTab() {
        this.tabbedPane1.setSelectedComponent(this.tabTestRig);
    }

    public void becomingVisibleForTheFirstTime() {
        this.lafIndex = this.lafCombo.getSelectedIndex();
        this.javacPathField.setEnabled(this.javacCustomPathButton.isSelected());
        this.browseJavacPath.setEnabled(this.javacCustomPathButton.isSelected());
        this.customClasspathField.setEnabled(this.classpathCustomButton.isSelected());
        this.browseCustomClassPathButton.setEnabled(this.classpathCustomButton.isSelected());
        StatisticsAW.shared().recordEvent(130);
    }

    public boolean close(boolean force) {
        this.apply();
        return super.close(force);
    }

    public boolean isAuxiliaryWindow() {
        return true;
    }

    public static void applyCommonPrefs() {
        XJApplication.setAutoSave(AWPrefs.getAutoSaveEnabled(), AWPrefs.getAutoSaveDelay());
    }

    public JComponent getComponent() {
        return this.tabbedPane1;
    }

    public void apply() {
        this.dialogPane.requestFocusInWindow();
        AWPrefsDialog.getPreferences().applyPreferences();
        if (this.lafIndex != this.lafCombo.getSelectedIndex()) {
            this.lafIndex = this.lafCombo.getSelectedIndex();
            if (!IDE.isPlugin()) {
                this.changeLookAndFeel();
            }
        }
        AWPrefsDialog.applyCommonPrefs();
        this.applyTestRigPrefs();
        XJNotificationCenter.defaultCenter().postNotification(this, NOTIF_PREFS_APPLIED);
    }

    private void changeLookAndFeel() {
        XJLookAndFeel.applyLookAndFeel(AWPrefs.getLookAndFeel());
    }

    private static XJPreferences getPreferences() {
        return XJApplication.shared().getPreferences();
    }

    public boolean shouldDisplayMainMenuBar() {
        return super.shouldDisplayMainMenuBar() && !IDE.isPlugin();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPane = new JPanel();
        this.tabbedPane1 = new JTabbedPane();
        this.tabGeneral = new JPanel();
        this.label2 = new JLabel();
        this.label5 = new JLabel();
        this.lafCombo = new JComboBox();
        this.startupActionCombo = new JComboBox();
        this.restoreWindowsBoundButton = new JCheckBox();
        this.desktopModeButton = new JCheckBox();
        this.label25 = new JLabel();
        this.outputPathField = new JTextField();
        this.browseOutputPathButton = new JButton();
        this.label24 = new JLabel();
        this.dotToolPathField = new JTextField();
        this.browseDotToolPathButton = new JButton();
        this.label37 = new JLabel();
        this.antlr3OptionsField = new JTextField();
        this.tabEditor = new JPanel();
        this.label3 = new JLabel();
        this.editorFontCombo = new JComboBox();
        this.editorFontSizeSpinner = new JSpinner();
        this.autoSaveButton = new JCheckBox();
        this.autoSaveDelayField = new JTextField();
        this.label11 = new JLabel();
        this.backupFileButton = new JCheckBox();
        this.highlightCursorLineButton = new JCheckBox();
        this.smoothScrollingButton = new JCheckBox();
        this.autoIndentColonInRuleButton = new JCheckBox();
        this.showLineNumbers = new JCheckBox();
        this.vstyleAutocompletionButton = new JCheckBox();
        this.label1 = new JLabel();
        this.tabWidthField = new JTextField();
        this.label22 = new JLabel();
        this.parserDelayField = new JTextField();
        this.label23 = new JLabel();
        this.tabSyntax = new JPanel();
        this.label26 = new JLabel();
        this.parserColorPanel = new JPanel();
        this.parserBoldButton = new JCheckBox();
        this.parserItalicButton = new JCheckBox();
        this.label27 = new JLabel();
        this.lexerColorPanel = new JPanel();
        this.lexerBoldButton = new JCheckBox();
        this.lexerItalicButton = new JCheckBox();
        this.label28 = new JLabel();
        this.labelColorPanel = new JPanel();
        this.labelsBoldButton = new JCheckBox();
        this.labelsItalicButton = new JCheckBox();
        this.label29 = new JLabel();
        this.refsActionColorPanel = new JPanel();
        this.refsActionBoldButton = new JCheckBox();
        this.refsActionItalicButton = new JCheckBox();
        this.label38 = new JLabel();
        this.blockLabelsColorPanel = new JPanel();
        this.blockLabelsBoldButton = new JCheckBox();
        this.blockLabelsItalicButton = new JCheckBox();
        this.label30 = new JLabel();
        this.commentsColorPanel = new JPanel();
        this.commentsBoldButton = new JCheckBox();
        this.commentsItalicButton = new JCheckBox();
        this.label31 = new JLabel();
        this.stringsColorPanel = new JPanel();
        this.stringsBoldButton = new JCheckBox();
        this.stringsItalicButton = new JCheckBox();
        this.label32 = new JLabel();
        this.keywordsColorPanel = new JPanel();
        this.keywordsBoldButton = new JCheckBox();
        this.keywordsItalicButton = new JCheckBox();
        this.syntaxDefaultButton = new JButton();
        this.tabCompiler = new JPanel();
        this.jikesRadio = new JRadioButton();
        this.integratedRadio = new JRadioButton();
        this.javacRadio = new JRadioButton();
        this.javacCustomPathButton = new JCheckBox();
        this.javacPathField = new JTextField();
        this.browseJavacPath = new JButton();
        this.label4 = new JLabel();
        this.jikesPathField = new JTextField();
        this.browseJikesPath = new JButton();
        this.label9 = new JLabel();
        this.classpathSystemButton = new JCheckBox();
        this.classpathCustomButton = new JCheckBox();
        this.customClasspathField = new JTextField();
        this.browseCustomClassPathButton = new JButton();
        this.tabDebugger = new JPanel();
        this.label33 = new JLabel();
        this.debugDefaultLocalPortField = new JTextField();
        this.label34 = new JLabel();
        this.debugLaunchTimeoutField = new JTextField();
        this.label35 = new JLabel();
        this.label12 = new JLabel();
        this.debugNonConsumedColorPanel = new JPanel();
        this.label13 = new JLabel();
        this.debugConsumedColorPanel = new JPanel();
        this.label14 = new JLabel();
        this.debugHiddenColorPanel = new JPanel();
        this.label15 = new JLabel();
        this.debugDeadColorPanel = new JPanel();
        this.label16 = new JLabel();
        this.debugLTColorPanel = new JPanel();
        this.label36 = new JLabel();
        this.detachablePanelChildrenButton = new JCheckBox();
        this.askGenButton = new JCheckBox();
        this.panel1 = new JPanel();
        this.label8 = new JLabel();
        this.checkGrammarSuccessButton = new JCheckBox();
        this.generateCodeSuccessButton = new JCheckBox();
        this.fileModifiedOnDiskButton = new JCheckBox();
        this.interpreterLimitationButton = new JCheckBox();
        this.label6 = new JLabel();
        this.clearConsoleBeforeCheckButton = new JCheckBox();
        this.tabUpdates = new JPanel();
        this.label7 = new JLabel();
        this.updateTypeCombo = new JComboBox();
        this.checkForUpdatesButton = new JButton();
        this.label10 = new JLabel();
        this.downloadPathField = new JTextField();
        this.browseUpdateDownloadPathButton = new JButton();
        this.tabTestRig = new JPanel();
        this.label17 = new JLabel();
        this.testRigLanguageComboBox = new JComboBox();
        this.testRigDefaultRadio = new JRadioButton();
        this.testRigTextRadio = new JRadioButton();
        this.scrollPane1 = new JScrollPane();
        this.testTextArea = new JTextPane();
        this.buttonBar = new JPanel();
        this.applyButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Preferences");
        Container contentPane2 = this.getContentPane();
        contentPane2.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setMinimumSize(new Dimension(540, 350));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPane.setLayout(new FormLayout("default, default:grow", "fill:default:grow"));
        this.tabGeneral.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;20dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;40dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label2.setText("At startup:");
        this.tabGeneral.add((Component)this.label2, cc.xy(3, 3));
        this.label5.setText("Look and feel:");
        this.tabGeneral.add((Component)this.label5, cc.xy(3, 7));
        this.tabGeneral.add((Component)this.lafCombo, cc.xywh(5, 7, 3, 1));
        this.startupActionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Create a new document", "Open the last opened document", "Open the last saved document", "Open all opened documents when ANTLRWorks was closed"}));
        this.tabGeneral.add((Component)this.startupActionCombo, cc.xywh(5, 3, 3, 1));
        this.restoreWindowsBoundButton.setText("Restore project's windows position and size");
        this.tabGeneral.add((Component)this.restoreWindowsBoundButton, cc.xywh(5, 5, 3, 1));
        this.desktopModeButton.setText("Desktop Mode");
        this.desktopModeButton.setToolTipText("This option will take effect after restarting ANTLRWorks");
        this.tabGeneral.add((Component)this.desktopModeButton, cc.xywh(5, 9, 3, 1));
        this.label25.setText("Output path:");
        this.tabGeneral.add((Component)this.label25, cc.xy(3, 11));
        this.outputPathField.setToolTipText("Relative path will be generated in the same directory as the grammar itself");
        this.tabGeneral.add((Component)this.outputPathField, cc.xywh(5, 11, 3, 1));
        this.browseOutputPathButton.setText("Browse...");
        this.tabGeneral.add((Component)this.browseOutputPathButton, cc.xy(9, 11));
        this.label24.setText("DOT path:");
        this.tabGeneral.add((Component)this.label24, cc.xy(3, 13));
        this.dotToolPathField.setToolTipText("Absolute path to the DOT command-line tool");
        this.tabGeneral.add((Component)this.dotToolPathField, cc.xywh(5, 13, 3, 1));
        this.browseDotToolPathButton.setText("Browse...");
        this.tabGeneral.add((Component)this.browseDotToolPathButton, cc.xy(9, 13));
        this.label37.setText("ANTLR options:");
        this.tabGeneral.add((Component)this.label37, cc.xy(3, 15));
        this.tabGeneral.add((Component)this.antlr3OptionsField, cc.xywh(5, 15, 3, 1));
        this.tabbedPane1.addTab("General", this.tabGeneral);
        this.tabEditor.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(20)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;45dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(20)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(30)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10))}));
        this.label3.setText("Font:");
        this.tabEditor.add((Component)this.label3, cc.xy(3, 3));
        this.editorFontCombo.setActionCommand("editorFontCombo");
        this.tabEditor.add((Component)this.editorFontCombo, cc.xywh(5, 3, 5, 1));
        this.editorFontSizeSpinner.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(8), null, (Number)1));
        this.tabEditor.add((Component)this.editorFontSizeSpinner, cc.xy(11, 3));
        this.autoSaveButton.setText("Auto-save every");
        this.tabEditor.add((Component)this.autoSaveButton, cc.xywh(5, 5, 3, 1));
        this.tabEditor.add((Component)this.autoSaveDelayField, cc.xy(9, 5));
        this.label11.setText("minutes");
        this.tabEditor.add((Component)this.label11, cc.xy(11, 5));
        this.backupFileButton.setText("Create backup file");
        this.tabEditor.add((Component)this.backupFileButton, cc.xywh(5, 7, 5, 1));
        this.highlightCursorLineButton.setText("Highlight cursor line");
        this.tabEditor.add((Component)this.highlightCursorLineButton, cc.xywh(5, 9, 5, 1));
        this.smoothScrollingButton.setText("Smooth scrolling");
        this.tabEditor.add((Component)this.smoothScrollingButton, cc.xywh(5, 11, 3, 1));
        this.autoIndentColonInRuleButton.setText("Auto-indent ':' in rule");
        this.tabEditor.add((Component)this.autoIndentColonInRuleButton, cc.xywh(5, 13, 7, 1));
        this.showLineNumbers.setText("Show line numbers");
        this.tabEditor.add((Component)this.showLineNumbers, cc.xywh(5, 15, 5, 1));
        this.vstyleAutocompletionButton.setText("Visual Studio auto-completion menu");
        this.vstyleAutocompletionButton.setToolTipText("Displayed when a space is pressed, remember previous auto-completed word, continues to auto-complete without decreasing the word choice as you type");
        this.tabEditor.add((Component)this.vstyleAutocompletionButton, cc.xywh(5, 17, 9, 1));
        this.label1.setText("Tab width:");
        this.label1.setHorizontalAlignment(4);
        this.tabEditor.add((Component)this.label1, cc.xy(3, 19));
        this.tabWidthField.setText("8");
        this.tabEditor.add((Component)this.tabWidthField, cc.xy(5, 19));
        this.label22.setText("Update delay:");
        this.tabEditor.add((Component)this.label22, cc.xy(3, 21));
        this.parserDelayField.setText("250");
        this.tabEditor.add((Component)this.parserDelayField, cc.xy(5, 21));
        this.label23.setText("ms");
        this.tabEditor.add((Component)this.label23, cc.xy(7, 21));
        this.tabbedPane1.addTab("Editor", this.tabEditor);
        this.tabSyntax.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(20)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label26.setText("Parser References:");
        this.tabSyntax.add((Component)this.label26, cc.xywh(3, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.parserColorPanel.setForeground(Color.black);
        this.parserColorPanel.setPreferredSize(new Dimension(70, 20));
        this.parserColorPanel.setBackground(new Color(255, 255, 51));
        this.parserColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.parserColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.parserColorPanel, cc.xy(5, 3));
        this.parserBoldButton.setText("Bold");
        this.parserBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.parserBoldButton, cc.xy(7, 3));
        this.parserItalicButton.setText("Italic");
        this.parserItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.parserItalicButton, cc.xy(9, 3));
        this.label27.setText("Lexer References:");
        this.tabSyntax.add((Component)this.label27, cc.xy(3, 5));
        this.lexerColorPanel.setForeground(Color.black);
        this.lexerColorPanel.setPreferredSize(new Dimension(70, 20));
        this.lexerColorPanel.setBackground(new Color(255, 255, 51));
        this.lexerColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.lexerColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.lexerColorPanel, cc.xy(5, 5));
        this.lexerBoldButton.setText("Bold");
        this.lexerBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.lexerBoldButton, cc.xy(7, 5));
        this.lexerItalicButton.setText("Italic");
        this.lexerItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.lexerItalicButton, cc.xy(9, 5));
        this.label28.setText("Labels:");
        this.tabSyntax.add((Component)this.label28, cc.xy(3, 7));
        this.labelColorPanel.setForeground(Color.black);
        this.labelColorPanel.setPreferredSize(new Dimension(70, 20));
        this.labelColorPanel.setBackground(new Color(255, 255, 51));
        this.labelColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.labelColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.labelColorPanel, cc.xy(5, 7));
        this.labelsBoldButton.setText("Bold");
        this.labelsBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.labelsBoldButton, cc.xy(7, 7));
        this.labelsItalicButton.setText("Italic");
        this.labelsItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.labelsItalicButton, cc.xy(9, 7));
        this.label29.setText("References in action:");
        this.tabSyntax.add((Component)this.label29, cc.xy(3, 9));
        this.refsActionColorPanel.setForeground(Color.black);
        this.refsActionColorPanel.setPreferredSize(new Dimension(70, 20));
        this.refsActionColorPanel.setBackground(new Color(255, 255, 51));
        this.refsActionColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.refsActionColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.refsActionColorPanel, cc.xy(5, 9));
        this.refsActionBoldButton.setText("Bold");
        this.refsActionBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.refsActionBoldButton, cc.xy(7, 9));
        this.refsActionItalicButton.setText("Italic");
        this.refsActionItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.refsActionItalicButton, cc.xy(9, 9));
        this.label38.setText("Blocks:");
        this.tabSyntax.add((Component)this.label38, cc.xy(3, 11));
        this.blockLabelsColorPanel.setForeground(Color.black);
        this.blockLabelsColorPanel.setPreferredSize(new Dimension(70, 20));
        this.blockLabelsColorPanel.setBackground(new Color(255, 255, 51));
        this.blockLabelsColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.blockLabelsColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.blockLabelsColorPanel, cc.xy(5, 11));
        this.blockLabelsBoldButton.setText("Bold");
        this.blockLabelsBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.blockLabelsBoldButton, cc.xy(7, 11));
        this.blockLabelsItalicButton.setText("Italic");
        this.blockLabelsItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.blockLabelsItalicButton, cc.xy(9, 11));
        this.label30.setText("Comments:");
        this.tabSyntax.add((Component)this.label30, cc.xy(3, 13));
        this.commentsColorPanel.setForeground(Color.black);
        this.commentsColorPanel.setPreferredSize(new Dimension(70, 20));
        this.commentsColorPanel.setBackground(new Color(255, 255, 51));
        this.commentsColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.commentsColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.commentsColorPanel, cc.xy(5, 13));
        this.commentsBoldButton.setText("Bold");
        this.commentsBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.commentsBoldButton, cc.xy(7, 13));
        this.commentsItalicButton.setText("Italic");
        this.commentsItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.commentsItalicButton, cc.xy(9, 13));
        this.label31.setText("Strings:");
        this.tabSyntax.add((Component)this.label31, cc.xy(3, 15));
        this.stringsColorPanel.setForeground(Color.black);
        this.stringsColorPanel.setPreferredSize(new Dimension(70, 20));
        this.stringsColorPanel.setBackground(new Color(255, 255, 51));
        this.stringsColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.stringsColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.stringsColorPanel, cc.xy(5, 15));
        this.stringsBoldButton.setText("Bold");
        this.stringsBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.stringsBoldButton, cc.xy(7, 15));
        this.stringsItalicButton.setText("Italic");
        this.stringsItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.stringsItalicButton, cc.xy(9, 15));
        this.label32.setText("Keywords:");
        this.tabSyntax.add((Component)this.label32, cc.xy(3, 17));
        this.keywordsColorPanel.setForeground(Color.black);
        this.keywordsColorPanel.setPreferredSize(new Dimension(70, 20));
        this.keywordsColorPanel.setBackground(new Color(255, 255, 51));
        this.keywordsColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.keywordsColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.keywordsColorPanel, cc.xy(5, 17));
        this.keywordsBoldButton.setText("Bold");
        this.keywordsBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.keywordsBoldButton, cc.xy(7, 17));
        this.keywordsItalicButton.setText("Italic");
        this.keywordsItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.keywordsItalicButton, cc.xy(9, 17));
        this.syntaxDefaultButton.setText("Default");
        this.tabSyntax.add((Component)this.syntaxDefaultButton, cc.xy(13, 19));
        this.tabbedPane1.addTab("Syntax", this.tabSyntax);
        this.tabCompiler.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.DEFAULT_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.jikesRadio.setText("jikes");
        this.tabCompiler.add((Component)this.jikesRadio, cc.xywh(3, 7, 2, 1));
        this.integratedRadio.setText("com.sun.tools.javac");
        this.integratedRadio.setActionCommand("integrated");
        this.tabCompiler.add((Component)this.integratedRadio, cc.xywh(3, 11, 3, 1));
        this.javacRadio.setText("javac");
        this.javacRadio.setSelected(true);
        this.tabCompiler.add((Component)this.javacRadio, cc.xywh(3, 3, 2, 1));
        this.javacCustomPathButton.setText("Path:");
        this.javacCustomPathButton.setToolTipText("Check to specify a custom path if the default system path doesn't include javac");
        this.tabCompiler.add((Component)this.javacCustomPathButton, cc.xywh(4, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.tabCompiler.add((Component)this.javacPathField, cc.xy(5, 5));
        this.browseJavacPath.setText("Browse...");
        this.tabCompiler.add((Component)this.browseJavacPath, cc.xy(6, 5));
        this.label4.setText("Path:");
        this.tabCompiler.add((Component)this.label4, cc.xywh(4, 9, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.tabCompiler.add((Component)this.jikesPathField, cc.xy(5, 9));
        this.browseJikesPath.setText("Browse...");
        this.tabCompiler.add((Component)this.browseJikesPath, cc.xy(6, 9));
        this.label9.setText("Classpath:");
        this.tabCompiler.add((Component)this.label9, cc.xy(3, 15));
        this.classpathSystemButton.setText("System");
        this.tabCompiler.add((Component)this.classpathSystemButton, cc.xy(4, 15));
        this.classpathCustomButton.setText("Custom:");
        this.tabCompiler.add((Component)this.classpathCustomButton, cc.xy(4, 17));
        this.tabCompiler.add((Component)this.customClasspathField, cc.xy(5, 17));
        this.browseCustomClassPathButton.setText("Browse...");
        this.tabCompiler.add((Component)this.browseCustomClassPathButton, cc.xy(6, 17));
        this.tabbedPane1.addTab("Compiler", this.tabCompiler);
        this.tabDebugger.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label33.setText("Default local port:");
        this.tabDebugger.add((Component)this.label33, cc.xy(3, 3));
        this.debugDefaultLocalPortField.setText("491000");
        this.tabDebugger.add((Component)this.debugDefaultLocalPortField, cc.xy(5, 3));
        this.label34.setText("Remote parser launch time-out:");
        this.tabDebugger.add((Component)this.label34, cc.xy(9, 3));
        this.debugLaunchTimeoutField.setText("5");
        this.tabDebugger.add((Component)this.debugLaunchTimeoutField, cc.xy(11, 3));
        this.label35.setText("seconds");
        this.tabDebugger.add((Component)this.label35, cc.xy(13, 3));
        this.label12.setText("Non-consumed token:");
        this.label12.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label12, cc.xy(3, 7));
        this.debugNonConsumedColorPanel.setForeground(Color.black);
        this.debugNonConsumedColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugNonConsumedColorPanel.setBackground(new Color(255, 255, 51));
        this.debugNonConsumedColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugNonConsumedColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugNonConsumedColorPanel, cc.xy(5, 7));
        this.label13.setText("Consumed token:");
        this.label13.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label13, cc.xy(3, 9));
        this.debugConsumedColorPanel.setForeground(Color.black);
        this.debugConsumedColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugConsumedColorPanel.setBackground(new Color(255, 255, 51));
        this.debugConsumedColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugConsumedColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugConsumedColorPanel, cc.xy(5, 9));
        this.label14.setText("Hidden token:");
        this.label14.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label14, cc.xy(3, 11));
        this.debugHiddenColorPanel.setForeground(Color.black);
        this.debugHiddenColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugHiddenColorPanel.setBackground(new Color(255, 255, 51));
        this.debugHiddenColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugHiddenColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugHiddenColorPanel, cc.xy(5, 11));
        this.label15.setText("Dead token:");
        this.label15.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label15, cc.xy(3, 13));
        this.debugDeadColorPanel.setForeground(Color.black);
        this.debugDeadColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugDeadColorPanel.setBackground(new Color(255, 255, 51));
        this.debugDeadColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugDeadColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugDeadColorPanel, cc.xy(5, 13));
        this.label16.setText("Lookahead token:");
        this.label16.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label16, cc.xy(3, 15));
        this.debugLTColorPanel.setForeground(Color.black);
        this.debugLTColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugLTColorPanel.setBackground(new Color(255, 255, 51));
        this.debugLTColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugLTColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugLTColorPanel, cc.xy(5, 15));
        this.label36.setText("Detachable panels:");
        this.tabDebugger.add((Component)this.label36, cc.xy(3, 19));
        this.detachablePanelChildrenButton.setText("Children of project's window");
        this.tabDebugger.add((Component)this.detachablePanelChildrenButton, cc.xywh(5, 19, 5, 1));
        this.askGenButton.setText("Ask before generating and compiling");
        this.tabDebugger.add((Component)this.askGenButton, cc.xywh(5, 21, 5, 1));
        this.tabbedPane1.addTab("Debugger", this.tabDebugger);
        this.panel1.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label8.setText("Display alerts:");
        this.panel1.add((Component)this.label8, cc.xywh(3, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.checkGrammarSuccessButton.setText("Successfull check grammar");
        this.panel1.add((Component)this.checkGrammarSuccessButton, cc.xy(5, 3));
        this.generateCodeSuccessButton.setText("Successfull code generation");
        this.panel1.add((Component)this.generateCodeSuccessButton, cc.xy(5, 5));
        this.fileModifiedOnDiskButton.setText("File modified on disk");
        this.panel1.add((Component)this.fileModifiedOnDiskButton, cc.xy(5, 7));
        this.interpreterLimitationButton.setText("Interpreter limitations");
        this.panel1.add((Component)this.interpreterLimitationButton, cc.xy(5, 9));
        this.label6.setText("Console:");
        this.panel1.add((Component)this.label6, cc.xywh(3, 11, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.clearConsoleBeforeCheckButton.setText("Clear before checking grammar");
        this.panel1.add((Component)this.clearConsoleBeforeCheckButton, cc.xy(5, 11));
        this.tabbedPane1.addTab("Advanced", this.panel1);
        this.tabUpdates.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label7.setText("Check for ANTLRWorks updates:");
        this.label7.setHorizontalAlignment(2);
        this.tabUpdates.add((Component)this.label7, cc.xy(3, 3));
        this.updateTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Manually", "At startup", "Daily", "Weekly"}));
        this.tabUpdates.add((Component)this.updateTypeCombo, cc.xywh(3, 5, 4, 1));
        this.checkForUpdatesButton.setText("Check Now");
        this.tabUpdates.add((Component)this.checkForUpdatesButton, cc.xy(7, 5));
        this.label10.setText("Download path:");
        this.label10.setHorizontalAlignment(2);
        this.tabUpdates.add((Component)this.label10, cc.xy(3, 9));
        this.tabUpdates.add((Component)this.downloadPathField, cc.xywh(3, 11, 3, 1));
        this.browseUpdateDownloadPathButton.setText("Browse...");
        this.browseUpdateDownloadPathButton.setActionCommand("Browse");
        this.tabUpdates.add((Component)this.browseUpdateDownloadPathButton, cc.xy(7, 11));
        this.tabbedPane1.addTab("Updates", this.tabUpdates);
        this.tabTestRig.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10))}));
        this.label17.setText("Test Rig for:");
        this.tabTestRig.add((Component)this.label17, cc.xywh(3, 3, 3, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.testRigLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Java", "Python"}));
        this.tabTestRig.add((Component)this.testRigLanguageComboBox, cc.xy(7, 3));
        this.testRigDefaultRadio.setText("Use default Test Rig Template");
        this.testRigDefaultRadio.setSelected(true);
        this.tabTestRig.add((Component)this.testRigDefaultRadio, cc.xywh(5, 5, 5, 1));
        this.testRigTextRadio.setText("Text:");
        this.tabTestRig.add((Component)this.testRigTextRadio, cc.xywh(5, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.scrollPane1.setViewportView(this.testTextArea);
        this.tabTestRig.add((Component)this.scrollPane1, cc.xywh(7, 7, 3, 1));
        this.tabbedPane1.addTab("Test Rig", this.tabTestRig);
        this.contentPane.add((Component)this.tabbedPane1, cc.xywh(1, 1, 2, 1));
        this.dialogPane.add((Component)this.contentPane, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("pref")));
        this.applyButton.setText("Apply");
        this.buttonBar.add((Component)this.applyButton, cc.xy(2, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane2.add((Component)this.dialogPane, "Center");
        this.pack();
    }
}

