/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.generate;

import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.antlr.Tool;
import org.antlr.tool.ErrorManager;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.generate.CodeGenerateDelegate;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerate
implements Runnable {
    private boolean debug = true;
    protected ComponentEditorGrammar editor;
    protected CodeGenerateDelegate delegate;
    protected long dateOfModificationOnDisk = 0L;
    protected String lastError;
    protected String generateError = null;
    protected XJDialogProgress progress;

    public CodeGenerate(ComponentEditorGrammar editor, CodeGenerateDelegate delegate) {
        this.editor = editor;
        this.delegate = delegate;
    }

    public void close() {
        this.editor = null;
        this.delegate = null;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getOutputPath() {
        return this.editor.getOutputPath();
    }

    public String getGrammarLanguage() {
        return this.editor.getGrammarEngine().getGrammarLanguage();
    }

    public String getGrammarName() {
        return this.editor.getGrammarEngine().getGrammarName();
    }

    public String getLastError() {
        return this.lastError;
    }

    public boolean generate() {
        boolean success;
        ErrorListener el = ErrorListener.getThreadInstance();
        ErrorManager.setErrorListener(el);
        String[] params = this.debug ? new String[]{"-debug", "-o", this.getOutputPath(), "-lib", this.editor.getFileFolder(), this.editor.getFilePath()} : new String[]{"-o", this.getOutputPath(), "-lib", this.editor.getFileFolder(), this.editor.getFilePath()};
        new File(this.getOutputPath()).mkdirs();
        Tool antlr = new Tool(Utils.concat(params, AWPrefs.getANTLR3Options()));
        antlr.process();
        boolean bl = success = !el.hasErrors();
        if (success) {
            this.dateOfModificationOnDisk = this.editor.getDocument().getDateOfModificationOnDisk();
        }
        this.lastError = el.getFirstErrorMessage();
        el.clear();
        ErrorManager.removeErrorListener();
        return success;
    }

    public List<String> getGeneratedFileNames() throws Exception {
        ArrayList<String> files = new ArrayList<String>();
        for (String name : this.editor.getGrammarEngine().getAllGeneratedNames()) {
            files.add(XJUtils.concatPath(this.getOutputPath(), name + ".java"));
        }
        return files;
    }

    public String getGeneratedFileName(int type) throws Exception {
        String className = this.editor.getGrammarEngine().getGeneratedClassName(type);
        if (className == null) {
            return null;
        }
        return XJUtils.concatPath(this.getOutputPath(), className + ".java");
    }

    public boolean isGeneratedTextFileExisting(int type) {
        try {
            String file = this.getGeneratedFileName(type);
            return file == null || new File(file).exists();
        }
        catch (Exception e) {
            this.editor.getConsole().println(e);
            return false;
        }
    }

    public boolean isFileModifiedSinceLastGeneration() {
        return this.dateOfModificationOnDisk != this.editor.getDocument().getDateOfModificationOnDisk();
    }

    public void generateInThread(Container parent) {
        this.progress = new XJDialogProgress(parent);
        this.progress.setInfo("Generating...");
        this.progress.setCancellable(false);
        this.progress.setIndeterminate(true);
        this.progress.display();
        new Thread(this).start();
    }

    public void generateInThreadDidTerminate() {
        this.progress.close();
        if (this.generateError != null) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot generate the grammar because:\n" + this.generateError);
            if (this.delegate != null) {
                this.delegate.codeGenerateDidCompleteWithError(this.generateError);
            }
        } else {
            if ((this.delegate == null || this.delegate.codeGenerateDisplaySuccess()) && AWPrefs.isAlertGenerateCodeSuccess()) {
                XJAlert alert = XJAlert.createInstance();
                alert.setDisplayDoNotShowAgainButton(true);
                alert.showSimple(this.editor.getWindowContainer(), "Success", "The grammar has been successfully generated in path:\n" + this.getOutputPath());
                AWPrefs.setAlertGenerateCodeSuccess(!alert.isDoNotShowAgain());
            }
            if (this.delegate != null) {
                this.delegate.codeGenerateDidComplete();
            }
        }
    }

    @Override
    public void run() {
        this.generateError = null;
        this.editor.getConsole().setMode(1);
        try {
            if (!this.generate()) {
                this.generateError = this.getLastError();
            }
        }
        catch (Exception e) {
            this.generateError = e.toString();
            this.editor.getConsole().println(e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CodeGenerate.this.generateInThreadDidTerminate();
            }
        });
    }
}

