/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.antlr;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAState;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarNonDeterminismMessage;
import org.antlr.tool.GrammarUnreachableAltsMessage;
import org.antlr.tool.Message;
import org.antlr.tool.NonRegularDecisionMessage;
import org.antlr.tool.Rule;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.grammar.antlr.ANTLRGrammarEngine;
import org.antlr.works.grammar.antlr.GrammarError;
import org.antlr.works.grammar.antlr.GrammarResult;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.utils.ErrorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANTLRGrammarEngineImpl
implements ANTLRGrammarEngine {
    private Grammar parserGrammar;
    private Grammar lexerGrammar;
    private List<GrammarError> errors;
    private boolean needsToCreateGrammar;
    private boolean needsToAnalyzeGrammar;
    private final GrammarResult createGrammarResult = new GrammarResult();
    private final GrammarResult analyzeResult = new GrammarResult();
    private GrammarEngine engine;

    public ANTLRGrammarEngineImpl() {
        this.errors = new ArrayList<GrammarError>();
        this.markDirty();
    }

    @Override
    public void setGrammarEngine(GrammarEngine engine) {
        this.engine = engine;
    }

    @Override
    public GrammarEngine getGrammarEngine() {
        return this.engine;
    }

    @Override
    public void close() {
        this.errors = null;
    }

    @Override
    public void markDirty() {
        this.needsToCreateGrammar = true;
        this.needsToAnalyzeGrammar = true;
    }

    @Override
    public Grammar getParserGrammar() {
        return this.parserGrammar;
    }

    @Override
    public Grammar getLexerGrammar() {
        return this.lexerGrammar;
    }

    @Override
    public NFAState getRuleStartState(String name) throws Exception {
        this.createGrammars();
        Grammar g = ATEToken.isLexerName(name) ? this.getLexerGrammar() : this.getParserGrammar();
        return g == null ? null : g.getRuleStartState(name);
    }

    @Override
    public Grammar getGrammarForRule(String name) throws Exception {
        this.createGrammars();
        if (ATEToken.isLexerName(name)) {
            return this.getLexerGrammar();
        }
        return this.getParserGrammar();
    }

    public List<GrammarError> getErrors() {
        return this.errors;
    }

    @Override
    public boolean hasGrammar() {
        switch (this.engine.getType()) {
            case 0: {
                return this.parserGrammar != null;
            }
            case 1: 
            case 3: {
                return this.parserGrammar != null;
            }
            case 2: {
                return this.lexerGrammar != null;
            }
        }
        return false;
    }

    @Override
    public Grammar getDefaultGrammar() {
        switch (this.engine.getType()) {
            case 0: {
                return this.parserGrammar;
            }
            case 1: 
            case 3: {
                return this.parserGrammar;
            }
            case 2: {
                return this.lexerGrammar;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createGrammars() throws Exception {
        if (!this.needsToCreateGrammar) {
            if (this.createGrammarResult.isSuccess()) {
                return;
            }
            this.needsToCreateGrammar = true;
        }
        ErrorListener el = ErrorListener.getThreadInstance();
        ErrorManager.setErrorListener(el);
        this.parserGrammar = null;
        this.lexerGrammar = null;
        this.createGrammarResult.clear();
        try {
            switch (this.engine.getType()) {
                case 0: {
                    this.createCombinedGrammar();
                    break;
                }
                case 1: 
                case 3: {
                    this.createParserGrammar();
                    break;
                }
                case 2: {
                    this.createLexerGrammar();
                }
            }
            this.needsToCreateGrammar = false;
        }
        finally {
            this.createGrammarResult.setErrors(el.errors);
            this.createGrammarResult.setWarnings(el.warnings);
            el.clear();
            ErrorManager.removeErrorListener();
        }
    }

    private Grammar createNewGrammar() throws TokenStreamException, RecognitionException, IOException {
        Grammar g = new Grammar();
        g.setTool(this.engine.getANTLRTool());
        g.setFileName(this.engine.getGrammarFileName());
        g.setGrammarContent(this.engine.getGrammarText());
        g.composite.createNFAs();
        ErrorManager.resetErrorState();
        return g;
    }

    private void createCombinedGrammar() throws Exception {
        this.createParserGrammar();
        this.lexerGrammar = this.createLexerGrammarFromCombinedGrammar(this.parserGrammar);
    }

    private Grammar createLexerGrammarFromCombinedGrammar(Grammar grammar) throws Exception {
        String lexerGrammarStr = grammar.getLexerGrammar();
        if (lexerGrammarStr == null) {
            return null;
        }
        Grammar lexerGrammar = new Grammar();
        lexerGrammar.implicitLexer = true;
        lexerGrammar.setTool(this.engine.getANTLRTool());
        lexerGrammar.setFileName("<internally-generated-lexer>");
        lexerGrammar.importTokenVocabulary(grammar);
        lexerGrammar.setGrammarContent(lexerGrammarStr);
        lexerGrammar.composite.createNFAs();
        return lexerGrammar;
    }

    private void createParserGrammar() throws TokenStreamException, RecognitionException, IOException {
        this.parserGrammar = this.createNewGrammar();
    }

    private void createLexerGrammar() throws TokenStreamException, RecognitionException, IOException {
        this.lexerGrammar = this.createNewGrammar();
    }

    private void printLeftRecursionToConsole(List rules) {
        StringBuilder info = new StringBuilder();
        info.append("Aborting because the following rules are mutually left-recursive:");
        for (Object rule : rules) {
            Set rulesSet = (Set)rule;
            info.append("\n    ");
            info.append(rulesSet);
        }
        this.engine.reportError(info.toString());
    }

    private void markLeftRecursiveRules(List rules) {
        for (Object ruleSet : rules) {
            Set rulesSet = (Set)ruleSet;
            for (Object rule : rulesSet) {
                Rule aRule = (Rule)rule;
                ElementRule r = this.engine.getRuleWithName(aRule.name);
                if (r == null) continue;
                r.setLeftRecursiveRulesSet(rulesSet);
            }
        }
    }

    @Override
    public GrammarResult analyze() throws Exception {
        if (!this.needsToAnalyzeGrammar) {
            GrammarResult r = this.analyzeCompleted(null);
            if (r.isSuccess()) {
                return r;
            }
            this.needsToAnalyzeGrammar = true;
        }
        ErrorListener el = ErrorListener.getThreadInstance();
        ErrorManager.setErrorListener(el);
        this.createGrammars();
        Grammar g = this.getDefaultGrammar();
        if (g == null) {
            return this.analyzeCompleted(el);
        }
        List rules = g.checkAllRulesForLeftRecursion();
        if (!rules.isEmpty()) {
            this.printLeftRecursionToConsole(rules);
            this.markLeftRecursiveRules(rules);
        }
        if (ErrorManager.doNotAttemptAnalysis()) {
            return this.analyzeCompleted(el);
        }
        try {
            if (g.nfa == null) {
                g.composite.createNFAs();
            }
            g.createLookaheadDFAs();
            if (this.engine.isCombinedGrammar() && this.lexerGrammar != null) {
                this.lexerGrammar.composite.createNFAs();
                this.lexerGrammar.createLookaheadDFAs();
            }
            this.buildNonDeterministicErrors(el);
            this.markRulesWithWarningsOrErrors();
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.analyzeCompleted(el);
    }

    private GrammarResult analyzeCompleted(ErrorListener el) throws InvocationTargetException, InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.engine.antlrGrammarEngineAnalyzeCompleted();
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ANTLRGrammarEngineImpl.this.engine.antlrGrammarEngineAnalyzeCompleted();
                }
            });
        }
        if (el != null) {
            this.needsToAnalyzeGrammar = false;
            this.analyzeResult.clear();
            this.analyzeResult.setErrors(el.errors);
            this.analyzeResult.setWarnings(el.warnings);
            if (el.hasErrors() || el.hasWarnings()) {
                this.needsToAnalyzeGrammar = true;
            }
            el.clear();
            ErrorManager.removeErrorListener();
        }
        return this.getCompleteResult();
    }

    private GrammarResult getCompleteResult() {
        GrammarResult result = new GrammarResult();
        result.errors.clear();
        result.errors.addAll(this.createGrammarResult.errors);
        result.errors.addAll(this.analyzeResult.errors);
        result.warnings.clear();
        result.warnings.addAll(this.createGrammarResult.warnings);
        result.warnings.addAll(this.analyzeResult.warnings);
        return result;
    }

    @Override
    public void cancel() {
        Grammar g = this.getDefaultGrammar();
        if (g != null) {
            g.externallyAbortNFAToDFAConversion();
        }
    }

    private void buildNonDeterministicErrors(ErrorListener el) {
        this.errors.clear();
        for (Message warning : el.warnings) {
            this.buildError(warning);
        }
        for (Message error : el.errors) {
            this.buildError(error);
        }
    }

    private void buildError(Object o) {
        if (o instanceof GrammarUnreachableAltsMessage) {
            this.errors.add(this.buildUnreachableAltsError((GrammarUnreachableAltsMessage)o));
        } else if (o instanceof GrammarNonDeterminismMessage) {
            this.errors.add(this.buildNonDeterministicError((GrammarNonDeterminismMessage)o));
        } else if (o instanceof NonRegularDecisionMessage) {
            this.errors.add(this.buildNonRegularDecisionError((NonRegularDecisionMessage)o));
        }
    }

    private GrammarError buildNonDeterministicError(GrammarNonDeterminismMessage message) {
        GrammarError error = new GrammarError();
        error.setLine(message.probe.dfa.getDecisionASTNode().getLine() - 1);
        List<Label> labels = message.probe.getSampleNonDeterministicInputSequence(message.problemState);
        error.setLabels(labels);
        String input = message.probe.getInputSequenceDisplay(labels);
        error.setMessageText("Decision can match input such as \"" + input + "\" using multiple alternatives");
        error.setMessage(message);
        return error;
    }

    private GrammarError buildUnreachableAltsError(GrammarUnreachableAltsMessage message) {
        GrammarError error = new GrammarError();
        error.setLine(message.probe.dfa.getDecisionASTNode().getLine() - 1);
        error.setMessageText("The following alternatives are unreachable: " + message.alts);
        error.setMessage(message);
        return error;
    }

    private GrammarError buildNonRegularDecisionError(NonRegularDecisionMessage message) {
        GrammarError error = new GrammarError();
        error.setLine(message.probe.dfa.getDecisionASTNode().getLine() - 1);
        error.setMessageText(message.toString());
        error.setMessage(message);
        return error;
    }

    private void markRulesWithWarningsOrErrors() throws Exception {
        for (ElementRule rule : this.engine.getRules()) {
            this.updateRuleWithErrors(rule, this.fetchErrorsForRule(rule));
        }
    }

    private void updateRuleWithErrors(ElementRule rule, List<GrammarError> errors) throws Exception {
        rule.setErrors(errors);
        rule.setNeedsToBuildErrors(true);
    }

    private List<GrammarError> fetchErrorsForRule(ElementRule rule) {
        ArrayList<GrammarError> errors = new ArrayList<GrammarError>();
        for (GrammarError error : this.getErrors()) {
            if (error.line < rule.start.startLineNumber || error.line > rule.end.startLineNumber) continue;
            errors.add(error);
        }
        return errors;
    }

    @Override
    public void computeRuleErrors(ElementRule rule) {
        List<GrammarError> errors = rule.getErrors();
        for (GrammarError error : errors) {
            Message o = error.getMessage();
            if (o instanceof GrammarUnreachableAltsMessage) {
                this.computeRuleError(error, (GrammarUnreachableAltsMessage)o);
                continue;
            }
            if (o instanceof GrammarNonDeterminismMessage) {
                this.computeRuleError(error, (GrammarNonDeterminismMessage)o);
                continue;
            }
            if (!(o instanceof NonRegularDecisionMessage)) continue;
            this.computeRuleError(error, (NonRegularDecisionMessage)o);
        }
        rule.setNeedsToBuildErrors(false);
    }

    private void computeRuleError(GrammarError error, GrammarNonDeterminismMessage message) {
        List nonDetAlts = message.probe.getNonDeterministicAltsForState(message.problemState);
        Set disabledAlts = message.probe.getDisabledAlternatives(message.problemState);
        int firstAlt = 0;
        for (Object nonDetAlt : nonDetAlts) {
            Integer displayAltI = (Integer)nonDetAlt;
            NFAState nfaStart = message.probe.dfa.getNFADecisionStartState();
            int tracePathAlt = nfaStart.translateDisplayAltToWalkAlt(displayAltI);
            if (firstAlt == 0) {
                firstAlt = tracePathAlt;
            }
            List path = message.probe.getNFAPathStatesForAlt(firstAlt, tracePathAlt, error.getLabels());
            error.addPath(path, disabledAlts.contains(displayAltI));
            error.addStates(path);
            for (Object aPath : path) {
                NFAState state = (NFAState)aPath;
                error.addRule(state.enclosingRule.name);
            }
        }
    }

    private void computeRuleError(GrammarError error, GrammarUnreachableAltsMessage message) {
        NFAState state = message.probe.dfa.getNFADecisionStartState();
        for (Object alt : message.alts) {
            error.addUnreachableAlt(state, (Integer)alt);
            error.addStates(state);
            error.addRule(state.enclosingRule.name);
        }
    }

    private void computeRuleError(GrammarError error, NonRegularDecisionMessage message) {
        NFAState state = message.probe.dfa.getNFADecisionStartState();
        for (Integer alt : message.altsWithRecursion) {
            error.addUnreachableAlt(state, alt);
            error.addStates(state);
            error.addRule(state.enclosingRule.name);
        }
    }
}

