/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.menu.ActionAbstract;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.visualization.SDGenerator;
import org.antlr.works.visualization.Visual;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GEngine;
import org.antlr.works.visualization.graphics.GEnginePS;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionExport
extends ActionAbstract {
    public ActionExport(ComponentContainer editor) {
        super(editor);
    }

    @Override
    public ComponentEditorGrammar getSelectedEditor() {
        return (ComponentEditorGrammar)super.getSelectedEditor();
    }

    public void exportEventsAsTextFile() {
        StatisticsAW.shared().recordEvent(3);
        if (!XJFileChooser.shared().displaySaveDialog((Component)this.getSelectedEditor().getWindowContainer(), "txt", "Text file", false)) {
            return;
        }
        String file = XJFileChooser.shared().getSelectedFilePath();
        if (file == null) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(this.getContainer().getActionDebugger().getEventsAsString());
            writer.close();
        }
        catch (IOException e) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Cannot save text file: " + file + "\nError: " + e);
        }
    }

    public void exportAsImage() {
        StatisticsAW.shared().recordEvent(0);
        EditorTab tab = this.getSelectedEditor().getSelectedTab();
        if (!tab.canExportToBitmap()) {
            return;
        }
        if (tab instanceof Visual) {
            this.exportRuleAsImage();
        } else {
            this.exportGViewAsImage(tab.getExportableGView());
        }
    }

    public void exportAllRulesAsImage() {
        this.exportAllRules(true);
    }

    public void exportAllRulesAsEPS() {
        this.exportAllRules(false);
    }

    public void exportAllRules(boolean asImage) {
        List<String> extensions = null;
        if (asImage) {
            extensions = ActionExport.lookupAvailableImageFormat();
        }
        if (!XJFileChooser.shared().displayChooseDirectory(this.getSelectedEditor().getWindowContainer(), extensions, extensions, !asImage)) {
            return;
        }
        String directory = XJFileChooser.shared().getSelectedFilePath();
        String extension = XJFileChooser.shared().getSelectedFileExtension();
        SDGenerator sd = new SDGenerator(this.getSelectedEditor().getGrammarEngine());
        for (ElementRule rule : this.getSelectedEditor().getRules()) {
            try {
                if (asImage) {
                    sd.renderRuleToBitmapFile(rule.name, extension, XJUtils.concatPath(directory, rule.name + "." + extension));
                    continue;
                }
                sd.renderRuleToEPSFile(rule.name, XJUtils.concatPath(directory, rule.name + ".eps"));
            }
            catch (Exception e) {
                XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Images cannot be saved because:\n" + e);
            }
        }
    }

    public void exportRuleAsImage() {
        if (!this.getSelectedEditor().visual.canSaveImage()) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Export Rule to Bitmap Image", "There is no rule at cursor position.");
            return;
        }
        this.saveImageToDisk(this.getSelectedEditor().visual.getImage());
    }

    public void exportGViewAsImage(GView view) {
        this.saveImageToDisk(view.getImage());
    }

    public void saveImageToDisk(BufferedImage image) {
        List<String> extensions = ActionExport.lookupAvailableImageFormat();
        if (XJFileChooser.shared().displaySaveDialog((Component)this.getSelectedEditor().getWindowContainer(), extensions, extensions, false)) {
            String file = XJFileChooser.shared().getSelectedFilePath();
            try {
                ImageIO.write((RenderedImage)image, file.substring(file.lastIndexOf(".") + 1), new File(file));
            }
            catch (IOException e) {
                XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Image \"" + file + "\" cannot be saved because:\n" + e);
            }
        }
    }

    private static List<String> lookupAvailableImageFormat() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (int i = 0; i < ImageIO.getWriterFormatNames().length; ++i) {
            String ext = ImageIO.getWriterFormatNames()[i].toLowerCase();
            if (extensions.contains(ext)) continue;
            extensions.add(ext);
        }
        return extensions;
    }

    public void exportAsEPS() {
        StatisticsAW.shared().recordEvent(1);
        EditorTab tab = this.getSelectedEditor().getSelectedTab();
        if (!tab.canExportToEPS()) {
            return;
        }
        if (tab instanceof Visual) {
            this.exportRuleAsEPS();
        } else {
            this.exportGViewAsEPS(tab.getExportableGView());
        }
    }

    protected void exportRuleAsEPS() {
        if (this.getSelectedEditor().rules.getEnclosingRuleAtPosition(this.getSelectedEditor().getCaretPosition()) == null) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Export Rule to EPS", "There is no rule at cursor position.");
            return;
        }
        GGraphAbstract graph = this.getSelectedEditor().visual.getCurrentGraph();
        if (graph == null) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Export Rule to EPS", "There is no graphical visualization.");
            return;
        }
        if (!XJFileChooser.shared().displaySaveDialog((Component)this.getSelectedEditor().getWindowContainer(), "eps", "EPS file", false)) {
            return;
        }
        String file = XJFileChooser.shared().getSelectedFilePath();
        if (file == null) {
            return;
        }
        try {
            GEnginePS engine = new GEnginePS();
            GContext context = graph.getContext();
            GEngine oldEngine = context.engine;
            context.setEngine(engine);
            graph.draw();
            context.setEngine(oldEngine);
            XJUtils.writeStringToFile(engine.getPSText(), file);
        }
        catch (Exception e) {
            this.getSelectedEditor().console.println(e);
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Cannot export to EPS file: " + file + "\nError: " + e);
        }
    }

    protected void exportGViewAsEPS(GView view) {
        if (!XJFileChooser.shared().displaySaveDialog((Component)this.getSelectedEditor().getWindowContainer(), "eps", "EPS file", false)) {
            return;
        }
        String file = XJFileChooser.shared().getSelectedFilePath();
        if (file == null) {
            return;
        }
        try {
            XJUtils.writeStringToFile(view.getEPS(), file);
        }
        catch (Exception e) {
            this.getSelectedEditor().console.println(e);
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Cannot export to EPS file: " + file + "\nError: " + e);
        }
    }

    public void exportAsDOT() {
        StatisticsAW.shared().recordEvent(2);
        EditorTab tab = this.getSelectedEditor().getSelectedTab();
        if (!tab.canExportToDOT()) {
            return;
        }
        if (!XJFileChooser.shared().displaySaveDialog((Component)this.getSelectedEditor().getWindowContainer(), "dot", "DOT file", false)) {
            return;
        }
        String file = XJFileChooser.shared().getSelectedFilePath();
        if (file == null) {
            return;
        }
        try {
            XJUtils.writeStringToFile(tab.getDOTString(), file);
        }
        catch (Exception e) {
            this.getSelectedEditor().console.println(e);
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Cannot export to DOT file: " + file + "\nError: " + e);
        }
    }
}

