/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.util.List;
import javax.swing.JOptionPane;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.grammar.CheckGrammar;
import org.antlr.works.grammar.CheckGrammarDelegate;
import org.antlr.works.grammar.RulesDependency;
import org.antlr.works.grammar.TokensDFA;
import org.antlr.works.grammar.antlr.GrammarResult;
import org.antlr.works.grammar.decisiondfa.DecisionDFA;
import org.antlr.works.grammar.element.ElementGroup;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.menu.ActionAbstract;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;

public class ActionGrammar
extends ActionAbstract
implements CheckGrammarDelegate,
XJDialogProgressDelegate {
    private CheckGrammar checkGrammar;
    private boolean checkingGrammar;

    public ActionGrammar(ComponentContainer editor) {
        super(editor);
    }

    public ComponentEditorGrammar getSelectedEditor() {
        return (ComponentEditorGrammar)super.getSelectedEditor();
    }

    public void showTokensSD() {
        StatisticsAW.shared().recordEvent(40);
        this.getSelectedEditor().visual.setRule(new ElementRule("Tokens"), true);
    }

    public void showTokensDFA() {
        StatisticsAW.shared().recordEvent(41);
        TokensDFA decision = new TokensDFA(this.getSelectedEditor());
        decision.launch();
    }

    public void showDecisionDFA() {
        DecisionDFA decision = new DecisionDFA(this.getSelectedEditor());
        decision.launch();
    }

    public void highlightDecisionDFA() {
        StatisticsAW.shared().recordEvent(42);
        try {
            if (this.getSelectedEditor().decisionDFAEngine.getDecisionDFACount() == 0) {
                this.getSelectedEditor().decisionDFAEngine.discoverAllDecisions();
            } else {
                this.getSelectedEditor().decisionDFAEngine.reset();
            }
            this.getSelectedEditor().decisionDFAEngine.refresh();
            this.getSelectedEditor().decisionDFAEngine.refreshMenu();
        }
        catch (Exception e) {
            e.printStackTrace();
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Cannot show the DFA:\n" + e.toString());
        }
    }

    public void showDependency() {
        StatisticsAW.shared().recordEvent(44);
        RulesDependency dependency = new RulesDependency(this.getSelectedEditor());
        dependency.launch();
    }

    public void group() {
        List<ElementRule> rules;
        StatisticsAW.shared().recordEvent(45);
        String s = (String)JOptionPane.showInputDialog(this.getSelectedEditor().getWindowContainer(), "Group Name:", "Group", 3, null, null, "Group");
        if (s != null && s.length() > 0 && !(rules = this.getSelectedEditor().rules.getSelectedRules()).isEmpty()) {
            this.getSelectedEditor().beginGroupChange("Group");
            ElementRule firstRule = rules.get(0);
            ElementRule lastRule = rules.get(rules.size() - 1);
            int end = lastRule.getEndIndex();
            this.getSelectedEditor().getTextEditor().insertText(end + 1, "\n// $>\n");
            int start = firstRule.getStartIndex();
            this.getSelectedEditor().getTextEditor().insertText(start - 1, "\n// $<" + s + "\n");
            this.getSelectedEditor().endGroupChange();
        }
    }

    public void ungroup() {
        ATEToken t;
        StatisticsAW.shared().recordEvent(46);
        ElementGroup openGroup = this.getSelectedEditor().rules.getSelectedGroup();
        if (openGroup == null && (openGroup = this.getSelectedEditor().rules.findOpenGroupClosestToLocation(this.getSelectedEditor().getTextPane().getSelectionStart())) == null) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Ungroup", "Cannot ungroup because no enclosing group has been found.");
            return;
        }
        ElementGroup closingGroup = this.getSelectedEditor().rules.findClosingGroupForGroup(openGroup);
        this.getSelectedEditor().beginGroupChange("Ungroup");
        if (closingGroup != null) {
            t = closingGroup.token;
            this.getSelectedEditor().replaceText(t.getStartIndex() - 1, t.getEndIndex(), "");
        }
        t = openGroup.token;
        this.getSelectedEditor().replaceText(t.getStartIndex() - 1, t.getEndIndex(), "");
        this.getSelectedEditor().endGroupChange();
    }

    public void ignore() {
        this.getSelectedEditor().rules.ignoreSelectedRules(true);
    }

    public void consider() {
        this.getSelectedEditor().rules.ignoreSelectedRules(false);
    }

    public void checkGrammar() {
        this.getSelectedEditor().showProgress("Checking Grammar...", this);
        if (AWPrefs.isClearConsoleBeforeCheckGrammar()) {
            this.getSelectedEditor().console.clear();
        }
        this.getContainer().saveAll();
        this.getSelectedEditor().console.makeCurrent();
        this.getSelectedEditor().console.println("Checking Grammar " + this.getSelectedEditor().getGrammarFileName() + "...");
        this.checkGrammar = new CheckGrammar(this.getSelectedEditor(), this);
        this.checkGrammar.check();
        StatisticsAW.shared().recordEvent(47);
    }

    public void checkGrammarDidBegin(CheckGrammar source) {
        this.checkingGrammar = true;
    }

    public void checkGrammarDidEnd(CheckGrammar source, GrammarResult result) {
        this.checkGrammar.close();
        this.checkGrammar = null;
        this.checkingGrammar = false;
        this.getSelectedEditor().hideProgress();
        if (result.isSuccess()) {
            if (AWPrefs.isAlertCheckGrammarSuccess()) {
                XJAlert alert = XJAlert.createInstance();
                alert.setDisplayDoNotShowAgainButton(true);
                alert.showSimple(this.getSelectedEditor().getWindowContainer(), "Success", "Check Grammar succeeded.");
                AWPrefs.setAlertCheckGrammarSuccess(!alert.isDoNotShowAgain());
            }
        } else if (result.getErrorCount() > 0) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Check Grammar reported some errors:\n" + result.getFirstErrorMessage() + "\nConsult the console for more information.");
        } else if (result.getWarningCount() > 0) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Warning", "Check Grammar reported some warnings:\n" + result.getFirstWarningMessage() + "\nConsult the console for more information.");
        } else {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Check Grammar reported some errors.\nConsult the console for more information.");
        }
    }

    public void dialogDidCancel() {
        if (this.checkingGrammar) {
            this.checkGrammar.cancel();
            this.checkGrammar.close();
            this.checkGrammar = null;
        }
    }
}

