/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;

public abstract class OverlayObject {
    public static final int DEFAULT_WIDTH = 300;
    public static final int DEFAULT_HEIGHT = 40;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_CUSTOM = 2;
    protected XJFrameInterface parentFrame;
    protected JComponent parentComponent;
    protected JComponent content;
    private ComponentAdapter pfcl;
    private ComponentAdapter pccl;
    private MouseAdapter pcml;

    public OverlayObject(XJFrameInterface parentFrame, JComponent parentComponent) {
        this.parentFrame = parentFrame;
        this.parentComponent = parentComponent;
        this.createKeyBindings();
        this.content = this.overlayCreateInterface();
        this.content.setVisible(false);
        parentFrame.getLayeredPane().add((Component)this.content, JLayeredPane.MODAL_LAYER);
        this.createListeners();
    }

    public void close() {
        if (this.parentFrame.getJavaContainer() != null) {
            this.parentFrame.getJavaContainer().removeComponentListener(this.pfcl);
        }
        this.parentComponent.removeComponentListener(this.pccl);
        this.parentComponent.removeMouseListener(this.pcml);
        this.parentFrame = null;
        this.parentComponent = null;
    }

    private void createListeners() {
        this.pfcl = new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                if (OverlayObject.this.content.isVisible()) {
                    OverlayObject.this.content.setVisible(false);
                }
            }
        };
        this.parentFrame.getJavaContainer().addComponentListener(this.pfcl);
        this.pccl = new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                if (!OverlayObject.this.isOverlayVisibleInParentComponent()) {
                    OverlayObject.this.hide();
                }
                if (OverlayObject.this.content.isVisible()) {
                    OverlayObject.this.resize();
                }
            }

            public void componentResized(ComponentEvent e) {
                if (!OverlayObject.this.isOverlayVisibleInParentComponent()) {
                    OverlayObject.this.hide();
                }
                if (OverlayObject.this.content.isVisible()) {
                    OverlayObject.this.resize();
                }
            }
        };
        this.parentComponent.addComponentListener(this.pccl);
        this.pcml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (OverlayObject.this.content.isVisible()) {
                    OverlayObject.this.hide();
                }
            }

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (OverlayObject.this.content.isVisible()) {
                    OverlayObject.this.hide();
                }
            }
        };
        this.parentComponent.addMouseListener(this.pcml);
    }

    public void createKeyBindings() {
        if (this.overlayDisplayKeyStroke() == null) {
            return;
        }
        this.parentComponent.getInputMap().put(this.overlayDisplayKeyStroke(), this.overlayDisplayKeyStrokeMappingName());
        this.parentComponent.getActionMap().put(this.overlayDisplayKeyStrokeMappingName(), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OverlayObject.this.display();
            }
        });
    }

    public boolean isOverlayVisibleInParentComponent() {
        Rectangle vr = SwingUtilities.convertRectangle(this.parentComponent, this.parentComponent.getVisibleRect(), this.parentFrame.getJavaContainer());
        Rectangle cr = SwingUtilities.convertRectangle(this.parentFrame.getLayeredPane(), this.content.getBounds(), this.parentFrame.getJavaContainer());
        return vr.intersects(cr);
    }

    public void hide() {
        if (this.content.isVisible()) {
            this.content.setVisible(false);
            this.parentComponent.requestFocusInWindow();
        }
    }

    public void resize() {
        Rectangle r = this.parentComponent.getVisibleRect();
        Point p = SwingUtilities.convertPoint(this.parentComponent, new Point(r.x, r.y), this.parentFrame.getRootPane());
        int x = 0;
        int y = 0;
        switch (this.overlayDefaultAlignment()) {
            case 1: {
                x = p.x + r.width / 2 - this.overlayDefaultWidth() / 2;
                y = p.y + r.height / 2 - this.overlayDefaultHeight() / 2;
                break;
            }
            case 0: {
                x = p.x + 5;
                y = p.y + r.height / 2 - this.overlayDefaultHeight() / 2;
                break;
            }
            case 2: {
                Point cp = this.overlayCustomPosition();
                if (cp == null) break;
                x = cp.x;
                y = cp.y;
            }
        }
        this.content.setBounds(x, y, this.overlayDefaultWidth(), this.overlayDefaultHeight());
    }

    public void display() {
        if (this.overlayWillDisplay()) {
            this.resize();
            this.content.setVisible(true);
        } else {
            this.content.setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.content.isVisible();
    }

    public abstract JComponent overlayCreateInterface();

    public abstract boolean overlayWillDisplay();

    public int overlayDefaultWidth() {
        return 300;
    }

    public int overlayDefaultHeight() {
        return 40;
    }

    public int overlayDefaultAlignment() {
        return 1;
    }

    public Point overlayCustomPosition() {
        return null;
    }

    public KeyStroke overlayDisplayKeyStroke() {
        return null;
    }

    public String overlayDisplayKeyStrokeMappingName() {
        return null;
    }
}

