/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.antlr.analysis.NFAState;
import org.antlr.works.ate.syntax.misc.ATEThread;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.visualization.Visual;
import org.antlr.works.visualization.graphics.GFactory;

public class VisualDrawing
extends ATEThread {
    protected Visual visual;
    protected GFactory factory = new GFactory();
    protected String text;
    protected ElementRule rule;
    protected String threadText;
    protected ElementRule threadRule;
    protected ElementRule threadLastProcessedRule;
    protected Map<ElementRule, List> cacheGraphs = new HashMap<ElementRule, List>();

    public VisualDrawing(Visual visual) {
        this.visual = visual;
        this.start();
    }

    public void stop() {
        super.stop();
        this.visual = null;
    }

    public void toggleNFAOptimization() {
        this.factory.toggleNFAOptimization();
        this.clearCacheGraphs();
    }

    public synchronized void setText(String text) {
        this.text = text;
        this.awakeThread(500);
    }

    public synchronized void setRule(ElementRule rule, boolean immediate) {
        this.rule = rule;
        this.awakeThread(immediate ? 0 : 500);
    }

    public synchronized void clearCacheGraphs() {
        this.cacheGraphs.clear();
    }

    public synchronized boolean refresh() {
        final List graphs = this.cacheGraphs.get(this.threadLastProcessedRule);
        if (graphs == null || graphs.isEmpty()) {
            return false;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VisualDrawing.this.refreshVisualPanel(graphs);
                }
            });
        } else {
            this.refreshVisualPanel(graphs);
        }
        return true;
    }

    private void refreshVisualPanel(List graphs) {
        this.visual.panel.setRule(this.threadLastProcessedRule);
        this.visual.panel.setGraphs(graphs);
        this.visual.panel.update();
    }

    public synchronized boolean threadShouldProcess() {
        return this.text != null || this.rule != null;
    }

    public synchronized void threadPrepareProcess() {
        this.threadText = this.text;
        this.threadRule = this.rule;
        this.text = null;
        this.rule = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadProcessText() {
        if (this.threadText == null) {
            return;
        }
        ErrorListener.getThreadInstance().setPrintToConsole(false);
        try {
            this.visual.getEngineGrammar().createGrammars();
        }
        catch (Exception exception) {
        }
        finally {
            this.clearCacheGraphs();
        }
    }

    private void threadProcessRule() throws Exception {
        if (this.threadRule == null) {
            return;
        }
        String error = null;
        ErrorListener.getThreadInstance().setPrintToConsole(false);
        if (this.visual.getEngineGrammar().hasGrammar()) {
            NFAState startState = null;
            try {
                startState = this.visual.getEngineGrammar().getRuleStartState(this.threadRule.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (startState == null) {
                error = "Cannot display rule \"" + this.threadRule + "\" because start state not found";
            }
        } else {
            error = "Cannot display rule \"" + this.threadRule + "\" because grammar could not be generated";
        }
        if (error != null) {
            this.visual.setPlaceholder(error);
            return;
        }
        this.createGraphsForRule(this.threadRule);
        this.threadLastProcessedRule = this.threadRule;
        this.refresh();
    }

    protected synchronized void createGraphsForRule(ElementRule rule) throws Exception {
        List graphs = this.cacheGraphs.get(rule);
        if (graphs == null) {
            this.factory.setOptimize(!AWPrefs.getDebugDontOptimizeNFA());
            this.factory.setConsole(this.visual.getConsole());
            graphs = this.factory.buildGraphsForRule(this.visual.getEngineGrammar(), rule.name, rule.errors);
            if (graphs != null) {
                this.cacheGraphs.put(rule, graphs);
            }
        }
    }

    public void threadReportException(Exception e) {
        this.visual.getConsole().println(e);
    }

    public void threadRun() throws Exception {
        this.visual.getConsole().setMode(2);
        if (this.threadShouldProcess()) {
            this.threadPrepareProcess();
            this.threadProcessText();
            this.threadProcessRule();
        }
    }
}

