/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.document;

import java.util.Collections;
import java.util.List;
import org.antlr.xjlib.appkit.document.XJData;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJWindowInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJDocumentFactory {
    private Class documentClass;
    private Class windowClass;
    private Class dataClass;
    private String ext;
    private String description;

    public XJDocumentFactory(Class documentClass, Class windowClass, Class dataClass, String ext, String description) {
        this.documentClass = documentClass;
        this.windowClass = windowClass;
        this.dataClass = dataClass;
        this.ext = ext;
        this.description = description;
    }

    public boolean handlesPath(String path) {
        return path != null && path.endsWith("." + this.ext);
    }

    public List<String> getExtensions() {
        return Collections.singletonList(this.ext);
    }

    public String getDescriptionString() {
        return this.description;
    }

    public XJDocument createDocument() throws IllegalAccessException, InstantiationException {
        XJDocument document = (XJDocument)this.documentClass.newInstance();
        document.setDocumentData((XJData)this.dataClass.newInstance());
        document.setDocumentFileType(this.getExtensions(), this.getDescriptionString());
        XJWindowInterface window = (XJWindowInterface)this.windowClass.newInstance();
        window.addDocument(document);
        document.setWindow(window);
        return document;
    }
}

