/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.shape;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class SLabel
implements XJXMLSerializable {
    protected Vector2D position = null;
    protected String title = null;
    protected Color color = Color.black;
    protected boolean visible = true;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setPosition(Vector2D position) {
        this.position = position;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public void setPosition(double x, double y) {
        this.setPosition(new Vector2D(x, y));
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void draw(Graphics g) {
        if (this.position == null || this.title == null || !this.visible) {
            return;
        }
        g.setColor(this.color);
        SLabel.drawCenteredString(this.title, (int)this.position.getX(), (int)this.position.getY(), g);
    }

    public static void drawCenteredString(String s, double x, double y, Graphics g) {
        if (s != null) {
            FontMetrics fm = g.getFontMetrics();
            int xx = (int)(x - (double)fm.stringWidth(s) * 0.5);
            int yy = (int)(y + (double)fm.getHeight() * 0.5);
            g.drawString(s, xx, yy);
        }
    }

    public static Rect getFrame(String s, double x, double y, Graphics g) {
        if (s != null && g != null) {
            FontMetrics fm = g.getFontMetrics();
            return new Rect(x - (double)fm.stringWidth(s) * 0.5, y - (double)fm.getHeight() * 0.5, (double)fm.stringWidth(s), (double)fm.getHeight());
        }
        return new Rect(0.0, 0.0, 0.0, 0.0);
    }
}

