/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;

public class XJDialogProgress
extends XJDialog {
    protected XJDialogProgressDelegate delegate;
    protected JLabel infoLabel;
    protected JProgressBar progressBar;
    protected JButton cancelButton;

    public XJDialogProgress(XJFrameInterface owner, boolean modal) {
        super(owner == null ? null : owner.getJavaContainer(), modal);
        this.init();
    }

    public XJDialogProgress(XJFrameInterface owner) {
        super(owner == null ? null : owner.getJavaContainer(), false);
        this.init();
    }

    public XJDialogProgress(Container owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public XJDialogProgress(Container owner) {
        super(owner, false);
        this.init();
    }

    public void init() {
        this.setResizable(false);
        this.setSize(400, 90);
        this.initComponents();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (XJDialogProgress.this.delegate != null) {
                    XJDialogProgress.this.setInfo("Cancelling...");
                    XJDialogProgress.this.delegate.dialogDidCancel();
                }
            }
        });
    }

    public void setCancellable(boolean flag) {
        this.cancelButton.setEnabled(flag);
    }

    public void setIndeterminate(boolean flag) {
        if (flag) {
            this.setProgress(0);
            this.setProgressMax(0);
        }
        this.progressBar.setIndeterminate(flag);
    }

    public void setDelegate(XJDialogProgressDelegate delegate) {
        this.delegate = delegate;
    }

    public void setInfo(String info) {
        this.infoLabel.setText(info);
    }

    public void setProgress(float value) {
        this.setProgress((int)value);
    }

    public void setProgress(int value) {
        this.progressBar.setValue(value);
    }

    public void setProgressMax(int value) {
        this.progressBar.setMaximum(value);
    }

    private void initComponents() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.infoLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton("Cancel");
        this.setTitle("Operation in progress");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(20, 20, 0, 0);
        contentPane.add((Component)this.infoLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 20, 20, 10);
        contentPane.add((Component)this.progressBar, gbc);
        gbc.gridx = 1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 20, 20);
        contentPane.add((Component)this.cancelButton, gbc);
    }
}

