/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.foundation;

import java.awt.GraphicsEnvironment;

public class XJSystem {
    public static boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getOSArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String getJavaRuntimeVersion() {
        return System.getProperty("java.runtime.version");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void setSystemProperties() {
        if (XJSystem.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance();
    }
}

