/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works;

import java.io.File;
import java.io.IOException;
import org.antlr.Tool;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngineDelegate;
import org.antlr.works.grammar.engine.GrammarEngineDelegate;
import org.antlr.works.grammar.engine.GrammarEngineImpl;
import org.antlr.works.grammar.syntax.GrammarSyntaxEngine;
import org.antlr.works.utils.ConsoleHelper;
import org.antlr.works.visualization.SDGenerator;
import org.antlr.works.visualization.serializable.SXMLEncoder;
import org.antlr.xjlib.foundation.XJUtils;

public class Console {
    private String file;
    private String outputDirectory;
    private String outputFile;
    private boolean verbose;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Console.printUsage();
            return;
        }
        System.setProperty("java.awt.headless", "true");
        Console c = new Console();
        c.process(args);
    }

    private static void printUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: java -cp antlrworks.jar org.antlr.works.Console [args]\n");
        sb.append(" -f grammarFile : ").append("specify the input grammar file (*.g)\n");
        sb.append(" -sd format : ").append("specify the format of the syntax diagram output file. For EPS, use 'eps'. For bitmap, use either 'png' or any available extensions\n");
        sb.append(" -serialize outputFile : ").append("serialize all the syntax diagram of the specified files");
        sb.append(" -o outputDir : ").append("specify the output directory\n");
        sb.append(" -verbose : ").append("prints the operations\n");
        System.out.println(sb.toString());
    }

    public Console() {
        ConsoleHelper.setCurrent(new ConsoleConsole());
    }

    private void process(String[] args) throws Exception {
        this.readArguments(args);
        String sdFormat = Console.getArgumentValue(args, "-sd");
        if (sdFormat != null) {
            if (this.verbose) {
                System.out.println("Generating syntax diagram in " + sdFormat);
            }
            this.generateSyntaxDiagrams(sdFormat);
        }
        if (Console.hasArgument(args, "-serialize")) {
            if (this.verbose) {
                System.out.println("Serializing syntax diagram ");
            }
            this.serializeSyntaxDiagrams();
        }
    }

    private void readArguments(String[] args) {
        this.file = Console.getArgumentValue(args, "-f");
        if (this.file == null) {
            System.err.println("File not specified (-f)");
            return;
        }
        this.file = new File(this.file).getAbsolutePath();
        this.outputDirectory = Console.getArgumentValue(args, "-o");
        if (this.outputDirectory == null && Console.hasArgument(args, "-sd")) {
            System.err.println("Output directory not specified (-o)");
            return;
        }
        this.outputFile = Console.getArgumentValue(args, "-serialize");
        if (this.outputFile == null && Console.hasArgument(args, "-serialize")) {
            System.err.println("Output file not specified (-serialize)");
            return;
        }
        String v = Console.getArgumentValue(args, "-verbose");
        if (v != null) {
            this.verbose = true;
        }
    }

    private void generateSyntaxDiagrams(String format) throws Exception {
        this.processSyntaxDiagram(new GeneratePSDDelegate(format));
    }

    private void serializeSyntaxDiagrams() throws Exception {
        this.processSyntaxDiagram(new SerializePSDDelegate());
    }

    private void processSyntaxDiagram(ProcessSyntaxDiagramDelegate delegate) throws Exception {
        GrammarEngineImpl engine = new GrammarEngineImpl(new EngineDelegate());
        GrammarSyntaxEngine syntaxEngine = engine.getSyntaxEngine();
        syntaxEngine.setDelegate(new SyntaxDelegate());
        syntaxEngine.processSyntax();
        engine.parserCompleted();
        SDGenerator gen = new SDGenerator(engine);
        delegate.beginProcess();
        for (String name : engine.getRuleNames()) {
            delegate.processRule(name, gen);
        }
        delegate.endProcess();
    }

    private static String getArgumentValue(String[] args, String name) {
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (!a.equals(name)) continue;
            if (i + 1 < args.length) {
                return args[i + 1];
            }
            return a;
        }
        return null;
    }

    private static boolean hasArgument(String[] args, String name) {
        for (String a : args) {
            if (!a.equals(name)) continue;
            return true;
        }
        return false;
    }

    private String getGrammarText() {
        try {
            return XJUtils.getStringFromFile(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private class ConsoleConsole
    implements org.antlr.works.utils.Console {
        private ConsoleConsole() {
        }

        public void setMode(int mode) {
        }

        public void println(String s) {
            if (Console.this.verbose) {
                System.out.println(s);
            }
        }

        public void println(String s, int level) {
            if (level != 0) {
                System.err.println(s);
            } else if (Console.this.verbose) {
                this.println(s);
            }
        }

        public void println(Throwable e) {
            e.printStackTrace();
        }

        public void print(String string, int level) {
            if (level != 0) {
                System.err.print(string);
            } else if (Console.this.verbose) {
                System.out.print(string);
            }
        }

        public void print(Throwable e) {
            e.printStackTrace();
        }
    }

    private class EngineDelegate
    implements GrammarEngineDelegate {
        private EngineDelegate() {
        }

        public void engineAnalyzeCompleted() {
        }

        public String getOutputPath() {
            return XJUtils.concatPath(XJUtils.getPathByDeletingLastComponent(Console.this.file), "output");
        }

        public Tool getANTLRTool() {
            Tool t = new Tool();
            t.setOutputDirectory(this.getOutputPath());
            return t;
        }

        public String getGrammarFileName() {
            return XJUtils.getLastPathComponent(Console.this.file);
        }

        public String getGrammarText() {
            return Console.this.getGrammarText();
        }

        public String getTokenVocabFile(String name) {
            return null;
        }

        public void gotoToRule(String grammar, String name) {
        }

        public void reportError(Exception e) {
            e.printStackTrace();
        }

        public void reportError(String error) {
            System.err.println(error);
        }
    }

    public class SyntaxDelegate
    implements ATESyntaxEngineDelegate {
        public String getText() {
            return Console.this.getGrammarText();
        }

        public void ateEngineBeforeParsing() {
        }

        public void ateEngineAfterParsing() {
        }
    }

    private class SerializePSDDelegate
    implements ProcessSyntaxDiagramDelegate {
        private StringBuilder content;

        private SerializePSDDelegate() {
        }

        public void beginProcess() {
            if (Console.this.verbose) {
                System.out.println("Begin");
            }
            new File(XJUtils.getPathByDeletingLastComponent(Console.this.outputFile)).mkdirs();
            this.content = new StringBuilder();
        }

        public void endProcess() throws IOException {
            XJUtils.writeStringToFile(this.content.toString(), Console.this.outputFile);
            if (Console.this.verbose) {
                System.out.println("Done");
            }
        }

        public void processRule(String name, SDGenerator gen) throws Exception {
            if (Console.this.verbose) {
                System.out.println("Generate rule " + name);
            }
            SXMLEncoder encoder = new SXMLEncoder();
            gen.serializeRule(name, encoder);
            this.content.append("\n\n------").append(name).append("------\n\n");
            this.content.append(((Object)encoder).toString());
        }
    }

    private class GeneratePSDDelegate
    implements ProcessSyntaxDiagramDelegate {
        private String format;

        public GeneratePSDDelegate(String format) {
            this.format = format;
        }

        public void beginProcess() {
            if (Console.this.verbose) {
                System.out.println("Begin");
            }
            new File(Console.this.outputDirectory).mkdirs();
        }

        public void endProcess() throws IOException {
            if (Console.this.verbose) {
                System.out.println("Done");
            }
        }

        public void processRule(String name, SDGenerator gen) throws Exception {
            if (Console.this.verbose) {
                System.out.println("Generate rule " + name);
            }
            String file = XJUtils.concatPath(Console.this.outputDirectory, name + "." + this.format);
            if (this.format.equals("eps")) {
                gen.renderRuleToEPSFile(name, file);
            } else {
                gen.renderRuleToBitmapFile(name, this.format, file);
            }
        }
    }

    private static interface ProcessSyntaxDiagramDelegate {
        public void beginProcess();

        public void endProcess() throws Exception;

        public void processRule(String var1, SDGenerator var2) throws Exception;
    }
}

