/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.gutter.ATEGutterColumnManager;
import org.antlr.works.ate.gutter.ATEGutterItem;
import org.antlr.works.ate.gutter.ATEGutterItemOverlay;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.utils.IconManager;

public class ATEGutter
extends JComponent {
    private static final int FOLDING_ICON_WIDTH = 9;
    private static final int FOLDING_ICON_HEIGHT = 9;
    private static final int OFFSET_FROM_TEXT = 2;
    private static final Color BACKGROUND_COLOR = new Color(240, 240, 240);
    private static final Stroke FOLDING_DASHED_STROKE = new BasicStroke(0.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);
    private static final Font LINE_NUMBER_FONT = new Font("Courier", 0, 12);
    private ATEPanel textEditor;
    private List<ItemInfo> items = new ArrayList<ItemInfo>();
    private List<FoldingInfo> foldingInfos = new ArrayList<FoldingInfo>();
    private boolean foldingEnabled = false;
    private FontMetrics lineNumberMetrics;
    private int offsetForLineNumber;
    private int gutterItemWidth;
    private boolean lineNumberEnabled;
    private ATEGutterItemOverlay overlay;
    private transient Image collapseDown;
    private transient Image collapseUp;
    private transient Image collapse;
    private transient Image expand;
    private transient Image delimiter;
    private transient Image delimiterUp;
    private transient Image delimiterDown;

    public ATEGutter(ATEPanel textEditor) {
        this.textEditor = textEditor;
        this.overlay = new ATEGutterItemOverlay(textEditor.getParentFrame(), this);
        this.collapseDown = IconManager.shared().getIconCollapseDown().getImage();
        this.collapseUp = IconManager.shared().getIconCollapseUp().getImage();
        this.collapse = IconManager.shared().getIconCollapse().getImage();
        this.expand = IconManager.shared().getIconExpand().getImage();
        this.delimiter = IconManager.shared().getIconDelimiter().getImage();
        this.delimiterUp = IconManager.shared().getIconDelimiterUp().getImage();
        this.delimiterDown = IconManager.shared().getIconDelimiterDown().getImage();
        this.addMouseListener(new MyMouseAdapter());
        this.addMouseMotionListener(new MyMouseMotionAdapter());
    }

    public void setFoldingEnabled(boolean foldingEnabled) {
    }

    public void setLineNumberEnabled(boolean lineNumberEnabled) {
        this.lineNumberEnabled = lineNumberEnabled;
    }

    public void markDirty() {
        this.repaint();
    }

    protected void itemAction(ItemInfo info, Point location) {
        if (info == null) {
            return;
        }
        int type = this.getItemTypeAtLocation(info, location);
        if (type == -1) {
            return;
        }
        info.item.itemAction(type);
        this.repaint();
    }

    protected void toggleFolding(FoldingInfo info) {
        if (info == null || !info.entity.foldingEntityCanBeCollapsed()) {
            return;
        }
        this.textEditor.foldingManager.toggleFolding(info.entity);
        this.markDirty();
    }

    protected int getLineYPixelPosition(int indexInText) {
        try {
            Rectangle r = this.textEditor.textPane.modelToView(indexInText);
            return r.y + r.height / 2;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public void changeUpdate(int offset, int length, boolean insert) {
        if (this.textEditor.gutterColumnsManager != null) {
            ATEGutterColumnManager manager = this.textEditor.gutterColumnsManager;
            for (String column : manager.getColumns()) {
                for (ATEGutterItem item : manager.getGutterItems(column)) {
                    if (item.getItemIndex() <= offset) continue;
                    item.setItemIndex(item.getItemIndex() + length);
                }
            }
        }
    }

    public void updateInfo(Rectangle clip) {
        int startIndex = this.textEditor.textPane.viewToModel(new Point(clip.x, clip.y));
        int endIndex = this.textEditor.textPane.viewToModel(new Point(clip.x + clip.width, clip.y + clip.height));
        this.items.clear();
        if (this.textEditor.gutterColumnsManager != null) {
            ATEGutterColumnManager manager = this.textEditor.gutterColumnsManager;
            int offsetX = this.offsetForLineNumber;
            for (String column : manager.getColumns()) {
                for (ATEGutterItem item : manager.getGutterItems(column)) {
                    int index = item.getItemIndex();
                    if (index < startIndex || index > endIndex) continue;
                    int y = this.getLineYPixelPosition(item.getItemIndex());
                    int width = item.getItemWidth();
                    int height = item.getItemHeight();
                    Rectangle r = new Rectangle(offsetX, y - height / 2, width, height);
                    this.items.add(new ItemInfo(item, r));
                }
                offsetX += manager.getColumnWidth(column);
            }
        }
        this.foldingInfos.clear();
        if (this.textEditor.foldingManager != null) {
            List<ATEFoldingEntity> entities = this.textEditor.foldingManager.getFoldingEntities();
            for (ATEFoldingEntity entity : entities) {
                int entityStartIndex = entity.foldingEntityGetStartIndex();
                int entityEndIndex = entity.foldingEntityGetEndIndex();
                if (entityStartIndex > endIndex || entityEndIndex < startIndex) continue;
                int top_y = this.getLineYPixelPosition(entity.foldingEntityGetStartIndex());
                int bottom_y = this.getLineYPixelPosition(entity.foldingEntityGetEndIndex());
                Point top = new Point(this.getWidth() - this.getOffsetFromText(), top_y);
                Point bottom = new Point(this.getWidth() - this.getOffsetFromText(), bottom_y);
                this.foldingInfos.add(new FoldingInfo(entity, top, bottom));
            }
        }
    }

    public boolean updateSize() {
        List<ATELine> lines;
        boolean resize = false;
        if (this.lineNumberMetrics == null) {
            this.lineNumberMetrics = this.textEditor.textPane.getFontMetrics(LINE_NUMBER_FONT);
        }
        int oldOffset = this.offsetForLineNumber;
        this.offsetForLineNumber = 0;
        if (this.lineNumberEnabled && (lines = this.textEditor.getLines()) != null) {
            this.offsetForLineNumber = this.lineNumberMetrics.stringWidth(String.valueOf(lines.size()));
        }
        resize = resize || oldOffset != this.offsetForLineNumber;
        int oldWidth = this.gutterItemWidth;
        this.gutterItemWidth = 0;
        if (this.textEditor.gutterColumnsManager != null) {
            this.gutterItemWidth = this.textEditor.gutterColumnsManager.getWidth();
        }
        resize = resize || oldWidth != this.gutterItemWidth;
        return resize;
    }

    public ItemInfo getItemInfoAtPoint(Point p) {
        for (ItemInfo info : this.items) {
            if (!info.contains(p)) continue;
            return info;
        }
        return null;
    }

    public FoldingInfo getFoldingInfoAtPoint(Point p) {
        for (FoldingInfo info : this.foldingInfos) {
            if (!info.contains(p)) continue;
            return info;
        }
        return null;
    }

    public int getOffsetFromText() {
        return 6;
    }

    public void paintComponent(Graphics g) {
        Rectangle r = this.getVisibleRect();
        this.updateInfo(r);
        if (this.updateSize()) {
            this.revalidate();
        }
        this.paintGutter(g, r);
        this.paintFolding((Graphics2D)g, r);
        this.paintItems((Graphics2D)g, r);
        if (this.lineNumberEnabled) {
            this.paintLineNumbers((Graphics2D)g, r);
        }
    }

    private void paintGutter(Graphics g, Rectangle clip) {
        g.setColor(this.textEditor.textPane.getBackground());
        g.fillRect(clip.x + clip.width - this.getOffsetFromText(), clip.y, this.getOffsetFromText(), clip.height);
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(clip.x, clip.y, clip.width - this.getOffsetFromText(), clip.height);
        g.setColor(Color.lightGray);
        g.drawLine(clip.x + clip.width - this.getOffsetFromText(), clip.y, clip.x + clip.width - this.getOffsetFromText(), clip.y + clip.height);
    }

    private void paintItems(Graphics2D g, Rectangle clip) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.red);
        for (ItemInfo info : this.items) {
            Rectangle r = info.r;
            if (!clip.intersects(r)) continue;
            ATEGutterItem item = info.item;
            int x = r.x;
            for (int t : item.getItemTypes()) {
                ImageIcon i = item.getItemIcon(t);
                g.drawImage(i.getImage(), x, r.y, null);
                x += i.getIconWidth();
            }
        }
    }

    private void paintLineNumbers(Graphics2D g, Rectangle clip) {
        g.setColor(Color.black);
        g.setFont(LINE_NUMBER_FONT);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int lineCount = this.textEditor.getLines().size();
        int lineHeight = this.textEditor.textPane.getFontMetrics(this.textEditor.textPane.getFont()).getHeight();
        int number = Math.max(0, Math.round(clip.y / lineHeight) - 1);
        int y = number * lineHeight;
        while (number <= lineCount && (double)(y - lineHeight) <= clip.getY() + clip.getHeight()) {
            String s = String.valueOf(number++);
            g.drawString(s, this.offsetForLineNumber - this.lineNumberMetrics.stringWidth(s), y - 4);
            y += lineHeight;
        }
    }

    private void paintFolding(Graphics2D g, Rectangle clip) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        for (FoldingInfo info : this.foldingInfos) {
            if (!clip.intersects(info.top_r) && !clip.intersects(info.bottom_r)) continue;
            Point top = info.top;
            Point bottom = info.bottom;
            if (this.foldingEnabled && info.entity.foldingEntityCanBeCollapsed()) {
                if (info.entity.foldingEntityIsExpanded()) {
                    this.drawFoldingLine(g, top, bottom);
                    if (top.equals(bottom)) {
                        ATEGutter.drawCenteredImageAtPoint(g, this.collapse, top);
                        continue;
                    }
                    ATEGutter.drawCenteredImageAtPoint(g, this.collapseUp, top);
                    ATEGutter.drawCenteredImageAtPoint(g, this.collapseDown, bottom);
                    continue;
                }
                ATEGutter.drawCenteredImageAtPoint(g, this.expand, top);
                continue;
            }
            this.drawFoldingLine(g, top, bottom);
            if (top.equals(bottom)) {
                ATEGutter.drawCenteredImageAtPoint(g, this.delimiter, top);
                continue;
            }
            ATEGutter.drawCenteredImageAtPoint(g, this.delimiterUp, top);
            ATEGutter.drawCenteredImageAtPoint(g, this.delimiterDown, bottom);
        }
    }

    private void drawFoldingLine(Graphics2D g, Point top, Point bottom) {
        g.setColor(Color.white);
        g.drawLine(top.x, top.y, bottom.x, bottom.y);
        Stroke s = g.getStroke();
        g.setStroke(FOLDING_DASHED_STROKE);
        g.setColor(Color.black);
        g.drawLine(top.x, top.y, bottom.x, bottom.y);
        g.setStroke(s);
    }

    public Dimension getPreferredSize() {
        Dimension d = this.textEditor.textPane.getSize();
        d.width = this.gutterItemWidth + this.offsetForLineNumber + 9 + 2;
        return d;
    }

    public static void drawCenteredImageAtPoint(Graphics g, Image image, Point p) {
        g.drawImage(image, p.x - image.getWidth(null) / 2, p.y - image.getHeight(null) / 2, null);
    }

    private int getItemTypeAtLocation(ItemInfo ii, Point location) {
        ATEGutterItem item = ii.item;
        int width = item.getItemWidth();
        for (int i = item.getItemTypes().size() - 1; i >= 0; --i) {
            int t = item.getItemTypes().get(i);
            if (location.x <= ii.r.x + (width -= item.getItemIcon(t).getIconWidth())) continue;
            return t;
        }
        return -1;
    }

    private boolean handleClickInColumn(Point point) {
        if (this.textEditor.gutterColumnsManager == null) {
            return false;
        }
        ATEGutterColumnManager manager = this.textEditor.gutterColumnsManager;
        if (point.x < this.offsetForLineNumber) {
            return false;
        }
        String column = null;
        int width = this.offsetForLineNumber;
        for (String c : manager.getColumns()) {
            if (point.x >= (width += manager.getColumnWidth(c))) continue;
            column = c;
            break;
        }
        if (column == null) {
            return false;
        }
        point.x = 0;
        int index = this.textEditor.textPane.viewToModel(point);
        return manager.handleClickInColumn(column, index);
    }

    protected class MyMouseMotionAdapter
    extends MouseMotionAdapter {
        protected MyMouseMotionAdapter() {
        }

        public void mouseMoved(MouseEvent e) {
            int type;
            String tooltip = null;
            ItemInfo ii = ATEGutter.this.getItemInfoAtPoint(e.getPoint());
            if (ii != null && (type = ATEGutter.this.getItemTypeAtLocation(ii, e.getPoint())) != -1) {
                tooltip = ii.item.getItemTooltip(type);
                Point p = SwingUtilities.convertPoint(ATEGutter.this, new Point(0, ii.r.y), ATEGutter.this.textEditor.getParentFrame().getJavaContainer());
                ATEGutter.this.overlay.setLocation(p);
            }
            if (tooltip != null && tooltip.length() > 0) {
                ATEGutter.this.overlay.setText(tooltip);
                ATEGutter.this.overlay.display();
            } else {
                ATEGutter.this.overlay.hide();
            }
            if (!ATEGutter.this.foldingEnabled) {
                return;
            }
            FoldingInfo info = ATEGutter.this.getFoldingInfoAtPoint(e.getPoint());
            if (info != null && info.entity.foldingEntityCanBeCollapsed()) {
                ATEGutter.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                ATEGutter.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected class MyMouseAdapter
    extends MouseAdapter {
        protected MyMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            if (!ATEGutter.this.handleClickInColumn(e.getPoint())) {
                ATEGutter.this.itemAction(ATEGutter.this.getItemInfoAtPoint(e.getPoint()), e.getPoint());
                ATEGutter.this.toggleFolding(ATEGutter.this.getFoldingInfoAtPoint(e.getPoint()));
            }
            ATEGutter.this.textEditor.damage();
            ATEGutter.this.overlay.hide();
        }

        public void mouseExited(MouseEvent e) {
            ATEGutter.this.setCursor(Cursor.getDefaultCursor());
            ATEGutter.this.overlay.hide();
        }
    }

    protected static class FoldingInfo {
        public ATEFoldingEntity entity;
        public Point top;
        public Point bottom;
        public Rectangle top_r;
        public Rectangle bottom_r;

        public FoldingInfo(ATEFoldingEntity entity, Point top, Point bottom) {
            this.entity = entity;
            this.top = top;
            this.bottom = bottom;
            this.top_r = new Rectangle(top.x - 4, top.y - 4, 9, 9);
            this.bottom_r = new Rectangle(bottom.x - 4, bottom.y - 4, 9, 9);
        }

        public boolean contains(Point p) {
            if (this.entity.foldingEntityIsExpanded()) {
                return this.top_r.contains(p) || this.bottom_r.contains(p);
            }
            return this.top_r.contains(p);
        }
    }

    protected static class ItemInfo {
        public ATEGutterItem item;
        public Rectangle r;

        public ItemInfo(ATEGutterItem item, Rectangle r) {
            this.item = item;
            this.r = r;
        }

        public boolean contains(Point p) {
            return this.r.contains(p);
        }
    }
}

