/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.syntax.misc;

public abstract class ATEThread
implements Runnable {
    protected int threadSleep = 100;
    protected int threshold = 0;
    protected int default_threshold = 250;
    protected boolean running = false;
    protected boolean run = false;
    protected Thread thread = null;
    protected boolean asleep = false;
    protected boolean skip = false;

    public void setDefaultThreshold(int threshold) {
        this.default_threshold = threshold;
    }

    public synchronized void setRunning(boolean flag) {
        this.running = flag;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    protected synchronized void start() {
        this.threadSleep = Integer.MAX_VALUE;
        this.start_();
    }

    protected synchronized void start(int threadSleep) {
        this.threadSleep = threadSleep;
        this.start_();
    }

    private void start_() {
        if (!this.run) {
            this.run = true;
            this.thread = new Thread(this);
            this.thread.setName(this.getClass().toString());
            this.thread.start();
        }
    }

    public synchronized void skip() {
        this.skip = true;
    }

    private synchronized void resetSkip() {
        this.skip = false;
    }

    public synchronized void stop() {
        this.threshold = 0;
        this.run = false;
        this.thread.interrupt();
    }

    public synchronized void awakeThread() {
        this.awakeThread(this.default_threshold);
    }

    public synchronized void awakeThread(int threshold) {
        this.resetSkip();
        this.threshold = threshold;
        if (this.asleep) {
            this.thread.interrupt();
        }
    }

    public boolean cancel() {
        return !this.run;
    }

    protected abstract void threadRun() throws Exception;

    public void threadReportException(Exception e) {
        e.printStackTrace();
    }

    public boolean threadSleep(int ms) {
        boolean interrupted = false;
        this.asleep = true;
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        this.asleep = false;
        return interrupted;
    }

    public void run() {
        this.setRunning(true);
        while (this.run) {
            if (this.threadSleep(this.threadSleep) && this.threshold > 0) {
                while (this.threadSleep(this.threshold)) {
                }
            }
            if (!this.run) break;
            if (this.skip) {
                this.resetSkip();
                continue;
            }
            try {
                this.threadRun();
            }
            catch (Exception e) {
                this.threadReportException(e);
            }
        }
        this.setRunning(false);
    }
}

