/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tree;

import java.awt.Component;
import java.util.Stack;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.debugger.tree.DBASTModel;
import org.antlr.works.debugger.tree.DBASTModelListener;
import org.antlr.works.debugger.tree.DBTreeNode;
import org.antlr.works.utils.DetachablePanel;
import org.antlr.works.utils.awtree.AWTreePanel;
import org.antlr.works.utils.awtree.AWTreePanelDelegate;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.swing.XJTable;
import org.antlr.xjlib.appkit.swing.XJTableDelegate;
import org.antlr.xjlib.appkit.swing.XJTableView;

public class DBASTPanel
extends DetachablePanel
implements DBASTModelListener,
XJTableDelegate,
AWTreePanelDelegate {
    public DebuggerTab debuggerTab;
    public XJTableView rulesTableView;
    public XJTableView rootsTableView;
    public AWTreePanel treePanel;
    public DBASTModel model;
    public JSplitPane tablesSplitPane;
    public JSplitPane tableTreeSplitPane;

    public DBASTPanel(DebuggerTab debuggerTab) {
        super("AST", debuggerTab);
        this.debuggerTab = debuggerTab;
        this.model = new DBASTModel(debuggerTab);
        this.model.addListener(this);
        this.rulesTableView = new XJTableView();
        this.rulesTableView.setFocusable(true);
        this.rulesTableView.getTable().setModel(new RulesTableModel());
        this.rulesTableView.getTable().setDelegate(this);
        this.rulesTableView.getTable().setAllowEmptySelection(false);
        this.rulesTableView.getTable().setRememberSelection(true);
        this.rulesTableView.autoresizeColumns();
        this.rootsTableView = new XJTableView();
        this.rootsTableView.getTable().setModel(new RootsTableModel());
        this.rootsTableView.setFocusable(true);
        this.rootsTableView.getTable().setDelegate(this);
        this.rootsTableView.getTable().setAllowEmptySelection(false);
        this.rootsTableView.getTable().setRememberSelection(true);
        this.rootsTableView.autoresizeColumns();
        this.treePanel = new AWTreePanel(new DefaultTreeModel(null));
        this.treePanel.setRootVisible(true);
        this.treePanel.setDelegate(this);
        this.tablesSplitPane = new JSplitPane();
        this.tablesSplitPane.setBorder(null);
        this.tablesSplitPane.setOrientation(1);
        this.tablesSplitPane.setContinuousLayout(true);
        this.tablesSplitPane.setOneTouchExpandable(true);
        this.tablesSplitPane.setResizeWeight(0.5);
        this.tablesSplitPane.setLeftComponent(this.rulesTableView);
        this.tablesSplitPane.setRightComponent(this.rootsTableView);
        this.tableTreeSplitPane = new JSplitPane();
        this.tableTreeSplitPane.setBorder(null);
        this.tableTreeSplitPane.setOrientation(1);
        this.tableTreeSplitPane.setContinuousLayout(true);
        this.tableTreeSplitPane.setOneTouchExpandable(true);
        this.tableTreeSplitPane.setResizeWeight(0.5);
        this.tableTreeSplitPane.setLeftComponent(this.tablesSplitPane);
        this.tableTreeSplitPane.setRightComponent(this.treePanel);
        this.mainPanel.add((Component)this.tableTreeSplitPane, "Center");
    }

    public void close() {
        super.close();
        this.treePanel.setDelegate(null);
        this.debuggerTab = null;
    }

    public void clear() {
        this.model.clear();
        this.treePanel.clear();
    }

    public void updateOnBreakEvent() {
        this.model.fireDataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DBASTPanel.this.selectLastRule();
                DBASTPanel.this.selectLastRootNode();
            }
        });
    }

    public DBASTModel getModel() {
        return this.model;
    }

    public void modelChanged(DBASTModel model) {
        this.rulesModelChanged();
        this.rootsModelChanged();
    }

    public void rulesModelChanged() {
        this.rulesTableView.getTable().reload();
    }

    public void rootsModelChanged() {
        this.rootsTableView.getTable().reload();
        this.updateTreePanel();
    }

    public void updateTreePanel() {
        int row = this.rootsTableView.getTable().getSelectedRow();
        if (row == -1) {
            this.treePanel.setRoot(null);
        } else {
            this.treePanel.setRoot(this.getRootAtIndex(row));
        }
        this.treePanel.refresh();
    }

    public void selectToken(Token token) {
        DBASTModel.Rule rule = this.getSelectedRule();
        if (rule == null) {
            return;
        }
        Stack<DBASTModel.ASTNode> roots = rule.getRoots();
        for (int r = 0; r < roots.size(); ++r) {
            DBASTModel.ASTNode node = (DBASTModel.ASTNode)roots.get(r);
            DBTreeNode candidate = node.findNodeWithToken(token);
            if (candidate == null) continue;
            this.rootsTableView.getTable().setSelectedRow(r);
            this.treePanel.selectNode(candidate);
            break;
        }
    }

    public void selectLastRule() {
        this.rulesTableView.getTable().selectLastRow();
    }

    public void selectLastRootNode() {
        this.rootsTableView.getTable().selectLastRow();
    }

    public DBASTModel.Rule getSelectedRule() {
        int row = this.rulesTableView.getTable().getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.model.getRuleAtIndex(row);
    }

    public DBASTModel.ASTNode getRootAtIndex(int index) {
        return this.getSelectedRule().getRootAtIndex(index);
    }

    public GView getGraphView() {
        return this.treePanel.getGraphView();
    }

    public void tableSelectionChanged(XJTable table, int selectedRow) {
        if (table == this.rulesTableView.getTable()) {
            this.rootsModelChanged();
        } else if (table == this.rootsTableView.getTable()) {
            this.updateTreePanel();
        }
    }

    public void awTreeDidSelectTreeNode(TreeNode node, boolean shiftKey) {
        DBASTModel.ASTNode n = (DBASTModel.ASTNode)node;
        this.debuggerTab.selectToken(n.token, n.getLocation());
    }

    public JPopupMenu awTreeGetContextualMenu() {
        return this.debuggerTab.treeGetContextualMenu();
    }

    public class RootsTableModel
    extends DefaultTableModel {
        public int getRowCount() {
            if (DBASTPanel.this == null) {
                return 0;
            }
            DBASTModel.Rule r = DBASTPanel.this.getSelectedRule();
            if (r == null) {
                return 0;
            }
            return r.roots.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            return "Root";
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return "r" + rowIndex;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    public class RulesTableModel
    extends DefaultTableModel {
        public int getRowCount() {
            if (DBASTPanel.this == null) {
                return 0;
            }
            if (DBASTPanel.this.model == null) {
                return 0;
            }
            return DBASTPanel.this.model.getRuleCount();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            return "Rule";
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return DBASTPanel.this.model.getRuleAtIndex((int)rowIndex).name;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

