/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.util.List;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.folding.ATEFoldingEntityProxy;
import org.antlr.works.ate.folding.ATEFoldingManager;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.grammar.element.ElementAction;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.prefs.AWPrefs;

public class EditorFoldingManager
extends ATEFoldingManager {
    protected static final int TAG_RULES = 0;
    protected static final int TAG_ACTIONS = 1;
    protected GrammarWindow window;

    public EditorFoldingManager(GrammarWindow window) {
        super(window.textEditor);
        this.window = window;
    }

    public void close() {
        super.close();
        this.window = null;
    }

    public void textPaneWillFold() {
        super.textPaneWillFold();
        this.window.disableTextPaneUndo();
    }

    public void textPaneDidFold() {
        super.textPaneDidFold();
        this.window.enableTextPaneUndo();
        this.window.editorIdeas.hide();
        this.window.editorTips.hide();
    }

    public ATEFoldingEntityProxy createEntityProxy(ATEFoldingEntity entity) {
        int tag;
        if (entity instanceof ElementRule) {
            tag = 0;
        } else if (entity instanceof ElementAction) {
            tag = 1;
        } else {
            return null;
        }
        return new ATEFoldingEntityProxy(this, entity.foldingEntityID(), tag);
    }

    public void provideFoldingEntities() {
        List<ElementAction> actions;
        List<ElementRule> rules = this.window.getGrammarEngine().getRules();
        if (rules != null) {
            for (ElementRule rule : rules) {
                this.addEntity(rule);
            }
        }
        if (AWPrefs.getFoldingEnabled() && AWPrefs.getDisplayActionsAnchorsFolding() && (actions = this.window.getGrammarEngine().getActions()) != null) {
            for (ElementAction action : actions) {
                if (!action.rule.isExpanded()) continue;
            }
        }
    }

    public ATEFoldingEntity getEntityForIdentifier(List entities, String identifier) {
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        for (Object entity1 : entities) {
            ATEFoldingEntity entity = (ATEFoldingEntity)entity1;
            if (!entity.foldingEntityID().equals(identifier)) continue;
            return entity;
        }
        return null;
    }

    public ATEFoldingEntity getEntityForKey(Object key, int tag) {
        if (tag == 1) {
            return this.getEntityForIdentifier(this.window.getGrammarEngine().getActions(), (String)key);
        }
        if (tag == 0) {
            return this.getEntityForIdentifier(this.window.getGrammarEngine().getRules(), (String)key);
        }
        return null;
    }
}

