/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.element;

import java.util.ArrayList;
import java.util.List;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.editor.EditorPersistentObject;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.element.ElementScopable;
import org.antlr.works.grammar.syntax.GrammarSyntaxParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementAction
extends ElementScopable
implements EditorPersistentObject,
ATEFoldingEntity {
    public ElementRule rule;
    public ATEToken start;
    public ATEToken end;
    public int actionNum;
    private boolean expanded = true;
    private GrammarSyntaxParser parser;

    public ElementAction(GrammarSyntaxParser parser, ElementRule rule, ATEToken start) {
        this.parser = parser;
        this.rule = rule;
        this.start = start;
    }

    public boolean containsIndex(int index) {
        return index >= this.start.getStartIndex() && index <= this.end.getEndIndex();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ElementAction) {
            return this.getUniqueIdentifier() == ((ElementAction)other).getUniqueIdentifier();
        }
        return false;
    }

    public List<ATEToken> getTokens() {
        ArrayList<ATEToken> t = new ArrayList<ATEToken>();
        for (int index = this.start.index; index < this.end.index; ++index) {
            t.add(this.parser.getTokens().get(index));
        }
        return t;
    }

    public int getUniqueIdentifier() {
        String actionText = this.start.getText().substring(this.start.start, this.end.end);
        return (this.rule.name + actionText + this.actionNum).hashCode();
    }

    @Override
    public void foldingEntitySetExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean foldingEntityIsExpanded() {
        return this.expanded;
    }

    @Override
    public boolean foldingEntityCanBeCollapsed() {
        return true;
    }

    @Override
    public int foldingEntityGetStartParagraphIndex() {
        return this.start.getStartIndex();
    }

    @Override
    public int foldingEntityGetStartIndex() {
        return this.start.getStartIndex();
    }

    @Override
    public int foldingEntityGetEndIndex() {
        return this.end.getEndIndex();
    }

    @Override
    public int foldingEntityGetStartLine() {
        return this.start.startLineNumber;
    }

    @Override
    public int foldingEntityGetEndLine() {
        return this.end.endLineNumber;
    }

    @Override
    public String foldingEntityPlaceholderString() {
        return "{ ... }";
    }

    @Override
    public String foldingEntityID() {
        return String.valueOf(this.getUniqueIdentifier());
    }

    @Override
    public int foldingEntityLevel() {
        return 1;
    }

    @Override
    public Object getPersistentID() {
        return this.getUniqueIdentifier();
    }

    @Override
    public void persistentAssign(EditorPersistentObject otherObject) {
        ElementAction otherAction = (ElementAction)otherObject;
        this.expanded = otherAction.expanded;
    }
}

