/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.fa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.Transition;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;

public class FAAnalysis {
    private Set processedStates = new HashSet();
    private Map stateIncomingTransitionCount = new HashMap();

    public void reset() {
        this.processedStates.clear();
        this.stateIncomingTransitionCount.clear();
    }

    public void analyze(FAState state) {
        this.reset();
        this.recursiveAnalysis(state);
    }

    public void analyze(NFAState state) {
        this.reset();
        this.recursiveAnalysis(state);
    }

    public void recursiveAnalysis(NFAState state) {
        if (this.processedStates.contains(state)) {
            return;
        }
        this.processedStates.add(state);
        for (int t = 0; t < state.getNumberOfTransitions(); ++t) {
            Transition transition = state.transition(t);
            this.addIncomingTransitionToState((NFAState)transition.target);
            this.recursiveAnalysis((NFAState)transition.target);
        }
    }

    public void recursiveAnalysis(FAState state) {
        if (this.processedStates.contains(state)) {
            return;
        }
        this.processedStates.add(state);
        for (int t = 0; t < state.getNumberOfTransitions(); ++t) {
            FATransition transition = state.transition(t);
            this.addIncomingTransitionToState(transition.target);
            this.recursiveAnalysis(transition.target);
        }
    }

    public void addIncomingTransitionToState(Object state) {
        Integer i = (Integer)this.stateIncomingTransitionCount.get(state);
        int count = 0;
        if (i != null) {
            count = i;
        }
        this.stateIncomingTransitionCount.put(state, new Integer(count + 1));
    }

    public int numberOfIncomingTransition(Object state) {
        Integer i = (Integer)this.stateIncomingTransitionCount.get(state);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (NFAState key : this.stateIncomingTransitionCount.keySet()) {
            Integer count = (Integer)this.stateIncomingTransitionCount.get(key);
            s.append(key.stateNumber + " = " + count + "\n");
        }
        return s.toString();
    }
}

