/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.fa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.Transition;
import org.antlr.tool.Grammar;
import org.antlr.works.visualization.fa.FAAnalysis;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAFactory {
    protected Grammar g;
    protected boolean optimize;
    protected FAAnalysis analysis = new FAAnalysis();
    protected Map<NFAState, FAState> processedStates = new HashMap<NFAState, FAState>();
    protected Map<Integer, FAState> skippedStatesMap = new HashMap<Integer, FAState>();
    protected int newStateNumber = -2;

    public FAFactory(Grammar g) {
        this.g = g;
    }

    public FAState buildNFA(NFAState state, boolean optimize) {
        this.optimize = optimize;
        return this.build(state);
    }

    public Map<Integer, FAState> getSkippedStatesMap() {
        return this.skippedStatesMap;
    }

    public FAState build(NFAState state) {
        this.processedStates.clear();
        this.analysis.analyze(state);
        return this.buildRecursiveState(state, new HashSet<NFAState>());
    }

    public FAState buildRecursiveState(NFAState state, Set<NFAState> currentPath) {
        if (this.processedStates.get(state) != null) {
            FAState js = this.processedStates.get(state);
            if (currentPath.contains(state)) {
                js.loop = true;
            }
            return js;
        }
        FAState js = new FAState(state);
        this.processedStates.put(state, js);
        currentPath.add(state);
        if (state.isAcceptState()) {
            return js;
        }
        for (int t = 0; t < state.getNumberOfTransitions(); ++t) {
            FAState parentState = js;
            Transition transition = state.transition(t);
            NFAState target = (NFAState)transition.target;
            if (this.targetStateIsInAnotherRule(transition)) {
                target = this.targetStateOfTransition(transition);
                parentState = this.createRuleReferenceState(parentState, transition, null);
            }
            if (transition.isEpsilon()) {
                this.buildRecursiveSkipState(parentState, target, new HashSet<NFAState>(currentPath), new ArrayList<Integer>());
                continue;
            }
            FAState targetState = this.buildRecursiveState(target, new HashSet<NFAState>(currentPath));
            if (targetState.loop) {
                targetState.addTransition(new FATransition(transition.label.toString(this.g), parentState), true);
                targetState.loop = false;
                continue;
            }
            parentState.addTransition(new FATransition(transition.label.toString(this.g), targetState));
        }
        return js;
    }

    public void buildRecursiveSkipState(FAState parentState, NFAState state, Set<NFAState> currentPath, List<Integer> skippedStates) {
        if (this.canBeSkipped(state)) {
            Integer skippedState = state.stateNumber;
            skippedStates.add(skippedState);
            this.skippedStatesMap.put(skippedState, parentState);
            for (int t = 0; t < state.getNumberOfTransitions(); ++t) {
                Transition transition = state.transition(t);
                if (this.targetStateIsInAnotherRule(transition)) {
                    NFAState target = this.targetStateOfTransition(transition);
                    FAState ruleRefState = this.createRuleReferenceState(parentState, transition, skippedStates);
                    this.buildRecursiveSkipState(ruleRefState, target, currentPath, new ArrayList<Integer>(skippedStates));
                    continue;
                }
                this.buildRecursiveSkipState(parentState, (NFAState)transition.target, currentPath, new ArrayList<Integer>(skippedStates));
            }
        } else {
            FAState targetState = this.buildRecursiveState(state, currentPath);
            if (targetState.loop) {
                targetState.addTransition(new FATransition(parentState, skippedStates), true);
                targetState.loop = false;
            } else {
                parentState.addTransition(new FATransition(targetState, skippedStates));
            }
        }
    }

    public boolean targetStateIsInAnotherRule(Transition transition) {
        return transition instanceof RuleClosureTransition;
    }

    public String nameOfExternalReferencedRule(Transition transition) {
        if (transition instanceof RuleClosureTransition) {
            RuleClosureTransition rct = (RuleClosureTransition)transition;
            return this.g.getRuleName(rct.rule.index);
        }
        return null;
    }

    public FAState createRuleReferenceState(FAState parentState, Transition transition, List<Integer> skippedStates) {
        FAState dummyState = new FAState(this.newStateNumber--);
        dummyState.enclosingRuleName = parentState.enclosingRuleName;
        FATransition epsilon = new FATransition(dummyState, skippedStates);
        parentState.addTransition(epsilon);
        FAState ruleRefState = new FAState(this.newStateNumber--);
        ruleRefState.enclosingRuleName = parentState.enclosingRuleName;
        FATransition tr = new FATransition(this.nameOfExternalReferencedRule(transition), ruleRefState);
        tr.setExternalRuleRef(true);
        dummyState.addTransition(tr);
        return ruleRefState;
    }

    public NFAState targetStateOfTransition(Transition transition) {
        NFAState target;
        if (transition instanceof RuleClosureTransition) {
            RuleClosureTransition rct = (RuleClosureTransition)transition;
            target = rct.followState;
        } else {
            target = (NFAState)transition.target;
        }
        return target;
    }

    public boolean canBeSkipped(NFAState state) {
        if (!this.optimize) {
            return false;
        }
        if (state.stateNumber == 0) {
            return false;
        }
        if (state.isAcceptState()) {
            return false;
        }
        if (state.getDecisionNumber() > 0) {
            return false;
        }
        if (state.endOfBlockStateNumber != -1) {
            return false;
        }
        if (this.analysis.numberOfIncomingTransition(state) > 1) {
            return false;
        }
        return this.hasOneOrMoreEpsilonTransitionOnly(state);
    }

    public boolean hasOneEpsilonTransitionOnly(NFAState state) {
        return state.getNumberOfTransitions() == 1 && state.transition(0).isEpsilon();
    }

    public boolean hasOneOrMoreEpsilonTransitionOnly(NFAState state) {
        for (int t = 0; t < state.getNumberOfTransitions(); ++t) {
            Transition transition = state.transition(t);
            if (transition.isEpsilon()) continue;
            return false;
        }
        return state.getNumberOfTransitions() > 0;
    }

    public boolean hasMoreThanOneEpsilonTransitionOnly(NFAState state) {
        for (int t = 0; t < state.getNumberOfTransitions(); ++t) {
            Transition transition = state.transition(t);
            if (transition.isEpsilon()) continue;
            return false;
        }
        return state.getNumberOfTransitions() > 1;
    }

    public boolean isAlternativeTransitionEndingAtSameState(NFAState state) {
        NFAState endState = this.endStateOfAlternative((NFAState)state.transition((int)0).target);
        for (int t = 1; t < state.getNumberOfTransitions(); ++t) {
            Transition transition = state.transition(t);
            NFAState newEndState = this.endStateOfAlternative((NFAState)transition.target);
            if (endState.equals(newEndState)) continue;
            return false;
        }
        return true;
    }

    public NFAState endStateOfAlternative(NFAState alt) {
        int endOfBlockStateNumber = alt.endOfBlockStateNumber;
        NFAState state = alt;
        while (state.stateNumber != endOfBlockStateNumber) {
            state = (NFAState)state.transition((int)0).target;
        }
        return state;
    }
}

