/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.works.visualization.fa.FAAnalysis;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraph;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.primitive.GPoint;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.graphics.shape.GNode;

public class GRenderer {
    private final List<GNode> graphicNodes = new ArrayList<GNode>();
    private final FAAnalysis analysis = new FAAnalysis();
    private final Map<FAState, GNode> nodes = new HashMap<FAState, GNode>();
    private final Map<FAState, EOAInfo> endOfAlternativeInfoMap = new HashMap<FAState, EOAInfo>();

    public synchronized GGraph render(FAState state) {
        GGraph graph = new GGraph();
        graph.setDimension(this.renderSize(state));
        this.renderPosition(state);
        GNode lastNode = this.graphicNodes.get(this.graphicNodes.size() - 1);
        if (lastNode != null) {
            lastNode.lastNodeOfRule = true;
        }
        graph.setNodes((ArrayList)((ArrayList)this.graphicNodes).clone());
        return graph;
    }

    public void renderPosition(FAState state) {
        this.recursiveRenderPositionNode(state, null, new GPoint());
    }

    public void recursiveRenderPositionNode(FAState state, FAState endState, GPoint basePoint) {
        while (state != endState) {
            GNode node = this.getNode(state);
            if (node == null) {
                System.err.println("Cannot find SDNode associated with state \"" + state + "\"");
                return;
            }
            node.setPosition(basePoint);
            if (state != null && state.isAlternative()) {
                state = this.recursiveRenderPositionAlternative(state, basePoint);
                basePoint.addX(node.nodeDimension.width + node.linkDimension.width);
                continue;
            }
            if (state != null && state.isSingle()) {
                basePoint.addX(node.nodeDimension.width + node.linkDimension.width);
                state = state.getNextFirstState();
                continue;
            }
            state = null;
        }
    }

    public FAState recursiveRenderPositionAlternative(FAState state, GPoint basePoint) {
        FAState alternativeEndState = this.alternativeEndState(state);
        GPoint point = new GPoint(basePoint);
        point.addX("mw");
        GDimension firstAlternativeDimension = null;
        for (int t = 0; t < state.getNumberOfTransitions(); ++t) {
            FATransition transition = state.transition(t);
            GLink link = this.getNode(state).getLink(transition);
            if (t == 0) {
                firstAlternativeDimension = link.branchDim;
            }
            if (t > 0 && !transition.loop) {
                point.addY("L");
                point.addY(link.branchDim.up);
            }
            if (transition.target == alternativeEndState) {
                if (transition.loop) {
                    GPoint vp = new GPoint(basePoint);
                    vp.subY(firstAlternativeDimension.up);
                    vp.subY(link.branchDim.down);
                    this.getNode(state).getLink(transition).setVirtualPosition(vp);
                    continue;
                }
                this.getNode(state).getLink(transition).setVirtualPosition(point);
                point.addY(link.branchDim.down);
                continue;
            }
            this.recursiveRenderPositionNode(transition.target, alternativeEndState, new GPoint(point));
            point.addY(link.branchDim.down);
        }
        return alternativeEndState;
    }

    public GDimension renderSize(FAState state) {
        this.graphicNodes.clear();
        this.nodes.clear();
        this.endOfAlternativeInfoMap.clear();
        this.analysis.analyze(state);
        return this.recursiveRenderSizeSingle(state, null);
    }

    public GDimension recursiveRenderSizeSingle(FAState state, FAState endState) {
        GDimension dimension = new GDimension();
        dimension.addUp("y");
        dimension.addDown("z");
        while (state != endState && state != null) {
            if (state.isAlternative()) {
                GDimension altDim = this.recursiveRenderSizeAlternative(state);
                dimension.addWidth("m" + altDim.width);
                dimension.maxUp(altDim.up);
                dimension.maxDown(altDim.down);
                state = this.alternativeEndState(state);
                continue;
            }
            if (state.isSingle()) {
                EOAInfo eoa;
                GNode n1 = this.createNode(state);
                FATransition transition = state.getFirstTransition();
                if (transition.isEpsilon()) {
                    n1.linkDimension.width = "w";
                    n1.linkDimension.up = "u";
                    n1.linkDimension.down = "d";
                } else {
                    n1.linkDimension.width = GContext.getBoxWidth(transition.label);
                    n1.linkDimension.up = "U";
                    n1.linkDimension.down = "D";
                }
                dimension.addWidth("m" + n1.linkDimension.width);
                dimension.maxUp(n1.linkDimension.up);
                dimension.maxDown(n1.linkDimension.down);
                state = transition.target;
                GNode n2 = this.createNode(state);
                GLink link = new GLink();
                link.transition = transition;
                link.target = n2;
                n1.addLink(link);
                if (state != endState || (eoa = this.endOfAlternativeInfoMap.get(state)) == null) continue;
                link.setLast(eoa.last);
                continue;
            }
            dimension.addWidth("m");
            state = null;
        }
        return dimension;
    }

    public GDimension recursiveRenderSizeAlternative(FAState state) {
        FAState alternativeEndState = this.alternativeEndState(state);
        GNode norigin = this.createNode(state);
        GDimension dimension = norigin.linkDimension;
        dimension.addWidth("w");
        GDimension firstTransitionDimension = null;
        for (int t = 0; t < state.getNumberOfTransitions(); ++t) {
            GDimension transitionDimension;
            boolean last;
            FATransition transition = state.transition(t);
            GLink link = new GLink();
            link.transition = transition;
            link.target = this.createNode(transition.target);
            norigin.addLink(link);
            boolean bl = last = t == state.getNumberOfTransitions() - 1;
            if (t == state.getNumberOfTransitions() - 2 && state.transition((int)(t + 1)).loop) {
                last = true;
            }
            link.setLast(last);
            if (transition.target == alternativeEndState) {
                transitionDimension = new GDimension();
                transitionDimension.addUp("u");
                transitionDimension.addDown("d");
                if (transition.loop) {
                    transitionDimension.addDown("L");
                }
                if (transition.loop) {
                    link.setBranchDimension(transitionDimension);
                    dimension.maxUp(firstTransitionDimension.up + transitionDimension.up + transitionDimension.down);
                    continue;
                }
                link.setBranchDimension(transitionDimension);
                if (t == 0) {
                    firstTransitionDimension = transitionDimension;
                }
                dimension.addDown(transitionDimension.up);
                dimension.addDown(transitionDimension.down);
                continue;
            }
            this.endOfAlternativeInfoMap.put(alternativeEndState, new EOAInfo(last));
            transitionDimension = this.recursiveRenderSizeSingle(transition.target, alternativeEndState);
            if ((t > 0 || t == 0 && !state.transition((int)1).loop) && !last) {
                dimension.addDown("L");
            }
            link.setBranchDimension(transitionDimension);
            transitionDimension.addWidth("w");
            dimension.maxWidth(transitionDimension.width);
            if (t == 0) {
                firstTransitionDimension = transitionDimension;
                dimension.maxUp(transitionDimension.up);
                dimension.addDown(transitionDimension.down);
                continue;
            }
            dimension.addDown(transitionDimension.up);
            dimension.addDown(transitionDimension.down);
        }
        return dimension;
    }

    public GNode createNode(FAState state) {
        GNode node = this.getNode(state);
        if (node == null) {
            node = new GNode();
            node.setState(state);
            this.graphicNodes.add(node);
            this.nodes.put(state, node);
        }
        return node;
    }

    public GNode getNode(FAState state) {
        return this.nodes.get(state);
    }

    public FAState alternativeEndState(FAState alt) {
        FATransition transition;
        int counter = alt.getNumberOfTransitions() - 1;
        FAState state = alt;
        while ((transition = state.getFirstTransition()) != null && (this.analysis.numberOfIncomingTransition(state = transition.target) <= 1 || (counter -= this.analysis.numberOfIncomingTransition(state) - 1) > 0)) {
            if (!state.isAlternative()) continue;
            counter += state.getNumberOfTransitions() - 1;
        }
        return state;
    }

    private class EOAInfo {
        public boolean last = false;

        public EOAInfo(boolean last) {
            this.last = last;
        }
    }
}

