/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.primitive.GLiteral;
import org.antlr.works.visualization.graphics.primitive.GPoint;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class GNode
extends GObject
implements SSerializable {
    public FAState state;
    public List<GLink> links = new ArrayList<GLink>();
    public GPoint position;
    public GDimension nodeDimension = new GDimension("m", "z", "y");
    public GDimension linkDimension = new GDimension();
    public GDimension globalDimension;
    public boolean lastNodeOfRule = false;

    public void setContext(GContext context) {
        super.setContext(context);
        for (GLink link : this.links) {
            link.setContext(context);
        }
    }

    public void setState(FAState state) {
        this.state = state;
    }

    public void setPosition(GPoint position) {
        this.position = new GPoint(position);
    }

    public boolean containsStateNumber(int n) {
        if (this.state.stateNumber == this.state.stateNumber) {
            return true;
        }
        for (GLink link : this.links) {
            if (!link.containsStateNumber(n)) continue;
            return true;
        }
        return false;
    }

    public void addLink(GLink link) {
        link.setSource(this);
        this.links.add(link);
    }

    public GLink getLink(FATransition transition) {
        for (GLink link : this.links) {
            if (link.transition != transition) continue;
            return link;
        }
        return null;
    }

    public float getX() {
        return this.position.getX(null);
    }

    public float getY() {
        return this.position.getY(null);
    }

    public float getCenterX() {
        return this.getX() + this.nodeDimension.getPixelWidth(null) / 2.0f;
    }

    public float getCenterY() {
        return this.getY();
    }

    public float getBeginX() {
        return this.getX();
    }

    public float getBeginY() {
        return this.getY();
    }

    public float getEndX() {
        return this.getX() + this.nodeDimension.getPixelWidth(null);
    }

    public float getEndY() {
        return this.getY();
    }

    public Rectangle getBounds() {
        float width = this.globalDimension.getPixelWidth(this.context);
        float up = this.globalDimension.getPixelUp(this.context);
        float down = this.globalDimension.getPixelDown(this.context);
        int x1 = (int)this.getX();
        int y1 = (int)(this.getY() - up);
        int x2 = (int)width;
        int y2 = (int)(up + down);
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean containsPoint(Point p) {
        return this.context.objectContainsPoint(this, p);
    }

    private void cacheGlobalDimension(GContext context) {
        this.globalDimension = new GDimension();
        this.globalDimension.addWidth(this.nodeDimension.width + this.linkDimension.width);
        this.globalDimension.addUp(GLiteral.max(this.nodeDimension.up, this.linkDimension.up));
        this.globalDimension.addDown(GLiteral.max(this.nodeDimension.down, this.linkDimension.down));
        this.globalDimension.cache(context);
    }

    public void render(float ox, float oy) {
        this.position.cache(this.context, ox, oy);
        this.nodeDimension.cache(this.context);
        this.linkDimension.cache(this.context);
        this.cacheGlobalDimension(this.context);
        for (GLink link : this.links) {
            link.render(ox, oy);
        }
    }

    public void draw() {
        this.context.drawNode(this);
        if (this.context.drawnode) {
            this.context.setColor(Color.red);
            this.context.fillRect(this.getX() - 1.0f, this.getY() - 1.0f, 3.0f, 3.0f);
        }
    }

    public void drawNodeAndLink() {
        for (GLink link : this.links) {
            link.draw();
        }
        this.draw();
        if (this.context.drawdimension) {
            this.context.setColor(Color.lightGray);
            float width = this.globalDimension.getPixelWidth(this.context);
            float up = this.globalDimension.getPixelUp(this.context);
            float down = this.globalDimension.getPixelDown(this.context);
            if (up + down > 0.0f) {
                this.context.drawRect(this.getX(), this.getY() - up, width, up + down, false);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.state.stateNumber);
    }

    public void encode(SEncoder encoder) {
        encoder.write(this.state);
        for (GLink link : this.links) {
            encoder.write(link);
        }
        encoder.write(this.lastNodeOfRule);
    }
}

