/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.frame;

import java.util.ArrayList;
import java.util.List;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJFrame;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJWindow
extends XJFrame {
    private final List<XJDocument> documents = new ArrayList<XJDocument>();

    public XJWindow() {
        XJApplication.shared().addWindow(this);
        this.setDefaultCloseOperation(0);
    }

    public boolean isAuxiliaryWindow() {
        return false;
    }

    @Override
    public boolean shouldAppearsInWindowMenu() {
        return true;
    }

    public void setDocument(XJDocument document) {
        this.documents.clear();
        this.documents.add(document);
    }

    public void addDocument(XJDocument document) {
        if (!this.documents.contains(document)) {
            this.documents.add(document);
        }
    }

    public XJDocument getDocumentForPath(String path) {
        for (XJDocument document : this.documents) {
            String docPath = document.getDocumentPath();
            if (docPath == null || !docPath.equals(path)) continue;
            return document;
        }
        return null;
    }

    public List<XJDocument> getDocuments() {
        return this.documents;
    }

    public XJDocument getDocument() {
        if (this.documents.isEmpty()) {
            return null;
        }
        return this.documents.get(0);
    }

    public boolean hasDocuments() {
        return !this.documents.isEmpty();
    }

    public boolean hasDirtyDocument() {
        for (XJDocument doc : this.documents) {
            if (!doc.isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDocumentsWithFileAssociated() {
        for (XJDocument doc : this.documents) {
            if (doc.getDocumentPath() == null) continue;
            return true;
        }
        return false;
    }

    public void reloadDocuments() {
        for (XJDocument doc : this.documents) {
            if (!doc.isModifiedOnDisk()) continue;
            this.windowDocumentPathDidChange(doc);
            doc.synchronizeLastModifiedDate();
        }
    }

    public void clearDocuments() {
        this.documents.clear();
    }

    public void saveAll() {
        for (XJDocument document : this.documents) {
            if (!document.isDirty() || document.getDocumentPath() == null) continue;
            document.save(false);
        }
    }

    public boolean closeDocuments(boolean force) {
        for (XJDocument doc : new ArrayList<XJDocument>(this.documents)) {
            if (doc.close(force)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean close(boolean force) {
        if (this.hasDocuments() && !this.closeDocuments(force)) {
            return false;
        }
        super.close(force);
        XJApplication.shared().removeWindow(this);
        this.clearDocuments();
        return true;
    }

    @Override
    public void menuItemState(XJMenuItem item) {
        super.menuItemState(item);
        if (!this.hasDocuments()) {
            if (item.getTag() == 10004) {
                item.setEnabled(true);
            } else {
                item.setEnabled(false);
            }
        }
        switch (item.getTag()) {
            case 10002: {
                item.setEnabled(this.hasDirtyDocument());
            }
        }
    }

    @Override
    public void handleMenuEvent(XJMenu menu, XJMenuItem item) {
        super.handleMenuEvent(menu, item);
        if (item.getTag() == 10004) {
            this.performClose(false);
        }
    }

    @Override
    public void windowActivated() {
        XJMainMenuBar mmb = this.getMainMenuBar();
        if (mmb != null) {
            mmb.refresh();
        }
        if (this.hasDocuments()) {
            this.reloadDocuments();
        }
    }

    public void windowDocumentPathDidChange(XJDocument doc) {
    }

    public void selectDocument(XJDocument doc) {
    }
}

