/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.utils;

import java.io.IOException;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.utils.GDOTImporter;

public class GDOTImporterPlain
extends GDOTImporter {
    public static int factor = 80;

    public GElement parseLine(String line) throws IOException {
        String[] tokens = this.parseTokens(line);
        if (tokens[0].equals("graph")) {
            this.height = Float.parseFloat(tokens[3]);
        } else {
            if (tokens[0].equals("node")) {
                return this.createGraphNode(tokens);
            }
            if (tokens[0].equals("edge")) {
                return this.createGraphEdge(tokens);
            }
        }
        return null;
    }

    public GElement createGraphNode(String[] tokens) {
        float x = Float.parseFloat(tokens[2]) * (float)factor;
        float y = (this.height - Float.parseFloat(tokens[3])) * (float)factor;
        float w = Float.parseFloat(tokens[4]) * (float)factor;
        float h = Float.parseFloat(tokens[5]) * (float)factor;
        GDOTImporter.Node node = new GDOTImporter.Node();
        node.setDraggable(true);
        node.setPosition(x, y);
        node.setSize(w, h);
        node.setRadius(w / 2.0f);
        node.setLabel(tokens[6]);
        node.setDouble(tokens[8].equals("doublecircle"));
        return node;
    }

    public GElement createGraphEdge(String[] tokens) {
        int controlCount = (int)Float.parseFloat(tokens[3]);
        Vector2D[] points = new Vector2D[controlCount];
        for (int index = 0; index < controlCount; ++index) {
            points[index] = new Vector2D(Float.parseFloat(tokens[4 + index * 2]) * (float)factor, (this.height - Float.parseFloat(tokens[4 + index * 2 + 1])) * (float)factor);
        }
        int labelIndex = 3 + 2 * controlCount + 1;
        String label = null;
        Vector2D labelPosition = null;
        if (this.isFloatString(tokens[labelIndex + 1])) {
            label = tokens[labelIndex];
            labelPosition = new Vector2D(Float.parseFloat(tokens[labelIndex + 1]) * (float)factor, (this.height - Float.parseFloat(tokens[labelIndex + 2])) * (float)factor);
        }
        GElement source = this.graph.findElementWithLabel(tokens[1]);
        GElement target = this.graph.findElementWithLabel(tokens[2]);
        GLink link = new GLink(source, "CENTER", target, "CENTER", 2, label, 0.0);
        link.setBezierControlPoints(points);
        link.setBezierLabelPosition(labelPosition);
        return link;
    }
}

